/*
 * Decompiled with CFR 0.152.
 */
package net.java.sen.filter.stream;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import net.java.sen.dictionary.Morpheme;
import net.java.sen.dictionary.Sentence;
import net.java.sen.dictionary.Token;
import net.java.sen.filter.StreamFilter;
import net.java.sen.util.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompoundWordFilter
implements StreamFilter {
    private HashMap<String, String> compoundTable;

    private int getFieldStart(String termInfo, int position) {
        if (position == 0) {
            return 0;
        }
        int cnt = 0;
        int ptr = 0;
        while (cnt < position && ptr < termInfo.length()) {
            if (termInfo.charAt(ptr++) != ',') continue;
            ++cnt;
        }
        if (cnt != position) {
            return -1;
        }
        return ptr++;
    }

    private String getField(String termInfo, int position) {
        int start = this.getFieldStart(termInfo, position);
        int end = this.getFieldStart(termInfo, position + 1);
        end = end == -1 || end == termInfo.length() ? termInfo.length() : --end;
        return termInfo.substring(start, end);
    }

    @Override
    public void preProcess(Sentence sentence) {
    }

    @Override
    public List<Token> postProcess(List<Token> tokens) {
        if (tokens.size() == 0) {
            return tokens;
        }
        ArrayList<Token> newTokens = new ArrayList<Token>();
        for (int i = 0; i < tokens.size(); ++i) {
            Token token = tokens.get(i);
            String compoundInfo = this.compoundTable.get(token.getMorpheme().toString());
            if (compoundInfo == null) {
                newTokens.add(token);
                continue;
            }
            StringTokenizer st = new StringTokenizer(compoundInfo);
            int start = token.getStart();
            while (st.hasMoreTokens()) {
                String termInfo = st.nextToken();
                Token newToken = new Token();
                String surface = this.getField(termInfo, 0);
                newToken.setSurface(surface);
                StringBuffer partOfSpeech = new StringBuffer(this.getField(termInfo, 2));
                String tmp = this.getField(termInfo, 3);
                if (!tmp.equals("*")) {
                    partOfSpeech.append("-").append(tmp);
                }
                if (!(tmp = this.getField(termInfo, 4)).equals("*")) {
                    partOfSpeech.append("-").append(tmp);
                }
                if (!(tmp = this.getField(termInfo, 5)).equals("*")) {
                    partOfSpeech.append("-").append(tmp);
                }
                newToken.setCost(token.getCost());
                String additionalInformation = this.getField(termInfo, 11).equals("-") ? "p=" + token.getMorpheme().getPartOfSpeech() : this.getField(termInfo, 11);
                Morpheme newMorpheme = new Morpheme(partOfSpeech.toString(), this.getField(termInfo, 6), this.getField(termInfo, 7), this.getField(termInfo, 8), new String[]{this.getField(termInfo, 9)}, new String[]{this.getField(termInfo, 10)}, additionalInformation);
                newToken.setMorpheme(newMorpheme);
                newToken.setLength(surface.length());
                newToken.setStart(start);
                start += surface.length();
                newTokens.add(newToken);
            }
        }
        return newTokens;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CompoundWordFilter(String compoundFile) {
        FileInputStream fis = null;
        ObjectInputStream is = null;
        try {
            fis = new FileInputStream(compoundFile);
            is = new ObjectInputStream(fis);
            this.compoundTable = (HashMap)is.readObject();
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                try {
                    IOUtils.close(is, fis);
                    throw throwable;
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
            }
        }
        try {
            IOUtils.close(is, fis);
            return;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

