/*
 * Decompiled with CFR 0.152.
 */
package com.vlsolutions.swing.docking;

import com.vlsolutions.swing.docking.BorderSplitter;
import com.vlsolutions.swing.docking.DockDropReceiver;
import com.vlsolutions.swing.docking.DockGroup;
import com.vlsolutions.swing.docking.DockKey;
import com.vlsolutions.swing.docking.Dockable;
import com.vlsolutions.swing.docking.DockableActionCustomizer;
import com.vlsolutions.swing.docking.DockableContainerFactory;
import com.vlsolutions.swing.docking.DockableDragSource;
import com.vlsolutions.swing.docking.DockableState;
import com.vlsolutions.swing.docking.DockingDesktop;
import com.vlsolutions.swing.docking.DockingUtilities;
import com.vlsolutions.swing.docking.SingleDockableContainer;
import com.vlsolutions.swing.docking.TabbedContainerActions;
import com.vlsolutions.swing.docking.TabbedDockableContainer;
import com.vlsolutions.swing.docking.event.DockDragEvent;
import com.vlsolutions.swing.docking.event.DockDropEvent;
import com.vlsolutions.swing.docking.event.DockEvent;
import com.vlsolutions.swing.docking.event.DockingActionCreateTabEvent;
import com.vlsolutions.swing.tabbedpane.JTabbedPaneSmartIcon;
import com.vlsolutions.swing.tabbedpane.JTabbedPaneSmartIconManager;
import com.vlsolutions.swing.tabbedpane.SmartIconJButton;
import java.awt.Component;
import java.awt.Container;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DockTabbedPane
extends JTabbedPane
implements DockDropReceiver,
DockableDragSource,
TabbedDockableContainer {
    private static final long serialVersionUID = 1L;
    private Rectangle lastDropBounds;
    private Rectangle lastDropTabBounds;
    private GeneralPath lastDropPath;
    private SingleDockableContainer draggedDockable = null;
    private boolean isMultipleDrag = false;
    protected DockingDesktop desktop;
    protected JPopupMenu popup = new JPopupMenu();
    protected int popupTab = -1;
    protected int previousSelectedDockable = -1;
    private HashMap<DockKey, Action> closeActions = new HashMap();
    private JTabbedPaneSmartIconManager tabManager = new JTabbedPaneSmartIconManager(this);
    static int instanceCount = 0;
    private Dockable selfDockable = new Dockable(){
        DockKey selfKey = new DockKey("dockTab" + instanceCount++);

        @Override
        public DockKey getDockKey() {
            this.selfKey.setName(String.valueOf(DockTabbedPane.this.getDockableAt(0).getDockKey().getName()) + "...");
            return this.selfKey;
        }

        @Override
        public Component getComponent() {
            return DockTabbedPane.this;
        }
    };
    private PropertyChangeListener keyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            int tab;
            DockKey k = (DockKey)e.getSource();
            if (e.getPropertyName().equals("close")) {
                Action closeAction = (Action)DockTabbedPane.this.closeActions.get(k);
                if (closeAction != null) {
                    closeAction.setEnabled(k.isCloseEnabled());
                }
            } else if (e.getPropertyName().equals("icon")) {
                int tab2 = DockTabbedPane.this.getDockableIndex(k);
                if (tab2 >= 0) {
                    JTabbedPaneSmartIcon tabIcon = (JTabbedPaneSmartIcon)DockTabbedPane.this.getIconAt(tab2);
                    tabIcon.setIcon((Icon)e.getNewValue());
                    JTabbedPaneSmartIcon newIcon = tabIcon.copy();
                    DockTabbedPane.this.setIconAt(tab2, newIcon);
                }
            } else if (e.getPropertyName().equals("name")) {
                int tab3 = DockTabbedPane.this.getDockableIndex(k);
                if (tab3 >= 0) {
                    JTabbedPaneSmartIcon tabIcon = (JTabbedPaneSmartIcon)DockTabbedPane.this.getIconAt(tab3);
                    String old = tabIcon.getLabel();
                    String label = (String)e.getNewValue();
                    tabIcon.setLabel(label);
                    JTabbedPaneSmartIcon newIcon = tabIcon.copy();
                    DockTabbedPane.this.setIconAt(tab3, newIcon);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            DockTabbedPane.this.revalidate();
                            DockTabbedPane.this.repaint();
                        }
                    });
                }
            } else if (e.getPropertyName().equals("tooltip") && (tab = DockTabbedPane.this.getDockableIndex(k)) >= 0) {
                JTabbedPaneSmartIcon tabIcon = (JTabbedPaneSmartIcon)DockTabbedPane.this.getIconAt(tab);
                tabIcon.setTooltipText((String)e.getNewValue());
                DockTabbedPane.this.setToolTipTextAt(tab, (String)e.getNewValue());
            }
        }
    };

    public DockTabbedPane() {
        int tabPlacement = UIManager.getInt("TabbedDockableContainer.tabPlacement");
        this.setTabLayoutPolicy(0);
        this.setTabPlacement(tabPlacement);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    DockTabbedPane.this.checkForPopUp(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    DockTabbedPane.this.checkForPopUp(e);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                Dockable d;
                if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e) && (d = DockTabbedPane.this.findDockableAt(e)) != null && d.getDockKey().isMaximizeEnabled() && d.getDockKey().getLocation() == DockableState.Location.DOCKED) {
                    DockTabbedPane.this.desktop.maximize(d);
                }
            }
        });
        if (UIManager.getBoolean("TabbedPane.alternateTabIcons")) {
            this.addChangeListener(new ChangeListener(){
                int prevTab = -1;

                @Override
                public void stateChanged(ChangeEvent e) {
                    int selectedTab = DockTabbedPane.this.getSelectedIndex();
                    if (selectedTab >= 0) {
                        DockTabbedPane.this.installTabIcons(selectedTab, true);
                        if (this.prevTab != -1) {
                            DockTabbedPane.this.installTabIcons(this.prevTab, false);
                        }
                        DockTabbedPane.this.previousSelectedDockable = this.prevTab;
                        this.prevTab = selectedTab;
                    }
                }
            });
        }
    }

    private void installTabIcons(int tab, boolean selected) {
        JTabbedPaneSmartIcon icon;
        if (tab < this.getTabCount() && (icon = (JTabbedPaneSmartIcon)this.getIconAt(tab)) != null) {
            SmartIconJButton closeIcon = icon.getSmartButton(0);
            if (selected) {
                closeIcon.setIcon(UIManager.getIcon("DockTabbedPane.close"));
                closeIcon.setPressedIcon(UIManager.getIcon("DockTabbedPane.close.pressed"));
                closeIcon.setRolloverIcon(UIManager.getIcon("DockTabbedPane.close.rollover"));
            } else {
                closeIcon.setIcon(UIManager.getIcon("DockTabbedPane.unselected_close"));
                closeIcon.setPressedIcon(UIManager.getIcon("DockTabbedPane.unselected_close.pressed"));
                closeIcon.setRolloverIcon(UIManager.getIcon("DockTabbedPane.unselected_close.rollover"));
            }
            icon.setSmartButton(0, closeIcon);
        }
    }

    public int getDockableIndex(DockKey key) {
        int i = 0;
        while (i < this.getTabCount()) {
            Dockable d = this.getDockableAt(i);
            if (d != null && d.getDockKey().equals(key)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void checkForPopUp(MouseEvent e) {
        Dockable d = this.findDockableAt(e);
        if (d != null) {
            DockableActionCustomizer customizer;
            DockKey key = d.getDockKey();
            JPopupMenu popup = new JPopupMenu(key.getName());
            int menuCount = 0;
            if (key.getLocation() == DockableState.Location.DOCKED) {
                if (key.isAutoHideEnabled()) {
                    popup.add(new JMenuItem(TabbedContainerActions.createHideTabAction(d, this.desktop)));
                    ++menuCount;
                }
                if (key.isFloatEnabled()) {
                    popup.add(new JMenuItem(TabbedContainerActions.createFloatTabAction(d, this.desktop)));
                    ++menuCount;
                }
                if (key.isMaximizeEnabled()) {
                    popup.add(new JMenuItem(TabbedContainerActions.createMaximizeTabAction(d, this.desktop)));
                    ++menuCount;
                }
                if (key.isCloseEnabled()) {
                    JMenuItem mItem = new JMenuItem(TabbedContainerActions.createCloseAction(d, this.desktop));
                    Icon closeIcon = UIManager.getIcon("DockTabbedPane.close");
                    mItem.setPressedIcon(closeIcon);
                    popup.add(mItem);
                    ++menuCount;
                }
            } else if (key.getLocation() == DockableState.Location.FLOATING) {
                if (!DockingUtilities.isChildOfCompoundDockable(d)) {
                    popup.add(new JMenuItem(TabbedContainerActions.createAttachTabAction(d, this.desktop)));
                    ++menuCount;
                }
            } else if (key.getLocation() != DockableState.Location.HIDDEN) {
                throw new RuntimeException("invalid state for a tabbed dockable");
            }
            if ((customizer = d.getDockKey().getActionCustomizer()) != null && customizer.isTabSelectorPopUpCustomizer()) {
                if (menuCount > 0) {
                    popup.addSeparator();
                }
                customizer.visitTabSelectorPopUp(popup, d);
            }
            if (menuCount > 0) {
                popup.pack();
                popup.show(this, e.getX(), e.getY());
            }
        }
    }

    private Dockable findDockableAt(MouseEvent e) {
        Point p = e.getPoint();
        this.popupTab = -1;
        int i = 0;
        while (i < this.getTabCount()) {
            Rectangle tabbounds = this.getBoundsAt(i);
            if (tabbounds != null && tabbounds.contains(p)) {
                return this.getDockableAt(i);
            }
            ++i;
        }
        return null;
    }

    @Override
    public void addDockable(Dockable dockable, int tab) {
        SingleDockableContainer dc = DockableContainerFactory.getFactory().createDockableContainer(dockable, DockableContainerFactory.ParentType.PARENT_TABBED_CONTAINER);
        dc.installDocking(this.desktop);
        this.addDockableContainer(dc, tab);
    }

    private void addDockableContainer(final SingleDockableContainer dc, int tab) {
        DockKey key = dc.getDockable().getDockKey();
        AbstractAction closeAction = new AbstractAction("Close"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                DockTabbedPane.this.desktop.close(dc.getDockable());
            }
        };
        this.closeActions.put(key, closeAction);
        SmartIconJButton closeIcon = new SmartIconJButton(closeAction);
        if (UIManager.getBoolean("TabbedPane.alternateTabIcons")) {
            closeIcon.setIcon(UIManager.getIcon("DockTabbedPane.unselected_close"));
            closeIcon.setPressedIcon(UIManager.getIcon("DockTabbedPane.unselected_close.pressed"));
            closeIcon.setRolloverIcon(UIManager.getIcon("DockTabbedPane.unselected_close.rollover"));
        } else {
            closeIcon.setIcon(UIManager.getIcon("DockTabbedPane.close"));
            closeIcon.setPressedIcon(UIManager.getIcon("DockTabbedPane.close.pressed"));
            closeIcon.setRolloverIcon(UIManager.getIcon("DockTabbedPane.close.rollover"));
        }
        closeAction.setEnabled(key.isCloseEnabled());
        closeAction.putValue("ShortDescription", UIManager.get("DockTabbedPane.closeButtonText"));
        JTabbedPaneSmartIcon smartIcon = new JTabbedPaneSmartIcon(key.getIcon(), key.getName(), new SmartIconJButton[]{closeIcon});
        smartIcon.setTooltipText(key.getTooltip());
        smartIcon.setIconForTabbedPane(this);
        if (tab >= this.getTabCount()) {
            this.addTab("", smartIcon, (Component)((Object)dc), key.getTooltip());
            tab = this.getTabCount() - 1;
        } else {
            this.insertTab("", smartIcon, (Component)((Object)dc), key.getTooltip(), tab);
        }
        key.addPropertyChangeListener(this.keyChangeListener);
        this.revalidate();
        this.repaint();
    }

    @Override
    public void processDockableDrag(DockDragEvent e) {
        this.scanDrop(e, false);
    }

    private void scanDrop(DockEvent event, boolean drop) {
        DockableDragSource dragSource = event.getDragSource();
        if (dragSource.getDockableContainer().isAncestorOf(this)) {
            if (drop) {
                ((DockDropEvent)event).rejectDrop();
            } else {
                ((DockDragEvent)event).delegateDrag();
            }
            return;
        }
        Dockable dockable = null;
        SingleDockableContainer dc = null;
        Container dragContainer = event.getDragSource().getDockableContainer();
        if (dragContainer instanceof TabbedDockableContainer) {
            if (dragContainer == this) {
                if (drop) {
                    ((DockDropEvent)event).rejectDrop();
                } else {
                    ((DockDragEvent)event).rejectDrag();
                }
                return;
            }
        } else {
            dockable = dragSource.getDockable();
            dc = DockingUtilities.findSingleDockableContainer(dockable);
            if (dc == null) {
                if (drop) {
                    ((DockDropEvent)event).rejectDrop();
                } else {
                    ((DockDragEvent)event).rejectDrag();
                }
                return;
            }
        }
        Point p = event.getMouseEvent().getPoint();
        Rectangle vbounds = this.getSelectedComponent().getBounds();
        if (vbounds.contains(p)) {
            this.scanMainTabZone(event, drop, dragSource, vbounds);
            return;
        }
        if (dragSource.getDockableContainer() instanceof TabbedDockableContainer) {
            if (drop) {
                ((DockDropEvent)event).rejectDrop();
            } else {
                ((DockDragEvent)event).rejectDrag();
            }
            return;
        }
        DockableDragSource s = event.getDragSource();
        Dockable d = s.getDockable();
        DockGroup dragGroup = d.getDockKey().getDockGroup();
        int i = 0;
        while (i < this.getTabCount()) {
            DockGroup thisGroup = this.getDockableAt(i).getDockKey().getDockGroup();
            if (!DockGroup.areGroupsCompatible(thisGroup, dragGroup)) {
                if (drop) {
                    ((DockDropEvent)event).rejectDrop();
                } else {
                    ((DockDragEvent)event).rejectDrag();
                }
                return;
            }
            ++i;
        }
        i = 0;
        while (i < this.getTabCount()) {
            Rectangle tabbounds = this.getBoundsAt(i);
            if (tabbounds != null && tabbounds.contains(p)) {
                SingleDockableContainer tab = (SingleDockableContainer)((Object)this.getComponentAt(i));
                if (tab.getDockable() == dragSource.getDockable()) {
                    if (drop) {
                        ((DockDropEvent)event).rejectDrop();
                    } else {
                        ((DockDragEvent)event).rejectDrag();
                    }
                    return;
                }
                if (i > 0 && (tab = (SingleDockableContainer)((Object)this.getComponentAt(i - 1))).getDockable() == dragSource.getDockable()) {
                    if (drop) {
                        ((DockDropEvent)event).rejectDrop();
                    } else {
                        ((DockDragEvent)event).rejectDrag();
                    }
                    return;
                }
                if (!vbounds.equals(this.lastDropBounds) || !tabbounds.equals(this.lastDropTabBounds)) {
                    GeneralPath gp = this.buildPathForCurrentTab(vbounds, tabbounds);
                    this.lastDropBounds = vbounds;
                    this.lastDropTabBounds = tabbounds;
                    this.lastDropPath = gp;
                }
                Dockable draggedDockable = dragSource.getDockable();
                DockableState.Location initialLocation = draggedDockable.getDockKey().getLocation();
                Dockable base = this.getDockableAt(0);
                DockableState.Location nextLocation = base.getDockKey().getLocation();
                event.setDockingAction(new DockingActionCreateTabEvent(event.getDesktop(), draggedDockable, initialLocation, nextLocation, base, i));
                if (drop) {
                    if (DockingUtilities.findTabbedDockableContainer(dockable) == this) {
                        ((DockDropEvent)event).acceptDrop(false);
                        this.addDockableContainer(dc, i);
                    } else {
                        if (base.getDockKey().getLocation() == DockableState.Location.FLOATING) {
                            if (dragSource.getDockable().getDockKey().getLocation() == DockableState.Location.FLOATING) {
                                ((DockDropEvent)event).acceptDrop();
                            } else {
                                ((DockDropEvent)event).acceptDrop(false);
                            }
                        } else {
                            ((DockDropEvent)event).acceptDrop();
                        }
                        this.desktop.createTab(base, dragSource.getDockable(), i);
                    }
                    this.setSelectedIndex(i);
                } else {
                    ((DockDragEvent)event).acceptDrag(this.lastDropPath);
                }
                return;
            }
            ++i;
        }
        int lastTab = this.getTabCount() - 1;
        Rectangle lasttabbounds = this.getBoundsAt(lastTab);
        if (lasttabbounds == null) {
            return;
        }
        Rectangle afterlast = new Rectangle(lasttabbounds.x + lasttabbounds.width, lasttabbounds.y, this.getX() + this.getWidth() - (lasttabbounds.x + lasttabbounds.width), lasttabbounds.height);
        if (afterlast.contains(p)) {
            SingleDockableContainer dockableContainer = (SingleDockableContainer)((Object)this.getComponentAt(lastTab));
            if (dockableContainer.getDockable() == dragSource.getDockable()) {
                if (drop) {
                    ((DockDropEvent)event).rejectDrop();
                } else {
                    ((DockDragEvent)event).rejectDrag();
                }
                return;
            }
            if (!vbounds.equals(this.lastDropBounds) || !afterlast.equals(this.lastDropTabBounds)) {
                GeneralPath gp = this.buildPathAfterLastTab(vbounds, afterlast);
                this.lastDropBounds = vbounds;
                this.lastDropTabBounds = afterlast;
                this.lastDropPath = gp;
            }
            Dockable draggedDockable = dragSource.getDockable();
            DockableState.Location initialLocation = draggedDockable.getDockKey().getLocation();
            Dockable base = this.getDockableAt(0);
            DockableState.Location nextLocation = base.getDockKey().getLocation();
            event.setDockingAction(new DockingActionCreateTabEvent(event.getDesktop(), draggedDockable, initialLocation, nextLocation, base, lastTab + 1));
            if (drop) {
                if (DockingUtilities.findTabbedDockableContainer(dockable) == this) {
                    ((DockDropEvent)event).acceptDrop(false);
                    this.addDockableContainer(dc, lastTab + 1);
                } else {
                    if (base.getDockKey().getLocation() == DockableState.Location.FLOATING) {
                        if (dragSource.getDockable().getDockKey().getLocation() == DockableState.Location.FLOATING) {
                            ((DockDropEvent)event).acceptDrop();
                        } else {
                            ((DockDropEvent)event).acceptDrop(false);
                        }
                    } else {
                        ((DockDropEvent)event).acceptDrop();
                    }
                    this.desktop.createTab(base, dragSource.getDockable(), lastTab + 1);
                }
                this.setSelectedIndex(this.getTabCount() - 1);
            } else {
                ((DockDragEvent)event).acceptDrag(this.lastDropPath);
            }
            return;
        }
        this.lastDropBounds = null;
        this.lastDropTabBounds = null;
        this.lastDropPath = null;
        if (drop) {
            ((DockDropEvent)event).rejectDrop();
        } else {
            ((DockDragEvent)event).rejectDrag();
        }
    }

    protected GeneralPath buildPathForCurrentTab(Rectangle vbounds, Rectangle tabbounds) {
        GeneralPath gp = new GeneralPath();
        if (this.getTabPlacement() == 3) {
            gp.moveTo(vbounds.x, vbounds.y);
            gp.lineTo(vbounds.x + vbounds.width, vbounds.y);
            gp.lineTo(vbounds.x + vbounds.width, vbounds.y + vbounds.height);
            int height = Math.min(16, tabbounds.height);
            if (this.getTabRunCount() > 1 && tabbounds.y > vbounds.y + vbounds.height + 10) {
                gp.lineTo(vbounds.x, vbounds.y + vbounds.height);
                gp.closePath();
                gp.moveTo(tabbounds.x, tabbounds.y);
                gp.lineTo(tabbounds.x + 30, tabbounds.y);
                gp.lineTo(tabbounds.x + 25, tabbounds.y + height);
                gp.lineTo(tabbounds.x, tabbounds.y + height);
                gp.closePath();
            } else {
                gp.lineTo(tabbounds.x + 30, vbounds.y + vbounds.height);
                gp.lineTo(tabbounds.x + 25, vbounds.y + vbounds.height + height);
                gp.lineTo(tabbounds.x, vbounds.y + vbounds.height + height);
                gp.lineTo(tabbounds.x, vbounds.y + vbounds.height);
                gp.lineTo(vbounds.x, vbounds.y + vbounds.height);
                gp.closePath();
            }
        } else {
            int height = Math.min(16, tabbounds.height);
            gp.moveTo(vbounds.x, vbounds.y);
            if (this.getTabRunCount() > 1 && tabbounds.y + tabbounds.height < vbounds.y - 10) {
                gp.lineTo(vbounds.x + vbounds.width, vbounds.y);
                gp.lineTo(vbounds.x + vbounds.width, vbounds.y + vbounds.height);
                gp.lineTo(vbounds.x, vbounds.y + vbounds.height);
                gp.closePath();
                gp.moveTo(tabbounds.x, tabbounds.y);
                gp.lineTo(tabbounds.x + 25, tabbounds.y);
                gp.lineTo(tabbounds.x + 30, tabbounds.y + height);
                gp.lineTo(tabbounds.x, tabbounds.y + height);
                gp.closePath();
            } else {
                gp.lineTo(tabbounds.x, vbounds.y);
                gp.lineTo(tabbounds.x, vbounds.y - height);
                gp.lineTo(tabbounds.x + 25, vbounds.y - height);
                gp.lineTo(tabbounds.x + 30, vbounds.y);
                gp.lineTo(vbounds.x + vbounds.width, vbounds.y);
                gp.lineTo(vbounds.x + vbounds.width, vbounds.y + vbounds.height);
                gp.lineTo(vbounds.x, vbounds.y + vbounds.height);
                gp.closePath();
            }
        }
        return gp;
    }

    protected GeneralPath buildPathAfterLastTab(Rectangle vbounds, Rectangle afterlast) {
        GeneralPath gp = new GeneralPath();
        if (this.getTabPlacement() == 3) {
            int height = Math.min(16, afterlast.height);
            gp.moveTo(vbounds.x, vbounds.y);
            gp.lineTo(vbounds.x + vbounds.width, vbounds.y);
            gp.lineTo(vbounds.x + vbounds.width, vbounds.y + vbounds.height);
            if (this.getTabRunCount() > 1) {
                gp.lineTo(vbounds.x, vbounds.y + vbounds.height);
                gp.closePath();
                gp.moveTo(afterlast.x, afterlast.y);
                gp.lineTo(afterlast.x + 30, afterlast.y);
                gp.lineTo(afterlast.x + 25, afterlast.y + height);
                gp.lineTo(afterlast.x, afterlast.y + height);
                gp.closePath();
            } else {
                if (afterlast.x + 30 > vbounds.x + vbounds.width) {
                    int newX = vbounds.x + vbounds.width - 30;
                    gp.lineTo(newX + 30, vbounds.y + vbounds.height);
                    gp.lineTo(newX + 25, vbounds.y + vbounds.height + height);
                    gp.lineTo(newX, vbounds.y + vbounds.height + height);
                    gp.lineTo(newX, vbounds.y + vbounds.height);
                } else {
                    gp.lineTo(afterlast.x + 30, vbounds.y + vbounds.height);
                    gp.lineTo(afterlast.x + 25, vbounds.y + vbounds.height + height);
                    gp.lineTo(afterlast.x, vbounds.y + vbounds.height + height);
                    gp.lineTo(afterlast.x, vbounds.y + vbounds.height);
                }
                gp.lineTo(vbounds.x, vbounds.y + vbounds.height);
                gp.closePath();
            }
        } else {
            int height = Math.min(16, afterlast.height);
            gp.moveTo(vbounds.x, vbounds.y);
            if (this.getTabRunCount() > 1) {
                gp.lineTo(vbounds.x + vbounds.width, vbounds.y);
                gp.lineTo(vbounds.x + vbounds.width, vbounds.y + vbounds.height);
                gp.lineTo(vbounds.x, vbounds.y + vbounds.height);
                gp.closePath();
                gp.moveTo(afterlast.x, afterlast.y);
                gp.lineTo(afterlast.x + 25, afterlast.y);
                gp.lineTo(afterlast.x + 30, afterlast.y + height);
                gp.lineTo(afterlast.x, afterlast.y + height);
                gp.closePath();
            } else {
                if (afterlast.x + 30 > vbounds.x + vbounds.width) {
                    int newX = vbounds.x + vbounds.width - 30;
                    gp.lineTo(newX, vbounds.y);
                    gp.lineTo(newX, vbounds.y - height);
                    gp.lineTo(newX + 25, vbounds.y - height);
                    gp.lineTo(newX + 30, vbounds.y);
                } else {
                    gp.lineTo(afterlast.x, vbounds.y);
                    gp.lineTo(afterlast.x, vbounds.y - height);
                    gp.lineTo(afterlast.x + 25, vbounds.y - height);
                    gp.lineTo(afterlast.x + 30, vbounds.y);
                }
                gp.lineTo(vbounds.x + vbounds.width, vbounds.y);
                gp.lineTo(vbounds.x + vbounds.width, vbounds.y + vbounds.height);
                gp.lineTo(vbounds.x, vbounds.y + vbounds.height);
                gp.closePath();
            }
        }
        return gp;
    }

    private void scanMainTabZone(DockEvent event, boolean drop, DockableDragSource dragSource, Rectangle vbounds) {
        Point p = event.getMouseEvent().getPoint();
        if (this.scanBorderBounds(event, drop, p)) {
            return;
        }
        if (dragSource.getDockableContainer() instanceof TabbedDockableContainer) {
            if (drop) {
                ((DockDropEvent)event).rejectDrop();
            } else {
                ((DockDragEvent)event).rejectDrag();
            }
            return;
        }
        if (this.scanSameComponent(event, drop, dragSource)) {
            return;
        }
        if (this.scanAdjacentTab(event, drop, dragSource)) {
            return;
        }
        DockGroup dragGroup = event.getDragSource().getDockable().getDockKey().getDockGroup();
        int i = 0;
        while (i < this.getTabCount()) {
            DockGroup thisGroup = this.getDockableAt(i).getDockKey().getDockGroup();
            if (!DockGroup.areGroupsCompatible(thisGroup, dragGroup)) {
                if (drop) {
                    ((DockDropEvent)event).rejectDrop();
                } else {
                    ((DockDragEvent)event).rejectDrag();
                }
                return;
            }
            ++i;
        }
        int tab = this.getSelectedIndex();
        Rectangle tabbounds = this.getBoundsAt(tab);
        if (tabbounds == null) {
            return;
        }
        if (!vbounds.equals(this.lastDropBounds) || !tabbounds.equals(this.lastDropTabBounds)) {
            GeneralPath gp = this.buildPathForCurrentTab(vbounds, tabbounds);
            this.lastDropBounds = vbounds;
            this.lastDropTabBounds = tabbounds;
            this.lastDropPath = gp;
        }
        Dockable base = this.getDockableAt(0);
        Dockable draggedDockable = dragSource.getDockable();
        DockableState.Location initialLocation = draggedDockable.getDockKey().getLocation();
        DockableState.Location nextLocation = base.getDockKey().getLocation();
        if (drop) {
            event.setDockingAction(new DockingActionCreateTabEvent(event.getDesktop(), draggedDockable, initialLocation, nextLocation, base, tab));
            if (base.getDockKey().getLocation() == DockableState.Location.FLOATING) {
                if (dragSource.getDockable().getDockKey().getLocation() == DockableState.Location.FLOATING) {
                    ((DockDropEvent)event).acceptDrop();
                } else {
                    ((DockDropEvent)event).acceptDrop(false);
                }
            } else {
                ((DockDropEvent)event).acceptDrop();
            }
            this.desktop.createTab(base, dragSource.getDockable(), tab);
            this.setSelectedIndex(tab);
        } else {
            event.setDockingAction(new DockingActionCreateTabEvent(event.getDesktop(), draggedDockable, initialLocation, nextLocation, base, tab));
            ((DockDragEvent)event).acceptDrag(this.lastDropPath);
        }
    }

    private boolean scanAdjacentTab(DockEvent event, boolean drop, DockableDragSource dragSource) {
        SingleDockableContainer dockableContainer;
        if (this.getSelectedIndex() > 0 && (dockableContainer = (SingleDockableContainer)((Object)this.getComponentAt(this.getSelectedIndex() - 1))).getDockable() == dragSource.getDockable()) {
            if (drop) {
                ((DockDropEvent)event).rejectDrop();
            } else {
                ((DockDragEvent)event).rejectDrag();
            }
            return true;
        }
        return false;
    }

    private boolean scanSameComponent(DockEvent event, boolean drop, DockableDragSource dragSource) {
        SingleDockableContainer dockableContainer = (SingleDockableContainer)((Object)this.getSelectedComponent());
        if (dockableContainer.getDockable() == dragSource.getDockable()) {
            if (drop) {
                ((DockDropEvent)event).rejectDrop();
            } else {
                ((DockDragEvent)event).rejectDrag();
            }
            return true;
        }
        return false;
    }

    private boolean scanBorderBounds(DockEvent event, boolean drop, Point p) {
        Dockable firstDockable = this.getDockableAt(0);
        if (firstDockable.getDockKey().getLocation() == DockableState.Location.FLOATING && !DockingUtilities.isChildOfCompoundDockable(firstDockable)) {
            return false;
        }
        Rectangle innerBounds = null;
        if (this.getTabPlacement() == 3) {
            int yTab = this.getBoundsAt((int)0).y;
            innerBounds = new Rectangle(20, 20, this.getWidth() - 20 - 20, yTab - 20 - 20);
        } else {
            Rectangle tabBounds = this.getBoundsAt(0);
            if (tabBounds == null) {
                return false;
            }
            int yTab = tabBounds.y + tabBounds.height;
            innerBounds = new Rectangle(20, yTab + 20, this.getWidth() - 20 - 20, this.getHeight() - yTab - 20 - 20);
        }
        if (!innerBounds.contains(p)) {
            BorderSplitter splitter = new BorderSplitter(this);
            if (drop) {
                splitter.processDockableDrop((DockDropEvent)event);
            } else {
                splitter.processDockableDrag((DockDragEvent)event);
            }
            return true;
        }
        return false;
    }

    @Override
    public void processDockableDrop(DockDropEvent event) {
        this.scanDrop(event, true);
    }

    @Override
    public boolean startDragComponent(Point p) {
        this.clearDragState();
        int i = 0;
        while (i < this.getTabCount()) {
            Rectangle tabbounds = this.getBoundsAt(i);
            if (tabbounds != null && tabbounds.contains(p)) {
                this.draggedDockable = (SingleDockableContainer)((Object)this.getComponentAt(i));
                if (i > 2 && i == this.getTabCount() - 1) {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().upFocusCycle();
                }
                return true;
            }
            ++i;
        }
        Rectangle header = this.getBoundsAt(0);
        if (header == null) {
            return false;
        }
        header.x = 0;
        int lastTab = this.getTabCount() - 1;
        Rectangle lasttabbounds = this.getBoundsAt(lastTab);
        if (lasttabbounds == null) {
            return false;
        }
        header = header.union(lasttabbounds);
        Rectangle afterlast = new Rectangle(lasttabbounds.x + lasttabbounds.width, lasttabbounds.y, this.getX() + this.getWidth() - (lasttabbounds.x + lasttabbounds.width), lasttabbounds.height);
        if (afterlast.contains(p) || header.contains(p)) {
            this.isMultipleDrag = true;
            return true;
        }
        return false;
    }

    @Override
    public Dockable getDockable() {
        if (this.isMultipleDrag) {
            return this.selfDockable;
        }
        if (this.draggedDockable != null) {
            return this.draggedDockable.getDockable();
        }
        return null;
    }

    @Override
    public Dockable getSelectedDockable() {
        if (this.getSelectedIndex() < 0) {
            return null;
        }
        Component comp = this.getComponentAt(this.getSelectedIndex());
        if (comp instanceof SingleDockableContainer) {
            return ((SingleDockableContainer)((Object)comp)).getDockable();
        }
        return null;
    }

    @Override
    public void setSelectedDockable(Dockable dockable) {
        Component c = (Component)((Object)DockingUtilities.findSingleDockableContainer(dockable));
        if (c != null && this.indexOfComponent(c) >= 0) {
            this.setSelectedComponent(c);
        }
    }

    @Override
    public Dockable getDockableAt(int index) {
        Component c = this.getComponentAt(index);
        if (c instanceof SingleDockableContainer) {
            return ((SingleDockableContainer)((Object)c)).getDockable();
        }
        return null;
    }

    @Override
    public void removeDockable(Dockable dockable) {
        SingleDockableContainer dc = DockingUtilities.findSingleDockableContainer(dockable);
        if (dc != null) {
            if (this.previousSelectedDockable != -1 && this.previousSelectedDockable < this.getTabCount()) {
                final Dockable d = this.getDockableAt(this.previousSelectedDockable);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DockTabbedPane.this.setSelectedDockable(d);
                    }
                });
            }
            this.remove((Component)((Object)dc));
        }
        this.closeActions.remove(dockable.getDockKey());
        dockable.getDockKey().removePropertyChangeListener(this.keyChangeListener);
    }

    @Override
    public void removeDockable(int index) {
        Dockable dockable = this.getDockableAt(index);
        final int prev = this.previousSelectedDockable;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (prev != -1 && prev < DockTabbedPane.this.getTabCount()) {
                    DockTabbedPane.this.setSelectedIndex(prev);
                }
            }
        });
        this.removeTabAt(index);
        this.closeActions.remove(dockable.getDockKey());
        dockable.getDockKey().removePropertyChangeListener(this.keyChangeListener);
    }

    private void clearDragState() {
        this.draggedDockable = null;
        this.isMultipleDrag = false;
    }

    @Override
    public String toString() {
        return "DockTabbedPane [" + Integer.toHexString(this.hashCode()) + " - tabcount=" + this.getTabCount() + "]";
    }

    @Override
    public int indexOfDockable(Dockable dockable) {
        SingleDockableContainer dc = DockingUtilities.findSingleDockableContainer(dockable);
        if (dc != null) {
            return this.indexOfComponent((Component)((Object)dc));
        }
        return -1;
    }

    @Override
    public void installDocking(DockingDesktop desktop) {
        this.desktop = desktop;
        desktop.installDockableDragSource(this);
    }

    @Override
    public void uninstallDocking(DockingDesktop desktop) {
        desktop.uninstallDockableDragSource(this);
    }

    @Override
    public Container getDockableContainer() {
        if (this.isMultipleDrag) {
            return this;
        }
        return (Container)((Object)this.draggedDockable);
    }

    @Override
    public void endDragComponent(boolean dropped) {
    }
}

