/*
 * Decompiled with CFR 0.152.
 */
package de.abelssoft.wordtools.jwordsplitter.impl;

import de.abelssoft.tools.FileTools;
import de.abelssoft.tools.persistence.FastObjectSaver;
import de.abelssoft.wordtools.jwordsplitter.AbstractWordSplitter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GermanWordSplitter
extends AbstractWordSplitter {
    private static final String SERIALIZED_DICT = "/wordsGerman.ser";
    private static final String EXCEPTION_DICT = "/exceptionsGerman.txt";
    private static final Collection<String> INTERFIXES = Arrays.asList("s-", "s", "-");
    private Set<String> words = null;
    private int minimumWordLength = 4;

    public GermanWordSplitter() throws IOException {
        this(true);
    }

    public GermanWordSplitter(boolean hideLinkingElement, String plainTextDictFile) throws IOException {
        super(hideLinkingElement, plainTextDictFile);
        this.setExceptionFile(EXCEPTION_DICT);
    }

    public GermanWordSplitter(boolean hideLinkingElement, InputStream plainTextDict) throws IOException {
        super(hideLinkingElement, plainTextDict);
        this.setExceptionFile(EXCEPTION_DICT);
    }

    public GermanWordSplitter(boolean hideLinkingElement) throws IOException {
        this(hideLinkingElement, (String)null);
    }

    @Override
    protected Set<String> getWordList() throws IOException {
        if (this.words == null) {
            this.words = this.loadWords();
        }
        return this.words;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> loadWords() throws IOException {
        if (this.plainTextDict != null) {
            return FileTools.loadFileToSet(this.plainTextDict, "utf-8");
        }
        if (this.plainTextDictFile != null) {
            FileInputStream fis = new FileInputStream(this.plainTextDictFile);
            try {
                Set<String> set = FileTools.loadFileToSet(fis, "utf-8");
                return set;
            }
            finally {
                fis.close();
            }
        }
        return (HashSet)FastObjectSaver.load(SERIALIZED_DICT);
    }

    @Override
    protected int getMinimumWordLength() {
        return this.minimumWordLength;
    }

    public void setMinimumWordLength(int minimumWordLength) {
        this.minimumWordLength = minimumWordLength;
    }

    @Override
    protected Collection<String> getConnectingCharacters() {
        return INTERFIXES;
    }
}

