#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#define INCL_WIN
#define INCL_GPI
#define INCL_DOS
#include <os2.h>
#include "gif.h"
#define MAX_COLORS 256





int  Debug=0;


GRAPHIC_CONTROL           GrExt;
GIF_HEADER                Header;
LOGICAL_SCREEN_DESCRIPTOR Descriptor;
char  Follower,Extension,ExtSize;
GIFCOLOR ColorTable[256];
IMAGE_DESCRIPTOR Image;
char  DataBuffer[256];
int   HasExtension=0;
int   HasGraphicExtension=0;
int   minColor;
BOOL SetTransparent(HAB hab,PSIZEL pBWSizel,PCHAR * pBWBitBuffer,PBITMAPINFO2 *ppBWBmi,
                    PSIZEL pCSizel, PCHAR * pCBitBuffer ,PBITMAPINFO2 *ppCBmi);
extern void FileToGif(unsigned long hbm,char *Path);
extern void ConvertToGif(char * FileName);
void ReadWrite(void *Buffer,int Num,size_t Size,FILE *In,FILE *Out) {
     if (In)   fread(Buffer,Num,Size,In);
     if (Out) fwrite(Buffer,Num,Size,Out);

}
void ReadColorTable(FILE* InGif,FILE* OutGif,int TableSize) {
    if (TableSize<=sizeof(ColorTable)) {
       ReadWrite((void *)ColorTable,TableSize,sizeof(GIFCOLOR),InGif,OutGif);
        if (Debug) fprintf(stderr,"Read color table of size %d\n",TableSize);
    } else {
        if (Debug) fprintf(stderr,"No room for color table\n");
       return;
    }
}
void SkipData(FILE* InGif,FILE* OutGif) {
   ExtSize=0;
   ReadWrite((void *)&ExtSize,1,sizeof(ExtSize),InGif,OutGif);
   do {
      ReadWrite((void *)&DataBuffer,ExtSize,1,InGif,OutGif);
      ExtSize=0;
      ReadWrite((void *)&ExtSize,1,sizeof(ExtSize),InGif,OutGif);
   } while (ExtSize>0);
}
void DmpGif(FILE* InGif,FILE* OutGif) {
   int TableSize;
   ReadWrite((void *)&Header,1,sizeof(Header),InGif,0);
   if (strncmp(Header.gif,"GIF",3)) {
      fprintf(stderr,"Not a GIF file\n");
      return;
   } else {
       if (Debug) fprintf(stderr,"GIF %2.2s\n",Header.year);
   }
   memcpy(Header.year,"89a",sizeof(Header.year));
   ReadWrite((void *)&Header,1,sizeof(Header),0,OutGif);
   /*----------------*/
   ReadWrite((void *)&Descriptor,1,sizeof(Descriptor),InGif,OutGif);
   if (HasColorTable(Descriptor)) {
      TableSize=ColorTableSize(Descriptor);
      ReadColorTable(InGif,OutGif,TableSize);
   }
   if ((!HasExtension)&&
       (!HasGraphicExtension)&&
       (OutGif!=0)) {
        if (Debug) fprintf(stderr,"Adding extension and graphic extension\n");
       Follower=EXTENSION_FOLLOWS;
       ReadWrite((void *)&Follower,1,sizeof(Follower),0,OutGif);
       Extension=GRAPHIC_CONTROL_EXTENSION;
       ReadWrite((void *)&Extension,1,sizeof(Extension),0,OutGif);
       ExtSize=4;
       ReadWrite((void *)&ExtSize,1,sizeof(ExtSize),0,OutGif);
       memset(&GrExt,0,sizeof(GrExt));
       SETTRANSPARENT(GrExt);
       GrExt.transparentColorIndex=minColor;
       ReadWrite((void *)&GrExt,1,ExtSize,0,OutGif);
       Extension=0;
       ReadWrite((void *)&Extension,1,sizeof(Extension),0,OutGif);
   }
   do {
      Follower=TRAILER_FOLLOWS;
      ReadWrite((void *)&Follower,1,sizeof(Follower),InGif,OutGif);
      switch (Follower) {
          case  EXTENSION_FOLLOWS:
            HasExtension=1;
            if ((!HasGraphicExtension)&&
                (OutGif!=0)) {
                if (Debug) fprintf(stderr,"Adding graphic extension\n");
                Extension=GRAPHIC_CONTROL_EXTENSION;
                ReadWrite((void *)&Extension,1,sizeof(Extension),0,OutGif);
                ExtSize=4;
                ReadWrite((void *)&ExtSize,1,sizeof(ExtSize),0,OutGif);
                memset(&GrExt,0,sizeof(GrExt));
                SETTRANSPARENT(GrExt);
                GrExt.transparentColorIndex=minColor;
                ReadWrite((void *)&GrExt,1,ExtSize,0,OutGif);
                Extension=0;
                ReadWrite((void *)&Extension,1,sizeof(Extension),0,OutGif);
            }
            ReadWrite((void *)&Extension,1,sizeof(Extension),InGif,OutGif);
            switch (Extension) {
               case  PLAIN_TEXT_EXTENSION:
                  if (Debug) fprintf(stderr,"Plain text extension\n");
                  SkipData(InGif,OutGif);
                  break;
               case  GRAPHIC_CONTROL_EXTENSION:
                  if (Debug) fprintf(stderr,"Graphic control extension\n");
                  HasGraphicExtension=1;
                  ExtSize=0;
                  ReadWrite((void *)&ExtSize,1,sizeof(ExtSize),InGif,0);
                  if (ExtSize>0) {
                      memset(&GrExt,0x0,sizeof(GrExt));
                      ReadWrite((void *)&GrExt,1,ExtSize,InGif,0);
                      if (ExtSize<4) {
                         ExtSize=4;
                      }
                      ReadWrite((void *)&GrExt,1,ExtSize,0,OutGif);
                  }
                  if (ExtSize>0) {
                      if (HasTransparent(GrExt)) {
                          if (Debug) fprintf(stderr,"Has a transparent color %d\n",(int)GrExt.transparentColorIndex);
                          ReadWrite((void *)&GrExt,1,ExtSize,InGif,OutGif);
                      } else {
                          if (Debug) fprintf(stderr,"Setting a graphic extension\n");
                          ReadWrite((void *)&GrExt,1,ExtSize,InGif,0);
                          SETTRANSPARENT(GrExt);
                          GrExt.transparentColorIndex=minColor;
                          ReadWrite((void *)&GrExt,1,ExtSize,0,OutGif);
                          Extension=0;
                          ReadWrite((void *)&Extension,1,sizeof(Extension),0,OutGif);
                      }
                  }
                  break;
               case  COMMENT_EXTENSION:
                  if (Debug) fprintf(stderr,"Comment extension\n");
                  SkipData(InGif,OutGif);
                  break;
               case  APPLICATION_EXTENSION:
                  if (Debug) fprintf(stderr,"Application extension\n");
                  SkipData(InGif,OutGif);
                  break;
               default:
                  fprintf(stderr,"Unknown %2.2X\n",Extension);

                  break;

            }
            break;
          case  IMAGE_DESCRIPTOR_FOLLOWS:
            if (Debug) fprintf(stderr,"Image descriptor\n");
            ReadWrite((void *)&Image,1,sizeof(Image),InGif,OutGif);
            if (HasColorTable(Image)) {
               TableSize=ColorTableSize(Image);
               ReadColorTable(InGif,OutGif,TableSize);
            }
            /* Read image data table */
            SkipData(InGif,OutGif);
            break;

          case  TRAILER_FOLLOWS:
            if (Debug) fprintf(stderr,"Trailer\n");
            break;
          default:
            break;
      }
   } while (Follower!=TRAILER_FOLLOWS);

}
VOID GetError(HAB hab,char *fmt,...) {
   ERRORID    Error;
   PERRINFO   ErrorInfo;
   ULONG      *szInfo;
   int        er;
   va_list    arg_ptr;
   va_start(arg_ptr,fmt);
   vprintf(fmt,arg_ptr);
   ErrorInfo=WinGetErrorInfo(hab);
   szInfo=(ULONG *)(((char*)ErrorInfo)+ErrorInfo->offaoffszMsg);
   for (er=0;er<ErrorInfo->cDetailLevel;er++) {
       fprintf(stderr,"Error %s\n",((char*)ErrorInfo)+szInfo[er]);
   }
   WinFreeErrorInfo(ErrorInfo);
   va_end(arg_ptr);
}
BOOL GetBitmapData(HAB hab,HBITMAP hBm,PSIZEL pSizel,PCHAR  * pBitBuffer,PBITMAPINFO2 *ppBmi,BOOL Color) {
   BITMAPINFOHEADER2 Bmi;
   HDC               hdc;
   ULONG             ColorSize,bufferSize,lineSize,bitLineSize;
   HPS               hps;
   Bmi.cbFix=sizeof(Bmi);
   if (!GpiQueryBitmapInfoHeader(hBm,&Bmi)) {
      GetError(hab,"Info header failed %p\n",hBm);
      return FALSE;
   }
   ColorSize=1<<(Bmi.cPlanes*Bmi.cBitCount);
   if (Color&(ColorSize>MAX_COLORS)) {
       fprintf(stderr,"Supports only %d max color icons\n",MAX_COLORS);
       return FALSE;
   }
   if ((!Color)&(ColorSize!=2)) {
       fprintf(stderr,"No Mask in .ICO %d,%X\n",ColorSize,Color);
       return FALSE;
   }
   if (Debug)
   fprintf(stderr,"cx %d cy %d Planes %d Count %d Bytes %d Size %d\n",
   Bmi.cx,Bmi.cy,
   Bmi.cPlanes,
   Bmi.cBitCount,
   Bmi.cbImage,
   ColorSize
   );
   pSizel->cx=Bmi.cx;
   pSizel->cy=Bmi.cy;
   hdc=DevOpenDC (hab, OD_MEMORY, "*", 0, 0,0);
   hps=GpiCreatePS(hab,hdc,pSizel,PU_PELS|GPIF_DEFAULT|GPIT_NORMAL|GPIA_ASSOC);
   GpiSetBitmap (hps,hBm);
   if (hps!=0) {
      int l,c,b;
      if (DosAllocMem((PVOID *)ppBmi,sizeof(BITMAPINFO2)+(ColorSize)*sizeof(RGB2),fALLOC)) {
          *ppBmi=0;
          fprintf(stderr,"Alloc Failed\n");
          return FALSE;
      }
      memset(*ppBmi,0x00,sizeof(BITMAPINFO2)+(ColorSize)*sizeof(RGB2));
      (*ppBmi)->cbFix=16;
      (*ppBmi)->ulCompression=BCA_UNCOMP;
      (*ppBmi)->usRecording=BRA_BOTTOMUP;
      (*ppBmi)->usRendering=BRH_NOTHALFTONED;
      (*ppBmi)->ulColorEncoding=BCE_RGB;
      (*ppBmi)->cPlanes=Bmi.cPlanes;
      (*ppBmi)->cBitCount=Bmi.cBitCount;
      ColorSize=1<<(Bmi.cPlanes*Bmi.cBitCount);
      lineSize=((Bmi.cBitCount*Bmi.cx+31)/32)*Bmi.cPlanes;
      bitLineSize =(Bmi.cBitCount*Bmi.cx*Bmi.cPlanes)-((lineSize-1)*32);
      bufferSize=lineSize*4*Bmi.cy;
      if (Debug) fprintf(stderr,"Alloc bit data size of %d \n",bufferSize);
      if (DosAllocMem((PVOID*)pBitBuffer,bufferSize,fALLOC)) {
          *pBitBuffer=0;
          fprintf(stderr,"Alloc Failed\n");
          return FALSE;
      }
      memset(*pBitBuffer ,0xFF,bufferSize);
      if (GpiQueryBitmapBits(hps,
                         0,Bmi.cy,(char *)(*pBitBuffer),
                         *ppBmi)>0) {
      } else {
         GetError(hab,"BW get data failed\n");
         return FALSE;
      }
      GpiDestroyPS(hps);
   }
   return TRUE;

}
BOOL SetTransparent(HAB hab,PSIZEL pBWSizel,PCHAR  * pBWBitBuffer,PBITMAPINFO2 *ppBWBmi,
                    PSIZEL pCSizel, PCHAR  * pCBitBuffer ,PBITMAPINFO2 *ppCBmi) {
   ULONG    Index;
   ULONG    ColorSize;
   ULONG    CBitCount,Nibbles;
   ULONG    CLineSize,BWLineSize;
   ULONG    CLineChars,BWLineChars;
   ULONG    ColorUsed[MAX_COLORS];
   ULONG    Mask;
   int      l,c,Cloffset,Cboffset;
   int      BWloffset,BWboffset;
   int      minUse;
   CLineSize =4*(((*ppCBmi)->cBitCount *(*ppCBmi)->cx+31)/32) *(*ppCBmi)->cPlanes;
   BWLineSize=4*(((*ppBWBmi)->cBitCount*(*ppBWBmi)->cx+31)/32)*(*ppBWBmi)->cPlanes;
   BWLineChars=(((*ppBWBmi)->cBitCount*(*ppBWBmi)->cx+7)/8)*(*ppBWBmi)->cPlanes;
   CLineChars =(((*ppCBmi)->cBitCount *(*ppCBmi)->cx+7)/8) *(*ppCBmi)->cPlanes;
   CBitCount =(((*ppCBmi)->cPlanes)*((*ppCBmi)->cBitCount));
   Nibbles=8/CBitCount;
   ColorSize=1<<CBitCount;
   Mask =ColorSize-1;
   if (Debug) fprintf(stderr,"base mask %8.8X Nibbles %d\n",Mask,Nibbles);

   for (l=0;l<(pBWSizel->cy)/2;l++) {
      for (c=0;c<BWLineChars;c++) {
          int top,b;
          BWloffset=((*ppBWBmi)->cBitCount*c)/32;
          /* Comupte transparent bits */
          ((*pBWBitBuffer)[c+(l+(pBWSizel->cy)/2)*BWLineSize])&=
               ~((*pBWBitBuffer)[c+(l)*BWLineSize]);
          /* Copy invert in the other part */
          ((*pBWBitBuffer)[c+(l)*BWLineSize])=
             ~((*pBWBitBuffer)[c+(l+(pBWSizel->cy)/2)*BWLineSize]);
          if (c<BWLineSize-1) top=8;
          else top=pBWSizel->cx%8;
          if (top==0) top=8;
          for (b=0;b<top;b++) {
             int bb;
             bb=(7-(b%8));
             if (((*pBWBitBuffer)[c+(l+(pBWSizel->cy)/2)*BWLineSize])&(1<<bb)) {
                  if (Debug) fprintf(stderr,"1");
             } else {
                  if (Debug) fprintf(stderr,"0");
             }
          }

      }
      if (Debug) fprintf(stderr,"\n");
   }
   if (Debug) fprintf(stderr,"\n");
   for (c=0;c<MAX_COLORS;c++) {
      ColorUsed[c]=0;
   }
   if (Debug) {
      fprintf(stderr,"dump colors line size %d \n",CLineChars);
      for (l=pCSizel->cy-1;l>=0;l--) {
         for (c=0;c<CLineChars;c++) {
             fprintf(stderr,"%2.2X",((*pCBitBuffer)[c]));
         }
         fprintf(stderr,"\n");
      }
      fprintf(stderr,"\n");
   }
   for (l=pCSizel->cy-1;l>=0;l--) {
      for (c=0;c<pCSizel->cx;c++) {
          BWloffset=c/8;
          BWboffset=7-(c%8);
          ((*pBWBitBuffer)[c/32+l*BWLineSize])&(1<<BWboffset);
          Cloffset=(CBitCount*c)/8;
          Cboffset=(CBitCount*c)%8;
          if (CBitCount<8) {
             Cboffset=(8-CBitCount)-Cboffset;
          }
/* if (Debug) fprintf(stderr,"\n COff=%2.2d;BWoff %2.2d;BWdat=%2.2X;Cdat=%1.1X : ",
      Cboffset,BWboffset,
      ((*pBWBitBuffer)[BWloffset+l*BWLineSize]),
      ((*pCBitBuffer)[Cloffset+l*CLineSize])>>Cboffset
      ); */
          Index=((Mask<<Cboffset)&((*pCBitBuffer)[Cloffset+l*CLineSize]))>>Cboffset;
          if ((1<<BWboffset)&((*pBWBitBuffer)[BWloffset+l*BWLineSize])) {
             ColorUsed[Index]++;
             if (Debug) {
                if (CBitCount<8) fprintf(stderr,"%1.1X",Index);
                else             fprintf(stderr,"%2.2X",Index);
             }
          } else {
             if (Debug) {
                if (CBitCount<8) fprintf(stderr,"-",Index);
                else             fprintf(stderr,"--",Index);
             }
          }
      }
      if (Debug) fprintf(stderr,"\n");
   }
   minColor=0;
   minUse=pCSizel->cx*pCSizel->cy; /* Set maximum possible usage in min */
   for (c=0;c<MAX_COLORS;c++) {
      if (ColorUsed[c]<minUse) {
         minUse=ColorUsed[c];
         minColor=c;
      }
   }
   if (Debug) fprintf(stderr,"Color less used %X %d\n",minColor,minUse);
   for (l=pCSizel->cy-1;l>=0;l--) {
      for (c=0;c<pCSizel->cx;c++) {
          BWloffset=c/8;
          BWboffset=7-(c%8);
          ((*pBWBitBuffer)[c/8+l*BWLineSize])&(1<<BWboffset);
          Cloffset=(CBitCount*c)/8;
          Cboffset=(CBitCount*c)%8;
          if (CBitCount<8) {
             Cboffset=(8-CBitCount)-Cboffset;
          }
          Index=((Mask<<Cboffset)&((*pCBitBuffer)[Cloffset+l*CLineSize]))>>Cboffset;
          if ((1<<BWboffset)&((*pBWBitBuffer)[BWloffset+l*BWLineSize])) {
             if (Debug) {
                if (CBitCount<8) fprintf(stderr,"%1.1X",Index);
                else             fprintf(stderr,"%2.2X",Index);
             }
          } else {
             if (Debug) {
                if (CBitCount<8) fprintf(stderr,"%1.1X",minColor);
                else             fprintf(stderr,"%2.2X",minColor);
             }
             (*pCBitBuffer)[Cloffset+l*CLineSize]&=(~(Mask<<Cboffset));
             (*pCBitBuffer)[Cloffset+l*CLineSize]|=(minColor<<Cboffset);
          }
      }
      if (Debug) fprintf(stderr,"\n");
   }
   return TRUE;

}
BOOL SetBitmapData(HAB hab,HBITMAP hBm,PSIZEL pSizel,PCHAR  * pBitBuffer,PBITMAPINFO2 *ppBmi,BOOL Color) {
   BITMAPINFOHEADER2 Bmi;
   HDC               hdc;
   ULONG             ColorSize,bufferSize,lineSize,bitLineSize;
   HPS               hps;
   Bmi.cbFix=sizeof(Bmi);
   if (!GpiQueryBitmapInfoHeader(hBm,&Bmi)) {
      GetError(hab,"Info header failed %p\n",hBm);
      return FALSE;
   }
   pSizel->cx=Bmi.cx;
   pSizel->cy=Bmi.cy;
   hdc=DevOpenDC (hab, OD_MEMORY, "*", 0, 0,0);
   hps=GpiCreatePS(hab,hdc,pSizel,PU_PELS|GPIF_DEFAULT|GPIT_NORMAL|GPIA_ASSOC);
   GpiSetBitmap (hps,hBm);
   if (hps!=0) {
      int l,c,b;
      if (GpiSetBitmapBits(hps,
                         0,Bmi.cy,(char *)(*pBitBuffer),
                         *ppBmi)>0) {
          if (Debug) fprintf(stderr,"Set OK\n");
      } else {
         GetError(hab,"Set data failed\n");
         return FALSE;
      }
      GpiDestroyPS(hps);
   }
   return TRUE;

}
void APIENTRY Ico2Gif(HAB hab,PPOINTERINFO pPointerInfo,char *Path) {
   FILE *       InGif;
   FILE *       OutGif;
   HPOINTER     hPointer;

   PBITMAPINFO2 pBWBmi=0;
   SIZEL        BWsizel;
   CHAR  *      BWbitBuffer=0;
   PBITMAPINFO2 pCBmi=0;
   SIZEL        Csizel;
   CHAR  *      CbitBuffer=0;
   if (!GetBitmapData(hab,pPointerInfo->hbmPointer,&BWsizel,&BWbitBuffer,&pBWBmi,FALSE)) {
      if (BWbitBuffer) DosFreeMem(BWbitBuffer);
      if (pBWBmi)      DosFreeMem(pBWBmi);
      return;
   }
   if (!GetBitmapData(hab,pPointerInfo->hbmColor,&Csizel,&CbitBuffer,&pCBmi,TRUE)) {
      if (CbitBuffer) DosFreeMem(CbitBuffer);
      if (pCBmi)      DosFreeMem(pCBmi);
      return;
   }
   if (!SetTransparent(hab,&BWsizel,&BWbitBuffer,&pBWBmi,
                       &Csizel,&CbitBuffer,&pCBmi)) {
      if (BWbitBuffer) DosFreeMem(BWbitBuffer);
      if (pBWBmi)      DosFreeMem(pBWBmi);
      if (CbitBuffer) DosFreeMem(CbitBuffer);
      if (pCBmi)      DosFreeMem(pCBmi);
      return;
   }
   if (!SetBitmapData(hab,pPointerInfo->hbmColor,&Csizel,&CbitBuffer,&pCBmi,TRUE)) {
      GetError(hab,"Set data failed\n");
      if (BWbitBuffer) DosFreeMem(BWbitBuffer);
      if (pBWBmi)      DosFreeMem(pBWBmi);
      if (CbitBuffer)  DosFreeMem(CbitBuffer);
      if (pCBmi)       DosFreeMem(pCBmi);
      return;
   }
   if (Debug) fprintf(stderr,"File to Gif\n");
   sprintf(DataBuffer,"%s.TMP",Path);
   if (Debug) fprintf(stderr,"Temp file name %s\n",DataBuffer);
   FileToGif(pPointerInfo->hbmColor,DataBuffer);
   if (Debug) fprintf(stderr,"Open Temp file name %s\n",DataBuffer);
   fflush(stderr);
   InGif=fopen(DataBuffer,"rb");
   if (InGif) {
     DmpGif(InGif,0);
     fclose(InGif);
   } else {
   }
   sprintf(DataBuffer,"%s.TMP",Path);
   InGif=fopen(DataBuffer,"rb");
   if (InGif) {
     sprintf(DataBuffer,"%s.GIF",Path);
     if (Debug) fprintf(stderr,"Open file out %s\n",DataBuffer);
     fflush(stderr);

     OutGif=fopen(DataBuffer,"wb");
     if (OutGif) {
        DmpGif(InGif,OutGif);
        fclose(OutGif);
     } else {
        if (Debug) fprintf(stderr,"Open file out %s failed\n",DataBuffer);
        fflush(stderr);
     }
     fclose(InGif);
   } else {
     if (Debug) fprintf(stderr,"Open file in  %s failed\n",DataBuffer);
     fflush(stderr);
   }
   if (BWbitBuffer) DosFreeMem(BWbitBuffer);
   if (pBWBmi)      DosFreeMem(pBWBmi);
   if (CbitBuffer)  DosFreeMem(CbitBuffer);
   if (pCBmi)       DosFreeMem(pCBmi);
}



