/* ListCanvas: This class paints a List view.  It is used by the */
/*    DataContainer object.                                      */

package extend.awt;

import java.awt.*;

public class ListCanvas extends Canvas {

   protected ListCanvas (DataContainer dc) {

      setBackground (Color.white);

      parent = dc;
   }

   public void paint (Graphics g) {    

      FontMetrics fm = getFontMetrics (getFont ());
      int lHeight = fm.getHeight ();
      ContainerItem item = parent.getRoot ();
      int lines = 0;
      int y = lHeight;
      int width = 0;

      parent.clearHotSpotList ();
      parent.drawDataArea (g, 0, size ());

      if (item != null)
         item = item.getItem (parent.getFirst ());

      while ((item != null) && (y < size ().height)) {

         width = fm.stringWidth (item.textFor ().replace ('\n', ' ')) + 4;

         g.setColor (Color.black);

         if (item.isSelected ()) {

            g.setColor (new Color (0, 0, 64));
            g.fillRect (2, y - lHeight + 4, width, lHeight);
            g.setColor (Color.white);
         }

         parent.addHotSpot (4, y - lHeight, width, lHeight, item,
                            DataContainer.Selectable, this);

         g.drawString (item.textFor ().replace ('\n', ' '), 4, y);
         y += lHeight;
         lines++;

         item = item.getNext ();
      }

      parent.setLines (lines);
   }

   private DataContainer parent;
}
