/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svn;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.tmatesoft.svn.cli.svn.SVNCommand;
import org.tmatesoft.svn.cli.svn.SVNNotifyPrinter;
import org.tmatesoft.svn.cli.svn.SVNOption;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNPath;
import org.tmatesoft.svn.core.wc.SVNWCClient;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNAddCommand
extends SVNCommand {
    public SVNAddCommand() {
        super("add", null);
    }

    protected Collection createSupportedOptions() {
        LinkedList<SVNOption> options = new LinkedList<SVNOption>();
        options.add(SVNOption.TARGETS);
        options.add(SVNOption.NON_RECURSIVE);
        options.add(SVNOption.DEPTH);
        options.add(SVNOption.QUIET);
        options.add(SVNOption.FORCE);
        options.add(SVNOption.NO_IGNORE);
        options.add(SVNOption.AUTOPROPS);
        options.add(SVNOption.NO_AUTOPROPS);
        options.add(SVNOption.PARENTS);
        return options;
    }

    public void run() throws SVNException {
        SVNDepth depth;
        List targets = this.getSVNEnvironment().combineTargets(this.getSVNEnvironment().getTargets(), true);
        if (targets.isEmpty()) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.CL_INSUFFICIENT_ARGS), SVNLogType.CLIENT);
        }
        if ((depth = this.getSVNEnvironment().getDepth()) == SVNDepth.UNKNOWN) {
            depth = SVNDepth.INFINITY;
        }
        SVNWCClient client = this.getSVNEnvironment().getClientManager().getWCClient();
        if (!this.getSVNEnvironment().isQuiet()) {
            client.setEventHandler(new SVNNotifyPrinter(this.getSVNEnvironment()));
        }
        for (String targetName : targets) {
            SVNPath target = new SVNPath(targetName);
            if (target.isURL()) continue;
            try {
                client.doAdd(target.getFile(), this.getSVNEnvironment().isForce(), false, this.getSVNEnvironment().isParents(), depth, this.getSVNEnvironment().isNoIgnore(), this.getSVNEnvironment().isParents());
            }
            catch (SVNException e) {
                this.getSVNEnvironment().handleWarning(e.getErrorMessage(), new SVNErrorCode[]{SVNErrorCode.ENTRY_EXISTS, SVNErrorCode.WC_PATH_NOT_FOUND}, this.getSVNEnvironment().isQuiet());
            }
        }
    }
}

