/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svn;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import java.util.regex.PatternSyntaxException;
import org.tmatesoft.svn.cli.SVNCommandUtil;
import org.tmatesoft.svn.cli.svn.SVNNotifyPrinter;
import org.tmatesoft.svn.cli.svn.SVNOption;
import org.tmatesoft.svn.cli.svn.SVNXMLCommand;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNLogEntryPath;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNPath;
import org.tmatesoft.svn.core.wc.SVNLogClient;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNRevisionRange;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNLogCommand
extends SVNXMLCommand
implements ISVNLogEntryHandler {
    private static final String SEPARATOR = "------------------------------------------------------------------------\n";
    private LinkedList myMergeStack;
    private String myAuthorOfInterest;
    private String myLogRegularExpression;

    public SVNLogCommand() {
        super("log", null);
    }

    public boolean acceptsRevisionRange() {
        return true;
    }

    protected Collection createSupportedOptions() {
        LinkedList<SVNOption> options = new LinkedList<SVNOption>();
        options.add(SVNOption.REVISION);
        options.add(SVNOption.QUIET);
        options.add(SVNOption.VERBOSE);
        options.add(SVNOption.USE_MERGE_HISTORY);
        options.add(SVNOption.CHANGE);
        options.add(SVNOption.TARGETS);
        options.add(SVNOption.STOP_ON_COPY);
        options.add(SVNOption.INCREMENTAL);
        options.add(SVNOption.XML);
        options.add(SVNOption.LIMIT);
        options.add(SVNOption.WITH_ALL_REVPROPS);
        options.add(SVNOption.WITH_NO_REVPROPS);
        options.add(SVNOption.WITH_REVPROP);
        options.add(SVNOption.AUTHOR_OF_INTEREST);
        options.add(SVNOption.REGULAR_EXPRESSION);
        return options;
    }

    public void run() throws SVNException {
        SVNErrorMessage err;
        LinkedList<SVNRevisionRange> revisionRanges;
        if (!this.getSVNEnvironment().isXML()) {
            SVNErrorMessage err2;
            if (this.getSVNEnvironment().isAllRevisionProperties()) {
                err2 = SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "'with-all-revprops' option only valid in XML mode");
                SVNErrorManager.error(err2, SVNLogType.CLIENT);
            }
            if (this.getSVNEnvironment().getRevisionProperties() != null) {
                err2 = SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "'with-revprop' option only valid in XML mode");
                SVNErrorManager.error(err2, SVNLogType.CLIENT);
            }
        }
        List<String> targets = new ArrayList();
        if (this.getSVNEnvironment().getTargets() != null) {
            targets.addAll(this.getSVNEnvironment().getTargets());
        }
        if ((targets = this.getSVNEnvironment().combineTargets(targets, true)).isEmpty()) {
            targets.add("");
        }
        SVNPath target = new SVNPath((String)targets.get(0), true);
        SVNRevision start = this.getSVNEnvironment().getStartRevision();
        SVNRevision end = this.getSVNEnvironment().getEndRevision();
        LinkedList<SVNRevisionRange> editedRevisionRangesList = revisionRanges = this.getSVNEnvironment().getRevisionRanges();
        if (this.getSVNEnvironment().isChangeOptionUsed()) {
            editedRevisionRangesList = new LinkedList<SVNRevisionRange>();
            if (this.getSVNEnvironment().isRevisionOptionUsed() && revisionRanges.size() > 1) {
                err = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "-c and -r are mutually exclusive");
                SVNErrorManager.error(err, SVNLogType.CLIENT);
            }
            for (SVNRevisionRange revRange : revisionRanges) {
                SVNRevision startRev = revRange.getStartRevision();
                SVNRevision endRev = revRange.getEndRevision();
                revRange = startRev.getNumber() < endRev.getNumber() ? new SVNRevisionRange(endRev, endRev) : new SVNRevisionRange(startRev, startRev);
                editedRevisionRangesList.add(revRange);
            }
            if (start.getNumber() < end.getNumber()) {
                start = end;
            } else {
                end = start;
            }
        }
        if (start != SVNRevision.UNDEFINED && end == SVNRevision.UNDEFINED) {
            end = start;
        } else if (start == SVNRevision.UNDEFINED) {
            start = target.getPegRevision() == SVNRevision.UNDEFINED ? (target.isURL() ? SVNRevision.HEAD : SVNRevision.BASE) : target.getPegRevision();
            if (end == SVNRevision.UNDEFINED) {
                end = SVNRevision.create(0L);
            }
        }
        if (target.isURL()) {
            for (int i = 1; i < targets.size(); ++i) {
                if (!SVNCommandUtil.isURL((String)targets.get(i))) continue;
                SVNErrorMessage err3 = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Only relative paths can be specified after a URL");
                SVNErrorManager.error(err3, SVNLogType.CLIENT);
            }
        } else if (targets.size() > 1) {
            err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "When specifying working copy paths, only one target may be given");
            SVNErrorManager.error(err, SVNLogType.CLIENT);
        }
        this.myAuthorOfInterest = this.getSVNEnvironment().getAuthorOfInterest();
        this.myLogRegularExpression = this.getSVNEnvironment().getRegularExpression();
        SVNLogClient client = this.getSVNEnvironment().getClientManager().getLogClient();
        if (!this.getSVNEnvironment().isQuiet()) {
            client.setEventHandler(new SVNNotifyPrinter(this.getSVNEnvironment()));
        }
        String[] revProps = null;
        if (this.getSVNEnvironment().isXML()) {
            if (!this.getSVNEnvironment().isIncremental()) {
                this.printXMLHeader("log");
            }
            if (!this.getSVNEnvironment().isAllRevisionProperties() && this.getSVNEnvironment().getRevisionProperties() != null && !this.getSVNEnvironment().getRevisionProperties().isEmpty()) {
                SVNProperties revPropNames = this.getSVNEnvironment().getRevisionProperties();
                revProps = new String[revPropNames.size()];
                int i = 0;
                for (String propName : revPropNames.nameSet()) {
                    String propVal = revPropNames.getStringValue(propName);
                    if (propVal.length() > 0) {
                        SVNErrorMessage err4 = SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "cannot assign with 'with-revprop' option (drop the '=')");
                        SVNErrorManager.error(err4, SVNLogType.CLIENT);
                    }
                    revProps[i++] = propName;
                }
            } else if (!this.getSVNEnvironment().isAllRevisionProperties()) {
                revProps = !this.getSVNEnvironment().isQuiet() ? new String[]{"svn:author", "svn:date", "svn:log"} : new String[]{"svn:author", "svn:date"};
            }
        } else {
            revProps = !this.getSVNEnvironment().isQuiet() ? new String[]{"svn:author", "svn:date", "svn:log"} : new String[]{"svn:author", "svn:date"};
        }
        if (target.isFile()) {
            client.doLog(new File[]{target.getFile()}, editedRevisionRangesList, target.getPegRevision(), this.getSVNEnvironment().isStopOnCopy(), this.getSVNEnvironment().isVerbose(), this.getSVNEnvironment().isUseMergeHistory(), this.getSVNEnvironment().getLimit(), revProps, (ISVNLogEntryHandler)this);
        } else {
            targets.remove(0);
            String[] paths = targets.toArray(new String[targets.size()]);
            client.doLog(target.getURL(), paths, target.getPegRevision(), editedRevisionRangesList, this.getSVNEnvironment().isStopOnCopy(), this.getSVNEnvironment().isVerbose(), this.getSVNEnvironment().isUseMergeHistory(), this.getSVNEnvironment().getLimit(), revProps, (ISVNLogEntryHandler)this);
        }
        if (this.getSVNEnvironment().isXML() && !this.getSVNEnvironment().isIncremental()) {
            this.printXMLFooter("log");
        } else if (!this.getSVNEnvironment().isIncremental()) {
            this.getSVNEnvironment().getOut().print(SEPARATOR);
        }
    }

    public void handleLogEntry(SVNLogEntry logEntry) throws SVNException {
        if (!this.getSVNEnvironment().isXML()) {
            this.printLogEntry(logEntry);
        } else {
            this.printLogEntryXML(logEntry);
        }
    }

    protected void printLogEntry(SVNLogEntry logEntry) throws SVNException {
        String date;
        SVNDate dateObject;
        if (logEntry == null) {
            return;
        }
        if (this.myAuthorOfInterest != null && !"".equals(this.myAuthorOfInterest) && !this.myAuthorOfInterest.equals(logEntry.getAuthor())) {
            return;
        }
        SVNProperties revisionProperties = logEntry.getRevisionProperties();
        String author = revisionProperties.getStringValue("svn:author");
        String message = revisionProperties.getStringValue("svn:log");
        String dateValue = revisionProperties.getStringValue("svn:date");
        SVNDate sVNDate = dateObject = dateValue == null ? null : SVNDate.parseDate(dateValue);
        if (message == null && logEntry.getRevision() == 0L) {
            return;
        }
        if (!SVNRevision.isValidRevisionNumber(logEntry.getRevision())) {
            if (!this.myMergeStack.isEmpty()) {
                this.myMergeStack.removeLast();
            }
            return;
        }
        if (this.myLogRegularExpression != null) {
            if (message == null) {
                return;
            }
            String[] result = null;
            try {
                result = message.split(this.myLogRegularExpression);
            }
            catch (PatternSyntaxException psy) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "you specified an invalid regular expression: {0}", psy.getMessage());
                SVNErrorManager.error(err, SVNLogType.CLIENT);
            }
            if (result.length == 1 && message.equals(result[0]) && !message.equals(this.myLogRegularExpression)) {
                return;
            }
        }
        StringBuffer buffer = new StringBuffer();
        if (author == null) {
            author = "(no author)";
        }
        String string = date = dateObject == null ? "(no date)" : SVNDate.formatHumanDate(dateObject, this.getSVNEnvironment().getClientManager().getOptions());
        if (!this.getSVNEnvironment().isQuiet() && message == null) {
            message = "";
        }
        buffer.append(SEPARATOR);
        buffer.append("r" + Long.toString(logEntry.getRevision()) + " | " + author + " | " + date);
        if (message != null) {
            int count = SVNCommandUtil.getLinesCount(message);
            buffer.append(" | " + count + (count == 1 ? " line" : " lines"));
        }
        buffer.append("\n");
        if (this.getSVNEnvironment().isVerbose() && logEntry.getChangedPaths() != null) {
            TreeMap sortedPaths = new TreeMap(logEntry.getChangedPaths());
            buffer.append("Changed paths:\n");
            for (String path : sortedPaths.keySet()) {
                SVNLogEntryPath lPath = (SVNLogEntryPath)sortedPaths.get(path);
                buffer.append("   " + lPath.getType() + " " + path);
                if (lPath.getCopyPath() != null) {
                    buffer.append(" (from " + lPath.getCopyPath() + ":" + lPath.getCopyRevision() + ")");
                }
                buffer.append("\n");
            }
        }
        if (this.myMergeStack != null && !this.myMergeStack.isEmpty()) {
            buffer.append("Merged via:");
            Iterator revs = this.myMergeStack.iterator();
            while (revs.hasNext()) {
                long rev = (Long)revs.next();
                buffer.append(" r");
                buffer.append(rev);
                if (revs.hasNext()) {
                    buffer.append(',');
                    continue;
                }
                buffer.append('\n');
            }
        }
        if (message != null) {
            buffer.append("\n" + message + "\n");
        }
        if (logEntry.hasChildren()) {
            Long rev = new Long(logEntry.getRevision());
            if (this.myMergeStack == null) {
                this.myMergeStack = new LinkedList();
            }
            this.myMergeStack.addLast(rev);
        }
        this.getSVNEnvironment().getOut().print(buffer.toString());
    }

    protected void printLogEntryXML(SVNLogEntry logEntry) throws SVNException {
        SVNDate dateObject;
        if (logEntry == null) {
            return;
        }
        if (this.myAuthorOfInterest != null && !"".equals(this.myAuthorOfInterest) && !this.myAuthorOfInterest.equals(logEntry.getAuthor())) {
            return;
        }
        SVNProperties revProps = logEntry.getRevisionProperties();
        String author = revProps.getStringValue("svn:author");
        String message = revProps.getStringValue("svn:log");
        String dateValue = revProps.getStringValue("svn:date");
        SVNDate sVNDate = dateObject = dateValue == null ? null : SVNDate.parseDate(dateValue);
        if (logEntry.getRevision() == 0L && message == null) {
            return;
        }
        if (this.myLogRegularExpression != null) {
            if (message == null) {
                return;
            }
            String[] result = null;
            try {
                result = message.split(this.myLogRegularExpression);
            }
            catch (PatternSyntaxException psy) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "you specified an invalid regular expression: {0}", psy.getMessage());
                SVNErrorManager.error(err, SVNLogType.CLIENT);
            }
            if (result.length == 1 && message.equals(result[0]) && !message.equals(this.myLogRegularExpression)) {
                return;
            }
        }
        if (author != null) {
            author = SVNEncodingUtil.fuzzyEscape(author);
        }
        if (message != null) {
            message = SVNEncodingUtil.fuzzyEscape(message);
        }
        StringBuffer buffer = new StringBuffer();
        if (!SVNRevision.isValidRevisionNumber(logEntry.getRevision())) {
            buffer = this.closeXMLTag("logentry", null);
            this.getSVNEnvironment().getOut().print(buffer.toString());
            if (!this.myMergeStack.isEmpty()) {
                this.myMergeStack.removeLast();
            }
            return;
        }
        buffer = this.openXMLTag("logentry", 1, "revision", Long.toString(logEntry.getRevision()), buffer);
        buffer = this.openCDataTag("author", author, buffer);
        if (dateObject != null && dateObject.getTime() != 0L) {
            String dateString = SVNEncodingUtil.fuzzyEscape(dateObject.format());
            buffer = this.openCDataTag("date", dateString, buffer);
        }
        if (logEntry.getChangedPaths() != null && !logEntry.getChangedPaths().isEmpty()) {
            buffer = this.openXMLTag("paths", 1, null, buffer);
            for (String key : logEntry.getChangedPaths().keySet()) {
                SVNLogEntryPath path = (SVNLogEntryPath)logEntry.getChangedPaths().get(key);
                LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>();
                attrs.put("action", path.getType() + "");
                if (path.getCopyPath() != null) {
                    attrs.put("copyfrom-path", path.getCopyPath());
                    attrs.put("copyfrom-rev", Long.toString(path.getCopyRevision()));
                }
                buffer = this.openXMLTag("path", 2, attrs, buffer);
                buffer.append(SVNEncodingUtil.xmlEncodeCDATA(path.getPath()));
                buffer = this.closeXMLTag("path", buffer);
            }
            buffer = this.closeXMLTag("paths", buffer);
        }
        if (message != null) {
            buffer = this.openCDataTag("msg", message, buffer);
        }
        if (revProps != null) {
            revProps.remove("svn:author");
            revProps.remove("svn:date");
            revProps.remove("svn:log");
        }
        if (revProps != null && !revProps.isEmpty()) {
            buffer = this.openXMLTag("revprops", 1, null, buffer);
            buffer = this.printXMLPropHash(buffer, revProps, false);
            buffer = this.closeXMLTag("revprops", buffer);
        }
        if (logEntry.hasChildren()) {
            if (this.myMergeStack == null) {
                this.myMergeStack = new LinkedList();
            }
            this.myMergeStack.addLast(new Long(logEntry.getRevision()));
        } else {
            buffer = this.closeXMLTag("logentry", buffer);
        }
        this.getSVNEnvironment().getOut().print(buffer.toString());
    }
}

