/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svn;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.tmatesoft.svn.cli.svn.SVNCommand;
import org.tmatesoft.svn.cli.svn.SVNOption;
import org.tmatesoft.svn.cli.svn.SVNShowRevisionType;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNPath;
import org.tmatesoft.svn.core.wc.SVNDiffClient;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNMergeInfoCommand
extends SVNCommand
implements ISVNLogEntryHandler {
    public SVNMergeInfoCommand() {
        super("mergeinfo", null);
    }

    protected Collection createSupportedOptions() {
        LinkedList<SVNOption> options = new LinkedList<SVNOption>();
        options.add(SVNOption.REVISION);
        options.add(SVNOption.SHOW_REVS);
        return options;
    }

    public void run() throws SVNException {
        SVNPath source;
        SVNRevision srcPegRevision;
        SVNErrorMessage err;
        List targets = this.getSVNEnvironment().combineTargets(null, true);
        if (targets.size() < 1) {
            err = SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "Not enough arguments given");
            SVNErrorManager.error(err, SVNLogType.CLIENT);
        }
        if (targets.size() > 2) {
            err = SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "Too many arguments given");
            SVNErrorManager.error(err, SVNLogType.CLIENT);
        }
        if ((srcPegRevision = (source = new SVNPath((String)targets.get(0), true)).getPegRevision()) == SVNRevision.UNDEFINED) {
            srcPegRevision = SVNRevision.HEAD;
        }
        SVNPath target = null;
        SVNRevision tgtPegRevision = null;
        if (targets.size() == 2) {
            target = new SVNPath((String)targets.get(1), true);
            tgtPegRevision = target.getPegRevision();
        } else {
            target = new SVNPath("");
            tgtPegRevision = SVNRevision.UNDEFINED;
        }
        if (tgtPegRevision == SVNRevision.UNDEFINED) {
            tgtPegRevision = target.isURL() ? SVNRevision.HEAD : SVNRevision.BASE;
        }
        SVNDiffClient client = this.getSVNEnvironment().getClientManager().getDiffClient();
        if (this.getSVNEnvironment().getShowRevisionType() == SVNShowRevisionType.MERGED) {
            if (target.isURL()) {
                if (source.isURL()) {
                    client.doGetLogMergedMergeInfo(target.getURL(), tgtPegRevision, source.getURL(), srcPegRevision, false, null, (ISVNLogEntryHandler)this);
                } else {
                    client.doGetLogMergedMergeInfo(target.getURL(), tgtPegRevision, source.getFile(), srcPegRevision, false, null, (ISVNLogEntryHandler)this);
                }
            } else if (source.isURL()) {
                client.doGetLogMergedMergeInfo(target.getFile(), tgtPegRevision, source.getURL(), srcPegRevision, false, null, (ISVNLogEntryHandler)this);
            } else {
                client.doGetLogMergedMergeInfo(target.getFile(), tgtPegRevision, source.getFile(), srcPegRevision, false, null, (ISVNLogEntryHandler)this);
            }
        } else if (this.getSVNEnvironment().getShowRevisionType() == SVNShowRevisionType.ELIGIBLE) {
            if (target.isURL()) {
                if (source.isURL()) {
                    client.doGetLogEligibleMergeInfo(target.getURL(), tgtPegRevision, source.getURL(), srcPegRevision, false, null, (ISVNLogEntryHandler)this);
                } else {
                    client.doGetLogEligibleMergeInfo(target.getURL(), tgtPegRevision, source.getFile(), srcPegRevision, false, null, (ISVNLogEntryHandler)this);
                }
            } else if (source.isURL()) {
                client.doGetLogEligibleMergeInfo(target.getFile(), tgtPegRevision, source.getURL(), srcPegRevision, false, null, (ISVNLogEntryHandler)this);
            } else {
                client.doGetLogEligibleMergeInfo(target.getFile(), tgtPegRevision, source.getFile(), srcPegRevision, false, null, (ISVNLogEntryHandler)this);
            }
        }
    }

    public void handleLogEntry(SVNLogEntry logEntry) throws SVNException {
        String message = MessageFormat.format("r{0}", String.valueOf(logEntry.getRevision()));
        this.getSVNEnvironment().getOut().println(message);
    }
}

