/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svn;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.tmatesoft.svn.cli.SVNCommandUtil;
import org.tmatesoft.svn.cli.svn.SVNOption;
import org.tmatesoft.svn.cli.svn.SVNPropertiesCommand;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNPath;
import org.tmatesoft.svn.core.internal.wc.SVNPropertiesManager;
import org.tmatesoft.svn.core.wc.ISVNPropertyHandler;
import org.tmatesoft.svn.core.wc.SVNPropertyData;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCClient;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNPropGetCommand
extends SVNPropertiesCommand {
    public SVNPropGetCommand() {
        super("propget", new String[]{"pget", "pg"});
    }

    protected Collection createSupportedOptions() {
        LinkedList<SVNOption> options = new LinkedList<SVNOption>();
        options.add(SVNOption.VERBOSE);
        options.add(SVNOption.RECURSIVE);
        options.add(SVNOption.DEPTH);
        options.add(SVNOption.REVISION);
        options.add(SVNOption.REVPROP);
        options.add(SVNOption.STRICT);
        options.add(SVNOption.XML);
        options.add(SVNOption.CHANGELIST);
        return options;
    }

    public void run() throws SVNException {
        SVNErrorMessage err;
        String propertyName = this.getSVNEnvironment().popArgument();
        if (propertyName == null) {
            err = SVNErrorMessage.create(SVNErrorCode.CL_INSUFFICIENT_ARGS);
            SVNErrorManager.error(err, SVNLogType.CLIENT);
        }
        if (!SVNPropertiesManager.isValidPropertyName(propertyName)) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "''{0}'' is not a valid Subversion property name", propertyName);
            SVNErrorManager.error(err, SVNLogType.CLIENT);
        }
        List<String> targets = new LinkedList();
        targets = this.getSVNEnvironment().combineTargets(targets, true);
        if (targets.isEmpty()) {
            targets.add("");
        }
        if (this.getSVNEnvironment().isRevprop()) {
            SVNURL url = this.getRevpropURL(this.getSVNEnvironment().getStartRevision(), targets);
            SVNWCClient wcClient = this.getSVNEnvironment().getClientManager().getWCClient();
            long rev = wcClient.doGetRevisionProperty(url, propertyName, this.getSVNEnvironment().getStartRevision(), (ISVNPropertyHandler)this);
            SVNPropertyData propertyValue = this.getRevisionProperty(rev);
            if (propertyValue != null) {
                if (this.getSVNEnvironment().isXML()) {
                    this.printXMLHeader("properties");
                    StringBuffer buffer = this.openXMLTag("revprops", 1, "rev", Long.toString(rev), null);
                    buffer = this.addXMLProp(propertyValue, buffer);
                    buffer = this.closeXMLTag("revprops", buffer);
                    this.getSVNEnvironment().getOut().print(buffer);
                    this.printXMLFooter("properties");
                } else {
                    if (propertyValue.getValue().isString()) {
                        this.getSVNEnvironment().getOut().print(propertyValue.getValue());
                    } else {
                        try {
                            this.getSVNEnvironment().getOut().write(propertyValue.getValue().getBytes());
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                    if (!this.getSVNEnvironment().isStrict()) {
                        this.getSVNEnvironment().getOut().println();
                    }
                }
            }
            this.clearCollectedProperties();
        } else {
            SVNDepth depth;
            if (this.getSVNEnvironment().isXML()) {
                this.printXMLHeader("properties");
            }
            if ((depth = this.getSVNEnvironment().getDepth()) == SVNDepth.UNKNOWN) {
                depth = SVNDepth.EMPTY;
            }
            boolean likeProplist = this.getSVNEnvironment().isVerbose() && !this.getSVNEnvironment().isStrict();
            Collection changeLists = this.getSVNEnvironment().getChangelistsCollection();
            SVNWCClient client = this.getSVNEnvironment().getClientManager().getWCClient();
            for (String targetPath : targets) {
                SVNPath target = new SVNPath(targetPath, true);
                SVNRevision pegRevision = target.getPegRevision();
                boolean printFileNames = false;
                if (target.isURL()) {
                    client.doGetProperty(target.getURL(), propertyName, pegRevision, this.getSVNEnvironment().getStartRevision(), depth, (ISVNPropertyHandler)this);
                    printFileNames = !this.getSVNEnvironment().isStrict() && (this.getSVNEnvironment().isVerbose() || depth.compareTo(SVNDepth.EMPTY) > 0 || targets.size() > 1 || this.getURLProperties().size() > 1);
                } else {
                    client.doGetProperty(target.getFile(), propertyName, pegRevision, this.getSVNEnvironment().getStartRevision(), depth, this, changeLists);
                    boolean bl = printFileNames = !this.getSVNEnvironment().isStrict() && (this.getSVNEnvironment().isVerbose() || depth.compareTo(SVNDepth.EMPTY) > 0 || targets.size() > 1 || this.getPathProperties().size() > 1);
                }
                if (!this.getSVNEnvironment().isXML()) {
                    this.printCollectedProperties(printFileNames, target.isURL(), likeProplist);
                } else {
                    this.printCollectedPropertiesXML(target.isURL());
                }
                this.clearCollectedProperties();
            }
            if (this.getSVNEnvironment().isXML()) {
                this.printXMLFooter("properties");
            }
        }
    }

    protected void printCollectedProperties(boolean printFileName, boolean isURL, boolean likePropList) {
        Map map = isURL ? this.getURLProperties() : this.getPathProperties();
        for (Object key : map.keySet()) {
            List props = (List)map.get(key);
            if (printFileName) {
                if (isURL) {
                    if (likePropList) {
                        this.getSVNEnvironment().getOut().println("Properties on '" + key + "':");
                    } else {
                        this.getSVNEnvironment().getOut().print(key);
                        this.getSVNEnvironment().getOut().print(" - ");
                    }
                } else {
                    String path = SVNCommandUtil.getLocalPath(this.getSVNEnvironment().getRelativePath((File)key));
                    if (likePropList) {
                        this.getSVNEnvironment().getOut().println("Properties on '" + path + "':");
                    } else {
                        this.getSVNEnvironment().getOut().print(path);
                        this.getSVNEnvironment().getOut().print(" - ");
                    }
                }
            }
            if (likePropList) {
                this.printProplist(props);
                continue;
            }
            SVNPropertyData property = (SVNPropertyData)props.get(0);
            this.printProperty(property.getValue(), likePropList);
            if (this.getSVNEnvironment().isStrict()) continue;
            this.getSVNEnvironment().getOut().println();
        }
    }

    protected void printCollectedPropertiesXML(boolean isURL) {
        Map map = isURL ? this.getURLProperties() : this.getPathProperties();
        for (Object key : map.keySet()) {
            List props = (List)map.get(key);
            String target = key.toString();
            if (!isURL) {
                target = SVNCommandUtil.getLocalPath(this.getSVNEnvironment().getRelativePath((File)key));
            }
            SVNPropertyData property = (SVNPropertyData)props.get(0);
            StringBuffer buffer = this.openXMLTag("target", 1, "path", target, null);
            buffer = this.addXMLProp(property, buffer);
            buffer = this.closeXMLTag("target", buffer);
            this.getSVNEnvironment().getOut().print(buffer);
        }
    }
}

