/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svn;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.tmatesoft.svn.cli.SVNCommandUtil;
import org.tmatesoft.svn.cli.svn.SVNOption;
import org.tmatesoft.svn.cli.svn.SVNPropertiesCommand;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.wc.SVNPath;
import org.tmatesoft.svn.core.wc.ISVNPropertyHandler;
import org.tmatesoft.svn.core.wc.SVNPropertyData;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCClient;

public class SVNPropListCommand
extends SVNPropertiesCommand {
    public SVNPropListCommand() {
        super("proplist", new String[]{"plist", "pl"});
    }

    protected Collection createSupportedOptions() {
        ArrayList<SVNOption> options = new ArrayList<SVNOption>();
        options.add(SVNOption.VERBOSE);
        options.add(SVNOption.RECURSIVE);
        options.add(SVNOption.DEPTH);
        options.add(SVNOption.REVISION);
        options.add(SVNOption.QUIET);
        options.add(SVNOption.REVPROP);
        options.add(SVNOption.XML);
        options.add(SVNOption.CHANGELIST);
        return options;
    }

    public void run() throws SVNException {
        List<String> targets = new ArrayList();
        targets = this.getSVNEnvironment().combineTargets(targets, true);
        if (targets.isEmpty()) {
            targets.add("");
        }
        if (this.getSVNEnvironment().isRevprop()) {
            SVNURL url = this.getRevpropURL(this.getSVNEnvironment().getStartRevision(), targets);
            SVNWCClient wcClient = this.getSVNEnvironment().getClientManager().getWCClient();
            long rev = wcClient.doGetRevisionProperty(url, null, this.getSVNEnvironment().getStartRevision(), (ISVNPropertyHandler)this);
            Map revisionPropertiesMap = this.getRevisionProperties();
            List revisionProperties = (List)revisionPropertiesMap.get(new Long(rev));
            if (revisionProperties == null) {
                revisionProperties = Collections.EMPTY_LIST;
            }
            if (this.getSVNEnvironment().isXML()) {
                this.printXMLHeader("properties");
                StringBuffer buffer = this.openXMLTag("revprops", 1, "rev", Long.toString(rev), null);
                for (SVNPropertyData property : revisionProperties) {
                    buffer = this.addXMLProp(property, buffer);
                }
                buffer = this.closeXMLTag("revprops", buffer);
                this.getSVNEnvironment().getOut().print(buffer);
                this.printXMLFooter("properties");
            } else {
                this.getSVNEnvironment().getOut().println("Unversioned properties on revision " + rev + ":");
                for (SVNPropertyData property : revisionProperties) {
                    this.getSVNEnvironment().getOut().print("  " + property.getName());
                    if (this.getSVNEnvironment().isVerbose()) {
                        this.getSVNEnvironment().getOut().print(" : ");
                        if (property.getValue().isString()) {
                            this.getSVNEnvironment().getOut().print(property.getValue().getString());
                        } else {
                            try {
                                this.getSVNEnvironment().getOut().write(property.getValue().getBytes());
                            }
                            catch (IOException e) {
                                // empty catch block
                            }
                        }
                    }
                    this.getSVNEnvironment().getOut().println();
                }
            }
            this.clearCollectedProperties();
        } else {
            SVNDepth depth;
            if (this.getSVNEnvironment().isXML()) {
                this.printXMLHeader("properties");
            }
            if ((depth = this.getSVNEnvironment().getDepth()) == SVNDepth.UNKNOWN) {
                depth = SVNDepth.EMPTY;
            }
            Collection changeLists = this.getSVNEnvironment().getChangelistsCollection();
            SVNWCClient client = this.getSVNEnvironment().getClientManager().getWCClient();
            for (String targetPath : targets) {
                SVNPath target = new SVNPath(targetPath, true);
                SVNRevision pegRevision = target.getPegRevision();
                try {
                    if (target.isURL()) {
                        client.doGetProperty(target.getURL(), null, pegRevision, this.getSVNEnvironment().getStartRevision(), depth, (ISVNPropertyHandler)this);
                    } else {
                        client.doGetProperty(target.getFile(), null, pegRevision, this.getSVNEnvironment().getStartRevision(), depth, this, changeLists);
                    }
                }
                catch (SVNException e) {
                    this.getSVNEnvironment().handleWarning(e.getErrorMessage(), new SVNErrorCode[]{SVNErrorCode.UNVERSIONED_RESOURCE, SVNErrorCode.ENTRY_NOT_FOUND}, this.getSVNEnvironment().isQuiet());
                }
                if (!this.getSVNEnvironment().isXML()) {
                    this.printCollectedProperties(target.isURL());
                } else {
                    this.printCollectedPropertiesXML(target.isURL());
                }
                this.clearCollectedProperties();
            }
            if (this.getSVNEnvironment().isXML()) {
                this.printXMLFooter("properties");
            }
        }
    }

    protected void printCollectedProperties(boolean isURL) {
        Map map = isURL ? this.getURLProperties() : this.getPathProperties();
        for (Object key : map.keySet()) {
            List props = (List)map.get(key);
            if (!this.getSVNEnvironment().isQuiet()) {
                this.getSVNEnvironment().getOut().print("Properties on '");
                if (isURL) {
                    this.getSVNEnvironment().getOut().print(key);
                } else {
                    String path = SVNCommandUtil.getLocalPath(this.getSVNEnvironment().getRelativePath((File)key));
                    this.getSVNEnvironment().getOut().print(path);
                }
                this.getSVNEnvironment().getOut().println("':");
            }
            this.printProplist(props);
        }
    }

    protected void printCollectedPropertiesXML(boolean isURL) {
        Map map = isURL ? this.getURLProperties() : this.getPathProperties();
        for (Object key : map.keySet()) {
            List props = (List)map.get(key);
            String target = key.toString();
            if (!isURL) {
                target = SVNCommandUtil.getLocalPath(this.getSVNEnvironment().getRelativePath((File)key));
            }
            StringBuffer buffer = this.openXMLTag("target", 1, "path", target, null);
            for (SVNPropertyData property : props) {
                buffer = this.addXMLProp(property, buffer);
            }
            buffer = this.closeXMLTag("target", buffer);
            this.getSVNEnvironment().getOut().print(buffer);
        }
    }
}

