/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svnadmin;

import java.util.Collection;
import java.util.LinkedList;
import org.tmatesoft.svn.cli.svnadmin.SVNAdminCommand;
import org.tmatesoft.svn.cli.svnadmin.SVNAdminOption;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.admin.ISVNAdminEventHandler;
import org.tmatesoft.svn.core.wc.admin.SVNAdminClient;
import org.tmatesoft.svn.core.wc.admin.SVNAdminEvent;
import org.tmatesoft.svn.core.wc.admin.SVNAdminEventAction;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNAdminDumpCommand
extends SVNAdminCommand
implements ISVNAdminEventHandler {
    public SVNAdminDumpCommand() {
        super("dump", null);
    }

    protected Collection createSupportedOptions() {
        LinkedList<SVNAdminOption> options = new LinkedList<SVNAdminOption>();
        options.add(SVNAdminOption.REVISION);
        options.add(SVNAdminOption.INCREMENTAL);
        options.add(SVNAdminOption.DELTAS);
        options.add(SVNAdminOption.QUIET);
        return options;
    }

    public void run() throws SVNException {
        SVNRevision start = this.getSVNAdminEnvironment().getStartRevision();
        SVNRevision end = this.getSVNAdminEnvironment().getEndRevision();
        SVNURL url = SVNURL.fromFile(this.getLocalRepository());
        SVNRepository repository = SVNRepositoryFactory.create(url);
        repository.setCanceller(this.getEnvironment());
        long latestRevision = repository.getLatestRevision();
        long startRev = this.getRevisionNumber(start, latestRevision, repository);
        long endRev = this.getRevisionNumber(end, latestRevision, repository);
        if (startRev < 0L) {
            startRev = 0L;
            endRev = latestRevision;
        } else if (endRev < 0L) {
            endRev = startRev;
        }
        if (startRev > endRev) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "First revision cannot be higher than second"), SVNLogType.CLIENT);
        }
        boolean incremental = this.getSVNAdminEnvironment().isIncremental();
        boolean deltas = this.getSVNAdminEnvironment().isDeltas();
        SVNAdminClient client = this.getEnvironment().getClientManager().getAdminClient();
        if (!this.getSVNAdminEnvironment().isQuiet()) {
            client.setEventHandler(this);
        }
        start = SVNRevision.create(startRev);
        end = SVNRevision.create(endRev);
        client.doDump(this.getLocalRepository(), this.getEnvironment().getOut(), start, end, incremental, deltas);
    }

    public void handleAdminEvent(SVNAdminEvent event, double progress) throws SVNException {
        if (event != null && event.getAction() == SVNAdminEventAction.REVISION_DUMPED) {
            this.getEnvironment().getErr().println(event.getMessage());
        }
    }

    public void handleEvent(SVNEvent event, double progress) throws SVNException {
    }

    public void checkCancelled() throws SVNCancelException {
        this.getEnvironment().checkCancelled();
    }
}

