/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc.admin;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNTreeConflictUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea15;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNLog;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNTreeConflictDescription;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNAdminArea16
extends SVNAdminArea15 {
    public static final int WC_FORMAT = 10;

    public SVNAdminArea16(File dir) {
        super(dir);
    }

    public boolean hasTreeConflict(String victimName) throws SVNException {
        return this.getTreeConflict(victimName) != null;
    }

    public SVNTreeConflictDescription getTreeConflict(String victimName) throws SVNException {
        SVNEntry dirEntry = this.getEntry(this.getThisDirName(), false);
        if (dirEntry == null) {
            return null;
        }
        Map conflicts = dirEntry.getTreeConflicts();
        return (SVNTreeConflictDescription)conflicts.get(this.getFile(victimName));
    }

    public void addTreeConflict(SVNTreeConflictDescription conflict) throws SVNException {
        SVNTreeConflictDescription existingDescription = this.getTreeConflict(conflict.getPath().getName());
        if (existingDescription != null) {
            SVNErrorMessage error = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT, "Attempt to add tree conflict that already exists at ''{0}''", conflict.getPath());
            SVNErrorManager.error(error, SVNLogType.WC);
        }
        SVNHashMap conflicts = new SVNHashMap();
        conflicts.put(conflict.getPath(), conflict);
        String conflictData = SVNTreeConflictUtil.getTreeConflictData(conflicts);
        SVNProperties command = new SVNProperties();
        command.put("name", this.getThisDirName());
        command.put("data", conflictData);
        SVNLog log = this.getLog();
        log.addCommand("add-tree-conflict", command, false);
        log.save();
        this.runLogs();
    }

    public SVNTreeConflictDescription deleteTreeConflict(String victimName) throws SVNException {
        File victimPath;
        SVNEntry dirEntry = this.getEntry(this.getThisDirName(), false);
        Map conflicts = dirEntry.getTreeConflicts();
        if (conflicts.containsKey(victimPath = this.getFile(victimName))) {
            SVNTreeConflictDescription conflict = (SVNTreeConflictDescription)conflicts.remove(victimPath);
            String conflictData = SVNTreeConflictUtil.getTreeConflictData(conflicts);
            SVNHashMap attributes = new SVNHashMap();
            attributes.put("svn:entry:tree-conflicts", conflictData);
            this.modifyEntry(this.getThisDirName(), attributes, true, false);
            return conflict;
        }
        return null;
    }

    public void setFileExternalLocation(String name, SVNURL url, SVNRevision pegRevision, SVNRevision revision, SVNURL reposRootURL) throws SVNException {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        if (url != null) {
            String reposRootStrURL;
            String strURL = url.toDecodedString();
            String path = strURL.substring((reposRootStrURL = reposRootURL.toDecodedString()).length());
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            attributes.put("svn:entry:file-external-peg-revision", pegRevision);
            attributes.put("svn:entry:file-external-revision", revision);
            attributes.put("svn:entry:file-external-path", path);
        } else {
            attributes.put("svn:entry:file-external-peg-revision", SVNRevision.UNDEFINED);
            attributes.put("svn:entry:file-external-revision", SVNRevision.UNDEFINED);
            attributes.put("svn:entry:file-external-path", null);
        }
        this.modifyEntry(name, attributes, true, false);
    }

    public int getFormatVersion() {
        return 10;
    }

    public void postUpgradeFormat(int format) throws SVNException {
        super.postUpgradeFormat(format);
        try {
            SVNFileUtil.deleteFile(this.getAdminFile("format"));
        }
        catch (SVNException sVNException) {
            // empty catch block
        }
    }

    protected void createFormatFile(File formatFile, boolean createMyself) throws SVNException {
    }

    protected boolean readExtraOptions(BufferedReader reader, SVNEntry entry) throws SVNException, IOException {
        if (super.readExtraOptions(reader, entry)) {
            return true;
        }
        String line = reader.readLine();
        if (this.isEntryFinished(line)) {
            return true;
        }
        String treeConflictData = this.parseString(line);
        if (treeConflictData != null) {
            entry.setTreeConflictData(treeConflictData);
        }
        if (this.isEntryFinished(line = reader.readLine())) {
            return true;
        }
        String fileExternalData = this.parseString(line);
        if (fileExternalData != null) {
            this.unserializeExternalFileData(entry, fileExternalData);
        }
        return false;
    }

    protected int writeExtraOptions(Writer writer, String entryName, SVNEntry entry, int emptyFields) throws SVNException, IOException {
        emptyFields = super.writeExtraOptions(writer, entryName, entry, emptyFields);
        String treeConflictData = entry.getTreeConflictData();
        emptyFields = this.writeString(writer, treeConflictData, emptyFields) ? 0 : ++emptyFields;
        String serializedFileExternalData = this.serializeExternalFileData(entry);
        emptyFields = this.writeString(writer, serializedFileExternalData, emptyFields) ? 0 : ++emptyFields;
        return emptyFields;
    }

    private String serializeExternalFileData(SVNEntry entry) throws SVNException {
        String representation = null;
        String path = entry.getExternalFilePath();
        SVNRevision revision = entry.getExternalFileRevision();
        SVNRevision pegRevision = entry.getExternalFilePegRevision();
        if (path != null) {
            String revStr = this.asString(revision, path);
            String pegRevStr = this.asString(pegRevision, path);
            representation = pegRevStr + ":" + revStr + ":" + path;
        }
        return representation;
    }

    private String asString(SVNRevision revision, String path) throws SVNException {
        if (revision == SVNRevision.HEAD || SVNRevision.isValidRevisionNumber(revision.getNumber())) {
            return revision.toString();
        }
        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.INCORRECT_PARAMS, "Illegal file external revision kind {0} for path ''{1}''", new Object[]{revision.toString(), path});
        SVNErrorManager.error(err, SVNLogType.WC);
        return null;
    }

    private void unserializeExternalFileData(SVNEntry entry, String rawExternalFileData) throws SVNException {
        SVNRevision pegRevision = SVNRevision.UNDEFINED;
        SVNRevision revision = SVNRevision.UNDEFINED;
        String path = null;
        if (rawExternalFileData != null) {
            StringBuffer buffer = new StringBuffer(rawExternalFileData);
            pegRevision = this.parseRevision(buffer);
            revision = this.parseRevision(buffer);
            path = buffer.toString();
        }
        entry.setExternalFilePath(path);
        entry.setExternalFilePegRevision(pegRevision);
        entry.setExternalFileRevision(revision);
    }

    private SVNRevision parseRevision(StringBuffer str) throws SVNException {
        int ind = str.indexOf(":");
        if (ind == -1) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.INCORRECT_PARAMS, "Found an unexpected \\0 in the file external ''{0}''", str);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        SVNRevision revision = null;
        String subStr = str.substring(0, ind);
        revision = subStr.equals(SVNRevision.HEAD.getName()) ? SVNRevision.HEAD : SVNRevision.parse(subStr);
        str = str.delete(0, ind + 1);
        return revision;
    }

    protected boolean isEntryPropertyApplicable(String propName) {
        return propName != null;
    }
}

