/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import org.eclipse.jgit.JGitText;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.ReflogEntry;
import org.eclipse.jgit.storage.file.ReflogReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflogCommand
extends GitCommand<Collection<ReflogEntry>> {
    private String ref = "HEAD";

    public ReflogCommand(Repository repo) {
        super(repo);
    }

    public ReflogCommand setRef(String ref) {
        this.checkCallable();
        this.ref = ref;
        return this;
    }

    @Override
    public Collection<ReflogEntry> call() throws Exception {
        this.checkCallable();
        try {
            ReflogReader reader = new ReflogReader(this.repo, this.ref);
            return reader.getReverseEntries();
        }
        catch (IOException e) {
            throw new InvalidRemoteException(MessageFormat.format(JGitText.get().cannotRead, this.ref));
        }
    }
}

