/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.dialog.ButtonPanel;
import com.jidesoft.dialog.ButtonResources;
import com.jidesoft.dialog.JideOptionPane;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.swing.JideBoxLayout;
import com.jidesoft.swing.NullPanel;
import com.jidesoft.swing.PaintPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicOptionPaneUI;

public class BasicJideOptionPaneUI
extends BasicOptionPaneUI {
    private Container _detailsArea;
    private Container _buttonArea;
    private Container _bannerArea;
    private Component _titleComponent;
    private ThemePainter _painter;
    private int _detailsPreferredWidth = -1;
    private static boolean _detailsVisible = false;

    public static ComponentUI createUI(JComponent x) {
        return new BasicJideOptionPaneUI();
    }

    protected LayoutManager createLayoutManager() {
        return new JideBoxLayout(this.optionPane, 1);
    }

    public static boolean isDetailsVisible() {
        return _detailsVisible;
    }

    public static void setDetailsVisible(boolean detailsVisible) {
        _detailsVisible = detailsVisible;
    }

    protected void installComponents() {
        boolean showBanner;
        boolean bl = showBanner = UIDefaultsLookup.get("OptionPane.showBanner") == null || UIDefaultsLookup.getBoolean("OptionPane.showBanner");
        if (showBanner) {
            this._bannerArea = this.createBannerArea();
            this.optionPane.add((Component)this._bannerArea, "fix");
        }
        Container messageArea = this.createMessageArea();
        if (!showBanner) {
            this.addIcon(messageArea);
        }
        LookAndFeel.installBorder((JComponent)messageArea, "OptionPane.border");
        this.optionPane.add(messageArea);
        Container separator = this.createSeparator();
        if (separator != null) {
            this.optionPane.add(separator);
        }
        this._buttonArea = this.createButtonArea();
        this.optionPane.add((Component)this._buttonArea, "fix");
        this.optionPane.applyComponentOrientation(this.optionPane.getComponentOrientation());
        if (this.shouldDetailsButtonVisible()) {
            this.updateDetailsComponent();
        }
        this.optionPane.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("details".equals(evt.getPropertyName())) {
                    Component detailsButton;
                    BasicJideOptionPaneUI.this.updateDetailsComponent();
                    if (BasicJideOptionPaneUI.this._buttonArea instanceof ButtonPanel && (detailsButton = ((ButtonPanel)BasicJideOptionPaneUI.this._buttonArea).getButtonByName("DETAILS")) != null) {
                        detailsButton.setVisible(evt.getNewValue() != null);
                    }
                } else if ("title".equals(evt.getPropertyName())) {
                    BasicJideOptionPaneUI.this.updateTitleComponent(BasicJideOptionPaneUI.this._bannerArea);
                }
            }
        });
    }

    protected void updateDetailsComponent() {
        if (this._detailsArea != null) {
            this.optionPane.remove(this._detailsArea);
            this._detailsArea = null;
        }
        this._detailsArea = this.createDetailsComponent();
        if (this._detailsArea != null) {
            this.optionPane.add((Component)this._detailsArea, "vary");
            this._detailsArea.setVisible(BasicJideOptionPaneUI.isDetailsVisible());
        }
    }

    protected Container createMessageArea() {
        JPanel top = new JPanel();
        Border topBorder = (Border)UIDefaultsLookup.get("OptionPane.messageAreaBorder");
        if (topBorder != null) {
            top.setBorder(topBorder);
        }
        top.setLayout(new BorderLayout());
        JPanel body = new JPanel(new GridBagLayout());
        JPanel realBody = new JPanel(new BorderLayout());
        body.setName("OptionPane.body");
        realBody.setName("OptionPane.realBody");
        if (this.getIcon() != null) {
            JPanel sep = new JPanel();
            sep.setName("OptionPane.separator");
            sep.setPreferredSize(new Dimension(15, 1));
            realBody.add((Component)sep, "Before");
        }
        realBody.add((Component)body, "Center");
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridy = 0;
        cons.gridx = 0;
        cons.gridwidth = 0;
        cons.gridheight = 1;
        int anchor = UIDefaultsLookup.getInt("OptionPane.messageAnchor");
        cons.anchor = anchor == 0 ? 10 : anchor;
        cons.insets = new Insets(0, 0, 3, 0);
        Object message = this.getMessage();
        this.addMessageComponents(body, cons, message, this.getMaxCharactersPerLineCount(), false);
        top.add((Component)realBody, "Center");
        return top;
    }

    protected Container createSeparator() {
        return new JSeparator();
    }

    protected void installDefaults() {
        super.installDefaults();
        this.optionPane.setBorder(BorderFactory.createEmptyBorder());
        this._painter = (ThemePainter)UIDefaultsLookup.get("Theme.painter");
    }

    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this._painter = null;
    }

    protected Container createDetailsComponent() {
        if (!(this.optionPane instanceof JideOptionPane)) {
            return null;
        }
        JideOptionPane jideOptionPane = (JideOptionPane)this.optionPane;
        Object details = jideOptionPane.getDetails();
        if (details instanceof Container) {
            this._detailsPreferredWidth = ((Container)details).getPreferredSize().width;
            return (Container)details;
        }
        if (details instanceof Component) {
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)details);
            this._detailsPreferredWidth = panel.getPreferredSize().width;
            return panel;
        }
        if (details instanceof String) {
            JTextArea area = new JTextArea((String)details);
            area.setEditable(false);
            area.setRows(20);
            area.setColumns(60);
            JPanel panel = new JPanel(new BorderLayout());
            panel.add(new JScrollPane(area));
            panel.setBorder(BorderFactory.createEmptyBorder(10, 6, 10, 6));
            this._detailsPreferredWidth = panel.getPreferredSize().width;
            return panel;
        }
        return null;
    }

    protected Container createButtonArea() {
        boolean sameSize;
        int orientation = UIDefaultsLookup.getInt("OptionPane.buttonOrientation");
        orientation = orientation == 0 ? 0 : orientation;
        ButtonPanel buttonPanel = new ButtonPanel(orientation);
        Border border = (Border)UIDefaultsLookup.get("OptionPane.buttonAreaBorder");
        buttonPanel.setName("OptionPane.buttonArea");
        if (border != null) {
            buttonPanel.setBorder(border);
        }
        buttonPanel.setSizeConstraint((sameSize = UIDefaultsLookup.getBoolean("OptionPane.sameSizeButtons")) ? 0 : 1);
        int padding = UIDefaultsLookup.getInt("OptionPane.buttonPadding");
        padding = padding == 0 ? 6 : padding;
        buttonPanel.setButtonGap(padding);
        this.addButtonComponents(buttonPanel, this.getButtons(), this.getInitialValueIndex());
        return buttonPanel;
    }

    protected void addButtonComponents(Container container, Object[] buttons, int initialIndex) {
        if (buttons != null && buttons.length > 0) {
            int numButtons = buttons.length;
            for (int counter = 0; counter < numButtons; ++counter) {
                Component newComponent;
                Object button = buttons[counter];
                if (button instanceof Component) {
                    newComponent = (Component)button;
                    container.add(newComponent, "ALTERNATIVE");
                    this.hasCustomComponents = true;
                } else {
                    JButton aButton = button instanceof ButtonFactory ? ((ButtonFactory)button).createButton() : (button instanceof Icon ? new JButton((Icon)button) : new JButton(button.toString()));
                    aButton.setMultiClickThreshhold(UIDefaultsLookup.getInt("OptionPane.buttonClickThreshhold"));
                    this.configureButton(aButton);
                    if ("YES".equals(aButton.getName()) || "NO".equals(aButton.getName()) || "OK".equals(aButton.getName()) || "CLOSE".equals(aButton.getName()) || "FINISH".equals(aButton.getName())) {
                        container.add((Component)aButton, "AFFIRMATIVE");
                    } else if ("CANCEL".equals(aButton.getName())) {
                        container.add((Component)aButton, "CANCEL");
                    } else if ("HELP".equals(aButton.getName())) {
                        container.add((Component)aButton, "HELP");
                    } else {
                        container.add((Component)aButton, "ALTERNATIVE");
                    }
                    if ("DETAILS".equals(aButton.getName())) {
                        aButton.addActionListener(new AbstractAction(){

                            public void actionPerformed(ActionEvent e) {
                                JButton defaultButton = (JButton)e.getSource();
                                Container top = defaultButton.getTopLevelAncestor();
                                ResourceBundle resourceBundle = ButtonResources.getResourceBundle(BasicJideOptionPaneUI.this.optionPane.getLocale());
                                if (BasicJideOptionPaneUI.this._detailsArea.isVisible()) {
                                    BasicJideOptionPaneUI.setDetailsVisible(false);
                                    BasicJideOptionPaneUI.this._detailsArea.setVisible(false);
                                    defaultButton.setText(BasicJideOptionPaneUI.this.optionPane instanceof JideOptionPane ? ((JideOptionPane)BasicJideOptionPaneUI.this.optionPane).getResourceString("Button.showDetails") : resourceBundle.getString("Button.showDetails"));
                                    defaultButton.setMnemonic(BasicJideOptionPaneUI.this.optionPane instanceof JideOptionPane ? ((JideOptionPane)BasicJideOptionPaneUI.this.optionPane).getResourceString("Button.showDetails.mnemonic").charAt(0) : resourceBundle.getString("Button.showDetails.mnemonic").charAt(0));
                                } else {
                                    BasicJideOptionPaneUI.setDetailsVisible(true);
                                    BasicJideOptionPaneUI.this._detailsArea.setVisible(true);
                                    defaultButton.setText(BasicJideOptionPaneUI.this.optionPane instanceof JideOptionPane ? ((JideOptionPane)BasicJideOptionPaneUI.this.optionPane).getResourceString("Button.hideDetails") : resourceBundle.getString("Button.hideDetails"));
                                    defaultButton.setMnemonic(BasicJideOptionPaneUI.this.optionPane instanceof JideOptionPane ? ((JideOptionPane)BasicJideOptionPaneUI.this.optionPane).getResourceString("Button.hideDetails.mnemonic").charAt(0) : resourceBundle.getString("Button.hideDetails.mnemonic").charAt(0));
                                }
                                if (top instanceof Window) {
                                    ((Window)top).pack();
                                }
                            }
                        });
                        aButton.setVisible(this.shouldDetailsButtonVisible());
                    } else {
                        ActionListener buttonListener = this.createButtonActionListener(counter);
                        if (buttonListener != null) {
                            aButton.addActionListener(buttonListener);
                        }
                    }
                    newComponent = aButton;
                }
                if (counter != initialIndex) continue;
                this.initialFocusComponent = newComponent;
                if (!(this.initialFocusComponent instanceof JButton)) continue;
                JButton defaultB = (JButton)this.initialFocusComponent;
                defaultB.addAncestorListener(new AncestorListener(){

                    public void ancestorAdded(AncestorEvent e) {
                        JButton defaultButton = (JButton)e.getComponent();
                        JRootPane root = SwingUtilities.getRootPane(defaultButton);
                        if (root != null) {
                            root.setDefaultButton(defaultButton);
                        }
                    }

                    public void ancestorRemoved(AncestorEvent event) {
                    }

                    public void ancestorMoved(AncestorEvent event) {
                    }
                });
            }
        }
    }

    protected Object[] getButtons() {
        if (this.optionPane != null) {
            Object[] suppliedOptions = this.optionPane.getOptions();
            if (suppliedOptions == null) {
                Object[] defaultOptions;
                int type = this.optionPane.getOptionType();
                Locale l = this.optionPane.getLocale();
                if (type == 0) {
                    defaultOptions = new ButtonFactory[]{new ButtonFactory("YES", UIDefaultsLookup.getString("OptionPane.yesButtonText", l), this.getMnemonic("OptionPane.yesButtonMnemonic", l), (Icon)UIDefaultsLookup.get("OptionPane.yesIcon")), new ButtonFactory("NO", UIDefaultsLookup.getString("OptionPane.noButtonText", l), this.getMnemonic("OptionPane.noButtonMnemonic", l), (Icon)UIDefaultsLookup.get("OptionPane.noIcon"))};
                } else if (type == 1) {
                    defaultOptions = new ButtonFactory[]{new ButtonFactory("YES", UIDefaultsLookup.getString("OptionPane.yesButtonText", l), this.getMnemonic("OptionPane.yesButtonMnemonic", l), (Icon)UIDefaultsLookup.get("OptionPane.yesIcon")), new ButtonFactory("NO", UIDefaultsLookup.getString("OptionPane.noButtonText", l), this.getMnemonic("OptionPane.noButtonMnemonic", l), (Icon)UIDefaultsLookup.get("OptionPane.noIcon")), new ButtonFactory("CANCEL", UIDefaultsLookup.getString("OptionPane.cancelButtonText", l), this.getMnemonic("OptionPane.cancelButtonMnemonic", l), (Icon)UIDefaultsLookup.get("OptionPane.cancelIcon"))};
                } else if (type == 2) {
                    defaultOptions = new ButtonFactory[]{new ButtonFactory("OK", UIDefaultsLookup.getString("OptionPane.okButtonText", l), this.getMnemonic("OptionPane.okButtonMnemonic", l), (Icon)UIDefaultsLookup.get("OptionPane.okIcon")), new ButtonFactory("CANCEL", UIDefaultsLookup.getString("OptionPane.cancelButtonText", l), this.getMnemonic("OptionPane.cancelButtonMnemonic", l), (Icon)UIDefaultsLookup.get("OptionPane.cancelIcon"))};
                } else if (type == 3) {
                    defaultOptions = new ButtonFactory[1];
                    ResourceBundle resourceBundle = ButtonResources.getResourceBundle(this.optionPane.getLocale());
                    defaultOptions[0] = new ButtonFactory("CLOSE", this.optionPane instanceof JideOptionPane ? ((JideOptionPane)this.optionPane).getResourceString("Button.close") : resourceBundle.getString("Button.close"), this.optionPane instanceof JideOptionPane ? ((JideOptionPane)this.optionPane).getResourceString("Button.close.mnemonic").charAt(0) : resourceBundle.getString("Button.close.mnemonic").charAt(0), null);
                } else {
                    defaultOptions = new ButtonFactory[]{new ButtonFactory("OK", UIDefaultsLookup.getString("OptionPane.okButtonText", l), this.getMnemonic("OptionPane.okButtonMnemonic", l), (Icon)UIDefaultsLookup.get("OptionPane.okIcon"))};
                }
                return this.addDetailsButton(defaultOptions, true);
            }
            return this.addDetailsButton(suppliedOptions, true);
        }
        return null;
    }

    protected Object[] addDetailsButton(Object[] options, boolean showDetails) {
        if (showDetails) {
            Object[] newOptions = new Object[options.length + 1];
            for (int i = 0; i < options.length; ++i) {
                newOptions[i] = options[i];
            }
            ResourceBundle resourceBundle = ButtonResources.getResourceBundle(this.optionPane.getLocale());
            newOptions[newOptions.length - 1] = new ButtonFactory("DETAILS", this.optionPane instanceof JideOptionPane ? ((JideOptionPane)this.optionPane).getResourceString("Button.showDetails") : resourceBundle.getString("Button.showDetails"), this.optionPane instanceof JideOptionPane ? ((JideOptionPane)this.optionPane).getResourceString("Button.showDetails.mnemonic").charAt(0) : resourceBundle.getString("Button.showDetails.mnemonic").charAt(0), null);
            return newOptions;
        }
        return options;
    }

    private boolean shouldDetailsButtonVisible() {
        return this.optionPane instanceof JideOptionPane && ((JideOptionPane)this.optionPane).getDetails() != null;
    }

    protected void configureButton(JButton button) {
        Font buttonFont = (Font)UIDefaultsLookup.get("OptionPane.buttonFont");
        if (buttonFont != null) {
            button.setFont(buttonFont);
        }
    }

    protected int getMnemonic(String key, Locale l) {
        String value = (String)UIDefaultsLookup.get(key, l);
        if (value == null) {
            return 0;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            return 0;
        }
    }

    protected void addIcon(Container top) {
        Icon sideIcon = this.getIcon();
        if (sideIcon != null) {
            JLabel iconLabel = new JLabel(sideIcon);
            iconLabel.setName("OptionPane.iconLabel");
            top.add((Component)iconLabel, "Before");
        }
    }

    protected Container createBannerArea() {
        PaintPanel bannerPanel = new PaintPanel(){

            public Dimension getPreferredSize() {
                Dimension preferredSize = super.getPreferredSize();
                if (preferredSize.width < BasicJideOptionPaneUI.this._detailsPreferredWidth) {
                    preferredSize.width = BasicJideOptionPaneUI.this._detailsPreferredWidth;
                }
                return preferredSize;
            }
        };
        this.customizeBannerArea(bannerPanel);
        bannerPanel.setLayout(new BorderLayout(10, 10));
        this.addIcon(bannerPanel);
        this.updateTitleComponent(bannerPanel);
        bannerPanel.add((Component)new JLabel(UIDefaultsLookup.getIcon("OptionPane.bannerIcon")), "After");
        return bannerPanel;
    }

    protected void customizeBannerArea(PaintPanel bannerPanel) {
        Paint paint = (Paint)UIDefaultsLookup.get("OptionPane.bannerBackgroundPaint");
        if (paint != null) {
            bannerPanel.setBackgroundPaint(paint);
        } else {
            boolean direction;
            Color dk = UIDefaultsLookup.getColor("OptionPane.bannerBackgroundDk");
            Color lt = UIDefaultsLookup.getColor("OptionPane.bannerBackgroundLt");
            boolean bl = direction = UIDefaultsLookup.get("OptionPane.bannerBackgroundDirection") == null || UIDefaultsLookup.getBoolean("OptionPane.bannerBackgroundDirection");
            if (dk == null && lt != null) {
                dk = lt;
                bannerPanel.setGradientPaint(dk != null ? dk : this.getPainter().getOptionPaneBannerLt(), lt != null ? lt : this.getPainter().getOptionPaneBannerDk(), direction);
            } else if (dk != null && lt == null) {
                lt = dk;
                bannerPanel.setGradientPaint(dk != null ? dk : this.getPainter().getOptionPaneBannerLt(), lt != null ? lt : this.getPainter().getOptionPaneBannerDk(), direction);
            } else if (dk != null && lt != null) {
                bannerPanel.setGradientPaint(dk != null ? dk : this.getPainter().getOptionPaneBannerLt(), lt != null ? lt : this.getPainter().getOptionPaneBannerDk(), direction);
            }
        }
        Border border = UIDefaultsLookup.getBorder("OptionPane.bannerBorder");
        bannerPanel.setBorder(border != null ? border : BorderFactory.createEmptyBorder(0, 10, 0, 0));
    }

    private void updateTitleComponent(Container bannerArea) {
        Object title;
        if (bannerArea == null) {
            return;
        }
        if (this._titleComponent != null) {
            bannerArea.remove(this._titleComponent);
            this._titleComponent = null;
        }
        Object object = title = this.optionPane instanceof JideOptionPane ? ((JideOptionPane)this.optionPane).getTitle() : null;
        if (title instanceof String) {
            if (((String)title).startsWith("<html>") || ((String)title).startsWith("<HTML>")) {
                JLabel titleLabel = new JLabel((String)title);
                this._titleComponent = titleLabel;
            } else {
                String[] titles = BasicJideOptionPaneUI.fitInWidth((String)title, UIDefaultsLookup.getInt("OptionPane.bannerMaxCharsPerLine"));
                NullPanel titlePanel = new NullPanel();
                titlePanel.setLayout(new BoxLayout(titlePanel, 1));
                titlePanel.setOpaque(false);
                titlePanel.add(Box.createGlue());
                for (String s : titles) {
                    JLabel label = new JLabel(s);
                    label.setFont(label.getFont().deriveFont(UIDefaultsLookup.getInt("OptionPane.bannerFontStyle"), UIDefaultsLookup.getInt("OptionPane.bannerFontSize")));
                    Color color = UIDefaultsLookup.getColor("OptionPane.bannerForeground");
                    label.setForeground(color != null ? color : this.getPainter().getOptionPaneBannerForeground());
                    titlePanel.add(label);
                }
                titlePanel.add(Box.createGlue());
                this._titleComponent = titlePanel;
            }
        } else if (title instanceof Component) {
            this._titleComponent = (Component)title;
        }
        if (this._titleComponent != null) {
            bannerArea.add(this._titleComponent, "Center");
        }
    }

    private static String[] fitInWidth(String str, int width) {
        if (str == null) {
            str = "";
        }
        String BLANK_STR = BasicJideOptionPaneUI.blankString(width, (byte)32);
        str = BasicJideOptionPaneUI.replaceOccurrences(str, "\n", BLANK_STR);
        str = BasicJideOptionPaneUI.replaceOccurrences(str, "\t", "    ");
        ArrayList<String> strArray = new ArrayList<String>();
        str = str.trim();
        while (str.length() > width) {
            String subStr;
            int breakPos = width;
            if (Character.isLetterOrDigit(str.charAt(width))) {
                char breakChar = str.charAt(--breakPos);
                while (Character.isLetterOrDigit(breakChar) && breakPos > 0) {
                    breakChar = str.charAt(--breakPos);
                }
                breakPos = breakPos == 0 && Character.isLetterOrDigit(breakChar) ? width : ++breakPos;
            }
            if ((subStr = str.substring(0, breakPos)).length() < width) {
                subStr = subStr + BasicJideOptionPaneUI.blankString(width - subStr.length(), (byte)32);
            }
            strArray.add(subStr);
            str = str.substring(breakPos).trim();
        }
        if (str.length() < width) {
            str = str + BasicJideOptionPaneUI.blankString(width - str.length(), (byte)32);
        }
        strArray.add(str);
        return strArray.toArray(new String[1]);
    }

    private static String blankString(int width, byte b2) {
        byte[] bytes = new byte[width];
        Arrays.fill(bytes, b2);
        return new String(bytes);
    }

    private static String replaceOccurrences(String string, String target, String dest) {
        int index;
        StringBuffer b2 = new StringBuffer(string);
        int lastIndex = 0;
        while ((index = BasicJideOptionPaneUI.indexOf(b2, target, lastIndex)) >= 0) {
            b2.replace(index, index + target.length(), dest);
            lastIndex = index + dest.length();
        }
        return b2.toString();
    }

    private static int indexOf(char[] source, int sourceOffset, int sourceCount, char[] target, int targetOffset, int targetCount, int fromIndex) {
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        char first = target[targetOffset];
        int pos = sourceOffset + fromIndex;
        int max = sourceOffset + (sourceCount - targetCount);
        block0: while (true) {
            if (pos <= max && source[pos] != first) {
                ++pos;
                continue;
            }
            if (pos > max) {
                return -1;
            }
            int secondPos = pos + 1;
            int end = secondPos + targetCount - 1;
            int targetPos = targetOffset + 1;
            while (secondPos < end) {
                if (source[secondPos++] == target[targetPos++]) continue;
                ++pos;
                continue block0;
            }
            break;
        }
        return pos - sourceOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int indexOf(StringBuffer buf, String findStr, int fromIndex) {
        StringBuffer stringBuffer = buf;
        synchronized (stringBuffer) {
            int bufLen = buf.length();
            char[] charArray = new char[bufLen];
            buf.getChars(0, bufLen, charArray, 0);
            return BasicJideOptionPaneUI.indexOf(charArray, 0, bufLen, findStr.toCharArray(), 0, findStr.length(), fromIndex);
        }
    }

    public ThemePainter getPainter() {
        return this._painter;
    }

    protected static class ButtonFactory {
        private String name;
        private String text;
        private int mnemonic;
        private Icon icon;

        ButtonFactory(String name, String text, int mnemonic, Icon icon) {
            this.name = name;
            this.text = text;
            this.mnemonic = mnemonic;
            this.icon = icon;
        }

        JButton createButton() {
            JButton button = new JButton(this.text);
            if (this.name != null) {
                button.setName(this.name);
            }
            if (this.icon != null) {
                button.setIcon(this.icon);
            }
            if (this.mnemonic != 0) {
                button.setMnemonic(this.mnemonic);
            }
            return button;
        }
    }
}

