/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.metal;

import com.jidesoft.plaf.basic.BasicPainter;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.plaf.metal.MetalBumps;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.List;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class MetalPainter
extends BasicPainter {
    private static MetalPainter _instance;

    public static ThemePainter getInstance() {
        if (_instance == null) {
            _instance = new MetalPainter();
        }
        return _instance;
    }

    public void paintGripper(JComponent c, Graphics g, Rectangle rect, int orientation, int state) {
        if (orientation == 0) {
            MetalBumps bumps = new MetalBumps(rect.width, rect.height - 6, state == 3 ? MetalLookAndFeel.getPrimaryControlHighlight() : MetalLookAndFeel.getControlHighlight(), state == 3 ? MetalLookAndFeel.getPrimaryControlDarkShadow() : MetalLookAndFeel.getControlDarkShadow(), null);
            bumps.paintIcon(null, g, rect.x, rect.y + 3);
        } else {
            MetalBumps bumps = new MetalBumps(rect.width - 6, rect.height, state == 3 ? MetalLookAndFeel.getPrimaryControlHighlight() : MetalLookAndFeel.getControlHighlight(), state == 3 ? MetalLookAndFeel.getPrimaryControlDarkShadow() : MetalLookAndFeel.getControlDarkShadow(), null);
            bumps.paintIcon(null, g, rect.x + 3, rect.y);
        }
    }

    public void paintDockableFrameTitlePane(JComponent c, Graphics g, Rectangle rect, int orientation, int state) {
        String gradientKey;
        boolean isSelected = state == 3;
        int width = rect.width;
        int height = rect.height;
        ColorUIResource background = isSelected ? MetalLookAndFeel.getWindowTitleBackground() : MetalLookAndFeel.getWindowTitleInactiveBackground();
        String string = gradientKey = isSelected ? "InternalFrame.activeTitleGradient" : "InternalFrame.inactiveTitleGradient";
        if (!MetalPainter.drawGradient(c, g, gradientKey, 0, 0, width, height, true)) {
            g.setColor(background);
            g.fillRect(0, 0, width, height);
        }
    }

    static boolean drawGradient(Component c, Graphics g, String key, int x, int y, int w, int h, boolean vertical) {
        Object colors = UIManager.get(key);
        if (!(colors instanceof List)) {
            return false;
        }
        java.util.List gradient = (java.util.List)colors;
        if (gradient == null || !(g instanceof Graphics2D)) {
            return false;
        }
        if (w <= 0 || h <= 0) {
            return true;
        }
        GradientPainter.INSTANCE.paint(c, (Graphics2D)g, gradient, x, y, w, h, vertical);
        return true;
    }

    private static class GradientPainter {
        public static final GradientPainter INSTANCE = new GradientPainter();

        GradientPainter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paint(Component c, Graphics2D g, java.util.List gradient, int x, int y, int w, int h, boolean isVertical) {
            int imageHeight;
            int imageWidth;
            if (isVertical) {
                imageWidth = w;
                imageHeight = h;
            } else {
                imageWidth = w;
                imageHeight = h;
            }
            Object object = c.getTreeLock();
            synchronized (object) {
                this.paint(c, g, imageWidth, imageHeight, gradient, isVertical);
            }
        }

        protected void paint(Component c, Graphics g, int w, int h, java.util.List gradient, boolean isVertical) {
            Graphics2D g2 = (Graphics2D)g;
            if (isVertical) {
                this.drawVerticalGradient(g2, ((Number)gradient.get(0)).floatValue(), ((Number)gradient.get(1)).floatValue(), (Color)gradient.get(2), (Color)gradient.get(3), (Color)gradient.get(4), w, h);
            } else {
                this.drawHorizontalGradient(g2, ((Number)gradient.get(0)).floatValue(), ((Number)gradient.get(1)).floatValue(), (Color)gradient.get(2), (Color)gradient.get(3), (Color)gradient.get(4), w, h);
            }
        }

        private void drawVerticalGradient(Graphics2D g, float ratio1, float ratio2, Color c1, Color c2, Color c3, int w, int h) {
            int mid = (int)(ratio1 * (float)h);
            int mid2 = (int)(ratio2 * (float)h);
            if (mid > 0) {
                g.setPaint(this.getGradient(0.0f, 0.0f, c1, 0.0f, mid, c2));
                g.fillRect(0, 0, w, mid);
            }
            if (mid2 > 0) {
                g.setColor(c2);
                g.fillRect(0, mid, w, mid2);
            }
            if (mid > 0) {
                g.setPaint(this.getGradient(0.0f, (float)mid + (float)mid2, c2, 0.0f, (float)mid * 2.0f + (float)mid2, c1));
                g.fillRect(0, mid + mid2, w, mid);
            }
            if (h - mid * 2 - mid2 > 0) {
                g.setPaint(this.getGradient(0.0f, (float)mid * 2.0f + (float)mid2, c1, 0.0f, h, c3));
                g.fillRect(0, mid * 2 + mid2, w, h - mid * 2 - mid2);
            }
        }

        private void drawHorizontalGradient(Graphics2D g, float ratio1, float ratio2, Color c1, Color c2, Color c3, int w, int h) {
            int mid = (int)(ratio1 * (float)w);
            int mid2 = (int)(ratio2 * (float)w);
            if (mid > 0) {
                g.setPaint(this.getGradient(0.0f, 0.0f, c1, mid, 0.0f, c2));
                g.fillRect(0, 0, mid, h);
            }
            if (mid2 > 0) {
                g.setColor(c2);
                g.fillRect(mid, 0, mid2, h);
            }
            if (mid > 0) {
                g.setPaint(this.getGradient((float)mid + (float)mid2, 0.0f, c2, (float)mid * 2.0f + (float)mid2, 0.0f, c1));
                g.fillRect(mid + mid2, 0, mid, h);
            }
            if (w - mid * 2 - mid2 > 0) {
                g.setPaint(this.getGradient((float)mid * 2.0f + (float)mid2, 0.0f, c1, w, 0.0f, c3));
                g.fillRect(mid * 2 + mid2, 0, w - mid * 2 - mid2, h);
            }
        }

        private GradientPaint getGradient(float x1, float y1, Color c1, float x2, float y2, Color c2) {
            return new GradientPaint(x1, y1, c1, x2, y2, c2, true);
        }
    }
}

