/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.vsnet;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.vsnet.VsnetUtils;
import com.jidesoft.swing.JideSwingUtilities;
import com.sun.java.swing.plaf.windows.WindowsProgressBarUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ProgressBarUI;

public class VsnetWindowsProgressBarUI
extends WindowsProgressBarUI
implements ActionListener {
    private int repaintInterval;
    private int x = 0;
    private int y = 0;
    private int delta = 1;
    private Timer timer = null;
    private Rectangle boxRect;

    public static ComponentUI createUI(JComponent x) {
        return new VsnetWindowsProgressBarUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        this.initRepaintInterval();
    }

    protected void startAnimationTimer() {
        if (this.timer == null) {
            this.timer = new Timer(this.getRepaintInterval() / 20, this);
        }
        this.y = 0;
        this.x = 0;
        this.delta = 1;
        this.timer.start();
    }

    protected void stopAnimationTimer() {
        if (this.timer != null) {
            this.timer.stop();
        }
    }

    public void actionPerformed(ActionEvent ae) {
        if (this.x == 0) {
            this.delta = 1;
        } else if (this.x == this.progressBar.getWidth()) {
            this.delta = -1;
        }
        this.x += this.delta;
        this.progressBar.repaint();
    }

    protected int getRepaintInterval() {
        return this.repaintInterval;
    }

    private int initRepaintInterval() {
        this.repaintInterval = UIDefaultsLookup.getInt("ProgressBar.repaintInterval");
        return this.repaintInterval;
    }

    public void paintIndeterminate(Graphics g, JComponent c) {
        super.paintIndeterminate(g, c);
        Color startColor = this.progressBar.getForeground();
        Color endColor = VsnetUtils.getLighterColor(startColor, 0.9f);
        if (!(g instanceof Graphics2D)) {
            return;
        }
        boolean vertical = this.progressBar.getOrientation() == 1;
        Insets b2 = this.progressBar.getInsets();
        b2.top = 2;
        b2.left = 2;
        b2.right = 2;
        b2.bottom = 2;
        int barRectWidth = this.progressBar.getWidth() - (b2.right + b2.left);
        int barRectHeight = this.progressBar.getHeight() - (b2.top + b2.bottom);
        g.setColor(this.progressBar.getBackground());
        g.fillRect(b2.left, b2.top, barRectWidth, barRectHeight);
        Graphics2D g2d = (Graphics2D)g;
        if (this.delta > 0) {
            this.boxRect = new Rectangle(b2.left, b2.top, this.x, barRectHeight);
            JideSwingUtilities.fillNormalGradient(g2d, this.boxRect, endColor, startColor, vertical);
        } else {
            this.boxRect = new Rectangle(this.x, b2.top, barRectWidth - this.x, barRectHeight);
            JideSwingUtilities.fillNormalGradient(g2d, this.boxRect, startColor, endColor, vertical);
        }
        if (this.progressBar.isStringPainted()) {
            if (this.progressBar.getOrientation() == 0) {
                this.paintString(g2d, b2.left, b2.top, barRectWidth, barRectHeight, this.boxRect.x, this.boxRect.width, b2);
            } else {
                this.paintString(g2d, b2.left, b2.top, barRectWidth, barRectHeight, this.boxRect.y, this.boxRect.height, b2);
            }
        }
    }

    private void paintString(Graphics g, int x, int y, int width, int height, int fillStart, int amountFull, Insets b2) {
        if (!(g instanceof Graphics2D)) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        String progressString = this.progressBar.getString();
        g2.setFont(this.progressBar.getFont());
        Point renderLocation = this.getStringPlacement(g2, progressString, x, y, width, height);
        Rectangle oldClip = g2.getClipBounds();
        if (this.progressBar.getOrientation() == 0) {
            g2.setColor(this.getSelectionBackground());
            JideSwingUtilities.drawString(this.progressBar, g2, progressString, renderLocation.x, renderLocation.y);
            g2.setColor(this.getSelectionForeground());
            g2.clipRect(fillStart, y, amountFull, height);
            JideSwingUtilities.drawString(this.progressBar, g2, progressString, renderLocation.x, renderLocation.y);
        } else {
            g2.setColor(this.getSelectionBackground());
            AffineTransform rotate = AffineTransform.getRotateInstance(1.5707963267948966);
            g2.setFont(this.progressBar.getFont().deriveFont(rotate));
            renderLocation = this.getStringPlacement(g2, progressString, x, y, width, height);
            JideSwingUtilities.drawString(this.progressBar, g2, progressString, renderLocation.x, renderLocation.y);
            g2.setColor(this.getSelectionForeground());
            g2.clipRect(x, fillStart, width, amountFull);
            JideSwingUtilities.drawString(this.progressBar, g2, progressString, renderLocation.x, renderLocation.y);
        }
        g2.setClip(oldClip);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JProgressBar progressBar = new JProgressBar();
        JProgressBar myProgressBar = new JProgressBar();
        myProgressBar.setUI((ProgressBarUI)((Object)new VsnetWindowsProgressBarUI()));
        progressBar.setIndeterminate(true);
        progressBar.setString("Percent");
        progressBar.setStringPainted(true);
        myProgressBar.setIndeterminate(true);
        myProgressBar.setString("Percent");
        myProgressBar.setStringPainted(true);
        JPanel panel = new JPanel(new BorderLayout(5, 5));
        panel.add((Component)progressBar, "North");
        panel.add((Component)myProgressBar, "South");
        JOptionPane.showMessageDialog(null, panel, "ProgressBars made intutive - santhosh@in.fiorano.com", 1);
        System.exit(0);
    }
}

