/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.range;

import com.jidesoft.range.AbstractRange;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeRange
extends AbstractRange<Date> {
    protected Date _min;
    protected Date _max;
    private TimeZone timeZone = TimeZone.getDefault();

    public TimeRange() {
        Calendar today = Calendar.getInstance();
        today.set(11, 0);
        today.set(12, 0);
        today.set(13, 0);
        today.set(14, 0);
        long todayLong = today.getTimeInMillis();
        today.add(10, 24);
        long tomorrowLong = today.getTimeInMillis();
        this._min = new Date(todayLong);
        this._max = new Date(tomorrowLong);
    }

    public TimeRange(Calendar from, Calendar to) {
        this._min = from.getTime();
        this._max = to.getTime();
        assert (from.before(to));
    }

    public TimeRange(Date from, Date to) {
        this._min = from;
        this._max = to;
    }

    public TimeRange(long from, long to) {
        this._min = new Date(from);
        this._max = new Date(to);
    }

    public void setMin(Date from) {
        Date oldValue = this._min;
        this._min = from;
        this.firePropertyChange("min", oldValue, this._min);
    }

    public void setMin(long from) {
        Date oldValue = this._min;
        this._min = new Date(from);
        this.firePropertyChange("min", oldValue, this._min);
    }

    @Override
    public void adjust(Date lower, Date upper) {
        this.setMin(lower);
        this.setMax(upper);
    }

    public void setMax(Date to) {
        Date oldValue = this._max;
        this._max = to;
        this.firePropertyChange("max", oldValue, this._max);
    }

    public void setMax(long to) {
        Date oldValue = this._max;
        this._max = new Date(to);
        this.firePropertyChange("max", oldValue, this._max);
    }

    @Override
    public double minimum() {
        return this._min.getTime();
    }

    @Override
    public double maximum() {
        return this._max.getTime();
    }

    @Override
    public double size() {
        return this.maximum() - this.minimum();
    }

    @Override
    public Date lower() {
        return this._min;
    }

    @Override
    public Date upper() {
        return this._max;
    }

    @Override
    public boolean contains(Date x) {
        if (x == null) {
            return false;
        }
        long value = x.getTime();
        return (double)value >= this.minimum() && (double)value <= this.maximum();
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public static TimeRange union(TimeRange r1, TimeRange r2) {
        if (r1 == null) {
            return r2;
        }
        if (r2 == null) {
            return r1;
        }
        long r1Min = r1._min.getTime();
        long r2Min = r2._min.getTime();
        long r1Max = r1._max.getTime();
        long r2Max = r2._max.getTime();
        long min = Math.min(r1Min, r2Min);
        long max = Math.max(r1Max, r2Max);
        return new TimeRange(min, max);
    }

    public boolean equals(Object other) {
        if (other instanceof TimeRange) {
            TimeRange otherRange = (TimeRange)other;
            return this._min == otherRange._min && this._max == otherRange._max;
        }
        return false;
    }

    public String toString() {
        DateFormat f = DateFormat.getDateTimeInstance(2, 2);
        return String.format("[%s, %s] rounded to [%s, %s]", f.format(this._min), f.format(this._max), f.format(this.minimum()), f.format(this.maximum()));
    }
}

