/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.dialog.JideOptionPane;
import com.jidesoft.swing.JideSplitPaneDivider;
import com.jidesoft.utils.SecurityUtils;
import com.jidesoft.utils.SystemInfo;
import java.awt.AWTError;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JideBoxLayout
implements LayoutManager2,
Serializable {
    private static final Logger LOGGER = Logger.getLogger(JideBoxLayout.class.getName());
    private boolean doReset = true;
    protected int _axis;
    protected Container _target;
    private int _gap = 0;
    protected int[] _componentSizes;
    public static final String FIX = "fix";
    public static final String FLEXIBLE = "flexible";
    public static final String VARY = "vary";
    private final HashMap<Component, Object> _constraintMap = new HashMap();
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    public static final int LINE_AXIS = 2;
    public static final int PAGE_AXIS = 3;
    private boolean _resetWhenInvalidate = true;
    private boolean _alwaysLayout = true;
    private static final long serialVersionUID = -183922972679053590L;

    public JideBoxLayout(Container target) {
        this(target, 0);
    }

    public JideBoxLayout(Container target, int axis) {
        this(target, axis, 0);
    }

    public JideBoxLayout(Container target, int axis, int gap) {
        if (axis != 0 && axis != 1 && axis != 2 && axis != 3) {
            throw new AWTError("Invalid axis");
        }
        this._axis = axis;
        this._target = target;
        this._gap = gap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            int i;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(this + " layoutContainer started");
            }
            Dimension containerSize = container.getSize();
            if (containerSize.height <= 0 || containerSize.width <= 0) {
                return;
            }
            Insets insets = this._target.getInsets();
            if (this.doReset) {
                this._componentSizes = new int[this._target.getComponentCount()];
                int availableSize = this.getAvailableSize(containerSize, insets);
                if ((availableSize -= this.getGapSize()) <= 0) {
                    return;
                }
                boolean success = this.calculateComponentSizes(availableSize, 0, this._target.getComponentCount());
                if (!success) {
                    if (!this.isAlwaysLayout() && "false".equals(SecurityUtils.getProperty("JideBoxLayout.alwaysLayout", "false"))) {
                        for (int i2 = 0; i2 < this._target.getComponentCount(); ++i2) {
                            Component comp = this._target.getComponent(i2);
                            this.setComponentToSize(comp, 0, 0, insets, containerSize);
                        }
                        this.redoLayout(container);
                    }
                    return;
                }
                this.doReset = false;
                if (this._componentSizes.length == 0) {
                    container.repaint();
                }
            } else {
                boolean containerResized;
                int totalSize = 0;
                for (int componentSize : this._componentSizes) {
                    totalSize += componentSize;
                }
                boolean bl = containerResized = totalSize + this.getGapSize() != this.getSizeForPrimaryAxis(containerSize);
                if (containerResized) {
                    int availableSize = this.getAvailableSize(containerSize, insets);
                    if ((availableSize -= this.getGapSize()) <= 0) {
                        return;
                    }
                    boolean success = this.calculateComponentSizes(availableSize, 0, this._target.getComponentCount());
                    if (!success) {
                        if (!this.isAlwaysLayout() && "false".equals(SecurityUtils.getProperty("JideBoxLayout.alwaysLayout", "false"))) {
                            for (i = 0; i < this._target.getComponentCount(); ++i) {
                                Component comp = this._target.getComponent(i);
                                this.setComponentToSize(comp, 0, 0, insets, containerSize);
                            }
                            this.redoLayout(container);
                        }
                        return;
                    }
                }
            }
            ComponentOrientation o = this._target.getComponentOrientation();
            boolean ltr = o.isLeftToRight();
            int location = this.getSizeForPrimaryAxis(insets, true);
            boolean needRedoLayout = false;
            if (!ltr && JideBoxLayout.resolveAxis(this._axis, o) == 0) {
                location = containerSize.width - location;
            }
            for (i = 0; i < this._target.getComponentCount(); ++i) {
                int newSize;
                Component comp = this._target.getComponent(i);
                int oldSize = this.getPreferredSizeOfComponent(comp);
                if (!ltr && JideBoxLayout.resolveAxis(this._axis, o) == 0) {
                    this.setComponentToSize(comp, this._componentSizes[i], location -= this._componentSizes[i], insets, containerSize);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("layoutContainer index: " + i + " size: " + this._componentSizes[i]);
                    }
                    if (this._componentSizes[i] != 0) {
                        location -= this._gap;
                    }
                } else {
                    this.setComponentToSize(comp, this._componentSizes[i], location, insets, containerSize);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("layoutContainer index: " + i + " size: " + this._componentSizes[i]);
                    }
                    location += this._componentSizes[i];
                    if (this._componentSizes[i] != 0) {
                        location += this._gap;
                    }
                }
                if ((newSize = this.getPreferredSizeOfComponent(comp)) == oldSize) continue;
                needRedoLayout = true;
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("layoutContainer ended");
            }
            if (this._target instanceof JideOptionPane) {
                for (i = 0; i < container.getComponentCount(); ++i) {
                    container.getComponent(i).invalidate();
                }
                if (needRedoLayout) {
                    this.redoLayout(container);
                }
            }
        }
    }

    private void redoLayout(Container container) {
        Container parent;
        for (parent = container.getParent(); parent != null && !(parent instanceof Dialog); parent = parent.getParent()) {
        }
        if (parent != null) {
            ((Dialog)parent).pack();
        }
    }

    protected boolean calculateComponentSizes(int availableSize, int startIndex, int endIndex) {
        boolean expand;
        int availableSizeExcludeFixed = availableSize;
        int varMinSize = 0;
        int flexMinSize = 0;
        int varIndex = -1;
        int totalFlexSize = 0;
        int totalFlexSizeMinusMin = 0;
        int lastFlexIndex = -1;
        int lastNoneZeroFlexIndex = -1;
        for (int i = startIndex; i < endIndex; ++i) {
            Component comp = this._target.getComponent(i);
            if (!comp.isVisible()) continue;
            Object constraint = this._constraintMap.get(comp);
            int minimumSize = this.getSizeForPrimaryAxis(comp.getMinimumSize());
            int preferredSize = this.getSizeForPrimaryAxis(this.getPreferredSizeOf(comp, i));
            if (FIX.equals(constraint)) {
                availableSizeExcludeFixed -= Math.max(preferredSize, minimumSize);
                continue;
            }
            if (VARY.equals(constraint)) {
                varIndex = i;
                this.getPreferredSizeOf(comp, i);
                varMinSize = minimumSize;
                continue;
            }
            if (preferredSize > minimumSize) {
                totalFlexSizeMinusMin += preferredSize - minimumSize;
            }
            totalFlexSize += preferredSize;
            flexMinSize += minimumSize;
            lastFlexIndex = i;
            if (preferredSize == 0) continue;
            lastNoneZeroFlexIndex = i;
        }
        if (!this.isAlwaysLayout() && "false".equals(SecurityUtils.getProperty("JideBoxLayout.alwaysLayout", "false")) && availableSizeExcludeFixed - varMinSize < 0) {
            return false;
        }
        boolean hasVary = varIndex != -1;
        boolean bl = expand = availableSizeExcludeFixed - varMinSize >= totalFlexSize;
        if (!hasVary || hasVary && !expand) {
            double resizeRatio = expand ? (totalFlexSize == 0 ? 0.0 : (double)(availableSizeExcludeFixed - varMinSize) / (double)totalFlexSize) : (totalFlexSizeMinusMin == 0 ? 0.0 : (double)(availableSizeExcludeFixed - varMinSize - flexMinSize) / (double)totalFlexSizeMinusMin);
            for (int i = startIndex; i < endIndex; ++i) {
                Component comp = this._target.getComponent(i);
                if (!comp.isVisible()) {
                    this.setComponentSize(i, 0);
                    continue;
                }
                Object constraint = this._constraintMap.get(comp);
                int minimumSize = this.getSizeForPrimaryAxis(comp.getMinimumSize());
                int preferredSize = this.getSizeForPrimaryAxis(this.getPreferredSizeOf(comp, i));
                if (FIX.equals(constraint)) {
                    this.setComponentSize(i, Math.max(preferredSize, minimumSize));
                    continue;
                }
                if (VARY.equals(constraint)) {
                    this.setComponentSize(i, varMinSize);
                    continue;
                }
                if (expand) {
                    this.setComponentSize(i, (int)((double)preferredSize * resizeRatio));
                    continue;
                }
                this.setComponentSize(i, minimumSize + (int)((double)(preferredSize - minimumSize) * resizeRatio));
            }
        } else {
            for (int i = startIndex; i < endIndex; ++i) {
                Component comp = this._target.getComponent(i);
                if (!comp.isVisible()) {
                    this.setComponentSize(i, 0);
                    continue;
                }
                Object constraint = this._constraintMap.get(comp);
                int minimumSize = this.getSizeForPrimaryAxis(comp.getMinimumSize());
                int preferredSize = this.getSizeForPrimaryAxis(this.getPreferredSizeOf(comp, i));
                if (FIX.equals(constraint)) {
                    this.setComponentSize(i, Math.max(preferredSize, minimumSize));
                    continue;
                }
                if (VARY.equals(constraint)) {
                    this.setComponentSize(i, availableSizeExcludeFixed - totalFlexSize);
                    continue;
                }
                this.setComponentSize(i, Math.max(preferredSize, minimumSize));
            }
        }
        int totalActualSize = 0;
        for (int i = startIndex; i < endIndex; ++i) {
            totalActualSize += this._componentSizes[i];
        }
        if (totalActualSize != availableSize) {
            if (varIndex != -1) {
                this.setComponentSizeByGap(varIndex, availableSize - totalActualSize);
            } else if (lastNoneZeroFlexIndex != -1) {
                this.setComponentSizeByGap(lastNoneZeroFlexIndex, availableSize - totalActualSize);
            } else if (lastFlexIndex != -1) {
                this.setComponentSizeByGap(lastFlexIndex, availableSize - totalActualSize);
            }
        }
        return true;
    }

    private void setComponentSizeByGap(int index, int gap) {
        if (SystemInfo.isJdk15Above() && this._target.getComponent(index).isMinimumSizeSet()) {
            this.setComponentSize(index, Math.max(this._componentSizes[index] + gap, this.getSizeForPrimaryAxis(this._target.getComponent(index).getMinimumSize())));
        } else {
            this.setComponentSize(index, this._componentSizes[index] + gap);
        }
    }

    private void setComponentSize(int index, int size) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("setComponentSize index: " + index + " size: " + size);
        }
        this._componentSizes[index] = size;
    }

    @Override
    public void addLayoutComponent(String name, Component component) {
        this.layoutReset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container container) {
        int minPrimary = 0;
        int minSecondary = 0;
        Insets insets = this._target.getInsets();
        Object object = container.getTreeLock();
        synchronized (object) {
            for (int i = 0; i < this._target.getComponentCount(); ++i) {
                Component comp = this._target.getComponent(i);
                if (!comp.isVisible()) continue;
                Object constraint = this._constraintMap.get(comp);
                Dimension minimumSize = comp.getMinimumSize();
                minPrimary = FIX.equals(constraint) ? (minPrimary += this.getPreferredSizeOfComponent(comp)) : (minPrimary += this.getSizeForPrimaryAxis(minimumSize));
                int secSize = this.getSizeForSecondaryAxis(minimumSize);
                if (secSize <= minSecondary) continue;
                minSecondary = secSize;
            }
            if (insets != null) {
                minPrimary += this.getSizeForPrimaryAxis(insets, true) + this.getSizeForPrimaryAxis(insets, false);
                minSecondary += this.getSizeForSecondaryAxis(insets, true) + this.getSizeForSecondaryAxis(insets, false);
            }
        }
        ComponentOrientation o = this._target.getComponentOrientation();
        if (JideBoxLayout.resolveAxis(this._axis, o) == 0) {
            return new Dimension(minPrimary + this.getGapSize(), minSecondary);
        }
        return new Dimension(minSecondary, minPrimary + this.getGapSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container container) {
        int prePrimary = 0;
        int preSecondary = 0;
        Insets insets = this._target.getInsets();
        Object object = container.getTreeLock();
        synchronized (object) {
            for (int i = 0; i < this._target.getComponentCount(); ++i) {
                Component comp = this._target.getComponent(i);
                if (!comp.isVisible()) continue;
                Dimension preferredSize = this.getPreferredSizeOf(comp, i);
                prePrimary += this.getSizeForPrimaryAxis(preferredSize);
                int secSize = this.getSizeForSecondaryAxis(preferredSize);
                if (secSize <= preSecondary) continue;
                preSecondary = secSize;
            }
            if (insets != null) {
                prePrimary += this.getSizeForPrimaryAxis(insets, true) + this.getSizeForPrimaryAxis(insets, false);
                preSecondary += this.getSizeForSecondaryAxis(insets, true) + this.getSizeForSecondaryAxis(insets, false);
            }
        }
        if (this._axis == 0) {
            return new Dimension(prePrimary + this.getGapSize(), preSecondary);
        }
        return new Dimension(preSecondary, prePrimary + this.getGapSize());
    }

    private int getGapSize() {
        if (this._gap == 0) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < this._target.getComponentCount(); ++i) {
            if (!this._target.getComponent(i).isVisible()) continue;
            ++count;
        }
        return Math.max(0, count - 1) * this._gap;
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        this._constraintMap.remove(comp);
        if (comp instanceof JideSplitPaneDivider) {
            this.layoutReset();
        }
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        if (constraints == null) {
            this._constraintMap.put(comp, FLEXIBLE);
        } else {
            this._constraintMap.put(comp, constraints);
        }
        this.layoutReset();
    }

    private void layoutReset() {
        this.doReset = true;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(this + " layoutReset");
        }
    }

    @Override
    public synchronized float getLayoutAlignmentX(Container target) {
        return 0.0f;
    }

    @Override
    public synchronized float getLayoutAlignmentY(Container target) {
        return 0.0f;
    }

    @Override
    public synchronized void invalidateLayout(Container c) {
        if (this.isResetWhenInvalidate() || this.componentCountChanged(c)) {
            this.layoutReset();
        }
    }

    protected boolean componentCountChanged(Container c) {
        if (this._componentSizes == null) {
            return true;
        }
        int oldLength = 0;
        for (int _componentSize : this._componentSizes) {
            if (_componentSize <= 0) continue;
            ++oldLength;
        }
        int newLength = 0;
        for (int i = 0; i < c.getComponentCount(); ++i) {
            if (!c.getComponent(i).isVisible()) continue;
            ++newLength;
        }
        return newLength != oldLength;
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    protected int getPreferredSizeOfComponent(Component c) {
        return this.getSizeForPrimaryAxis(c.getPreferredSize());
    }

    int getMinimumSizeOfComponent(Component c) {
        return this.getSizeForPrimaryAxis(c.getMinimumSize());
    }

    protected int getSizeOfComponent(Component c) {
        return this.getSizeForPrimaryAxis(c.getSize());
    }

    protected int getAvailableSize(Dimension containerSize, Insets insets) {
        if (insets == null) {
            return this.getSizeForPrimaryAxis(containerSize);
        }
        return this.getSizeForPrimaryAxis(containerSize) - (this.getSizeForPrimaryAxis(insets, true) + this.getSizeForPrimaryAxis(insets, false));
    }

    protected int getInitialLocation(Insets insets) {
        if (insets != null) {
            return this.getSizeForPrimaryAxis(insets, true);
        }
        return 0;
    }

    protected void setComponentToSize(Component c, int size, int location, Insets insets, Dimension containerSize) {
        if (insets != null) {
            ComponentOrientation o = this._target.getComponentOrientation();
            if (JideBoxLayout.resolveAxis(this._axis, o) == 0) {
                c.setBounds(Math.max(location, 0), Math.max(insets.top, 0), Math.max(size, 0), Math.max(containerSize.height - (insets.top + insets.bottom), 0));
            } else {
                c.setBounds(Math.max(insets.left, 0), Math.max(location, 0), Math.max(containerSize.width - (insets.left + insets.right), 0), Math.max(size, 0));
            }
        } else {
            ComponentOrientation o = this._target.getComponentOrientation();
            if (JideBoxLayout.resolveAxis(this._axis, o) == 0) {
                c.setBounds(Math.max(location, 0), 0, Math.max(size, 0), Math.max(containerSize.height, 0));
            } else {
                c.setBounds(0, Math.max(location, 0), Math.max(containerSize.width, 0), Math.max(size, 0));
            }
        }
    }

    int getSizeForPrimaryAxis(Dimension size) {
        ComponentOrientation o = this._target.getComponentOrientation();
        if (JideBoxLayout.resolveAxis(this._axis, o) == 0) {
            return size.width;
        }
        return size.height;
    }

    int getSizeForSecondaryAxis(Dimension size) {
        ComponentOrientation o = this._target.getComponentOrientation();
        if (JideBoxLayout.resolveAxis(this._axis, o) == 0) {
            return size.height;
        }
        return size.width;
    }

    int getSizeForPrimaryAxis(Insets insets, boolean isTop) {
        ComponentOrientation o = this._target.getComponentOrientation();
        if (JideBoxLayout.resolveAxis(this._axis, o) == 0) {
            if (isTop) {
                return insets.left;
            }
            return insets.right;
        }
        if (isTop) {
            return insets.top;
        }
        return insets.bottom;
    }

    int getSizeForSecondaryAxis(Insets insets, boolean isTop) {
        ComponentOrientation o = this._target.getComponentOrientation();
        if (JideBoxLayout.resolveAxis(this._axis, o) == 0) {
            if (isTop) {
                return insets.top;
            }
            return insets.bottom;
        }
        if (isTop) {
            return insets.left;
        }
        return insets.right;
    }

    public Map<Component, Object> getConstraintMap() {
        return this._constraintMap;
    }

    protected static int resolveAxis(int axis, ComponentOrientation o) {
        int absoluteAxis = axis == 2 ? (o.isHorizontal() ? 0 : 1) : (axis == 3 ? (o.isHorizontal() ? 1 : 0) : axis);
        return absoluteAxis;
    }

    public int getGap() {
        return this._gap;
    }

    public void setGap(int gap) {
        this._gap = gap;
    }

    protected Dimension getPreferredSizeOf(Component comp, int atIndex) {
        Dimension preferredSize = comp.getPreferredSize();
        Dimension minimumSize = comp.getMinimumSize();
        if (preferredSize.height < minimumSize.height) {
            preferredSize.height = minimumSize.height;
        }
        if (preferredSize.width < minimumSize.width) {
            preferredSize.width = minimumSize.width;
        }
        Dimension maximumSize = comp.getMaximumSize();
        if (preferredSize.height > maximumSize.height) {
            preferredSize.height = maximumSize.height;
        }
        if (preferredSize.width > maximumSize.width) {
            preferredSize.width = maximumSize.width;
        }
        return preferredSize;
    }

    public boolean isResetWhenInvalidate() {
        return this._resetWhenInvalidate;
    }

    public void setResetWhenInvalidate(boolean resetWhenInvalidate) {
        this._resetWhenInvalidate = resetWhenInvalidate;
    }

    public int getAxis() {
        return this._axis;
    }

    public void setAxis(int axis) {
        this._axis = axis;
    }

    public boolean isAlwaysLayout() {
        return this._alwaysLayout;
    }

    public void setAlwaysLayout(boolean alwaysLayout) {
        this._alwaysLayout = alwaysLayout;
    }
}

