#!/bin/bash
#
# Normally, editing this script should not be required.
#
# To specify an alternative Java Runtime Environment, uncomment the following line and edit the path
#SMARTGIT_JAVA_HOME=/usr/lib/java

# Set the maximum heap size
MAXIMUM_HEAP_SIZE=256m

# If you experience problems, e.g. incorrectly painted windows, try to uncomment one of the following two lines
#export AWT_TOOLKIT=MToolkit
#export AWT_TOOLKIT=XToolkit

if [ "$SMARTGIT_JAVA_HOME" = "" ] ; then
    SMARTGIT_JAVA_HOME=$JAVA_HOME
fi

_JAVA_EXEC="java"
if [ "$SMARTGIT_JAVA_HOME" != "" ] ; then
    _TMP="$SMARTGIT_JAVA_HOME/bin/java"
    if [ -f "$_TMP" ] ; then
        if [ -x "$_TMP" ] ; then
            _JAVA_EXEC="$_TMP"
        else
            echo "Warning: $_TMP is not executable"
        fi
    else
        echo "Warning: $_TMP does not exist"
    fi
fi

if ! which "$_JAVA_EXEC" >/dev/null ; then
    echo "Error: No java environment found"
    exit 1
fi

#
# Resolve the location of the SmartGit installation.
# This includes resolving any symlinks.
PRG=$0
while [ -h "$PRG" ]; do
    ls=`ls -ld "$PRG"`
    link=`expr "$ls" : '^.*-> \(.*\)$' 2>/dev/null`
    if expr "$link" : '^/' 2> /dev/null >/dev/null; then
        PRG="$link"
    else
        PRG="`dirname "$PRG"`/$link"
    fi
done

SMARTGIT_BIN=`dirname "$PRG"`

# absolutize dir
oldpwd=`pwd`
cd "${SMARTGIT_BIN}"; SMARTGIT_BIN=`pwd`
cd "${oldpwd}"; unset oldpwd

SMARTGIT_HOME=`dirname "$SMARTGIT_BIN"`

_VM_PROPERTIES="-Dsun.io.useCanonCaches=false -Dsun.java.command=SmartGit"

# -XX:-UseSSE42Intrinsics is used to work-around bug 6875866 of Java 1.6.0_20 (and earlier) on Intel Nehalem CPUs, e.g. Core i7
$_JAVA_EXEC -XX:-UseSSE42Intrinsics -version >/dev/null 2>/dev/null
if [ $? = 0 ] ; then
  echo "Disabling SSE42Intrinsics to work around bug 6875866."
  _VM_PROPERTIES="${_VM_PROPERTIES} -XX:-UseSSE42Intrinsics"
fi

# This option should ensure that new Debian versions work:
_VM_PROPERTIES="${_VM_PROPERTIES} -Djava.net.preferIPv4Stack=true"

# Uncomment the following line to change the location where SmartGit should store
# settings (the given example path will make SmartGit portable by storing the settings
# in the installation directory):
#_VM_PROPERTIES="$_VM_PROPERTIES -Dsmartgit.home=\${smartgit.installation}/.smartgit"

$_JAVA_EXEC $_VM_PROPERTIES -Xmx${MAXIMUM_HEAP_SIZE} -Dsmartgit.vm-xmx=${MAXIMUM_HEAP_SIZE} -jar "$SMARTGIT_HOME/lib/smartgit.jar" "$@"
