/*
 * Decompiled with CFR 0.152.
 */
package com.ice.config;

import com.ice.config.ConfigureConstants;
import com.ice.config.ConfigureEditor;
import com.ice.config.ConfigureEditorFactory;
import com.ice.config.ConfigureSpec;
import com.ice.config.ConfigureTree;
import com.ice.config.ConfigureTreeModel;
import com.ice.config.ConfigureTreeNode;
import com.ice.config.ConfigureUtil;
import com.ice.config.DefaultConfigureEditorFactory;
import com.ice.config.InvalidSpecificationException;
import com.ice.pref.UserPrefs;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.Scrollable;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class ConfigurePanel
extends JPanel
implements ConfigureConstants,
TreeSelectionListener {
    protected JTree tree = null;
    protected JLabel title = null;
    protected JPanel editorPanel = null;
    protected JSplitPane splitter = null;
    protected UserPrefs specs;
    protected Vector specVector;
    protected UserPrefs prefs;
    protected UserPrefs origPrefs;
    protected ConfigureTreeModel model = null;
    protected ConfigureEditor currEditor = null;
    protected ConfigureTreeNode currSelection = null;
    protected Properties template = new Properties();
    protected ConfigureEditorFactory factory = null;

    public ConfigurePanel(UserPrefs cfgPrefs, UserPrefs specs) {
        this(cfgPrefs, specs, new DefaultConfigureEditorFactory(specs));
    }

    public ConfigurePanel(UserPrefs cfgPrefs, UserPrefs specs, ConfigureEditorFactory factory) {
        this.origPrefs = cfgPrefs;
        this.prefs = cfgPrefs.createWorkingCopy("Configuration Working Copy");
        this.specs = specs;
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.model = new ConfigureTreeModel();
        try {
            this.specVector = ConfigureUtil.readConfigSpecification(specs);
        }
        catch (InvalidSpecificationException ex) {
            ex.printStackTrace();
            this.specVector = new Vector();
        }
        this.establishConfigTree();
        this.tree = new ConfigureTree(this.model);
        this.tree.addTreeSelectionListener(this);
        JScrollPane treeScroller = new JScrollPane(this.tree);
        JPanel pan = new JPanel();
        pan.setLayout(new BorderLayout());
        pan.setPreferredSize(new Dimension(125, 225));
        pan.add("Center", treeScroller);
        this.editorPanel = new EditorPanel();
        this.editorPanel.setLayout(new BorderLayout());
        this.editorPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BorderLayout());
        this.title = new JLabel("Properties", 2);
        this.title.setPreferredSize(new Dimension(30, 30));
        this.title.setBackground(new Color(224, 224, 255));
        this.title.setForeground(Color.black);
        this.title.setOpaque(true);
        this.title.setFont(new Font(this.getFont().getName(), 1, 14));
        this.title.setBorder(new CompoundBorder(new LineBorder(Color.black), new EmptyBorder(5, 5, 5, 5)));
        this.splitter = new JSplitPane(1, true, pan, contentPanel);
        this.splitter.setDividerSize(5);
        contentPanel.add("North", this.title);
        contentPanel.add("Center", this.editorPanel);
        this.add("Center", this.splitter);
        this.factory = factory;
    }

    public void setDividerLocation(double divPct) {
        this.splitter.setDividerLocation(divPct);
    }

    public ConfigureEditorFactory getEditorFactory() {
        return this.factory;
    }

    public void setEditorFactory(ConfigureEditorFactory factory) {
        this.factory = factory;
    }

    public void commit() {
        Enumeration enumeration = this.specVector.elements();
        while (enumeration.hasMoreElements()) {
            ConfigureSpec spec = (ConfigureSpec)enumeration.nextElement();
            ConfigureEditor editor = this.factory.createEditor(spec.getPropertyType());
            if (editor == null) continue;
            editor.commit(spec, this.prefs, this.origPrefs);
        }
    }

    private void establishConfigTree() {
        Enumeration enumeration = this.specVector.elements();
        while (enumeration.hasMoreElements()) {
            ConfigureSpec spec = (ConfigureSpec)enumeration.nextElement();
            String path = spec.getPropertyPath();
            this.model.addPath(path, spec);
        }
    }

    public void saveCurrentEdit() {
        if (this.currSelection != null && this.currEditor != null) {
            this.currEditor.saveChanges(this.prefs, this.currSelection.getConfigureSpec());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void valueChanged(TreeSelectionEvent event) {
        Object obj = this.tree.getLastSelectedPathComponent();
        if (obj == this.currSelection) {
            return;
        }
        this.saveCurrentEdit();
        Object object = this.editorPanel.getTreeLock();
        synchronized (object) {
            this.editorPanel.removeAll();
            this.title.setText("");
            if (obj != null) {
                this.currSelection = (ConfigureTreeNode)obj;
                ConfigureTreeNode node = this.currSelection;
                if (node.isLeaf()) {
                    ConfigureSpec spec = node.getConfigureSpec();
                    if (spec != null) {
                        this.currEditor = this.factory.createEditor(node.getConfigureSpec().getPropertyType());
                        if (this.currEditor == null) {
                            this.currEditor = this.factory.createEditor("DEFAULT");
                        }
                        StringBuffer sb = new StringBuffer();
                        sb.append(spec.getName());
                        if (this.currEditor != null) {
                            if (this.currEditor.isModified(spec, this.prefs, this.origPrefs)) {
                                sb.append(" *");
                            }
                        } else {
                            sb.append(" (NO EDITOR)");
                        }
                        this.title.setText(sb.toString());
                        if (this.currEditor != null) {
                            this.currEditor.edit(this.prefs, spec);
                            this.editorPanel.add("Center", this.currEditor);
                            this.editorPanel.revalidate();
                            this.currEditor.requestInitialFocus();
                        }
                    }
                } else {
                    this.currEditor = null;
                    this.currSelection = null;
                    this.title.setText(node.getName());
                }
            }
        }
        this.editorPanel.repaint(250L);
    }

    public void addEditor(String type, ConfigureEditor editor) {
        if (this.factory instanceof DefaultConfigureEditorFactory) {
            ((DefaultConfigureEditorFactory)this.factory).addEditor(type, editor);
        } else {
            new Throwable("can not add editor, factory is not class DefaultConfigureEditorFactory").printStackTrace();
        }
    }

    public String treePath(TreePath treePath) {
        Object[] list = treePath.getPath();
        StringBuffer path = new StringBuffer();
        int i = 1;
        while (i < list.length) {
            ConfigureTreeNode node = (ConfigureTreeNode)list[i];
            if (i > 1) {
                path.append(".");
            }
            path.append(node.getName());
            ++i;
        }
        return path.toString();
    }

    public void editProperty(String propName) {
        String[] propNames = new String[]{propName};
        this.editProperties(propNames);
    }

    public void editProperties(String[] propNames) {
        int numSpecs = this.specVector.size();
        Vector<String> pathV = new Vector<String>();
        int i = propNames.length - 1;
        while (i >= 0) {
            String propName = propNames[i];
            int j = 0;
            while (j < numSpecs) {
                ConfigureSpec spec = (ConfigureSpec)this.specVector.elementAt(j);
                if (spec.getPropertyName().equals(propName)) {
                    pathV.addElement(spec.getPropertyPath());
                    break;
                }
                ++j;
            }
            --i;
        }
        if (pathV.size() > 0) {
            Object[] paths = new String[pathV.size()];
            pathV.copyInto(paths);
            this.editPaths((String[])paths);
        }
    }

    public void editPath(String path) {
        String[] paths = new String[]{path};
        this.editPaths(paths);
    }

    public void editPaths(String[] paths) {
        int i = paths.length - 1;
        while (i >= 0) {
            ConfigureTreeNode node = this.model.getPathNode(paths[i]);
            if (node != null) {
                TreePath tPath = new TreePath(node.getPath());
                this.tree.expandPath(tPath);
                if (i == 0) {
                    this.tree.setSelectionPath(tPath);
                }
            }
            --i;
        }
    }

    private class EditorPanel
    extends JPanel
    implements Scrollable {
        private EditorPanel() {
        }

        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            if (orientation == 1) {
                return visibleRect.height - 10;
            }
            return visibleRect.width - 10;
        }

        public boolean getScrollableTracksViewportHeight() {
            return false;
        }

        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            if (orientation == 1) {
                int unit = visibleRect.height / 10;
                return unit == 0 ? 1 : (unit > 20 ? 20 : unit);
            }
            int unit = visibleRect.width / 10;
            return unit == 0 ? 1 : (unit > 20 ? 20 : unit);
        }
    }
}

