/*
 * Decompiled with CFR 0.152.
 */
package com.ice.config;

import com.ice.config.ConfigureConstants;
import com.ice.config.ConfigureSpec;
import com.ice.config.InvalidSpecificationException;
import com.ice.pref.UserPrefs;
import java.util.Enumeration;
import java.util.Vector;

public class ConfigureUtil
implements ConfigureConstants {
    public static Vector readConfigSpecification(UserPrefs specs) throws InvalidSpecificationException {
        String specSfx = ".spec";
        Vector<ConfigureSpec> result = new Vector<ConfigureSpec>();
        String propPfx = specs.getPropertyPrefix();
        Enumeration<Object> enumeration = specs.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            if (!key.endsWith(specSfx)) continue;
            String keyBase = specs.getBaseName(key);
            String type = specs.getProperty(keyBase, null);
            keyBase = keyBase.substring(0, keyBase.length() - specSfx.length());
            String path = specs.getProperty(keyBase + ".path", null);
            String name = specs.getProperty(keyBase + ".name", null);
            String desc = specs.getProperty(keyBase + ".desc", null);
            String help = specs.getProperty(keyBase + ".help", null);
            String reason = "";
            boolean invalid = false;
            if (type == null) {
                invalid = true;
                reason = "the spec has no property type";
            } else if (path == null) {
                invalid = true;
                reason = "the spec has no config tree path";
            } else if (name == null) {
                invalid = true;
                reason = "the spec has no property name";
            } else if (type.equals("choice") || type.equals("combo")) {
                Vector<String> sV = new Vector<String>();
                int ci = 0;
                while (ci < 64) {
                    String item = specs.getProperty(keyBase + "." + type + "." + ci, null);
                    if (item == null) break;
                    sV.addElement(item);
                    ++ci;
                }
                if (sV.size() < 2) {
                    invalid = true;
                    reason = "choice config has no choices (need 2 or more)";
                } else {
                    Object[] choices = new String[sV.size()];
                    sV.copyInto(choices);
                    ConfigureSpec spec = new ConfigureSpec(keyBase, type.trim(), path.trim(), name.trim(), desc == null ? desc : desc.trim(), help == null ? help : help.trim(), (String[])choices);
                    result.addElement(spec);
                }
            } else {
                ConfigureSpec spec = new ConfigureSpec(keyBase, type.trim(), path.trim(), name.trim(), desc == null ? desc : desc.trim(), help == null ? help : help.trim(), null);
                result.addElement(spec);
            }
            if (!invalid) continue;
            throw new InvalidSpecificationException("invalid configuration specification for '" + keyBase + "', " + reason);
        }
        return result;
    }
}

