/*
 * Decompiled with CFR 0.152.
 */
package com.ice.cvsc;

import com.ice.cvsc.CVSCUtilities;
import com.ice.cvsc.CVSLog;
import com.ice.cvsc.CVSProject;
import java.io.File;
import java.io.IOException;

public class CVSProjectDef {
    public static final String RCS_ID = "$Id: CVSProjectDef.java,v 2.4 2003/07/27 01:08:32 time Exp $";
    public static final String RCS_REV = "$Revision: 2.4 $";
    private boolean isValid;
    private boolean isPServer;
    private int connectMethod;
    private String connectMethodStr;
    private String hostName;
    private String userName;
    private String rootDirectory;
    private String repository;
    private String reason;
    private boolean noModeRoot;

    public CVSProjectDef(String rootStr, String reposStr) {
        this.parseRootDirectory(rootStr, reposStr);
    }

    public CVSProjectDef(int connMeth, boolean isPServ, boolean noMode, String host, String user, String rootDir, String repos) {
        this.isValid = true;
        this.isPServer = isPServ;
        this.noModeRoot = noMode;
        this.hostName = host;
        this.userName = user;
        this.repository = repos;
        this.rootDirectory = rootDir;
        this.connectMethod = connMeth;
        this.connectMethodStr = this.connectMethod == 2 ? "server" : (this.connectMethod == 3 ? "ext" : (this.isPServer ? "pserver" : "direct"));
    }

    public synchronized boolean isValid() {
        return this.isValid;
    }

    public synchronized boolean isPServer() {
        return this.isPServer;
    }

    public synchronized boolean isSSHServer() {
        return this.connectMethod == 3;
    }

    public synchronized int getConnectMethod() {
        return this.connectMethod;
    }

    public synchronized String getConnectMethodString() {
        return this.connectMethodStr;
    }

    public synchronized String getUserName() {
        return this.userName;
    }

    public synchronized String getHostName() {
        return this.hostName;
    }

    public synchronized String getRootDirectory() {
        return this.rootDirectory;
    }

    public synchronized String getRepository() {
        return this.repository;
    }

    public synchronized String getReason() {
        return this.reason;
    }

    public String getRootDirectorySpec() {
        String connMethod = this.connectMethod == 2 ? "server" : (this.connectMethod == 3 ? "ext" : (this.isPServer() ? "pserver" : "direct"));
        StringBuffer rootDirStr = new StringBuffer(128);
        if (!this.noModeRoot) {
            rootDirStr.append(":");
            rootDirStr.append(connMethod);
            rootDirStr.append(":");
        }
        if (this.userName.length() > 0) {
            rootDirStr.append(this.userName);
            rootDirStr.append("@");
        }
        rootDirStr.append(this.hostName);
        rootDirStr.append(":");
        rootDirStr.append(this.rootDirectory);
        return rootDirStr.toString();
    }

    public synchronized boolean parseRootDirectory(String specification, String repos) {
        String userNameStr = "";
        String hostNameStr = "";
        boolean isOk = true;
        this.isValid = false;
        this.isPServer = false;
        this.repository = repos;
        this.noModeRoot = false;
        this.reason = "parsed '" + specification + "'";
        String rootDirSpec = specification;
        if (rootDirSpec.startsWith(":")) {
            int index = (rootDirSpec = rootDirSpec.substring(1)).indexOf(58);
            if (index > 0) {
                String methodStr = rootDirSpec.substring(0, index);
                rootDirSpec = rootDirSpec.substring(index + 1);
                if (methodStr.equalsIgnoreCase("ext") || methodStr.equalsIgnoreCase("pserver") || methodStr.equalsIgnoreCase("direct") || methodStr.equalsIgnoreCase("server")) {
                    this.connectMethodStr = methodStr;
                    index = rootDirSpec.indexOf(58);
                    String tempStr = rootDirSpec.substring(0, index);
                    this.rootDirectory = rootDirSpec.substring(index + 1);
                    if (index > 0) {
                        if (methodStr.equals("pserver")) {
                            this.isPServer = true;
                            this.connectMethod = 1;
                        } else if (methodStr.equals("server")) {
                            this.isPServer = false;
                            this.connectMethod = 2;
                        } else if (methodStr.equals("ext")) {
                            this.isPServer = false;
                            this.connectMethod = 3;
                        } else if (methodStr.equals("direct")) {
                            this.isPServer = false;
                            this.connectMethod = 1;
                        } else {
                            this.isPServer = false;
                            this.connectMethod = 2;
                        }
                        int subidx = tempStr.indexOf(64);
                        if (subidx > 0) {
                            this.userName = tempStr.substring(0, subidx);
                            this.hostName = tempStr.substring(subidx + 1);
                        } else {
                            this.userName = System.getProperty("user.name", "");
                            this.hostName = tempStr;
                            if (this.isPServer) {
                                isOk = false;
                                CVSLog.logMsg("ERROR Root directory spec '" + specification + "' is invalid (pserver: no user).");
                            }
                        }
                    } else {
                        isOk = false;
                        this.reason = "ERROR Root directory spec '" + specification + "' is invalid (incomplete).";
                    }
                } else {
                    isOk = false;
                    this.reason = "ERROR Root directory spec '" + specification + "' is invalid (server not 'server' or 'pserver').";
                }
            } else {
                isOk = false;
                this.reason = "ERROR Root directory spec '" + specification + "' is invalid (no server spec).";
            }
            this.isValid = isOk;
        } else {
            int index = rootDirSpec.indexOf(64);
            int subidx = rootDirSpec.indexOf(58);
            if (index > 0 && subidx > index) {
                this.isValid = true;
                this.noModeRoot = true;
                this.isPServer = false;
                this.connectMethod = 2;
                this.connectMethodStr = "";
                this.userName = rootDirSpec.substring(0, index);
                this.hostName = rootDirSpec.substring(index + 1, subidx);
                this.rootDirectory = rootDirSpec.substring(subidx + 1);
            } else {
                this.isValid = false;
                this.reason = "ERROR Root directory spec '" + specification + "' is invalid.";
            }
        }
        if (this.isValid && !this.repository.startsWith(this.rootDirectory)) {
            this.repository = this.rootDirectory + "/" + this.repository;
        }
        return this.isValid;
    }

    public static CVSProjectDef readDef(String adminPath) throws IOException {
        String rootPath = CVSProject.getAdminRootPath(adminPath);
        File adminRootFile = new File(rootPath);
        if (!adminRootFile.exists()) {
            throw new IOException("admin Root file '" + adminRootFile.getPath() + "' does not exist");
        }
        String reposPath = CVSProject.getAdminRepositoryPath(adminPath);
        File adminReposFile = new File(reposPath);
        if (!adminReposFile.exists()) {
            throw new IOException("admin Repository file '" + adminReposFile.getPath() + "' does not exist");
        }
        String rootDirectoryStr = CVSCUtilities.readStringFile(adminRootFile);
        if (rootDirectoryStr == null) {
            throw new IOException("reading admin Root file '" + adminRootFile.getPath());
        }
        String repositoryStr = CVSCUtilities.readStringFile(adminReposFile);
        if (repositoryStr == null) {
            throw new IOException("reading admin Repository file '" + adminReposFile.getPath());
        }
        CVSProjectDef def = new CVSProjectDef(rootDirectoryStr, repositoryStr);
        if (!def.isValid()) {
            throw new IOException("CVS admin defintion is not valid, " + def.getReason());
        }
        return def;
    }
}

