/*
 * Decompiled with CFR 0.152.
 */
package com.ice.cvsc;

import com.ice.cvsc.CVSTimestamp;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class CVSTimestampFormat
extends Format {
    public static final String RCS_ID = "$Id: CVSTimestampFormat.java,v 2.5 2003/07/27 01:08:32 time Exp $";
    public static final String RCS_REV = "$Revision: 2.5 $";
    public static final String DEFAULT_GMT_TZID = "GMT";
    private static TimeZone tz;
    private static String timezoneID;

    public static final CVSTimestampFormat getInstance() {
        return new CVSTimestampFormat();
    }

    public static final void setTimeZoneID(String timezoneID) {
        CVSTimestampFormat.timezoneID = timezoneID;
        tz = TimeZone.getTimeZone(CVSTimestampFormat.timezoneID);
    }

    public String format(CVSTimestamp stamp) throws IllegalArgumentException {
        return this.formatTimeZone(stamp, tz);
    }

    public String formatTimeZone(CVSTimestamp stamp, TimeZone tz) throws IllegalArgumentException {
        Locale loc = Locale.US;
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy", loc);
        dateFormat.setTimeZone(tz);
        String result = dateFormat.format(stamp);
        return result;
    }

    public StringBuffer format(Object stamp, StringBuffer appendTo, FieldPosition fieldPos) throws IllegalArgumentException {
        String tmpFormat = this.format((CVSTimestamp)stamp);
        appendTo.append(tmpFormat);
        return appendTo;
    }

    public String formatTerse(CVSTimestamp stamp) {
        return this.formatTerseTimeZone(stamp, tz);
    }

    public String formatTerseTimeZone(CVSTimestamp stamp, TimeZone tz) {
        Locale loc = Locale.US;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyMMdd HH:mm", loc);
        dateFormat.setTimeZone(CVSTimestampFormat.tz);
        String result = dateFormat.format(stamp);
        return result;
    }

    public CVSTimestamp parse(String source) throws ParseException {
        return this.parseTimestamp(source);
    }

    public Object parseObject(String source, ParsePosition pos) {
        CVSTimestamp stamp = null;
        try {
            stamp = this.parseTimestamp(source);
        }
        catch (ParseException ex) {
            stamp = null;
        }
        return stamp;
    }

    public CVSTimestamp parseTimestamp(String source) throws ParseException {
        ParsePosition pos = new ParsePosition(0);
        return this.parseTimestamp(source, pos);
    }

    public CVSTimestamp parseTimestamp(String source, ParsePosition pos) throws ParseException {
        Locale loc = Locale.US;
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy", loc);
        dateFormat.setTimeZone(tz);
        Date result = dateFormat.parse(source, pos);
        if (result == null) {
            throw new ParseException("invalid timestamp '" + source + "'", 0);
        }
        return new CVSTimestamp(result);
    }

    public static void main(String[] args) {
        CVSTimestampFormat fmt = CVSTimestampFormat.getInstance();
        try {
            CVSTimestamp ts = fmt.parseTimestamp(args[0], new ParsePosition(0));
            System.err.println("TS = " + ts);
        }
        catch (ParseException ex) {
            ex.printStackTrace();
        }
    }

    static {
        timezoneID = DEFAULT_GMT_TZID;
        tz = TimeZone.getTimeZone(timezoneID);
    }
}

