/*
 * Decompiled with CFR 0.152.
 */
package com.ice.jcvsii;

import com.ice.cvsc.CVSClient;
import com.ice.cvsc.CVSLog;
import com.ice.cvsc.CVSProject;
import com.ice.cvsc.CVSRequest;
import com.ice.jcvsii.Config;
import com.ice.pref.PrefsTuple;
import com.ice.pref.PrefsTupleTable;
import com.ice.pref.UserPrefs;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class CVSUtilities {
    public static CVSClient createCVSClient() {
        CVSClient client = new CVSClient();
        client.setMultipleInterfaceSupport(Config.getInstance().getPrefs().getBoolean("global.multipleInterfaceSupport", false));
        return client;
    }

    public static CVSClient createCVSClient(String cvsHost, int cvsPort) {
        CVSClient client = CVSUtilities.createCVSClient();
        client.setHostName(cvsHost);
        client.setPort(cvsPort);
        return client;
    }

    public static String establishServerCommand(String hostname, int connMethod, boolean pServer) {
        UserPrefs prefs = Config.getPreferences();
        String command = "(not applicable)";
        if (connMethod == 2) {
            command = "cvs server";
            PrefsTupleTable table = prefs.getTupleTable("global.serverTable", null);
            if (table != null) {
                PrefsTuple tup = table.getTuple(hostname);
                if (tup != null) {
                    command = tup.getValueAt(0);
                }
                if (command == null && (tup = table.getTuple("DEFAULT")) != null) {
                    command = tup.getValueAt(0);
                }
            }
        } else if (connMethod == 3) {
            command = "cvs server";
            PrefsTupleTable table = prefs.getTupleTable("global.serverTable", null);
            if (table != null) {
                PrefsTuple tup = table.getTuple(hostname);
                if (tup != null) {
                    command = tup.getValueAt(0);
                }
                if (command == null && (tup = table.getTuple("DEFAULT")) != null) {
                    command = tup.getValueAt(0);
                }
            }
        }
        return command;
    }

    public static void establishRSHProcess(CVSRequest request) {
        UserPrefs prefs = Config.getPreferences();
        String rshCommand = prefs.getProperty("global.rshCommand", null);
        if (rshCommand != null && rshCommand.length() > 0) {
            request.setRshProcess(rshCommand);
        }
    }

    public static void establishRSHProcess(CVSProject project) {
        UserPrefs prefs = Config.getPreferences();
        String rshCommand = prefs.getProperty("global.rshCommand", null);
        if (rshCommand != null && rshCommand.length() > 0) {
            project.setRshProcess(rshCommand);
        }
    }

    public static int computePortNum(String hostname, int connMethod, boolean isPServer) {
        int defPort;
        UserPrefs prefs = Config.getPreferences();
        StringBuffer prefName = new StringBuffer("portNum.");
        if (connMethod == 2) {
            prefName.append("server.");
            defPort = prefs.getInteger("global.defPorts.server", 0);
            if (defPort == 0) {
                defPort = 514;
            }
        } else if (connMethod == 3) {
            prefName.append("ext.");
            defPort = prefs.getInteger("global.defPorts.ext", 0);
            if (defPort == 0) {
                defPort = 22;
            }
        } else if (isPServer) {
            prefName.append("pserver.");
            defPort = prefs.getInteger("global.defPorts.pserver", 0);
            if (defPort == 0) {
                defPort = 2401;
            }
        } else {
            prefName.append("direct.");
            defPort = prefs.getInteger("global.defPorts.direct", 0);
            if (defPort == 0) {
                defPort = 2402;
            }
        }
        int cvsPort = prefs.getInteger(prefName + hostname, defPort);
        return cvsPort;
    }

    public static String[] getUserSetVariables(String hostname) {
        String prop;
        int count = 0;
        String prefix = "setVars.";
        UserPrefs prefs = Config.getPreferences();
        int i = 0;
        while (prefs.getProperty(prefix + "all." + i, null) != null) {
            ++i;
            ++count;
        }
        i = 0;
        while (prefs.getProperty(prefix + hostname + "." + i, null) != null) {
            ++i;
            ++count;
        }
        if (count == 0) {
            return null;
        }
        String[] result = new String[count];
        int idx = 0;
        i = 0;
        while (idx < count) {
            prop = prefs.getProperty(prefix + "all." + i, null);
            if (prop == null) break;
            result[idx++] = prop;
            ++i;
        }
        i = 0;
        while (idx < count) {
            prop = prefs.getProperty(prefix + hostname + "." + i, null);
            if (prop == null) break;
            result[idx++] = prop;
            ++i;
        }
        return result;
    }

    public static String getFilePath(File file) {
        String parent = null;
        String pathName = file.getPath();
        int index = pathName.lastIndexOf(File.separatorChar);
        if (index < 0) {
            index = pathName.lastIndexOf(47);
            if (index >= 0) {
                parent = pathName.substring(0, index);
            }
        } else {
            parent = pathName.substring(0, index);
        }
        return parent;
    }

    public static String getFileName(File file) {
        return CVSUtilities.getFileName(file.getPath());
    }

    public static String getFileName(String path) {
        String newName = path;
        int index = newName.lastIndexOf(File.separatorChar);
        if (index < 0) {
            index = newName.lastIndexOf(47);
            if (index >= 0) {
                newName = newName.substring(index + 1);
            }
        } else {
            newName = newName.substring(index + 1);
        }
        return newName;
    }

    public static boolean renameFile(File entryFile, String pattern, boolean overWrite) {
        String rootPath = CVSUtilities.getFilePath(entryFile);
        String fileName = CVSUtilities.getFileName(entryFile);
        int index = pattern.indexOf(64);
        String newName = index < 0 ? fileName + pattern : pattern.substring(0, index) + fileName + pattern.substring(index + 1);
        File backFile = new File(rootPath + "/" + newName);
        if (overWrite && backFile.exists()) {
            backFile.delete();
        }
        boolean result = entryFile.renameTo(backFile);
        return result;
    }

    public static boolean copyFile(File entryFile, String pattern) {
        boolean result = true;
        BufferedInputStream in = null;
        BufferedOutputStream out = null;
        String rootPath = CVSUtilities.getFilePath(entryFile);
        String fileName = CVSUtilities.getFileName(entryFile);
        int index = pattern.indexOf(64);
        String newName = index < 0 ? fileName + pattern : pattern.substring(0, index) + fileName + pattern.substring(index + 1);
        File copyFile = new File(rootPath + "/" + newName);
        try {
            in = new BufferedInputStream(new FileInputStream(entryFile));
        }
        catch (Exception ex) {
            in = null;
            result = false;
            CVSLog.logMsg("CVSUtilities.copyFile: failed creating in reader: " + ex.getMessage());
        }
        if (result) {
            try {
                out = new BufferedOutputStream(new FileOutputStream(copyFile));
            }
            catch (Exception ex) {
                out = null;
                result = false;
                CVSLog.logMsg("CVSUtilities.copyFile: failed creating out writer: " + ex.getMessage());
            }
        }
        if (out == null || in == null) {
            result = false;
            CVSLog.logMsg("CVSUtilities.copyFile: failed creating '" + (out == null ? "output writer" : "input reader") + "'");
        }
        if (result) {
            long fileSize;
            int bytes;
            byte[] buffer = new byte[8192];
            for (long length = fileSize = entryFile.length(); length > 0L; length -= (long)bytes) {
                bytes = (int)(length > 8192L ? 8192L : length);
                try {
                    bytes = in.read(buffer, 0, bytes);
                }
                catch (IOException ex) {
                    result = false;
                    CVSLog.logMsg("CVSUtilities.copyFile: ERROR reading in file:\n   " + ex.getMessage());
                    break;
                }
                if (bytes < 0) break;
                try {
                    out.write(buffer, 0, bytes);
                    continue;
                }
                catch (IOException ex) {
                    result = false;
                    CVSLog.logMsg("CVSUtilities.copyFile: ERROR writing out file:\n   " + ex.getMessage());
                    break;
                }
            }
        }
        try {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
        catch (IOException ex) {
            CVSLog.logMsg("CVSUtilities.copyFile: failed closing files: " + ex.getMessage());
            result = false;
        }
        return result;
    }
}

