/*
 * Decompiled with CFR 0.152.
 */
package com.ice.jcvsii;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.EventListener;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.EventListenerList;
import javax.swing.event.MouseInputListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ColumnHeader
extends JComponent {
    protected TableColumnModel columnModel;
    protected CellRendererPane rendererPane;
    protected MouseInputListener mouseInputListener;
    protected boolean updateTableInRealTime;
    protected transient TableColumn resizingColumn;
    protected transient TableColumn draggedColumn;
    protected transient int draggedDistance;
    protected boolean resizingAllowed;
    protected boolean reorderingAllowed;
    protected ColumnHeaderRenderer hdrCellRenderer;
    protected EventListenerList resizeListeners;
    static /* synthetic */ Class class$com$ice$jcvsii$ColumnHeader$ResizeListener;

    public ColumnHeader(TableColumnModel model) {
        this.columnModel = model;
        this.resizingAllowed = true;
        this.updateTableInRealTime = true;
        this.resizeListeners = new EventListenerList();
        this.hdrCellRenderer = new DefaultColumnHeaderRenderer();
        MouseInputHandler mouseListener = new MouseInputHandler();
        this.addMouseListener(mouseListener);
        this.addMouseMotionListener(mouseListener);
        this.rendererPane = new CellRendererPane();
        this.add(this.rendererPane);
    }

    public void addResizeListener(ResizeListener l) {
        this.resizeListeners.add(class$com$ice$jcvsii$ColumnHeader$ResizeListener == null ? (class$com$ice$jcvsii$ColumnHeader$ResizeListener = ColumnHeader.class$("com.ice.jcvsii.ColumnHeader$ResizeListener")) : class$com$ice$jcvsii$ColumnHeader$ResizeListener, l);
    }

    public void removeResizeListener(ResizeListener l) {
        this.resizeListeners.remove(class$com$ice$jcvsii$ColumnHeader$ResizeListener == null ? (class$com$ice$jcvsii$ColumnHeader$ResizeListener = ColumnHeader.class$("com.ice.jcvsii.ColumnHeader$ResizeListener")) : class$com$ice$jcvsii$ColumnHeader$ResizeListener, l);
    }

    protected void fireColumnHeadersResized(boolean isResizing) {
        Object[] listeners = this.resizeListeners.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == (class$com$ice$jcvsii$ColumnHeader$ResizeListener == null ? ColumnHeader.class$("com.ice.jcvsii.ColumnHeader$ResizeListener") : class$com$ice$jcvsii$ColumnHeader$ResizeListener)) {
                ResizeEvent evt = new ResizeEvent(this, isResizing);
                ((ResizeListener)listeners[i + 1]).columnHeadersResized(evt);
            }
            i -= 2;
        }
    }

    protected void fireColumnHeadersNeedUpdate(boolean isResizing) {
        Object[] listeners = this.resizeListeners.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == (class$com$ice$jcvsii$ColumnHeader$ResizeListener == null ? ColumnHeader.class$("com.ice.jcvsii.ColumnHeader$ResizeListener") : class$com$ice$jcvsii$ColumnHeader$ResizeListener)) {
                ResizeEvent evt = new ResizeEvent(this, isResizing);
                ((ResizeListener)listeners[i + 1]).columnHeadersNeedUpdate(evt);
            }
            i -= 2;
        }
    }

    public TableColumnModel getColumnModel() {
        return this.columnModel;
    }

    public ColumnHeaderRenderer getRenderer() {
        return this.hdrCellRenderer;
    }

    public void setRenderer(ColumnHeaderRenderer rend) {
        this.hdrCellRenderer = rend;
    }

    public TableColumn getDraggedColumn() {
        return this.draggedColumn;
    }

    public void setDraggedColumn(TableColumn col) {
        this.draggedColumn = col;
    }

    public TableColumn getResizingColumn() {
        return this.resizingColumn;
    }

    public void setResizingColumn(TableColumn col) {
        this.resizingColumn = col;
    }

    public int getDraggedDistance() {
        return this.draggedDistance;
    }

    public void setDraggedDistance(int dist) {
        this.draggedDistance = dist;
    }

    public boolean getResizingAllowed() {
        return this.resizingAllowed;
    }

    public void setResizingAllowed(boolean allowed) {
        this.resizingAllowed = allowed;
    }

    public boolean getReorderingAllowed() {
        return this.reorderingAllowed;
    }

    public void setReorderingAllowed(boolean allowed) {
        this.reorderingAllowed = allowed;
    }

    public boolean getUpdateTableInRealTime() {
        return this.updateTableInRealTime;
    }

    public void setUpdateTableInRealTime(boolean upd) {
        this.updateTableInRealTime = upd;
    }

    public void paint(Graphics g) {
        Rectangle clipBounds = g.getClipBounds();
        if (this.getColumnModel() == null) {
            return;
        }
        int column = 0;
        boolean drawn = false;
        int draggedColumnIndex = -1;
        Rectangle draggedCellRect = null;
        Dimension size = this.getSize();
        Rectangle cellRect = new Rectangle(0, 0, size.width, size.height);
        Enumeration<TableColumn> enumeration = this.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn aColumn = enumeration.nextElement();
            int columnMargin = this.getColumnModel().getColumnMargin();
            cellRect.width = aColumn.getWidth() + columnMargin;
            if (cellRect.intersects(clipBounds)) {
                drawn = true;
                if (aColumn != this.getDraggedColumn()) {
                    this.paintCell(g, cellRect, column);
                } else {
                    g.setColor(this.getParent().getBackground());
                    g.fillRect(cellRect.x, cellRect.y, cellRect.width, cellRect.height);
                    draggedCellRect = new Rectangle(cellRect);
                    draggedColumnIndex = column;
                }
            } else if (drawn) break;
            cellRect.x += cellRect.width;
            ++column;
        }
        TableColumn draggedColumnObject = this.getDraggedColumn();
        if (draggedColumnObject != null && draggedCellRect != null) {
            draggedCellRect.x += this.getDraggedDistance();
            this.paintCell(g, draggedCellRect, draggedColumnIndex);
        }
    }

    private void paintCell(Graphics g, Rectangle cellRect, int columnIndex) {
        TableColumn aCol = this.getColumnModel().getColumn(columnIndex);
        Component component = this.hdrCellRenderer.getHeaderCellRendererComponent(this, aCol.getHeaderValue(), columnIndex);
        this.rendererPane.add(component);
        this.rendererPane.paintComponent(g, component, this, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
    }

    private int getHeaderHeight() {
        int height = 0;
        TableColumnModel columnModel = this.getColumnModel();
        int col = 0;
        while (col < columnModel.getColumnCount()) {
            TableColumn aCol = columnModel.getColumn(col);
            Component comp = this.hdrCellRenderer.getHeaderCellRendererComponent(this, aCol.getHeaderValue(), col);
            height = Math.max(height, comp.getPreferredSize().height);
            ++col;
        }
        return height;
    }

    private Dimension createHeaderSize(long width) {
        TableColumnModel columnModel = this.getColumnModel();
        if ((width += (long)(columnModel.getColumnMargin() * (columnModel.getColumnCount() + 1))) > Integer.MAX_VALUE) {
            width = Integer.MAX_VALUE;
        }
        return new Dimension((int)width, this.getHeaderHeight());
    }

    public Dimension getMinimumSize() {
        long width = 0L;
        Enumeration<TableColumn> enumeration = this.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn aColumn = enumeration.nextElement();
            width += (long)aColumn.getMinWidth();
        }
        return this.createHeaderSize(width);
    }

    public Dimension getPreferredSize() {
        long width = 0L;
        Enumeration<TableColumn> enumeration = this.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn aColumn = enumeration.nextElement();
            width += (long)aColumn.getPreferredWidth();
        }
        return this.createHeaderSize(width);
    }

    public Dimension getMaximumSize() {
        long width = 0L;
        Enumeration<TableColumn> enumeration = this.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn aColumn = enumeration.nextElement();
            width += (long)aColumn.getMaxWidth();
        }
        return this.createHeaderSize(width);
    }

    public Rectangle getHeaderRect(int columnIndex) {
        TableColumnModel columnModel = this.getColumnModel();
        if (columnIndex < 0 || columnIndex >= columnModel.getColumnCount()) {
            throw new IllegalArgumentException("Column index out of range");
        }
        int rectX = 0;
        int column = 0;
        int columnMargin = this.getColumnModel().getColumnMargin();
        Enumeration<TableColumn> enumeration = this.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn aColumn = enumeration.nextElement();
            if (column == columnIndex) {
                return new Rectangle(rectX, 0, aColumn.getWidth() + columnMargin, this.getSize().height);
            }
            rectX += aColumn.getWidth() + columnMargin;
            ++column;
        }
        return new Rectangle();
    }

    public Point getLocationOnScreen() {
        Container parent = this.getParent();
        if (parent != null) {
            Point parentLocation = parent.getLocationOnScreen();
            Point componentLocation = this.getLocation();
            componentLocation.translate(parentLocation.x, parentLocation.y);
            return componentLocation;
        }
        return null;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class DefaultColumnHeaderRenderer
    extends JLabel
    implements ColumnHeaderRenderer {
        public DefaultColumnHeaderRenderer() {
            this.setBorder(new CompoundBorder(new BevelBorder(0), new EmptyBorder(0, 3, 0, 3)));
        }

        public Component getHeaderCellRendererComponent(ColumnHeader header, Object value, int index) {
            if (value == null) {
                value = "Column " + index;
            }
            this.setText((String)value);
            return this;
        }
    }

    public static interface ColumnHeaderRenderer {
        public Component getHeaderCellRendererComponent(ColumnHeader var1, Object var2, int var3);
    }

    public class ResizeEvent
    extends AWTEvent {
        private boolean isResizing;

        public ResizeEvent(Component source, boolean isResizing) {
            super(source, 1999);
            this.isResizing = isResizing;
        }

        public boolean isResizing() {
            return this.isResizing;
        }
    }

    public static interface ResizeListener
    extends EventListener {
        public void columnHeadersResized(ResizeEvent var1);

        public void columnHeadersNeedUpdate(ResizeEvent var1);
    }

    public class MouseInputHandler
    implements MouseInputListener {
        private int lastEffectiveMouseX;

        public void mouseClicked(MouseEvent e) {
        }

        public void mousePressed(MouseEvent evt) {
            ColumnHeader.this.setDraggedColumn(null);
            ColumnHeader.this.setResizingColumn(null);
            ColumnHeader.this.setDraggedDistance(0);
            Point p = evt.getPoint();
            this.lastEffectiveMouseX = p.x;
            int index = ColumnHeader.this.getColumnModel().getColumnIndexAtX(p.x);
            if (index != -1) {
                int resizeIndex = this.computeResizingColumn(p);
                if (ColumnHeader.this.getResizingAllowed() && resizeIndex != -1) {
                    TableColumn hitColumn = ColumnHeader.this.columnModel.getColumn(resizeIndex);
                    ColumnHeader.this.setResizingColumn(hitColumn);
                } else if (ColumnHeader.this.getReorderingAllowed()) {
                    TableColumn hitColumn = ColumnHeader.this.columnModel.getColumn(index);
                    ColumnHeader.this.setDraggedColumn(hitColumn);
                }
            }
        }

        public void mouseMoved(MouseEvent evt) {
            if (this.computeResizingColumn(evt.getPoint()) != -1) {
                Cursor resizeCursor = Cursor.getPredefinedCursor(11);
                if (ColumnHeader.this.getCursor() != resizeCursor) {
                    ColumnHeader.this.setCursor(resizeCursor);
                }
            } else {
                Cursor defaultCursor = Cursor.getPredefinedCursor(0);
                if (ColumnHeader.this.getCursor() != defaultCursor) {
                    ColumnHeader.this.setCursor(defaultCursor);
                }
            }
        }

        public void mouseDragged(MouseEvent evt) {
            int mouseX = evt.getX();
            int deltaX = mouseX - this.lastEffectiveMouseX;
            if (deltaX == 0) {
                return;
            }
            TableColumn rColumn = ColumnHeader.this.getResizingColumn();
            TableColumn draggedColumn = ColumnHeader.this.getDraggedColumn();
            if (rColumn != null) {
                Dimension origSz = ColumnHeader.this.getSize();
                int oldWidth = rColumn.getWidth();
                int newWidth = oldWidth + deltaX;
                rColumn.setWidth(newWidth);
                rColumn.setPreferredWidth(newWidth);
                int acheivedDeltaX = rColumn.getWidth() - oldWidth;
                this.lastEffectiveMouseX += acheivedDeltaX;
                ColumnHeader.this.fireColumnHeadersResized(true);
                ColumnHeader.this.revalidate();
                ColumnHeader.this.repaint();
                if (ColumnHeader.this.getUpdateTableInRealTime()) {
                    ColumnHeader.this.fireColumnHeadersNeedUpdate(true);
                }
            } else if (draggedColumn != null) {
                this.move(evt, deltaX);
                this.lastEffectiveMouseX = mouseX;
            } else {
                this.lastEffectiveMouseX = mouseX;
            }
        }

        public void mouseReleased(MouseEvent evt) {
            TableColumn rColumn = ColumnHeader.this.getResizingColumn();
            TableColumn draggedColumn = ColumnHeader.this.getDraggedColumn();
            if (rColumn != null) {
                ColumnHeader.this.fireColumnHeadersResized(false);
                ColumnHeader.this.fireColumnHeadersNeedUpdate(false);
            }
            ColumnHeader.this.setResizingColumn(null);
            ColumnHeader.this.setDraggedColumn(null);
            ColumnHeader.this.setDraggedDistance(0);
            ColumnHeader.this.repaint();
        }

        public void mouseEntered(MouseEvent evt) {
        }

        public void mouseExited(MouseEvent evt) {
        }

        private int viewIndexForColumn(TableColumn aColumn) {
            TableColumnModel cm = ColumnHeader.this.getColumnModel();
            int column = 0;
            while (column < cm.getColumnCount()) {
                if (cm.getColumn(column) == aColumn) {
                    return column;
                }
                ++column;
            }
            return -1;
        }

        private void move(MouseEvent evt, int delta) {
            int width;
            TableColumnModel columnModel = ColumnHeader.this.getColumnModel();
            int lastColumn = columnModel.getColumnCount() - 1;
            TableColumn draggedColumn = ColumnHeader.this.getDraggedColumn();
            int draggedDistance = ColumnHeader.this.getDraggedDistance() + delta;
            int hitColumnIndex = this.viewIndexForColumn(draggedColumn);
            if (draggedDistance < 0 && hitColumnIndex != 0) {
                width = columnModel.getColumnMargin() + columnModel.getColumn(hitColumnIndex - 1).getWidth();
                if (-draggedDistance > width / 2) {
                    columnModel.moveColumn(hitColumnIndex, hitColumnIndex - 1);
                    draggedDistance = width + draggedDistance;
                    --hitColumnIndex;
                }
            } else if (draggedDistance > 0 && hitColumnIndex != lastColumn && draggedDistance > (width = columnModel.getColumnMargin() + columnModel.getColumn(hitColumnIndex + 1).getWidth()) / 2) {
                columnModel.moveColumn(hitColumnIndex, hitColumnIndex + 1);
                draggedDistance = -(width - draggedDistance);
                ++hitColumnIndex;
            }
            Rectangle redrawRect = ColumnHeader.this.getHeaderRect(hitColumnIndex);
            redrawRect.x += ColumnHeader.this.getDraggedDistance();
            Rectangle redrawRect2 = ColumnHeader.this.getHeaderRect(hitColumnIndex);
            redrawRect2.x += draggedDistance;
            redrawRect = redrawRect.union(redrawRect2);
            ColumnHeader.this.repaint(redrawRect.x, 0, redrawRect.width, redrawRect.height);
            if (ColumnHeader.this.getUpdateTableInRealTime()) {
                // empty if block
            }
            ColumnHeader.this.setDraggedColumn(columnModel.getColumn(hitColumnIndex));
            ColumnHeader.this.setDraggedDistance(draggedDistance);
        }

        private int computeResizingColumn(Point p) {
            int column = 0;
            Rectangle resizeRect = new Rectangle(-3, 0, 6, ColumnHeader.this.getSize().height);
            int columnMargin = ColumnHeader.this.getColumnModel().getColumnMargin();
            Enumeration<TableColumn> enumeration = ColumnHeader.this.getColumnModel().getColumns();
            while (enumeration.hasMoreElements()) {
                TableColumn aColumn = enumeration.nextElement();
                resizeRect.x += aColumn.getWidth() + columnMargin;
                if (resizeRect.x > p.x) break;
                if (resizeRect.contains(p)) {
                    return column;
                }
                ++column;
            }
            return -1;
        }
    }
}

