/*
 * Decompiled with CFR 0.152.
 */
package com.ice.jcvsii;

import com.ice.config.ConfigureEditor;
import com.ice.config.ConfigureSpec;
import com.ice.jcvsii.Config;
import com.ice.pref.PrefsTuple;
import com.ice.pref.PrefsTupleTable;
import com.ice.pref.UserPrefs;
import com.ice.util.AWTUtilities;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class ExecCommandEditor
extends ConfigureEditor
implements ActionListener,
ItemListener {
    protected PrefsTupleTable cmdTable;
    protected JTextField cmdText;
    protected JTextField envText;
    protected JComboBox cmdBox;

    public ExecCommandEditor() {
        super("Exec Commands");
        this.descOffset = 10;
    }

    public void edit(UserPrefs prefs, ConfigureSpec spec) {
        super.edit(prefs, spec);
        this.cmdTable = Config.getInstance().getExecCmdDefinitions();
        this.cmdBox.setModel(new DefaultComboBoxModel(this.cmdTable.getKeyOrder()));
        this.cmdBox.setSelectedItem(null);
        this.cmdBox.repaint(50L);
        this.validate();
    }

    public void saveChanges(UserPrefs prefs, ConfigureSpec spec) {
        this.saveCurrentCommand((String)this.cmdBox.getSelectedItem());
        String propName = spec.getPropertyName();
        prefs.setTupleTable(propName, this.cmdTable);
    }

    public void commitChanges(ConfigureSpec spec, UserPrefs prefs, UserPrefs orig) {
        String propName = spec.getPropertyName();
        PrefsTupleTable table = prefs.getTupleTable(propName, null);
        orig.removeTupleTable(propName);
        if (table != null) {
            orig.setTupleTable(propName, table);
        }
        Config.getInstance().loadExecCmdDefinitions();
    }

    public boolean isModified(ConfigureSpec spec, UserPrefs prefs, UserPrefs orig) {
        String propName = spec.getPropertyName();
        PrefsTupleTable nt = prefs.getTupleTable(propName, null);
        PrefsTupleTable ot = orig.getTupleTable(propName, null);
        return nt != null && ot != null ? !nt.equals(ot) : nt != null || ot != null;
    }

    public void requestInitialFocus() {
        this.cmdBox.requestFocus();
    }

    public void saveCurrentCommand(String extVerb) {
        if (extVerb != null) {
            String cmd = this.cmdText.getText();
            String env = this.envText.getText();
            String[] vals = new String[]{env, cmd};
            PrefsTuple tup = new PrefsTuple(extVerb, vals);
            this.cmdTable.putTuple(tup);
        }
    }

    public void newCommand() {
        String extVerb = null;
        while ((extVerb = JOptionPane.showInputDialog("Enter key: .ext.verb (e.g. .java.edit)")) != null) {
            if (extVerb.indexOf(".") == -1) {
                JOptionPane.showMessageDialog(null, "The key '" + extVerb + "' is not valid.\n" + "The format is '.ext.verb'.\n", "Invalid Key", 2);
                continue;
            }
            String[] tupVals = new String[]{"", ""};
            PrefsTuple newTuple = new PrefsTuple(extVerb, tupVals);
            boolean append = true;
            int i = 0;
            int sz = this.cmdTable.size();
            while (i < sz) {
                PrefsTuple tup = this.cmdTable.getTupleAt(i);
                if (extVerb.compareTo(tup.getKey()) < 0) {
                    append = false;
                    this.cmdTable.insertTupleAt(newTuple, i);
                    break;
                }
                ++i;
            }
            if (append) {
                this.cmdTable.appendTuple(newTuple);
            }
            this.cmdBox.setModel(new DefaultComboBoxModel(this.cmdTable.getKeyOrder()));
            this.cmdBox.setSelectedItem(extVerb);
            this.cmdBox.repaint(500L);
            break;
        }
    }

    public void deleteCommand() {
        PrefsTuple tup;
        String extVerb = (String)this.cmdBox.getSelectedItem();
        if (extVerb != null && (tup = this.cmdTable.getTuple(extVerb)) != null) {
            this.cmdTable.removeTuple(tup);
            this.cmdBox.removeItem(extVerb);
        }
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equals("NEW")) {
            this.newCommand();
        } else if (command.equals("DEL")) {
            this.deleteCommand();
        }
    }

    public void itemStateChanged(ItemEvent evt) {
        int stateChg = evt.getStateChange();
        if (stateChg == 1) {
            String key = (String)evt.getItem();
            PrefsTuple tup = this.cmdTable.getTuple(key);
            if (tup != null) {
                this.cmdText.setText(tup.getValueAt(1));
                this.envText.setText(tup.getValueAt(0));
            } else {
                this.cmdText.setText("");
                this.envText.setText("");
            }
        } else if (stateChg == 2) {
            this.saveCurrentCommand((String)evt.getItem());
            this.cmdText.setText("");
            this.envText.setText("");
        }
    }

    protected JPanel createEditPanel() {
        JPanel result = new JPanel();
        result.setLayout(new GridBagLayout());
        result.setBorder(new EmptyBorder(5, 3, 3, 3));
        int cols = 3;
        int row = 0;
        JButton btn = new JButton("New...");
        btn.addActionListener(this);
        btn.setActionCommand("NEW");
        AWTUtilities.constrain(result, btn, 0, 17, 0, row, 1, 1, 0.0, 0.0, new Insets(0, 7, 0, 10));
        this.cmdBox = new JComboBox();
        this.cmdBox.addItemListener(this);
        AWTUtilities.constrain(result, this.cmdBox, 2, 10, 1, row, 1, 1, 1.0, 0.0);
        btn = new JButton("Delete");
        btn.addActionListener(this);
        btn.setActionCommand("DEL");
        AWTUtilities.constrain(result, btn, 0, 13, 2, row++, 1, 1, 0.0, 0.0, new Insets(0, 10, 0, 7));
        JLabel lbl = new JLabel("Command:");
        AWTUtilities.constrain(result, lbl, 0, 17, 0, row++, cols, 1, 0.0, 0.0, new Insets(10, 0, 1, 0));
        this.cmdText = new JTextField();
        AWTUtilities.constrain(result, this.cmdText, 2, 17, 0, row++, cols, 1, 1.0, 0.0);
        lbl = new JLabel("Environment:");
        lbl.setBorder(new EmptyBorder(1, 3, 1, 3));
        AWTUtilities.constrain(result, lbl, 0, 17, 0, row++, cols, 1, 0.0, 0.0, new Insets(10, 0, 1, 0));
        this.envText = new JTextField();
        AWTUtilities.constrain(result, this.envText, 2, 17, 0, row++, cols, 1, 1.0, 0.0);
        return result;
    }
}

