/*
 * Decompiled with CFR 0.152.
 */
package com.ice.pref;

import com.ice.pref.PrefsTuple;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class PrefsTupleTable
extends Hashtable {
    private Vector keyOrder = new Vector();

    public boolean equals(PrefsTupleTable that) {
        if (this.size() != that.size()) {
            return false;
        }
        int i = 0;
        while (i < this.keyOrder.size()) {
            String key = (String)this.keyOrder.elementAt(i);
            PrefsTuple thisTup = this.getTuple(key);
            PrefsTuple thatTup = that.getTuple(key);
            if (thisTup == null || thatTup == null) {
                return false;
            }
            if (!thisTup.equals(thatTup)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Vector getKeyOrder() {
        return this.keyOrder;
    }

    public PrefsTuple getTuple(String key) {
        Object o = this.get(key);
        return (PrefsTuple)this.get(key);
    }

    public PrefsTuple getTupleAt(int idx) {
        if (idx < 0 || idx >= this.keyOrder.size()) {
            return null;
        }
        return (PrefsTuple)this.get(this.keyOrder.elementAt(idx));
    }

    public PrefsTuple setTupleAt(PrefsTuple tup, int idx) {
        String key = (String)this.keyOrder.elementAt(idx);
        PrefsTuple remTup = (PrefsTuple)this.remove(key);
        this.keyOrder.setElementAt(tup.getKey(), idx);
        this.put(tup.getKey(), tup);
        return remTup;
    }

    public void removeTuple(PrefsTuple tup) {
        this.keyOrder.removeElement(tup);
        this.remove(tup);
    }

    public void removeTupleAt(int idx) {
        if (idx < 0 || idx >= this.keyOrder.size()) {
            return;
        }
        this.remove(this.keyOrder.elementAt(idx));
        this.keyOrder.removeElementAt(idx);
    }

    public void insertTupleAt(PrefsTuple tup, int idx) {
        if (idx < 0 || idx >= this.keyOrder.size()) {
            return;
        }
        this.put(tup.getKey(), tup);
        this.keyOrder.insertElementAt(tup.getKey(), idx);
    }

    public void appendTuple(PrefsTuple tup) {
        this.put(tup.getKey(), tup);
        this.keyOrder.addElement(tup.getKey());
    }

    public void putTuple(PrefsTuple tuple) {
        if (this.get(tuple.getKey()) == null) {
            this.keyOrder.addElement(tuple.getKey());
        }
        this.put(tuple.getKey(), tuple);
    }

    public int getMaximumTupleLength() {
        int max = 0;
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            PrefsTuple tup = (PrefsTuple)enumeration.nextElement();
            if (tup.length() <= max) continue;
            max = tup.length();
        }
        return max;
    }

    public String toSting() {
        return "[PrefsTupleTable [size=" + this.size() + "," + super.toString() + "]";
    }
}

