/*
 * Decompiled with CFR 0.152.
 */
package com.ice.pref;

import com.ice.pref.UserPrefs;
import com.ice.pref.UserPrefsConstants;
import com.ice.pref.UserPrefsFileLoader;
import com.ice.pref.UserPrefsStreamLoader;
import java.io.IOException;
import java.util.Properties;

public abstract class UserPrefsLoader
extends Properties
implements UserPrefsConstants {
    private String appName = null;
    private String userName = null;
    private String prefsName = null;

    public static UserPrefsLoader getDefaultLoader() {
        return UserPrefsLoader.getLoader("StreamLoader");
    }

    public static UserPrefsLoader getDefaultLoader(String appName, String userName, String prefsName) {
        UserPrefsLoader result = UserPrefsLoader.getDefaultLoader();
        result.setAppName(appName);
        result.setUserName(userName);
        result.setPrefsName(prefsName);
        return result;
    }

    public static UserPrefsLoader getLoader(String loaderName) {
        if (loaderName.equalsIgnoreCase("FileLoader")) {
            return new UserPrefsFileLoader();
        }
        if (loaderName.equalsIgnoreCase("StreamLoader")) {
            return new UserPrefsStreamLoader();
        }
        return null;
    }

    public static UserPrefsLoader getLoader(String loaderName, String appName, String userName, String prefsName) {
        UserPrefsLoader result = UserPrefsLoader.getLoader(loaderName);
        if (result != null) {
            result.setAppName(appName);
            result.setUserName(userName);
            result.setPrefsName(prefsName);
        }
        return result;
    }

    public UserPrefsLoader() {
    }

    public UserPrefsLoader(String appName, String userName, String prefsName) {
        this.appName = appName;
        this.userName = userName;
        this.prefsName = prefsName;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String name) {
        this.appName = name;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String name) {
        this.userName = name;
    }

    public String getPrefsName() {
        return this.prefsName;
    }

    public void setPrefsName(String prefsName) {
        this.prefsName = prefsName;
    }

    public abstract void loadPreferences(UserPrefs var1) throws IOException;

    public abstract void storePreferences(UserPrefs var1) throws IOException;
}

