/*
 * Decompiled with CFR 0.152.
 */
package com.ice.util;

import com.ice.util.ICETracer;
import com.ice.util.ResourceUtilities;
import com.ice.util.StringUtilities;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Vector;

public abstract class UserProperties {
    private static final String PREFIX_PROPERTY = "propertyPrefix";
    private static final String DEFAULTS_RSRC_NAME = ".com.ice.global.defaultsResource.";
    private static final String GLOBAL_RSRCLIST_NAME = ".com.ice.global.propertyResourceList";
    private static final String GLOBAL_RSRC_PREFIX = ".com.ice.global.propertyResource.";
    private static final String APP_RSRCLIST_NAME = ".com.ice.local.propertyResourceList";
    private static final String APP_RSRC_PREFIX = ".com.ice.local.propertyResource.";
    private static final String LOCAL_PROPERTY = "global.localPropertyFile";
    private static final String LOCAL_DEFAULT = null;
    private static final String DYNAMIC_PROPERTY_VERSION = "1.0";
    private static boolean debug = false;
    private static boolean verbose = false;
    private static String osname;
    private static String userName;
    private static String userHome;
    private static String javaHome;
    private static String prefix;
    private static String osSuffix;
    private static String userSuffix;
    private static String defaultsResource;
    private static String localPropertyFile;
    private static Hashtable dynKeysTable;
    private static Hashtable dynPathTable;
    private static Properties workingProps;

    public static String getOSName() {
        return osname;
    }

    public static String getUserHome() {
        return userHome;
    }

    public static String getUserName() {
        return userName;
    }

    public static void setDebug(boolean debug) {
        UserProperties.debug = debug;
    }

    public static void setVerbose(boolean verbose) {
        UserProperties.verbose = verbose;
    }

    public static void setLocalPropertyFile(String fileName) {
        localPropertyFile = fileName;
    }

    public static void setDefaultsResource(String rsrcName) {
        defaultsResource = rsrcName;
    }

    public static void setOSSuffix(String suffix) {
        osSuffix = suffix;
    }

    public static void setUserSuffix(String suffix) {
        userSuffix = suffix;
    }

    public static void setPropertyPrefix(String prefix) {
        UserProperties.prefix = prefix.endsWith(".") ? prefix : prefix + ".";
    }

    public static String getPropertyPrefix() {
        return prefix;
    }

    public static String getLineSeparator() {
        return System.getProperty("line.separator", "\n");
    }

    public static Font getFont(String name, Font defaultFont) {
        return Font.getFont(UserProperties.prefixedPropertyName(name), defaultFont);
    }

    public static Color getColor(String name, Color defaultColor) {
        return Color.getColor(UserProperties.prefixedPropertyName(name), defaultColor);
    }

    public static String prefixedPropertyName(String name) {
        return prefix + name;
    }

    public static String normalizePropertyName(String name) {
        if (name.startsWith(".")) {
            return name.substring(1);
        }
        return UserProperties.prefixedPropertyName(name);
    }

    private static String getOverridableProperty(String name, String defval) {
        String value = null;
        String overName = null;
        String fullName = null;
        fullName = UserProperties.normalizePropertyName(name);
        if (fullName.endsWith(".")) {
            fullName = fullName.substring(0, fullName.length() - 1);
            value = System.getProperty(fullName, defval);
            if (debug) {
                System.err.println("UserProperties.getOverridableProperty: " + fullName + " = '" + value + "'");
            }
            return value;
        }
        if (osSuffix != null && userSuffix != null) {
            overName = fullName + "." + osSuffix + "." + userSuffix;
            value = System.getProperty(overName, null);
            if (debug) {
                System.err.println("UserProperties.getOverridableProperty: " + overName + " = '" + value + "'");
            }
            if (value != null) {
                return value;
            }
        }
        if (userSuffix != null) {
            overName = fullName + "." + userSuffix;
            value = System.getProperty(overName, null);
            if (debug) {
                System.err.println("UserProperties.getOverridableProperty: " + overName + " = '" + value + "'");
            }
            if (value != null) {
                return value;
            }
        }
        if (osSuffix != null) {
            overName = fullName + "." + osSuffix;
            value = System.getProperty(overName, null);
            if (debug) {
                System.err.println("UserProperties.getOverridableProperty: " + overName + " = '" + value + "'");
            }
            if (value != null) {
                return value;
            }
        }
        if (value == null) {
            value = System.getProperty(fullName, null);
            if (debug) {
                System.err.println("UserProperties.getOverridableProperty: " + fullName + " = '" + value + "'");
            }
        }
        if (value == null) {
            value = defval;
            if (debug) {
                System.err.println("UserProperties.getOverridableProperty: " + name + " defaulted to '" + value + "'");
            }
        }
        return value;
    }

    public static String getProperty(String name, String defval) {
        String result = UserProperties.getOverridableProperty(name, defval);
        return result;
    }

    public static int getProperty(String name, int defval) {
        int result;
        block2: {
            result = defval;
            String val = UserProperties.getProperty(name, null);
            if (val == null) break block2;
            try {
                result = Integer.parseInt(val);
            }
            catch (NumberFormatException ex) {
                result = defval;
            }
        }
        return result;
    }

    public static long getProperty(String name, long defval) {
        long result;
        block2: {
            result = defval;
            String val = UserProperties.getProperty(name, null);
            if (val == null) break block2;
            try {
                result = Long.parseLong(val);
            }
            catch (NumberFormatException ex) {
                result = defval;
            }
        }
        return result;
    }

    public static double getProperty(String name, double defval) {
        double result;
        block2: {
            result = defval;
            String val = UserProperties.getProperty(name, null);
            if (val == null) break block2;
            try {
                result = Double.valueOf(val);
            }
            catch (NumberFormatException ex) {
                result = defval;
            }
        }
        return result;
    }

    public static boolean getProperty(String name, boolean defval) {
        boolean result = defval;
        String val = UserProperties.getProperty(name, null);
        if (val != null) {
            if (val.equalsIgnoreCase("T") || val.equalsIgnoreCase("TRUE") || val.equalsIgnoreCase("Y") || val.equalsIgnoreCase("YES")) {
                result = true;
            } else if (val.equalsIgnoreCase("F") || val.equalsIgnoreCase("FALSE") || val.equalsIgnoreCase("N") || val.equalsIgnoreCase("NO")) {
                result = false;
            }
        }
        return result;
    }

    public static String[] getStringArray(String name, String[] defval) {
        String[] result = defval;
        String val = UserProperties.getProperty(name, null);
        if (val != null) {
            result = StringUtilities.splitString(val, ":");
        }
        return result;
    }

    public static Vector getStringVector(String name, Vector defval) {
        Vector<String> result = defval;
        String[] sa = UserProperties.getStringArray(name, null);
        if (sa != null) {
            result = new Vector<String>();
            int s = 0;
            while (s < sa.length) {
                result.addElement(sa[s]);
                ++s;
            }
        }
        return result;
    }

    public static int getClassConstant(String name, int defval) {
        int result;
        block2: {
            int index;
            result = defval;
            String val = UserProperties.getProperty(name, null);
            if (val == null || (index = val.lastIndexOf(".")) <= 0) break block2;
            try {
                String className = val.substring(0, index);
                String constName = val.substring(index + 1);
                Class<?> cls = Class.forName(className);
                Field fld = cls.getField(constName);
                result = fld.getInt(null);
            }
            catch (Exception ex) {
                result = defval;
                ICETracer.traceWithStack("Exception getting constant.");
            }
        }
        return result;
    }

    public static void defaultProperties(Properties props) {
        props.put("com.ice.util.UserProperties.revision", "$Revision: 1.10 $");
        props.put("copyright", "Copyright (c) by Tim Endres");
    }

    public static void includeProperties(Properties into, Properties from) {
        Enumeration<Object> enumeration = from.keys();
        while (enumeration.hasMoreElements()) {
            String key = null;
            try {
                key = (String)enumeration.nextElement();
            }
            catch (NoSuchElementException ex) {
                key = null;
            }
            if (key == null) continue;
            into.put(key, from.get(key));
        }
    }

    public static void addDefaultProperties(Properties props, Properties defaultProps) {
        UserProperties.includeProperties(props, defaultProps);
    }

    private static boolean loadPropertiesStream(InputStream in, Properties props) throws IOException {
        props.load(in);
        return true;
    }

    private static void doLoadPropertiesFile(String path, Properties props, Properties loaded) throws IOException {
        FileInputStream in;
        boolean result = true;
        try {
            in = new FileInputStream(path);
        }
        catch (IOException ex) {
            throw new IOException("opening property file '" + path + "' - " + ex.getMessage());
        }
        try {
            if (loaded != null) {
                UserProperties.loadPropertiesStream(in, loaded);
                UserProperties.includeProperties(props, loaded);
            } else {
                UserProperties.loadPropertiesStream(in, props);
            }
        }
        catch (IOException ex) {
            throw new IOException("loading property file '" + path + "' - " + ex.getMessage());
        }
        try {
            in.close();
        }
        catch (IOException ex) {
            throw new IOException("closing property file '" + path + "' - " + ex.getMessage());
        }
    }

    private static boolean loadPropertiesFile(String path, Properties props, Properties loaded) {
        boolean result = true;
        if (debug) {
            System.err.println("Loading property file '" + path + "'.");
        }
        try {
            UserProperties.doLoadPropertiesFile(path, props, loaded);
        }
        catch (IOException ex) {
            System.err.println("ERROR " + ex.getMessage());
            result = false;
        }
        if (result) {
            System.err.println("Loaded property file '" + path + "'.");
        }
        return result;
    }

    private static void loadDynamicProperties(String name, String path) {
        Properties dynProps = new Properties();
        Properties sysProps = System.getProperties();
        if (debug) {
            System.err.println("Loading  '" + name + "' protperties from '" + path + "'.");
        }
        try {
            UserProperties.doLoadPropertiesFile(path, sysProps, dynProps);
            UserProperties.addDynamicPropertyKeys(name, dynProps);
            System.err.println("Loaded '" + name + "' properties from '" + path + "'.");
        }
        catch (IOException ex) {}
    }

    private static boolean loadPropertiesResource(String name, Properties props) {
        boolean result = false;
        if (debug) {
            System.err.println("Load properties resource '" + name + "'");
        }
        try {
            InputStream in = ResourceUtilities.openNamedResource(name);
            UserProperties.loadPropertiesStream(in, props);
            in.close();
            result = true;
        }
        catch (IOException ex) {
            System.err.println("ERROR loading properties resource '" + name + "' - " + ex.getMessage());
        }
        return result;
    }

    private static void loadPropertyResourceList(String listPropName, String rsrcPrefix, Properties props) {
        String rsrcListStr = UserProperties.getProperty(listPropName, null);
        if (rsrcListStr != null) {
            String[] rsrcList = StringUtilities.splitString(rsrcListStr, ":");
            int rIdx = 0;
            while (rsrcList != null && rIdx < rsrcList.length) {
                boolean result;
                String rsrcTag = rsrcPrefix + rsrcList[rIdx];
                String rsrcName = UserProperties.getProperty(rsrcTag, null);
                if (rsrcName != null && !(result = UserProperties.loadPropertiesResource(rsrcName, props))) {
                    System.err.println("ERROR loading property resource '" + rsrcName + "'");
                }
                ++rIdx;
            }
        }
    }

    public static void loadProperties(String packageName, Properties appProps) {
        File propFile;
        boolean result;
        Properties sysProps;
        if (debug) {
            UserProperties.printContext(System.err);
        }
        if ((sysProps = System.getProperties()) == null) {
            return;
        }
        UserProperties.defaultProperties(sysProps);
        String rsrcName = defaultsResource;
        if (rsrcName == null) {
            rsrcName = UserProperties.getProperty(DEFAULTS_RSRC_NAME, null);
        }
        if (debug) {
            System.err.println("Default Properties Resource '" + rsrcName + "'");
        }
        if (rsrcName != null) {
            result = UserProperties.loadPropertiesResource(rsrcName, sysProps);
            System.err.println("Loaded " + (result ? "the " : "no ") + "default properties.");
        }
        if (appProps != null) {
            if (debug) {
                System.err.println("Adding application default properties.");
            }
            UserProperties.addDefaultProperties(sysProps, appProps);
        }
        String newPrefix = prefix;
        if (debug) {
            System.err.println("Prefix '" + newPrefix + "'");
        }
        if (newPrefix == null) {
            UserProperties.getProperty(packageName + "." + PREFIX_PROPERTY, null);
            if (newPrefix != null) {
                if (debug) {
                    System.err.println("Prefix via property '" + newPrefix + "'");
                }
                UserProperties.setPropertyPrefix(newPrefix);
                if (verbose) {
                    System.err.println("Property prefix set to '" + newPrefix + "'");
                }
            }
        }
        UserProperties.loadPropertyResourceList(GLOBAL_RSRCLIST_NAME, GLOBAL_RSRC_PREFIX, sysProps);
        UserProperties.processDynamicProperties();
        String propPath = localPropertyFile;
        if (propPath == null) {
            propPath = UserProperties.getProperty(LOCAL_PROPERTY, LOCAL_DEFAULT);
        }
        if (debug) {
            System.err.println("Local property file '" + propPath + "'");
        }
        if (propPath != null && (propFile = new File(propPath)).exists() && !(result = UserProperties.loadPropertiesFile(propPath, sysProps, null))) {
            System.err.println("ERROR loading local property file '" + propPath + "'");
        }
        UserProperties.loadPropertyResourceList(APP_RSRCLIST_NAME, APP_RSRC_PREFIX, sysProps);
    }

    private static void processDynamicProperties() {
        Properties sysProps = System.getProperties();
        String dynPropList = sysProps.getProperty("global.dynamicPropList", null);
        if (dynPropList != null) {
            String[] dynList = StringUtilities.splitString(dynPropList, ":");
            int sIdx = 0;
            while (sIdx < dynList.length) {
                String dynName = dynList[sIdx];
                String pathPropName = "global.dynamicPropFile." + dynName;
                String dynPath = sysProps.getProperty(pathPropName, null);
                if (dynPath != null) {
                    if (dynPath.startsWith("~" + File.separator)) {
                        dynPath = sysProps.getProperty("user.home", "") + dynPath.substring(2);
                    }
                    UserProperties.registerDynamicProperties(dynName, dynPath, new Properties());
                }
                ++sIdx;
            }
        }
        Enumeration names = dynKeysTable.keys();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String path = (String)dynPathTable.get(name);
            UserProperties.loadDynamicProperties(name, path);
        }
    }

    public static void registerDynamicProperties(String name, String path, Properties props) {
        dynPathTable.put(name, path);
        UserProperties.addDynamicPropertyKeys(name, props);
    }

    private static void addDynamicPropertyKeys(String name, Properties dynProps) {
        Vector<String> dynKeys = (Vector<String>)dynKeysTable.get(name);
        if (dynKeys == null) {
            dynKeys = dynProps == null ? new Vector<String>(0) : new Vector(dynProps.size());
            dynKeysTable.put(name, dynKeys);
        }
        if (dynProps != null) {
            Enumeration<Object> keys = dynProps.keys();
            while (keys.hasMoreElements()) {
                String keyName = (String)keys.nextElement();
                if (dynKeys.contains(keyName)) continue;
                dynKeys.addElement(keyName);
            }
        }
    }

    private static void copyDynamicProperties(String name, Properties props) {
        String path = (String)dynPathTable.get(name);
        Vector keys = (Vector)dynKeysTable.get(name);
        if (keys == null || path == null) {
            throw new NoSuchElementException("you have not registered the dynamic property package named '" + name + "'");
        }
        Properties sysProps = System.getProperties();
        try {
            Enumeration<Object> enumeration = props.keys();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                if (key == null) continue;
                String normalKey = UserProperties.normalizePropertyName(key);
                sysProps.put(normalKey, props.get(key));
                if (keys.contains(normalKey)) continue;
                keys.addElement(normalKey);
            }
        }
        catch (NoSuchElementException ex) {}
    }

    public static void setDynamicProperties(String name, Properties props) {
        UserProperties.copyDynamicProperties(name, props);
    }

    public static void setDynamicProperty(String name, String propName, String propValue) {
        workingProps.clear();
        workingProps.put(propName, propValue);
        UserProperties.setDynamicProperties(name, workingProps);
    }

    public static void removeDynamicProperty(String name, String propName) {
        String path = (String)dynPathTable.get(name);
        Vector keys = (Vector)dynKeysTable.get(name);
        if (keys == null || path == null) {
            throw new NoSuchElementException("you have not registered the dynamic property package named '" + name + "'");
        }
        String normalKey = UserProperties.normalizePropertyName(propName);
        if (keys.contains(normalKey)) {
            keys.removeElement(normalKey);
            System.getProperties().remove(normalKey);
        }
    }

    public static void saveDynamicProperties(String name) throws IOException {
        String path = (String)dynPathTable.get(name);
        Vector keys = (Vector)dynKeysTable.get(name);
        if (keys == null || path == null) {
            throw new NoSuchElementException("you have not registered the dynamic property package named '" + name + "'");
        }
        Properties dynProps = new Properties();
        Properties sysProps = System.getProperties();
        int count = keys.size();
        int idx = 0;
        while (idx < count) {
            String pName = (String)keys.elementAt(idx);
            dynProps.put(pName, sysProps.get(pName));
            ++idx;
        }
        UserProperties.saveDynamicPropFile(name, path, dynProps);
    }

    private static void saveDynamicPropFile(String name, String path, Properties dynProps) throws IOException {
        String eol = System.getProperty("line.separator", "\n");
        String comment = eol + "## --------------------  W A R N I N G  -------------------- " + eol + "#  This file is automatically generated." + eol + "#  Any changes you make to this file will be overwritten." + eol + "## ---------------------------------------------------------" + eol + "#";
        FileOutputStream out = new FileOutputStream(path);
        dynProps.put("global.dynPropVersion." + name, DYNAMIC_PROPERTY_VERSION);
        dynProps.save(out, comment);
        out.close();
    }

    public static void printContext(PrintStream out) {
        out.println("os.name    = '" + osname + "'");
        out.println("user.name  = '" + userName + "'");
        out.println("user.home  = '" + userHome + "'");
        out.println("java.home  = '" + javaHome + "'");
        out.println("");
        out.println("prefix     = '" + prefix + "'");
        out.println("osSuffix   = '" + osSuffix + "'");
        out.println("userSuffix = '" + userSuffix + "'");
        out.println("");
    }

    public static void printUsage(PrintStream out) {
        out.println("Properties options:");
        out.println("   -propDebug             -- turns on debugging of property loading");
        out.println("   -propVerbose           -- turns on verbose messages during loading");
        out.println("   -propDefaults rsrcName -- sets default properties resource name");
        out.println("   -propFile path         -- sets application property file path");
        out.println("   -propOS suffix         -- sets the os suffix");
        out.println("   -propUser suffix       -- sets the user suffix");
        out.println("   -propPrefix prefix     -- sets application property prefix");
    }

    public static String[] processOptions(String[] args) {
        Vector<String> newArgs = new Vector<String>(args.length);
        int iArg = 0;
        while (iArg < args.length) {
            if (args[iArg].equals("-propPrefix") && iArg + 1 < args.length) {
                UserProperties.setPropertyPrefix(args[++iArg]);
            } else if (args[iArg].equals("-propFile") && iArg + 1 < args.length) {
                UserProperties.setLocalPropertyFile(args[++iArg]);
            } else if (args[iArg].equals("-propDefaults") && iArg + 1 < args.length) {
                UserProperties.setDefaultsResource(args[++iArg]);
            } else if (args[iArg].equals("-propDebug")) {
                UserProperties.setDebug(true);
            } else if (args[iArg].equals("-propVerbose")) {
                UserProperties.setVerbose(true);
            } else if (args[iArg].equals("-propOS") && iArg + 1 < args.length) {
                UserProperties.setOSSuffix(args[++iArg]);
            } else if (args[iArg].equals("-propUser") && iArg + 1 < args.length) {
                UserProperties.setUserSuffix(args[++iArg]);
            } else {
                newArgs.addElement(args[iArg]);
            }
            ++iArg;
        }
        String[] result = new String[newArgs.size()];
        int i = 0;
        while (i < newArgs.size()) {
            result[i] = (String)newArgs.elementAt(i);
            ++i;
        }
        return result;
    }

    static {
        prefix = null;
        defaultsResource = null;
        localPropertyFile = null;
        dynKeysTable = new Hashtable();
        dynPathTable = new Hashtable();
        workingProps = new Properties();
        osname = System.getProperty("os.name");
        userName = System.getProperty("user.name");
        userHome = System.getProperty("user.home");
        javaHome = System.getProperty("java.home");
        osSuffix = osname.replace(' ', '_');
        userSuffix = userName.replace(' ', '_');
    }
}

