/*
 * Decompiled with CFR 0.152.
 */
package com.ice.viewer;

import com.ice.text.HexNumberFormat;
import com.ice.util.AWTUtilities;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.io.IOException;
import java.io.InputStream;
import java.text.FieldPosition;
import java.util.Vector;
import javax.activation.CommandObject;
import javax.activation.DataHandler;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;

public class HexViewer
extends JComponent
implements CommandObject {
    private static final int BLOCKSIZE = 256;
    private static final int HEXBYTES = 16;
    private static final int HEXLINES = 16;
    private static final int PAGEINCR = 8;
    private String verb = null;
    private DataHandler dataHandler = null;
    private JScrollPane scroller = null;
    private JEditorPane editorPane = null;
    private EditorKit editor = null;
    private Document doc = null;
    private boolean hitEOF = false;
    private boolean closeStream = false;
    private int dataLength = -1;
    private InputStream dataStream = null;
    private int currentBlkIdx = 0;
    private Vector blockCache = new Vector();
    private HexNumberFormat hexFmt = null;
    private HexCanvas hexCanvas = null;
    private JScrollBar scrollBar = null;
    private JTextField blkHexField = null;
    private JTextField blkDecField = null;
    private JTextField offHexField = null;
    private JTextField offDecField = null;
    private Cursor saveCursor = null;

    public HexViewer() {
        this(null, -1);
    }

    public HexViewer(InputStream content, int length) {
        this.setDoubleBuffered(true);
        this.establishContents();
        if (content != null) {
            this.setMessage(content, length);
        }
    }

    public void removeNotify() {
        super.removeNotify();
        this.checkClose();
    }

    protected void checkClose() {
        if (this.dataStream != null && this.closeStream) {
            try {
                this.dataStream.close();
            }
            catch (IOException ex) {
                // empty catch block
            }
            this.dataStream = null;
        }
    }

    public boolean getCloseStream() {
        return this.closeStream;
    }

    public void setCloseStream(boolean flag) {
        this.closeStream = flag;
    }

    public void setCommandContext(String verb, DataHandler dh) throws IOException {
        this.verb = verb;
        this.dataHandler = dh;
        InputStream content = dh.getInputStream();
        this.setMessage(content, -1);
    }

    public void setMessage(InputStream content, int length) {
        this.dataStream = content;
        this.dataLength = length;
        this.adjustScroller();
        if (content != null) {
            this.setCurrentBlock(0);
        }
        this.invalidate();
        this.validate();
    }

    public void adjustScroller() {
        if (this.dataLength < 0) {
            this.scrollBar.setMaximum(8);
        } else {
            this.scrollBar.setMaximum((this.dataLength + 255) / 256);
        }
    }

    private void setCurrentBlock(int offset) {
        this.setWaitCursor();
        int blkNum = offset / 256;
        if (blkNum >= this.blockCache.size()) {
            try {
                if (this.readBlock(blkNum) == -1) {
                    this.hitEOF = true;
                    blkNum = this.blockCache.size() - 1;
                    this.scrollBar.setValue(blkNum);
                    this.scrollBar.setMaximum(blkNum + 1);
                }
            }
            catch (IOException ex) {
                ex.printStackTrace(System.err);
                blkNum = this.blockCache.size() - 1;
            }
        }
        this.currentBlkIdx = blkNum;
        if (this.currentBlkIdx < this.blockCache.size()) {
            int rem;
            byte[] dispData = (byte[])this.blockCache.elementAt(blkNum);
            if (this.hitEOF && this.dataLength >= 0 && this.currentBlkIdx == this.blockCache.size() - 1 && (rem = this.dataLength - this.currentBlkIdx * 256) != 256) {
                byte[] remData = new byte[rem];
                System.arraycopy(dispData, 0, remData, 0, rem);
                dispData = remData;
            }
            this.hexCanvas.displayData(dispData);
        } else {
            this.hexCanvas.displayEOF();
        }
        if (this.dataLength < 0 && this.currentBlkIdx > this.scrollBar.getMaximum() - 8) {
            this.scrollBar.setMaximum(this.currentBlkIdx + 8);
        }
        int hexVal = this.currentBlkIdx;
        String fldStr = this.hexFmt.format(hexVal);
        this.blkHexField.setText(fldStr);
        fldStr = "" + hexVal;
        this.blkDecField.setText(fldStr);
        hexVal = this.currentBlkIdx * 256;
        fldStr = this.hexFmt.format(hexVal);
        this.offHexField.setText(fldStr);
        fldStr = "" + hexVal;
        this.offDecField.setText(fldStr);
        this.scrollBar.setValue(this.currentBlkIdx);
        this.resetCursor();
    }

    public int readBlock(int blkNum) throws IOException {
        int result = 0;
        int curBlk = this.blockCache.size();
        while (curBlk <= blkNum) {
            byte[] buf = new byte[256];
            int off = 0;
            int need = buf.length;
            while (need > 0) {
                int numRead = this.dataStream.read(buf, off, need);
                if (numRead < 0) {
                    result = -1;
                    this.checkClose();
                    if (this.dataLength >= 0) break;
                    this.dataLength = curBlk * 256 + off;
                    break;
                }
                off += numRead;
                need -= numRead;
            }
            if (off > 0) {
                this.blockCache.addElement(buf);
            }
            ++curBlk;
        }
        return result;
    }

    public void establishContents() {
        int row = 0;
        this.setLayout(new GridBagLayout());
        this.hexFmt = new HexNumberFormat("XXXXXXXX");
        JPanel ctlPanel = new JPanel();
        ctlPanel.setLayout(new GridBagLayout());
        ctlPanel.setBorder(new EmptyBorder(2, 2, 2, 2));
        AWTUtilities.constrain(this, ctlPanel, 2, 10, 0, row++, 1, 1, 1.0, 0.0);
        int ctlRow = 0;
        int ctlCol = 0;
        JLabel label = new JLabel("Block:");
        label.setHorizontalAlignment(4);
        label.setBorder(new EmptyBorder(0, 2, 0, 2));
        AWTUtilities.constrain(ctlPanel, label, 0, 10, ctlCol++, ctlRow, 1, 1, 0.0, 0.0);
        this.blkHexField = new JTextField();
        AWTUtilities.constrain(ctlPanel, this.blkHexField, 2, 10, ctlCol++, ctlRow, 1, 1, 0.2, 0.0);
        this.blkDecField = new JTextField();
        AWTUtilities.constrain(ctlPanel, this.blkDecField, 2, 10, ctlCol++, ctlRow, 1, 1, 0.25, 0.0);
        label = new JLabel("Offset:");
        label.setHorizontalAlignment(4);
        label.setBorder(new EmptyBorder(0, 8, 0, 2));
        AWTUtilities.constrain(ctlPanel, label, 0, 10, ctlCol++, ctlRow, 1, 1, 0.0, 0.0);
        this.offHexField = new JTextField();
        AWTUtilities.constrain(ctlPanel, this.offHexField, 2, 10, ctlCol++, ctlRow, 1, 1, 0.2, 0.0);
        this.offDecField = new JTextField();
        AWTUtilities.constrain(ctlPanel, this.offDecField, 2, 10, ctlCol++, ctlRow++, 1, 1, 0.35, 0.0);
        JPanel dataPanel = new JPanel();
        dataPanel.setLayout(new GridBagLayout());
        dataPanel.setBorder(new EmptyBorder(2, 2, 2, 2));
        AWTUtilities.constrain(this, dataPanel, 1, 10, 0, row++, 1, 1, 1.0, 1.0);
        this.scrollBar = new JScrollBar(0, 0, 1, 0, 1);
        this.scrollBar.setBlockIncrement(8);
        BoundedRangeModel boundedRangeModel = this.scrollBar.getModel();
        HexViewer hexViewer = this;
        hexViewer.getClass();
        boundedRangeModel.addChangeListener(hexViewer.new ScrollerChangeListener());
        AWTUtilities.constrain(dataPanel, this.scrollBar, 2, 10, 0, 0, 1, 1, 1.0, 0.0);
        this.hexCanvas = new HexCanvas();
        this.hexCanvas.setOpaque(true);
        this.hexCanvas.setBackground(Color.white);
        this.hexCanvas.setBorder(new EmptyBorder(0, 8, 0, 2));
        this.hexCanvas.setFont(new Font("Monospaced", 0, 12));
        AWTUtilities.constrain(dataPanel, this.hexCanvas, 1, 10, 0, 1, 1, 1, 1.0, 1.0);
    }

    public void resetCursor() {
        Frame f = (Frame)this.getTopLevelAncestor();
        if (f != null && this.saveCursor != null) {
            f.setCursor(this.saveCursor);
        }
        this.saveCursor = null;
    }

    public void setWaitCursor() {
        Frame f = (Frame)this.getTopLevelAncestor();
        if (f != null) {
            this.saveCursor = f.getCursor();
            f.setCursor(Cursor.getPredefinedCursor(3));
        }
    }

    private class ScrollerChangeListener
    implements ChangeListener {
        private ScrollerChangeListener() {
        }

        public void stateChanged(ChangeEvent event) {
            int value = HexViewer.this.scrollBar.getValue();
            HexViewer.this.setCurrentBlock(value * 256);
        }
    }

    private class HexCanvas
    extends JComponent {
        private int hexHeight;
        private int hexByteW;
        private int hexQuadW;
        private int hexDataW;
        private int hexSepW;
        private int hexCharW;
        private int hexLineW;
        private int spaceW;
        private int offsetW;
        private Dimension mDim = new Dimension(20, 20);
        private Dimension pDim = new Dimension(400, 400);
        private boolean displayEOF = false;
        private byte[] data = null;
        private HexNumberFormat format = new HexNumberFormat("XX");

        public boolean isFocusTraversable() {
            return false;
        }

        public void displayEOF() {
            this.data = null;
            this.displayEOF = true;
            this.repaint(500L);
        }

        public void displayData(byte[] data) {
            this.data = data;
            this.displayEOF = false;
            this.repaint(500L);
        }

        public void update(Graphics updateG) {
            this.paint(updateG);
        }

        public synchronized void paint(Graphics g) {
            Dimension sz = this.getSize();
            if (this.isOpaque()) {
                g.setColor(this.getBackground());
                g.fillRect(0, 0, sz.width, sz.height);
            }
            g.setColor(this.getForeground());
            Font fHex = this.getFont();
            Font fTitle = this.getFont();
            int x = 1;
            int y = this.hexHeight + 1;
            if (this.displayEOF) {
                g.setFont(new Font("Serif", 1, 18));
                FontMetrics fm = g.getFontMetrics(g.getFont());
                String msg = "End Of Data";
                int sW = fm.stringWidth(msg);
                x = (sz.width - sW) / 2;
                y = (sz.height - fm.getHeight()) / 2 + fm.getHeight();
                g.drawString(msg, x, y);
                return;
            }
            if (this.data == null) {
                return;
            }
            int cnt = 0;
            g.setFont(fHex);
            int i = 0;
            while (i < 16 && cnt < this.data.length) {
                StringBuffer buf = new StringBuffer();
                StringBuffer chBuf = new StringBuffer();
                FieldPosition pos = new FieldPosition(0);
                this.format.format(new Integer(i * 16), buf, pos);
                buf.append(": ");
                int j = 0;
                while (j < 16 && cnt < this.data.length) {
                    int index = i * 16 + j;
                    if (index >= this.data.length) break;
                    char ch = (char)this.data[index];
                    chBuf.append(ch >= ' ' && ch < '\u007f' ? ch : (char)'.');
                    this.format.format(new Integer(this.data[index]), buf, pos);
                    buf.append(" ");
                    ++j;
                    ++cnt;
                }
                while (j < 16) {
                    buf.append("   ");
                    ++j;
                }
                buf.append(" ");
                buf.append(chBuf);
                g.drawString(buf.toString(), x, y);
                y += this.hexHeight;
                ++i;
            }
        }

        public void addNotify() {
            super.addNotify();
            this.computeDimensions();
        }

        public void setFont(Font f) {
            super.setFont(f);
            Graphics g = this.getGraphics();
            if (g != null) {
                this.establishFontMetrics(g, f);
            }
        }

        private void establishFontMetrics(Graphics g, Font f) {
            FontMetrics fm = g.getFontMetrics(this.getFont());
            this.hexHeight = fm.getLeading() + fm.getAscent();
            this.spaceW = fm.stringWidth(" ");
            this.offsetW = fm.stringWidth("88: ");
            this.hexByteW = fm.stringWidth("88");
            this.hexQuadW = 4 * this.hexByteW + 3 * this.spaceW;
            this.hexDataW = 4 * this.hexQuadW;
            this.hexSepW = fm.stringWidth("  ");
            this.hexCharW = fm.stringWidth("0123456789ABCDEF");
            this.hexLineW = this.offsetW + this.hexDataW + this.hexSepW + this.hexCharW;
        }

        public void computeDimensions() {
            Dimension sz = this.getSize();
            Graphics g = this.getGraphics();
            this.establishFontMetrics(g, this.getFont());
            int width = this.hexLineW + 2;
            int height = 16 * this.hexHeight + 2;
            this.mDim.width = width;
            this.mDim.height = height;
            this.pDim.width = this.mDim.width;
            this.pDim.height = this.mDim.height;
        }

        public Dimension getPreferredSize() {
            return this.pDim;
        }

        public Dimension getMinimumSize() {
            return this.pDim;
        }
    }
}

