/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcearcade.jinvaders;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Panel;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.opensourcearcade.jinvaders.AppletHighScores;
import org.opensourcearcade.jinvaders.ApplicationHighScores;
import org.opensourcearcade.jinvaders.Entity;
import org.opensourcearcade.jinvaders.HighScores;
import org.opensourcearcade.jinvaders.Sound;
import org.opensourcearcade.jinvaders.ToolBox;

public final class Game
extends Applet
implements Runnable {
    private static final long serialVersionUID = 1802938807824847849L;
    public static final String VERSION = "2.2";
    public static final int WIDTH = 449;
    public static final int HEIGHT = 480;
    public static final int FRAMES_PER_SECOND = 30;
    public static final String RES_DIR = "/res/";
    private GameStates gameState = GameStates.SPLASH_SCREEN;
    private static final int LIVES = 3;
    private static final int FRAMES_PER_IMAGE = 3;
    private static final int PLAYER_SPEED = 200;
    private static final int PLAYER_SHOT_SPEED = 300;
    private static final int ALIEN_SPEED = 400;
    private static final int UFO_SPEED = 75;
    private static final int ALIEN_SHOT_SPEED = 150;
    private static final int ALIEN_SHOT_FREQ = 1000;
    private static final int BOTTOM_LINE_POS = 462;
    private static final int PLAYER_Y_POS = 416;
    private static final int UFO_Y_POS = 75;
    private static final int ALIENS_X_POS = 68;
    private static final int ALIENS_Y_POS = 112;
    private static final int BUNKERS_Y_POS = 368;
    private static final String STR_GAME_OVER = "GAME OVER";
    private static final String STR_CLICK_TO_START = "CLICK HERE TO BEGIN";
    private static final String STR_PRESS_ENTER = "PRESS ENTER TO PLAY";
    private static final String STR_HISCORE = "HISCORE";
    private static final String STR_HIGHSCORE_LIST = "HIGHSCORES";
    private static final String STR_INPUTNAME = "INPUT YOUR NAME";
    private static final String STR_PAUSED = "PAUSED, CLICK HERE";
    private static final String[] STR_HELP = new String[]{"ENTER = START GAME", "SPACE = FIRE", "MOVE = CURSOR LEFT/RIGHT", "ESC = LEAVE GAME"};
    private static final String[] SPLASH_SCORE_TABLE = new String[]{"*SCORE ADVANCE TABLE*", "=? MYSTERY", "=30 POINTS", "=20 POINTS", "=10 POINTS"};
    private static final String[] PLAY_INVADERS = new String[]{"PLAY", "JINVADERS", "V2.2"};
    private static final NumberFormat NUM_FORMAT = new DecimalFormat("000000");
    private HighScores highScores;
    private BufferedImage backbuffer;
    private Graphics2D g2d;
    private BufferedImage plyrImg;
    private BufferedImage e1Img;
    private BufferedImage e2Img;
    private BufferedImage e3Img;
    private BufferedImage ufoImg;
    private BufferedImage llBnkImg;
    private BufferedImage lrBnkImg;
    private BufferedImage ulBnkImg;
    private BufferedImage urBnkImg;
    private BufferedImage mmBnkImg;
    private BufferedImage sndOffImg;
    private Entity player;
    private Entity ufo;
    private Entity playerShot;
    private Entity alienShot;
    private Entity[][] aliens = new Entity[5][11];
    private Entity[][] bunkers = new Entity[4][20];
    private boolean paused;
    private boolean leftKey;
    private boolean rightKey;
    private boolean spaceKey;
    private boolean escKey;
    private boolean enterKey;
    private boolean backKey;
    private boolean spaceKeyReleased = true;
    private String playerName1;
    private String playerName2;
    private String tmpPlayerName;
    private int caretPos;
    private int score1;
    private int score2;
    private int highscore;
    private int lives1;
    private int alienCtr;
    private int soundCtr;
    private int ufoCntDown;
    private float alienSX;
    private long frameCtr;
    private long shootCtr;
    private long splashScreenTimer;
    private long lastShotTime;
    private long lastSoundTime;
    private long shot_freq;
    private Font font;
    private int lastKey;
    private Panel panel;
    private static Game self;
    private Thread gameLoopThread;
    private long lastUpdate;

    public static void main(String[] stringArray) {
        Game game = Game.getInstance();
        Frame frame = new Frame("JInvaders");
        try {
            BufferedImage bufferedImage = ToolBox.loadImage(game.getURL("jinvaders.png"));
            frame.setIconImage(bufferedImage);
        }
        catch (Exception exception) {
            // empty catch block
        }
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        frame.setLayout(new BorderLayout());
        frame.add((Component)game.getPanel(), "Center");
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
        game.init();
    }

    public static Game getInstance() {
        self = null;
        try {
            self = new Game();
        }
        catch (Exception exception) {
            System.err.println(exception.getLocalizedMessage());
        }
        return self;
    }

    public Game() throws Exception {
        System.out.println(System.getProperty("java.vm.name") + System.getProperty("java.vm.version"));
        System.out.println(this.getClass().getName() + " v" + VERSION);
        this.panel = new Panel();
        this.panel.setPreferredSize(new Dimension(449, 480));
        this.panel.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                Game.this.keyEvent(keyEvent, true);
            }

            public void keyReleased(KeyEvent keyEvent) {
                Game.this.keyEvent(keyEvent, false);
            }
        });
        this.panel.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent focusEvent) {
                Game.this.pause();
            }

            public void focusGained(FocusEvent focusEvent) {
                Game.this.resume();
            }
        });
        this.backbuffer = new BufferedImage(449, 480, 1);
        this.setLayout(new BorderLayout());
        this.add((Component)this.getPanel(), "Center");
    }

    public URL getURL(String string) throws FileNotFoundException {
        URL uRL = this.getClass().getResource(RES_DIR + string);
        if (uRL == null) {
            throw new FileNotFoundException(RES_DIR + string);
        }
        return uRL;
    }

    public void init() {
        this.setSize(449, 480);
        boolean bl = null != System.getSecurityManager();
        this.highScores = bl ? new AppletHighScores() : new ApplicationHighScores();
        this.backbuffer = ToolBox.convertToCompatibleImage(new BufferedImage(449, 480, 1));
        this.g2d = this.backbuffer.createGraphics();
        this.playerName1 = "PLAYER1";
        this.playerName2 = "PLAYER2";
        this.tmpPlayerName = this.playerName1;
        this.caretPos = this.playerName1.length();
        try {
            this.plyrImg = ToolBox.loadImage(this.getURL("player.png"));
            this.e1Img = ToolBox.loadImage(this.getURL("e1.png"));
            this.e2Img = ToolBox.loadImage(this.getURL("e2.png"));
            this.e3Img = ToolBox.loadImage(this.getURL("e3.png"));
            this.llBnkImg = ToolBox.loadImage(this.getURL("ll.png"));
            this.lrBnkImg = ToolBox.loadImage(this.getURL("lr.png"));
            this.ulBnkImg = ToolBox.loadImage(this.getURL("ul.png"));
            this.urBnkImg = ToolBox.loadImage(this.getURL("ur.png"));
            this.mmBnkImg = ToolBox.loadImage(this.getURL("mm.png"));
            this.ufoImg = ToolBox.loadImage(this.getURL("ufo.png"));
            this.sndOffImg = ToolBox.loadImage(this.getURL("sndOff.png"));
            Sound.loadSound(Sound.SOUNDS.SHOT, this.getURL("sounds/PlyShot_44.wav"));
            Sound.loadSound(Sound.SOUNDS.PLY_HIT, this.getURL("sounds/PlyHit_44.wav"));
            Sound.loadSound(Sound.SOUNDS.INV_HIT, this.getURL("sounds/InvHit_44.wav"));
            Sound.loadSound(Sound.SOUNDS.BASE_HIT, this.getURL("sounds/BaseHit_44.wav"));
            Sound.loadSound(Sound.SOUNDS.UFO, this.getURL("sounds/Ufo.wav"));
            Sound.loadSound(Sound.SOUNDS.UFO_HIT, this.getURL("sounds/UfoHit.wav"));
            Sound.loadSound(Sound.SOUNDS.WALK1, this.getURL("sounds/Walk1.wav"));
            Sound.loadSound(Sound.SOUNDS.WALK2, this.getURL("sounds/Walk2.wav"));
            Sound.loadSound(Sound.SOUNDS.WALK3, this.getURL("sounds/Walk3.wav"));
            Sound.loadSound(Sound.SOUNDS.WALK4, this.getURL("sounds/Walk4.wav"));
            Sound.setEnabled(true);
            this.font = ToolBox.loadFont(this.getURL("ARCADEPI.TTF"));
        }
        catch (Exception exception) {
            System.err.println(exception.getLocalizedMessage());
            System.exit(1);
        }
        this.getPanel().requestFocus();
        this.resetGame();
        this.lastUpdate = System.nanoTime();
        this.gameLoopThread = new Thread(this);
        this.gameLoopThread.start();
    }

    public void updateGame(long l) {
        switch (this.gameState) {
            case SPLASH_SCREEN: {
                this.updateSplashScreen(l);
                break;
            }
            case HELP_SCREEN: {
                this.updateHelpScreen(l);
                break;
            }
            case HIGH_SCORE_SCREEN: {
                this.updateHighScoreScreen(l);
                break;
            }
            case IN_GAME_SCREEN: {
                this.updateInGameScreen(l);
                break;
            }
            case INPUT_NAME_SCREEN: {
                this.updateInputNameScreen(l);
                break;
            }
            case GAME_OVER_SCREEN: {
                if (!this.enterKey) break;
                this.enterKey = false;
                if (this.score1 > 0) {
                    this.gameState = GameStates.INPUT_NAME_SCREEN;
                    break;
                }
                this.gameState = GameStates.SPLASH_SCREEN;
                break;
            }
        }
        if (this.lastKey == 83) {
            this.lastKey = 0;
            boolean bl = !Sound.isEnabled();
            Sound.setEnabled(bl);
            if (bl && this.ufo.visible && this.ufo.frame == 0) {
                Sound.loop(Sound.SOUNDS.UFO);
            }
        }
    }

    private void updateSplashScreen(long l) {
        if (this.enterKey) {
            this.enterKey = false;
            this.resetGame();
            this.gameState = GameStates.IN_GAME_SCREEN;
            return;
        }
        this.splashScreenTimer -= l;
        if (this.splashScreenTimer <= 0L) {
            this.highscore = this.highScores.getHighScore();
            this.splashScreenTimer = 5000000000L;
            this.gameState = GameStates.HIGH_SCORE_SCREEN;
        }
    }

    private void updateHelpScreen(long l) {
        if (this.enterKey) {
            this.enterKey = false;
            this.resetGame();
            this.gameState = GameStates.IN_GAME_SCREEN;
            return;
        }
        this.splashScreenTimer -= l;
        if (this.splashScreenTimer <= 0L) {
            this.highscore = this.highScores.getHighScore();
            this.splashScreenTimer = 5000000000L;
            this.gameState = GameStates.SPLASH_SCREEN;
        }
    }

    private void updateHighScoreScreen(long l) {
        if (this.enterKey) {
            this.enterKey = false;
            this.resetGame();
            this.gameState = GameStates.IN_GAME_SCREEN;
            return;
        }
        Object[] objectArray = this.highScores.getHighScores();
        this.highscore = objectArray.length > 0 ? Integer.parseInt((String)objectArray[1]) : 0;
        this.splashScreenTimer -= l;
        if (this.splashScreenTimer <= 0L) {
            this.splashScreenTimer = 4000000000L;
            this.gameState = GameStates.HELP_SCREEN;
        }
    }

    private void updateInGameScreen(long l) {
        if (this.escKey) {
            this.escKey = false;
            this.resetGame();
            this.gameState = GameStates.SPLASH_SCREEN;
            return;
        }
        if (!this.paused) {
            this.updateShooting(l);
            this.updatePositions(l);
            this.updateCollisions(l);
            this.updateExplosions(l);
            this.playWalkingSound(l);
            if (this.alienCtr == 0) {
                int n = this.e1Img.getWidth() / 3 + 4;
                for (int i = 0; i < this.aliens.length; ++i) {
                    for (int j = 0; j < this.aliens[i].length; ++j) {
                        Entity entity = this.aliens[i][j];
                        entity.x = 68 + j * n + (n / 2 - entity.w / 2);
                        entity.y = 112 + i * entity.h * 2;
                        entity.frame = 0;
                        entity.visible = true;
                    }
                }
                this.alienCtr = this.aliens.length * this.aliens[0].length;
                this.alienSX -= 1.0f;
                this.shot_freq = (long)(0.9f * (float)this.shot_freq);
            }
        }
    }

    private void updateInputNameScreen(long l) {
        if (this.enterKey) {
            this.enterKey = false;
            if (this.tmpPlayerName.isEmpty()) {
                this.tmpPlayerName = this.playerName1;
            }
            this.playerName1 = this.tmpPlayerName;
            this.caretPos = this.playerName1.length();
            this.highScores.postHighScore(this.playerName1, this.score1);
            this.gameState = GameStates.HIGH_SCORE_SCREEN;
        } else if (this.backKey) {
            if (this.caretPos > 0) {
                --this.caretPos;
                this.tmpPlayerName = this.caretPos > 0 ? this.tmpPlayerName.substring(0, this.caretPos) : "";
            }
            this.backKey = false;
        } else if (this.lastKey != 0) {
            if (this.caretPos < 8) {
                int n = this.tmpPlayerName.length();
                String string = this.caretPos > 0 ? this.tmpPlayerName.substring(0, this.caretPos) : "";
                String string2 = this.caretPos < n ? this.tmpPlayerName.substring(this.caretPos + 1, n - 1) : "";
                this.tmpPlayerName = string + KeyEvent.getKeyText(this.lastKey) + string2;
                ++this.caretPos;
            }
            this.lastKey = 0;
        }
    }

    private void updateShooting(long l) {
        if (this.spaceKey && this.spaceKeyReleased && !this.playerShot.visible && this.player.frame == 0) {
            this.spaceKeyReleased = false;
            long l2 = System.nanoTime();
            if (l2 - this.lastShotTime > 300000L) {
                this.lastShotTime = l2;
                Sound.play(Sound.SOUNDS.SHOT);
                this.playerShot = new Entity();
                this.playerShot.x = this.player.x + (float)(this.player.w / 2) - 1.0f;
                this.playerShot.y = this.player.y - 10.0f;
                this.playerShot.w = 2;
                this.playerShot.h = 8;
                this.playerShot.sy = (float)(-Math.round(100.0f)) / 10.0f;
            }
        }
        this.shootCtr += 33L;
        if (this.shootCtr > this.shot_freq) {
            Entity entity = null;
            block0: while (entity == null) {
                int n = (int)(Math.random() * (double)this.aliens[0].length);
                for (int i = this.aliens.length - 1; i >= 0; --i) {
                    if (!this.aliens[i][n].visible) continue;
                    entity = this.aliens[i][n];
                    continue block0;
                }
            }
            Entity entity2 = new Entity();
            entity2.x = entity.x + (float)(entity.w / 2) - 1.0f;
            entity2.y = entity.y + (float)entity.h;
            entity2.w = 2;
            entity2.h = 8;
            entity2.sy = (float)Math.round(50.0f) / 10.0f;
            if (this.alienShot == null) {
                this.alienShot = entity2;
            } else {
                entity2.prev = this.alienShot;
                this.alienShot = entity2;
            }
            this.shootCtr = 0L;
        }
    }

    private void updateExplosions(long l) {
        if (this.player.frame != 0) {
            this.player.cntDown -= 33L;
            if (this.player.cntDown < 0L) {
                this.player.cntDown = 0L;
                this.player.frame = 0;
            }
        }
        if (this.ufo.visible && this.ufo.frame != 0) {
            this.ufo.cntDown -= 33L;
            if (this.ufo.cntDown < 0L) {
                if (this.ufo.frame == 1) {
                    this.ufo.cntDown = 1000L;
                    this.ufo.frame = 2;
                } else {
                    this.ufo.visible = false;
                    this.ufo.frame = 0;
                    this.score1 += (int)(Math.random() * 10.0) * 100;
                }
            }
        }
    }

    private void updateCollisions(long l) {
        int n;
        int n2;
        int n3;
        for (int i = 0; i < this.aliens.length && this.gameState == GameStates.IN_GAME_SCREEN; ++i) {
            for (n3 = 0; n3 < this.aliens[i].length && this.gameState == GameStates.IN_GAME_SCREEN; ++n3) {
                Entity entity = this.aliens[i][n3];
                if (!entity.visible || entity.frame >= 2) continue;
                if (this.playerShot.visible && ToolBox.checkCollision(this.playerShot, entity)) {
                    Sound.play(Sound.SOUNDS.INV_HIT);
                    --this.alienCtr;
                    entity.frame = 2;
                    this.playerShot.visible = false;
                    if (entity.image == this.e1Img) {
                        this.score1 += 10;
                        continue;
                    }
                    if (entity.image == this.e2Img) {
                        this.score1 += 20;
                        continue;
                    }
                    this.score1 += 30;
                    continue;
                }
                if (this.player.frame == 0 && this.player.visible && ToolBox.checkCollision(this.player, entity)) {
                    Sound.play(Sound.SOUNDS.PLY_HIT);
                    Sound.play(Sound.SOUNDS.INV_HIT);
                    --this.alienCtr;
                    entity.frame = 2;
                    this.player.dx = 0.0f;
                    this.player.frame = 1;
                    this.player.cntDown = 2000L;
                    if (--this.lives1 != 0) continue;
                    this.gameState = GameStates.GAME_OVER_SCREEN;
                    if (!this.ufo.visible) continue;
                    Sound.stop(Sound.SOUNDS.UFO);
                    this.ufo.visible = false;
                    continue;
                }
                for (n2 = 0; n2 < this.bunkers.length; ++n2) {
                    for (n = 0; n < 4; ++n) {
                        for (int j = 0; j < 5; ++j) {
                            Entity entity2 = this.bunkers[n2][n * 5 + j];
                            if (!entity2.visible || !ToolBox.checkCollision(entity, entity2)) continue;
                            entity2.visible = false;
                            Sound.play(Sound.SOUNDS.BASE_HIT);
                        }
                    }
                }
            }
        }
        if (this.ufo.frame < 2 && this.ufo.visible && this.playerShot.visible && ToolBox.checkCollision(this.playerShot, this.ufo)) {
            this.ufo.frame = 1;
            this.ufo.cntDown = 1000L;
            this.playerShot.visible = false;
            Sound.stop(Sound.SOUNDS.UFO);
            Sound.play(Sound.SOUNDS.UFO_HIT);
        }
        Entity entity = this.alienShot;
        while (entity != null) {
            if (this.player.frame == 0 && entity.visible && ToolBox.checkCollision(entity, this.player)) {
                entity.y = 480 + entity.h;
                Sound.play(Sound.SOUNDS.PLY_HIT);
                this.player.dx = 0.0f;
                this.player.frame = 1;
                this.player.cntDown = 2000L;
                if (--this.lives1 != 0) break;
                this.gameState = GameStates.GAME_OVER_SCREEN;
                if (!this.ufo.visible) break;
                Sound.stop(Sound.SOUNDS.UFO);
                this.ufo.visible = false;
                break;
            }
            n3 = 0;
            for (int i = 0; i < this.bunkers.length && n3 == 0; ++i) {
                for (n2 = 0; n2 < 4 && n3 == 0; ++n2) {
                    for (n = 0; n < 5 && n3 == 0; ++n) {
                        Entity entity3 = this.bunkers[i][n2 * 5 + n];
                        if (!entity3.visible) continue;
                        if (entity.visible && ToolBox.checkCollision(entity, entity3)) {
                            entity.y = 480 + entity.h;
                            ++entity3.frame;
                            if (entity3.frame > 2) {
                                entity3.visible = false;
                            }
                            n3 = 1;
                        } else if (this.playerShot.visible && ToolBox.checkCollision(this.playerShot, entity3)) {
                            this.playerShot.visible = false;
                            ++entity3.frame;
                            if (entity3.frame > 2) {
                                entity3.visible = false;
                            }
                            n3 = 1;
                        }
                        if (n3 == 0) continue;
                        Sound.play(Sound.SOUNDS.BASE_HIT);
                    }
                }
            }
            entity = entity.prev;
        }
    }

    private void updatePositions(long l) {
        Entity entity;
        int n;
        int n2;
        float f;
        float f2;
        float f3;
        if (this.player.frame == 0) {
            f3 = this.player.sx * ((float)l / 1.0E9f);
            this.player.dx = this.leftKey ? -f3 : (this.rightKey ? f3 : 0.0f);
        }
        this.player.x += this.player.dx;
        if (this.player.x < 0.0f || this.player.x > (float)(449 - this.player.w)) {
            this.player.x -= this.player.dx;
        }
        if (this.ufo.visible) {
            if (this.ufo.frame == 0) {
                f3 = this.ufo.sx * ((float)l / 1.0E9f);
                if (this.ufo.x > 449.0f) {
                    this.ufo.visible = false;
                    Sound.stop(Sound.SOUNDS.UFO);
                } else {
                    this.ufo.x += f3;
                }
            }
        } else {
            this.ufoCntDown -= 33;
            if (this.ufoCntDown < 0) {
                this.ufo.x = -this.ufo.image.getWidth(null);
                this.ufo.visible = true;
                this.ufoCntDown = 15000 + (2000 - (int)(Math.random() * 4000.0));
                Sound.loop(Sound.SOUNDS.UFO);
            }
        }
        f3 = 2.0f * this.alienSX * ((float)l / 1.0E9f);
        boolean bl = this.checkAlienBounce(f3 /= (float)(this.alienCtr + 4));
        if (!bl) {
            f2 = 0.0f;
            f = 0.0f;
            for (n2 = 0; n2 < this.aliens.length; ++n2) {
                for (n = 0; n < this.aliens[n2].length; ++n) {
                    entity = this.aliens[n2][n];
                    entity.x += f3;
                    f = entity.y + (float)entity.image.getHeight(null);
                    f2 = f > f2 ? f : f2;
                }
            }
        } else {
            f2 = 0.0f;
            f = 0.0f;
            this.alienSX = bl ? -this.alienSX : this.alienSX;
            for (n2 = 0; n2 < this.aliens.length; ++n2) {
                for (n = 0; n < this.aliens[n2].length; ++n) {
                    entity = this.aliens[n2][n];
                    entity.y += 10.0f;
                    f = entity.y + (float)entity.image.getHeight(null);
                    f2 = f > f2 ? f : f2;
                }
            }
            if (f2 >= 461.0f) {
                this.lives1 = 0;
                Sound.play(Sound.SOUNDS.PLY_HIT);
                this.player.dx = 0.0f;
                this.player.frame = 1;
                this.player.cntDown = 2000L;
                this.gameState = GameStates.GAME_OVER_SCREEN;
                if (this.ufo.visible) {
                    Sound.stop(Sound.SOUNDS.UFO);
                    this.ufo.visible = false;
                }
            }
        }
        if (this.playerShot != null) {
            this.playerShot.y += this.playerShot.sy;
            if (this.playerShot.y < -10.0f) {
                this.playerShot.visible = false;
            }
        }
        Entity entity2 = this.alienShot;
        while (null != entity2) {
            entity2.y += entity2.sy;
            if (entity2.prev != null && entity2.prev.y > 480.0f) {
                entity2.prev = null;
            }
            entity2 = entity2.prev;
        }
    }

    private boolean checkAlienBounce(float f) {
        Entity entity = null;
        entity = this.alienSX > 0.0f ? this.aliens[this.aliens.length - 1][this.getMostRightColumn()] : this.aliens[this.aliens.length - 1][this.getMostLeftColumn()];
        float f2 = entity.x + f;
        return (int)f2 < 0 || (int)f2 > 449 - entity.w;
    }

    private int getMostLeftColumn() {
        int n = Integer.MAX_VALUE;
        for (int i = 0; i < this.aliens.length; ++i) {
            for (int j = 0; j < this.aliens[i].length; ++j) {
                if (!this.aliens[i][j].visible) continue;
                n = Math.min(n, j);
            }
        }
        return n;
    }

    private int getMostRightColumn() {
        int n = Integer.MIN_VALUE;
        for (int i = 0; i < this.aliens.length; ++i) {
            for (int j = 0; j < this.aliens[i].length; ++j) {
                if (!this.aliens[i][j].visible) continue;
                n = Math.max(n, j);
            }
        }
        return n;
    }

    public void paint() {
        this.frameCtr += 33L;
        if (this.frameCtr > 300L) {
            this.frameCtr = 0L;
        }
        this.g2d.setColor(Color.black);
        this.g2d.clearRect(0, 0, 449, 480);
        this.g2d.setColor(Color.white);
        this.g2d.setFont(this.font.deriveFont(20.0f));
        FontMetrics fontMetrics = this.g2d.getFontMetrics(this.g2d.getFont());
        int n = fontMetrics.getHeight();
        int n2 = (int)((double)n * 1.5);
        ToolBox.drawText(this.g2d, this.playerName1, 74, n2, Color.white);
        ToolBox.drawText(this.g2d, STR_HISCORE, n2, Color.white);
        ToolBox.drawText(this.g2d, this.playerName2, 370, n2, Color.white);
        int n3 = n * 3;
        ToolBox.drawText(this.g2d, NUM_FORMAT.format(this.score1), 74, n3, Color.white);
        ToolBox.drawText(this.g2d, NUM_FORMAT.format(this.highscore), n3, Color.white);
        ToolBox.drawText(this.g2d, NUM_FORMAT.format(this.score2), 370, n3, Color.white);
        switch (this.gameState) {
            case SPLASH_SCREEN: {
                this.drawSplashScreen(this.g2d, n);
                break;
            }
            case HELP_SCREEN: {
                this.drawHelpScreen(this.g2d, n);
                break;
            }
            case HIGH_SCORE_SCREEN: {
                this.drawHighScoreScreen(this.g2d, n);
                break;
            }
            case IN_GAME_SCREEN: {
                this.drawIngameScreen(this.g2d);
                break;
            }
            case GAME_OVER_SCREEN: {
                this.drawGameOverScreen(this.g2d, n);
                break;
            }
            case INPUT_NAME_SCREEN: {
                this.drawInputNameScreen(this.g2d, n, fontMetrics.stringWidth("M") + 1);
            }
        }
        if (this.paused) {
            this.drawClickToContinue(this.g2d, n2);
        } else if (this.gameState != GameStates.IN_GAME_SCREEN) {
            this.drawPressEnter(this.g2d, n2);
        }
        if (!Sound.isEnabled()) {
            this.g2d.drawImage((Image)this.sndOffImg, 449 - this.sndOffImg.getWidth() - 1, 464, null);
        }
        this.panel.getGraphics().drawImage(this.backbuffer, 0, 0, null);
    }

    private void drawSplashScreen(Graphics graphics, int n) {
        if (this.frameCtr < 250L) {
            ToolBox.drawText(graphics, PLAY_INVADERS[0], 6 * n, Color.white);
            ToolBox.drawText(graphics, PLAY_INVADERS[1], 8 * n, Color.white);
            ToolBox.drawText(graphics, PLAY_INVADERS[2], 10 * n, Color.white);
        }
        ToolBox.drawText(graphics, SPLASH_SCORE_TABLE[0], 224, 12 * n, Color.white);
        ToolBox.drawText(graphics, SPLASH_SCORE_TABLE[1], 224, 14 * n, Color.white);
        ToolBox.drawImageCentered(graphics, this.ufoImg, 125, 13 * n, 0);
        ToolBox.drawText(graphics, SPLASH_SCORE_TABLE[2], 224, (int)(15.5 * (double)n), Color.white);
        ToolBox.drawImageCentered(graphics, this.e3Img, 125, (int)(14.5 * (double)n), 0);
        ToolBox.drawText(graphics, SPLASH_SCORE_TABLE[3], 224, 17 * n, Color.white);
        ToolBox.drawImageCentered(graphics, this.e2Img, 125, 16 * n, 0);
        ToolBox.drawText(graphics, SPLASH_SCORE_TABLE[4], 224, (int)(18.5 * (double)n), Color.green);
        ToolBox.drawImageCentered(graphics, this.e1Img, 125, (int)(17.5 * (double)n), 0);
    }

    private void drawHelpScreen(Graphics graphics, int n) {
        for (int i = 0; i < STR_HELP.length; ++i) {
            ToolBox.drawText(graphics, STR_HELP[i], n * 2 * (i + 5), Color.white);
        }
    }

    private void drawHighScoreScreen(Graphics graphics, int n) {
        ToolBox.drawText(graphics, STR_HIGHSCORE_LIST, n * 5, Color.white);
        Object[] objectArray = this.highScores.getHighScores();
        for (int i = 0; i + 1 < objectArray.length && i < 16; i += 2) {
            int n2 = (int)((float)n * (7.0f + (float)i / 1.5f));
            Color color = i < 2 ? Color.red : Color.white;
            ToolBox.drawText(graphics, (String)objectArray[i], 112, n2, color);
            ToolBox.drawText(graphics, (String)objectArray[i + 1], 336, n2, color);
        }
    }

    private void drawIngameScreen(Graphics graphics) {
        int n;
        int n2;
        graphics.setColor(Color.white);
        graphics.drawLine(0, 462, 449, 462);
        graphics.drawString("" + this.lives1, 19, 479);
        for (n2 = 0; n2 < this.lives1 - 1; ++n2) {
            ToolBox.drawImage(graphics, this.player.image, 40 + n2 * (this.player.w + 3), 465, 0);
        }
        for (n2 = 0; n2 < this.aliens.length; ++n2) {
            for (n = 0; n < this.aliens[n2].length; ++n) {
                Entity entity = this.aliens[n2][n];
                if (!entity.visible) continue;
                entity.draw(graphics);
                if (this.frameCtr != 0L) continue;
                if (entity.frame == 2) {
                    entity.visible = false;
                    continue;
                }
                entity.frame = 1 - entity.frame;
            }
        }
        for (n2 = 0; n2 < this.bunkers.length; ++n2) {
            for (n = 0; n < 4; ++n) {
                for (int i = 0; i < 5; ++i) {
                    if (!this.bunkers[n2][n * 5 + i].visible) continue;
                    this.bunkers[n2][n * 5 + i].draw(graphics);
                }
            }
        }
        if (this.player.visible) {
            this.player.draw(graphics);
        }
        if (this.player.frame != 0 && this.frameCtr == 0L) {
            this.player.frame = 3 - this.player.frame;
        }
        if (this.ufo.visible) {
            this.ufo.draw(graphics);
        }
        if (this.playerShot.visible) {
            graphics.fillRect((int)this.playerShot.x, (int)this.playerShot.y, this.playerShot.w, this.playerShot.h);
        }
        Entity entity = this.alienShot;
        while (null != entity) {
            graphics.fillRect((int)entity.x, (int)entity.y, 2, 8);
            entity = entity.prev;
        }
    }

    private void drawGameOverScreen(Graphics graphics, int n) {
        this.drawIngameScreen(graphics);
        if (this.frameCtr < 250L) {
            ToolBox.drawText(graphics, STR_GAME_OVER, (int)(4.5 * (double)n), Color.red);
        }
    }

    private void drawInputNameScreen(Graphics graphics, int n, int n2) {
        ToolBox.drawText(graphics, STR_INPUTNAME, n * 7, Color.white);
        int n3 = this.tmpPlayerName.length();
        int n4 = 224 - n2 * 4;
        int n5 = 240 - n;
        for (int i = 0; i < 8; ++i) {
            graphics.drawLine(n4 + n2 * i, n5 + 2, n4 + n2 * (i + 1) - 2, n5 + 2);
            graphics.drawLine(n4 + n2 * i, n5 + 3, n4 + n2 * (i + 1) - 2, n5 + 3);
            if (i >= n3) continue;
            graphics.drawString(this.tmpPlayerName.substring(i, i + 1), n4 + n2 * i, n5);
        }
        graphics.setColor(Color.red);
        graphics.drawLine(n4 + n2 * this.caretPos, n5 + 2, n4 + n2 * (this.caretPos + 1) - 2, n5 + 2);
        graphics.drawLine(n4 + n2 * this.caretPos, n5 + 3, n4 + n2 * (this.caretPos + 1) - 2, n5 + 3);
        graphics.setColor(Color.white);
    }

    private void drawPressEnter(Graphics graphics, int n) {
        if (this.frameCtr < 250L) {
            if (this.getPanel().hasFocus()) {
                ToolBox.drawText(graphics, STR_PRESS_ENTER, 480 - n / 2, Color.red);
            } else {
                ToolBox.drawText(graphics, STR_CLICK_TO_START, 480 - n / 2, Color.red);
            }
        }
    }

    private void drawClickToContinue(Graphics graphics, int n) {
        if (this.frameCtr < 250L) {
            ToolBox.drawText(graphics, STR_PAUSED, 480 - n / 2, Color.red);
        }
    }

    private void playWalkingSound(long l) {
        int n = 0;
        for (int i = 0; i < this.aliens.length; ++i) {
            n += this.aliens[i].length;
        }
        float f = 1.0f - (float)this.alienCtr / (float)n;
        long l2 = 1000000000L - (long)(f * 7.0E8f);
        if (System.nanoTime() - this.lastSoundTime > l2) {
            Sound.play(Sound.SOUNDS.WALK1.ordinal() + this.soundCtr++);
            if (this.soundCtr > 3) {
                this.soundCtr = 0;
            }
            this.lastSoundTime = System.nanoTime();
        }
    }

    private void resetGame() {
        int n;
        int n2;
        this.lastShotTime = this.lastSoundTime = System.nanoTime();
        this.score2 = 0;
        this.score1 = 0;
        this.highscore = this.highScores.getHighScore();
        this.splashScreenTimer = 4000000000L;
        this.soundCtr = 0;
        this.lives1 = 3;
        this.ufoCntDown = 15000 + (2000 - (int)(Math.random() * 4000.0));
        this.shot_freq = 1000L;
        if (this.ufo == null) {
            this.ufo = new Entity();
            this.ufo.setImage(this.ufoImg, 3);
            this.ufo.y = 75.0f;
        }
        this.ufo.sx = 75.0f;
        this.ufo.cntDown = 0L;
        this.ufo.frame = 0;
        this.ufo.visible = false;
        if (this.player == null) {
            this.player = new Entity();
            this.player.setImage(this.plyrImg, 3);
            this.player.y = 416.0f;
        }
        this.player.sx = 200.0f;
        this.player.cntDown = 0L;
        this.player.frame = 0;
        this.player.visible = true;
        this.player.x = 224 - this.plyrImg.getWidth() / 2;
        if (this.playerShot == null) {
            this.playerShot = new Entity();
            this.playerShot.w = 2;
            this.playerShot.h = 8;
        }
        this.playerShot.x = this.player.x + (float)(this.player.w / 2) - 1.0f;
        this.playerShot.y = this.player.y - 10.0f;
        int n3 = this.e1Img.getWidth() / 3 + 4;
        for (n2 = 0; n2 < this.aliens.length; ++n2) {
            BufferedImage bufferedImage = n2 == 0 ? this.e3Img : (n2 < 3 ? this.e2Img : this.e1Img);
            for (n = 0; n < this.aliens[n2].length; ++n) {
                Entity entity = this.aliens[n2][n];
                if (entity == null) {
                    entity = new Entity();
                    entity.setImage(bufferedImage, 3);
                    this.aliens[n2][n] = entity;
                }
                entity.x = 68 + n * n3 + (n3 / 2 - entity.w / 2);
                entity.y = 112 + n2 * entity.h * 2;
                entity.frame = 0;
                entity.visible = true;
            }
        }
        this.alienCtr = this.aliens.length * this.aliens[0].length;
        this.alienSX = 400.0f;
        n2 = 224 - 7 * (5 * this.llBnkImg.getWidth() / 3 + 2) / 2;
        for (int i = 0; i < this.bunkers.length; ++i) {
            for (n = 0; n < 4; ++n) {
                for (int j = 0; j < 5; ++j) {
                    BufferedImage bufferedImage = this.mmBnkImg;
                    if (n == 0 && j == 0) {
                        bufferedImage = this.ulBnkImg;
                    } else if (n == 0 && j == 4) {
                        bufferedImage = this.urBnkImg;
                    } else if (n == 3 && j == 1) {
                        bufferedImage = this.llBnkImg;
                    } else if (n == 3 && j == 3) {
                        bufferedImage = this.lrBnkImg;
                    }
                    Entity entity = this.bunkers[i][n * 5 + j];
                    if (entity == null) {
                        entity = new Entity();
                        entity.setImage(bufferedImage, 3);
                        this.bunkers[i][n * 5 + j] = entity;
                    }
                    entity.x = n2 + i * 2 * (entity.w * 5) + j * entity.w;
                    entity.y = 368 + n * entity.h;
                    entity.frame = 0;
                    entity.visible = n != 3 || j != 2;
                }
            }
        }
        this.ufo.visible = false;
        Sound.stop(Sound.SOUNDS.UFO);
        this.playerShot.visible = false;
        while (this.alienShot != null) {
            Entity entity = this.alienShot;
            this.alienShot = entity.prev;
            entity.prev = null;
        }
    }

    public void keyEvent(KeyEvent keyEvent, boolean bl) {
        int n = keyEvent.getKeyCode();
        switch (n) {
            case 37: {
                this.leftKey = bl;
                break;
            }
            case 39: {
                this.rightKey = bl;
                break;
            }
            case 32: {
                this.spaceKey = bl;
                if (bl) break;
                this.spaceKeyReleased = true;
                break;
            }
            case 27: {
                this.escKey = bl;
                break;
            }
            case 10: {
                this.enterKey = bl;
                break;
            }
            case 8: {
                this.backKey = bl;
                break;
            }
            default: {
                char c = keyEvent.getKeyChar();
                if (!bl || this.lastKey == n || (c <= '/' || c >= '[') && (c <= '`' || c >= '{')) break;
                this.lastKey = n;
            }
        }
    }

    public void resume() {
        this.paused = false;
        if (this.gameState == GameStates.IN_GAME_SCREEN && this.ufo.visible && this.ufo.frame == 0) {
            Sound.loop(Sound.SOUNDS.UFO);
        }
    }

    public void pause() {
        this.paused = true;
        if (this.gameState == GameStates.IN_GAME_SCREEN && this.ufo.visible && this.ufo.frame == 0) {
            Sound.stop(Sound.SOUNDS.UFO);
        }
    }

    public void stop() {
        Sound.setEnabled(false);
        this.gameLoopThread = null;
        System.out.println("Game stopped.");
    }

    public Panel getPanel() {
        return this.panel;
    }

    public void run() {
        Thread thread = Thread.currentThread();
        while (thread == this.gameLoopThread) {
            long l = System.nanoTime();
            this.updateGame(l - this.lastUpdate);
            this.paint();
            this.lastUpdate = l;
            Thread.yield();
            try {
                Thread.sleep(33L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void setUserCredentials(String string, String string2) {
        System.out.println("setUserCredentials : " + string + "," + string2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GameStates {
        SPLASH_SCREEN,
        HELP_SCREEN,
        HIGH_SCORE_SCREEN,
        GAME_OVER_SCREEN,
        IN_GAME_SCREEN,
        INPUT_NAME_SCREEN;

    }
}

