/******************************************************************************
 * Project JKobo
 * XKobo arcade style game
 *
 * Copyright (C) 1997 John "Jake" Wetzel All Rights Reserved
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 *****************************************************************************/

/***************************** FILE INFORMATION ******************************
 * NAME OF FILE 	  : Bomb1.java
 * CONCEPT & ARCHITECTURE : Akira Higuchi
 * MAIN PROGRAMMER	  : Jake Wetzel
 * DATE CREATED 	  : 10-25-98
 * DESCRIPTION		  :
 * CHANGE LOG		  :
 *	  WHO		  WHEN			  WHY
 *	  ---		  ----			  ---
 *
 *****************************************************************************/

/******************************* IMPORT FILES ********************************/

import Enemy;
import Enemies;

class Bomb1 extends EnemyKind implements EnemyDefines, GlobalDefines
{

/******************************** GLOBAL DATA ********************************/

/**************************** FUNCTION DECLARATIONS  *************************/

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : Bomb1
 * DESCRIPTION	  :
 *****************************************************************************/
  Bomb1()
  {
    int sl;

    sl = JKobo.Context.getScaleLog2();
    score    =	5;
    hitsize  =	5 << sl;
    chipposx = 14;
    chipposy =	4;
    chipsize = 16 << sl;

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : make
 * DESCRIPTION	  :
 *****************************************************************************/
  void make(Enemy e)
  {

    e.count = 500;
    e.shield = e.di = 1;

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : move
 * DESCRIPTION	  :
 *****************************************************************************/
  void move(Enemy e)
  {
    int i, tmp, h1, v1;
    int vx1, vy1, vx2, vy2;
    int vx3, vy3, vx4, vy4;
    int vx5, vy5;
    int shift;
    Enemies enemies;


    h1 = Math.abs(e.diffx);
    v1 = Math.abs(e.diffy);
    if(((h1 < 100) && (v1 < 30)) || (h1 < 30) && (v1 < 100))
      {
	enemies = JKobo.Context.getEnemies();
	shift = JKobo.Context.getScaleParms().getEnemyShift();
	vx1 = (-e.diffx << (shift - 3)) / 3;
	vy1 = (-e.diffy << (shift - 3)) / 3;
	vx3 = vx2 = vx1;
	vy3 = vy2 = vy1;
	for(i=0; i<4; i++)
	  {
	    tmp = vx2;
	    vx2 += (vy2 >> 4);
	    vy2 -= (tmp >> 4);
	    tmp = vx3;
	    vx3 -= (vy3 >> 4);
	    vy3 += (tmp >> 4);
	  }
	enemies.make(BEAM, e.x >> shift, e.y >> shift,
		     vx2 << (shift - SHIFT), vy2 << (shift - SHIFT), 0);
	enemies.make(BEAM, e.x >> shift, e.y >> shift,
		     vx3 << (shift - SHIFT), vy3 << (shift - SHIFT), 0);
	e.state = NOTUSE;
    }

  }

}  /* END OF CLASS : Bomb1 */


/* END OF FILE : Bomb1.java */

