/******************************************************************************
 * Project JKobo
 * XKobo arcade style game
 *
 * Copyright (C) 1997 John "Jake" Wetzel All Rights Reserved
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 *****************************************************************************/

/***************************** FILE INFORMATION ******************************
 * NAME OF FILE 	  : Enemies.java
 * CONCEPT & ARCHITECTURE : Akira Higuchi
 * MAIN PROGRAMMER	  : Jake Wetzel
 * DATE CREATED 	  : 10-25-98
 * DESCRIPTION		  :
 * CHANGE LOG		  :
 *	  WHO		  WHEN			  WHY
 *	  ---		  ----			  ---
 *
 *****************************************************************************/

/******************************* IMPORT FILES ********************************/

import java.awt.Canvas;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageProducer;
import java.awt.image.MemoryImageSource;
import java.lang.reflect.Array;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

import Enemy;
import Tiff;


class Enemies implements EnemyDefines, ErrorDefines, GlobalDefines
{

  static String SpriteName;
  static String TiffName;
  static String TiffError;

/******************************** GLOBAL DATA ********************************/

  Enemy enemy[];
  int enemy_max;
  int ekind_to_generate_1;
  int ekind_to_generate_2;
  int e1_interval;
  int e2_interval;
  Image enemy_bitmap;	 /* bitmap containing ship and all enemies	       */

/**************************** FUNCTION DECLARATIONS  *************************/

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : Enemies
 * DESCRIPTION	  :
 *****************************************************************************/
  Enemies() throws KoboException
  {
    int i, sl;
    Canvas canvas;
    Tiff tiff;
    Image tmp_image;
    MemoryImageSource mis;
    Object objs[];


    enemy = new Enemy[ENEMY_MAX];
    for(i=0; i<ENEMY_MAX; i++)
      enemy[i] = new Enemy();
    tiff = new Tiff();
    mis = tiff.readTiff();
    if(mis == null)
      {
	objs = new Object[2];
	objs[0] = (Object) SpriteName;
	objs[1] = (Object) TiffName;
	throw new KoboException(FATAL,
				MessageFormat.format(TiffError, objs));
      }
    canvas = JKobo.Context.getPlayWin().getCanvas();
    sl = JKobo.Context.getScaleLog2();
    enemy_bitmap = canvas.createImage((ImageProducer) mis);
    if(sl > 0)
      {
	tmp_image = enemy_bitmap;
	enemy_bitmap = tmp_image.getScaledInstance(tmp_image.getWidth(null) << sl,
						   tmp_image.getHeight(null) << sl,
						   Image.SCALE_AREA_AVERAGING);
      }
  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : init
 * DESCRIPTION	  :
 *****************************************************************************/
  int init()
  {
    int i;

    for(i=0; i<ENEMY_MAX; i++)
      enemy[i].init();

    enemy_max = 0;
    ekind_to_generate_1 = 0;
    ekind_to_generate_2 = 0;
    e1_interval = 1;
    e2_interval = 1;

    return(0);

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : make
 * DESCRIPTION	  :
 *****************************************************************************/
  int make(int ek, int x, int y, int h, int v, int di)
  {
    int i;

    for(i=0; i<ENEMY_MAX; i++)
      if(enemy[i].make(ek, x, y, h, v, di) == 0)
	return(0);

    return(1);

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : move
 * DESCRIPTION	  :
 *****************************************************************************/
  void move()
  {
    int i;

    /* realize reserved enemies */
    for(i=0; i<ENEMY_MAX; i++)
      if(enemy[i].realize() == true)
	enemy_max = i;

     /* enemy max must be set before calling move */
     for(i=0; i<=enemy_max; i++)
       if(enemy[i].realize() == true)
	 enemy[i].move();

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : put
 * DESCRIPTION	  :
 *****************************************************************************/
  void put()
  {
    int i;

    for(i=0; i<=enemy_max; i++)
      enemy[i].put();
  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : eraseCannon
 * DESCRIPTION	  :
 *****************************************************************************/
  int eraseCannon(int x, int y)
  {
    int i, count = 0;

    for(i=0; i<ENEMY_MAX; i++)
      count += enemy[i].eraseCannon(x, y);

    if(count > 0)
      JKobo.Context.getRadar().erase(x, y);

    return(count);

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : existPipe
 * DESCRIPTION	  :
 *****************************************************************************/
  int existPipe()
  {
    int i, count = 0;

    for(i=0; i<ENEMY_MAX; i++)
      if(enemy[i].isPipe() == true)
	count++;

    return(count);

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : setEnemyKindToGenerate
 * DESCRIPTION	  :
 *****************************************************************************/
  void setEnemyKindToGenerate(int ek1, int i1, int ek2, int i2)
  {

    ekind_to_generate_1 = ek1;
    ekind_to_generate_2 = ek2;
    e1_interval = i1;
    e2_interval = i2;

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : getEnemy1Interval
 * DESCRIPTION	  :
 *****************************************************************************/
  final int getEnemy1Interval()
  {
    return(e1_interval);
  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : getEnemy2Interval
 * DESCRIPTION	  :
 *****************************************************************************/
  final int getEnemy2Interval()
  {
    return(e2_interval);
  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : getEnemyKindToGenerate1
 * DESCRIPTION	  :
 *****************************************************************************/
  final int getEnemyKindToGenerate1()
  {
    return(ekind_to_generate_1);
  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : getEnemyKindToGenerate2
 * DESCRIPTION	  :
 *****************************************************************************/
  final int getEnemyKindToGenerate2()
  {
    return(ekind_to_generate_2);
  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : getEnemyBitmap
 * DESCRIPTION	  :
 *****************************************************************************/
  final Image getEnemyBitmap()
  {
    return(enemy_bitmap);
  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : static
 * DESCRIPTION	  :
 *****************************************************************************/
  static
  {
    ResourceBundle bundle;


    bundle = JKobo.Context.getResourceBundle();

    try {
      SpriteName = bundle.getString("SpriteName.message");
    }
    catch(MissingResourceException e) {
      SpriteName = "sprite";
    }
    try {
      TiffName = bundle.getString("TiffName.message");
    }
    catch(MissingResourceException e) {
      TiffName = "tiff";
    }
    try {
      TiffError = bundle.getString("EnemiesKoboException.message");
    }
    catch(MissingResourceException e) {
      TiffError = "Cannot locate {0} {1} file";
    }

  }

}  /* END OF CLASS : Enemies */


/* END OF FILE : Enemies.java */

