/******************************************************************************
 * Project JKobo
 * XKobo arcade style game
 *
 * Copyright (C) 1997 John "Jake" Wetzel All Rights Reserved
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 *****************************************************************************/

/***************************** FILE INFORMATION ******************************
 * NAME OF FILE 	  : Enemy.java
 * CONCEPT & ARCHITECTURE : Akira Higuchi
 * MAIN PROGRAMMER	  : Jake Wetzel
 * DATE CREATED 	  : 10-25-98
 * DESCRIPTION		  :
 * CHANGE LOG		  :
 *	  WHO		  WHEN			  WHY
 *	  ---		  ----			  ---
 *
 *****************************************************************************/

/******************************* IMPORT FILES ********************************/

import java.lang.Math;
import java.util.Random;

import MyShip;
import Enemies;
import Manage;
import PlayWin;
import ScaleParms;


class Enemy implements EnemyDefines, GlobalDefines
{

/******************************** GLOBAL DATA ********************************/

  int kind;
  int state;
  int x,y;
  int h,v;
  int di;
  int a,b;
  int count;
  int shield;
  int diffx, diffy;
  int norm;
  int hitsize;
  int chipposx, chipposy;
  int chipsize;

  static final EnemyKind enemy_kinds[];
  static final int vx[] = {    0,  200,  300,  200,    0, -200, -300, -200 };
  static final int vy[] = { -300, -200,    0,  200,  300,  200,    0, -200 };


/**************************** FUNCTION DECLARATIONS  *************************/

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : static
 * DESCRIPTION	  :
 *****************************************************************************/
  static
  {

    enemy_kinds = new EnemyKind[ENEMY_KINDS];

    enemy_kinds[BEAM] = new Beam();
    enemy_kinds[EXPLOSION] = new Explosion();
    enemy_kinds[ENEMY1] = new Enemy1();
    enemy_kinds[ENEMY2] = new Enemy2();
    enemy_kinds[ENEMY3] = new Enemy3();
    enemy_kinds[ENEMY4] = new Enemy4();
    enemy_kinds[ENEMY5] = new Enemy5();
    enemy_kinds[ENEMY6] = new Enemy6();
    enemy_kinds[ENEMY7] = new Enemy7();
    enemy_kinds[BOMB1] = new Bomb1();
    enemy_kinds[BOMB2] = new Bomb2();
    enemy_kinds[CANNON] = new Cannon();
    enemy_kinds[ECORE] = new Core();
    enemy_kinds[PIPE1] = new Pipe1();
    enemy_kinds[PIPE2] = new Pipe2();
    enemy_kinds[ROCK] = new Rock();
    enemy_kinds[RING] = new Ring();
    enemy_kinds[ENEMY_M1] = new EnemyM1();
    enemy_kinds[ENEMY_M2] = new EnemyM2();
    enemy_kinds[ENEMY_M3] = new EnemyM3();
    enemy_kinds[ENEMY_M4] = new EnemyM4();

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : Enemy
 * DESCRIPTION	  :
 *****************************************************************************/
  Enemy()
  {

    kind = UNKNOWN;
    state = RESERVED;

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : init
 * DESCRIPTION	  :
 *****************************************************************************/
  void init()
  {

    state = NOTUSE;

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : make
 * DESCRIPTION	  :
 *****************************************************************************/
  int make(int ek, int px, int py, int h1, int v1, int d1)
  {
    int shift;


    if(state != NOTUSE)
      return(-1);

    shift = JKobo.Context.getScaleParms().getEnemyShift();
    kind = ek;
    state = RESERVED;
    x = px << shift;
    y = py << shift;
    di = d1;
    h = h1;
    v = v1;
    a = 0;
    b = 0;
    count = 0;
    shield = 1;

    hitsize = enemy_kinds[ek].hitsize;
    chipposx = enemy_kinds[ek].chipposx;
    chipposy = enemy_kinds[ek].chipposy;
    chipsize = enemy_kinds[ek].chipsize;

    enemy_kinds[ek].make(this);

    return(0);

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : hitByBeam
 * DESCRIPTION	  :
 *****************************************************************************/
  void hitByBeam()
  {
    int shift;
    Enemies enemies;


    if((--shield) > 0)
      return;

    JKobo.Context.getManage().addScore(enemy_kinds[kind].score);
    enemies = JKobo.Context.getEnemies();
    shift = JKobo.Context.getScaleParms().getEnemyShift();

    if(kind == CANNON)
      enemies.make(PIPE1, x >> shift, y >> shift, 0, 0, 0);
    else if(kind == ECORE)
      {
	enemies.make(PIPE2, x >> shift, y >> shift, 0, 0, 3);
	enemies.make(PIPE2, x >> shift, y >> shift, 0, 0, 7);
	enemies.make(PIPE2, x >> shift, y >> shift, 0, 0, 1);
	enemies.make(PIPE2, x >> shift, y >> shift, 0, 0, 5);
	enemies.make(EXPLOSION, x >> shift, y >> shift, 0, 0, 0);
	JKobo.Context.getManage().destroyedACore();
      }
    else
      enemies.make(EXPLOSION, x >> shift, y >> shift, 0, 0, 0);
    state = NOTUSE;

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : moveEnemyTemplate
 * DESCRIPTION	  :
 *****************************************************************************/
  void moveEnemyTemplate(int quick, int maxspeed)
  {
    int m, sl;
    int ms, q;


    sl = JKobo.Context.getScaleLog2();
    ms = maxspeed << sl;
    q = quick << sl;
    if(diffx > 0)
      {
	if(h > -ms)
	  h -= q;
      }
    else if(diffx < 0)
      {
	if(h < ms)
	  h += q;
      }
    if(diffy > 0)
      {
	if(v > -ms)
	  v -= q;
      }
    else if(diffy < 0)
      {
	if(v < ms)
	  v += q;
      }

    m = Math.max(Math.abs(h), Math.abs(v));
    if(m == h)
      {
	if((m >> 1) < v)
	  di = 4;
	else if((m >> 1) < -(v))
	  di = 2;
	else
	  di = 3;
      }
    else if(m == -(h))
      {
	if((m >> 1) < v)
	  di = 6;
	else if((m >> 1) < -(v))
	  di = 8;
	else
	  di = 7;
      }
    else if(m == v)
      {
	if((m >> 1) < h)
	  di = 4;
	else if((m >> 1) < -(h))
	  di = 6;
	else
	  di = 5;
      }
    else
      {
	if((m >> 1) < h)
	  di = 2;
	else if((m >> 1) < -(h))
	  di = 8;
	else
	  di = 1;
      }
  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : moveEnemyTemplate2
 * DESCRIPTION	  :
 *****************************************************************************/
  void moveEnemyTemplate2(int quick, int maxspeed)
  {
    int m, shift;
    int sl, ms, q;

    shift = JKobo.Context.getScaleParms().getEnemyShift();
    sl = JKobo.Context.getScaleLog2();
    ms = maxspeed << sl;
    q = quick << sl;
    h = -(diffy << (shift - q));
    v =  (diffx << (shift - q));

    if(diffx > 0)
      {
	if(h > -ms)
	  h -= q;
      }
    else if(diffx < 0)
      {
	if(h < ms)
	  h += q;
      }
    if(diffy > 0)
      {
	if(v > -ms)
	  v -= q;
      }
    else if(diffy < 0)
      {
	if(v < ms)
	  v += q;
      }

    m = Math.max(Math.abs(h), Math.abs(v));
    if(m == h)
      {
	if((m >> 1) < v)
	  di = 4;
	else if((m >> 1) < -(v))
	  di = 2;
	else
	  di = 3;
      }
    else if(m == -(h))
      {
	if((m >> 1) < v)
	  di = 6;
	else if((m >> 1) < -(v))
	  di = 8;
	else
	  di = 7;
      }
    else if(m == v)
      {
	if((m >> 1) < h)
	  di = 4;
	else if((m >> 1) < -(h))
	  di = 6;
	else
	  di = 5;
      }
    else
      {
	if((m >> 1) < h)
	  di = 2;
	else if((m >> 1) < -(h))
	  di = 8;
	else
	  di = 1;
      }
  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : moveEnemyTemplate3
 * DESCRIPTION	  :
 *****************************************************************************/
  void moveEnemyTemplate3(int quick, int maxspeed)
  {
    int m, shift;
    int sl, ms, q;


    shift = JKobo.Context.getScaleParms().getEnemyShift();
    sl = JKobo.Context.getScaleLog2();
    ms = maxspeed << sl;
    q = quick << sl;
    h =  (diffy << (shift - q));
    v = -(diffx << (shift - q));

    if(diffx > 0)
      {
	if(h > -ms)
	  h -= q;
      }
    else if(diffx < 0)
      {
	if(h < ms)
	  h += q;
      }
    if(diffy > 0)
      {
	if(v > -ms)
	  v -= q;
      }
    else if(diffy < 0)
      {
	if(v < ms)
	  v += q;
      }

    m = Math.max(Math.abs(h), Math.abs(v));
    if(m == h)
      {
	if((m >> 1) < v)
	  di = 4;
	else if((m >> 1) < -(v))
	  di = 2;
	else
	  di = 3;
      }
    else if(m == -(h))
      {
	if((m >> 1) < v)
	  di = 6;
	else if((m >> 1) < -(v))
	  di = 8;
	else
	  di = 7;
      }
    else if(m == v)
      {
	if((m >> 1) < h)
	  di = 4;
	else if((m >> 1) < -(h))
	  di = 6;
	else
	  di = 5;
      }
    else
      {
	if((m >> 1) < h)
	  di = 2;
	else if((m >> 1) < -(h))
	  di = 8;
	else
	  di = 1;
      }
  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : shotTemplate
 * DESCRIPTION	  :
 *****************************************************************************/
  void shotTemplate(int ek, int shift, int rnd, int maxspeed)
  {
    int vx, vy;
    int eshift, ms, sl;
    Random random;


    sl = JKobo.Context.getScaleLog2();
    eshift = JKobo.Context.getScaleParms().getEnemyShift();
    ms = maxspeed << sl;
    vx = -diffx;
    vy = -diffy;
    if(rnd != 0)
      {
	random = JKobo.Context.getRandom();
	vx += ((random.nextInt() & (rnd - 1)) - (rnd >>> 1));
	vy += ((random.nextInt() & (rnd - 1)) - (rnd >>> 1));
      }
    vx <<= (eshift - shift);
    vy <<= (eshift - shift);
    if(ms > 0)
      {
	if(vx > ms)
	  vx = ms;
	else if(vx < -ms)
	  vx = -ms;
	if(vy > ms)
	  vy = ms;
	else if(vy < -ms)
	  vy = -ms;
      }
    JKobo.Context.getEnemies().make(ek, (x + vx) >> eshift, (y + vy) >> eshift,
				    vx, vy, 0);
  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : shotTemplate8Dir
 * DESCRIPTION	  :
 *****************************************************************************/
  void shotTemplate8Dir(int ek)
  {
    int i, shift;
    Enemies enemies;


    enemies = JKobo.Context.getEnemies();
    shift = JKobo.Context.getScaleParms().getEnemyShift();
    for(i=0; i<8; i++)
      enemies.make(ek, (x >> shift), (y >> shift),
		   vx[i] << (shift - SHIFT), vy[i] << (shift - SHIFT), 0);
  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : move
 * DESCRIPTION	  :
 *****************************************************************************/
  void move()
  {
    int scrx, scry, sl;
    int shift, wsize, spr_size;
    MyShip myship;
    ScaleParms scale_parms;



    x += h;
    y += v;
    myship = JKobo.Context.getMyShip();
    scale_parms = JKobo.Context.getScaleParms();
    sl = JKobo.Context.getScaleLog2();
    shift = scale_parms.getEnemyShift();
    wsize = scale_parms.getWindowWidth();
    diffx = (x >> shift) - myship.getX();
    diffy = (y >> shift) - myship.getY();
    scrx = scale_parms.getSpaceWidth();
    scry = scale_parms.getSpaceHeight();
    spr_size = scale_parms.getSpriteWidth();

    if(diffx > (scrx >>> 1))
      {
	diffx -= scrx;
	x -= (scrx << shift);
      }
    if(diffx < -(scrx >>> 1))
      {
	diffx += scrx;
	x += (scrx << shift);
      }
    if(diffy > (scry >>> 1))
      {
	diffy -= scry;
	y -= (scry << shift);
      }
    if(diffy < -(scry >>> 1))
      {
	diffy += scry;
	y += (scry << shift);
      }

    norm = Math.max(Math.abs(diffx), Math.abs(diffy));

    enemy_kinds[kind].move(this);

    if((hitsize >= 0) && (norm < (hitsize + (HIT_MYSHIP << sl))))
      myship.destroyed();
    if((shield < 0) || (norm >= (wsize + spr_size) >>> 1))
      return;
    if(myship.hitBeam(x >> shift, y >> shift, hitsize + (HIT_BEAM << sl)) != 0)
      hitByBeam();

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : put
 * DESCRIPTION	  :
 *****************************************************************************/
  void put()
  {
    int wsize, shift;
    int spr_size, spr_shift;
    PlayWin pw;


    wsize = JKobo.Context.getScaleParms().getWindowWidth();
    spr_size = JKobo.Context.getScaleParms().getSpriteWidth();
    if((state == MOVING) && (chipsize > 0) &&
       (norm < ((wsize >>> 1) + (spr_size >>> 1))))
      {
	pw = JKobo.Context.getPlayWin();
	spr_shift = JKobo.Context.getScaleParms().getSpriteWidthShift();
	shift = JKobo.Context.getScaleParms().getEnemyShift();
	pw.copySprite((chipposx + di - 1) << spr_shift,
		      chipposy << spr_shift, chipsize, chipsize,
		      (x >> shift) - (chipsize >>> 1),
		      (y >> shift) - (chipsize >>> 1));
      }
  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : realize
 * DESCRIPTION	  :
 *****************************************************************************/
  boolean realize()
  {

    if(state == RESERVED)
      state = MOVING;

    return((state == MOVING) ? true : false);

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : isPipe
 * DESCRIPTION	  :
 *****************************************************************************/
  boolean isPipe()
  {
    return(((state != NOTUSE) && ((kind == PIPE1) || (kind == PIPE2))) ?
	   true : false);
  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : eraseCannon
 * DESCRIPTION	  :
 *****************************************************************************/
  int eraseCannon(int px, int py)
  {
    int shift, scrx, scry;
    int spr_shift;
    ScaleParms sp;

    sp = JKobo.Context.getScaleParms();
    shift = sp.getEnemyShift();
    scrx = sp.getSpaceWidth();
    scry = sp.getSpaceHeight();
    spr_shift = sp.getSpriteWidthShift();
    if((state != NOTUSE) && (kind == CANNON) &&
       (((x >> shift) & (scrx - 1)) >>> spr_shift == px) &&
       (((y >> shift) & (scry - 1)) >>> spr_shift == py))
      {
	state = NOTUSE;
	return(1);
      }

    return(0);
  }

}  /* END OF CLASS : Enemy */


/* END OF FILE : Enemy.java */

