/******************************************************************************
 * Project JKobo
 * XKobo arcade style game
 *
 * Copyright (C) 1997 John "Jake" Wetzel All Rights Reserved
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 *****************************************************************************/

/***************************** FILE INFORMATION ******************************
 * NAME OF FILE 	  : Radar.java
 * CONCEPT & ARCHITECTURE : Akira Higuchi
 * MAIN PROGRAMMER	  : Jake Wetzel
 * DATE CREATED 	  : 10-25-98
 * DESCRIPTION		  :
 * CHANGE LOG		  :
 *	  WHO		  WHEN			  WHY
 *	  ---		  ----			  ---
 *
 *****************************************************************************/

/******************************* IMPORT FILES ********************************/

import java.awt.Color;
import java.awt.Canvas;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;

import MyShip;
import PlayWin;
import ScaleParms;
import Space;


class Radar implements GlobalDefines, MapDefines
{

/******************************** GLOBAL DATA ********************************/

  int sx, sy;
  int mx_old, my_old;
  Color pixel_f0;
  Color pixel_f1;
  Color pixel_f2;
  Color pixel_b;
  Image radar_bitmap;	 /* bitmap containing radar area		       */
  Graphics radar_gc;

/**************************** FUNCTION DECLARATIONS  *************************/

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : Radar
 * DESCRIPTION	  :
 *****************************************************************************/
  Radar()
  {
    int sl;


    sl = JKobo.Context.getScaleLog2();
    sx = JKobo.Context.getScaleParms().getRadarWidth();
    sy = JKobo.Context.getScaleParms().getRadarHeight();
    radar_bitmap = JKobo.Context.getPlayWin().getCanvas().createImage(sx, sy);
    sx >>>= sl;
    sy >>>= sl;
    radar_gc = radar_bitmap.getGraphics();
    pixel_f0 = pixel_f1 = pixel_f2 = pixel_b  = null;

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : prepare
 * DESCRIPTION	  :
 *****************************************************************************/
  void prepare()
  {
    int i, j, a, sl;
    Rectangle r;
    Graphics g;
    Space space;


    if(pixel_f0 == null)
      {
	pixel_f0 = new Color(128, 240, 240);
	pixel_f1 = new Color(200, 240, 240);
	pixel_f2 = new Color(64, 128, 128);
	pixel_b  = new Color(32, 48, 64);
      }

    sl = JKobo.Context.getScaleLog2();
    g = radar_gc;
    r = g.getClipBounds();
    g.setColor(pixel_b);
    g.fillRect(r.x, r.y, r.width, r.height);

    space = JKobo.Context.getSpace();
    for(i=0; i<sx; i++)
      {
	for(j=0; j<sy; j++)
	  {
	    a = space.getChipNumber(i, j);
	    if(a == CORE)
	      {
		g.setColor(pixel_f1);
		g.fillOval(i << sl, j << sl, 1 << sl, 1 << sl);
	      }
	    else if((a == U_MASK) || (a == R_MASK) ||
		    (a == D_MASK) || (a == L_MASK))
	      {
		g.setColor(pixel_f2);
		g.fillOval(i << sl, j << sl, 1 << sl, 1 << sl);
	      }
	    else if((a & HIT_MASK) != 0)
	      {
		g.setColor(pixel_f2);
		g.fillRect(i << sl, j << sl, 1 << sl, 1 << sl);
	      }
	  }
      }

    mx_old = -1;
    my_old = -1;

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : erase
 * DESCRIPTION	  :
 *****************************************************************************/
  void erase(int x, int y)
  {
    int sl;
    Graphics g;

    sl = JKobo.Context.getScaleLog2();
    g = radar_gc;
    g.setColor(pixel_b);
    g.fillRect(x << sl, y << sl, 1 << sl, 1 << sl);

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : traceMyShip
 * DESCRIPTION	  :
 *****************************************************************************/
  void traceMyShip()
  {
    int mx_new, my_new, sl;
    Graphics g;
    ScaleParms sp;


    sl = JKobo.Context.getScaleLog2();
    sp = JKobo.Context.getScaleParms();
    mx_new = (JKobo.Context.getMyShip().getX() &
	      (sp.getSpaceWidth() - 1)) >>> sp.getSpriteWidthShift();
    my_new = (JKobo.Context.getMyShip().getY() &
	      (sp.getSpaceHeight() - 1)) >>> sp.getSpriteHeightShift();
    if((mx_new == mx_old) && (my_new == my_old))
      return;
    if(JKobo.Context.getSpace().getChipNumber(mx_new, my_new) != SPACE)
      return;

    g = radar_gc;
    g.setColor(pixel_f0);
    g.fillOval(mx_new << sl, my_new << sl, 1 << sl, 1 << sl);
    if(mx_old >= 0)
      {
	g.setColor(pixel_b);
	g.fillRect(mx_old << sl, my_old << sl, 1 << sl, 1 << sl);
      }
    mx_old = mx_new;
    my_old = my_new;

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : getRadarBitmap
 * DESCRIPTION	  :
 *****************************************************************************/
  final Image getRadarBitmap()
  {
    return(radar_bitmap);
  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : getRadarGraphics
 * DESCRIPTION	  :
 *****************************************************************************/
  final Graphics getRadarGraphics()
  {
    return(radar_gc);
  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : close
 * DESCRIPTION	  :
 *****************************************************************************/
  void close()
  {
    radar_gc.dispose();
  }

}  /* END OF CLASS : Radar */


/* END OF FILE : Radar.java */

