/******************************************************************************
 * Project JKobo
 * XKobo arcade style game
 *
 * Copyright (C) 1997 John "Jake" Wetzel All Rights Reserved
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 *****************************************************************************/

/***************************** FILE INFORMATION ******************************
 * NAME OF FILE 	  : Score.java
 * CONCEPT & ARCHITECTURE : Akira Higuchi
 * MAIN PROGRAMMER	  : Jake Wetzel
 * DATE CREATED 	  : 10-25-98
 * DESCRIPTION		  :
 * CHANGE LOG		  :
 *	  WHO		  WHEN			  WHY
 *	  ---		  ----			  ---
 *
 *****************************************************************************/

/******************************* IMPORT FILES ********************************/

import java.io.File;
import java.io.FileInputStream;
import java.io.DataInputStream;
import java.io.RandomAccessFile;
import java.io.FileNotFoundException;
import java.io.EOFException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.Random;
import java.util.ResourceBundle;

import ScoreWin;


class Score
{

  static final int SCORE_SAVE_MAX = 100;
  static final int MAX_NAME_LEN   =  64;
  static final int ENCRYPT_SEED   = 123;

  static String FindError;
  static String ReadError;
  static String CloseError;
  static String EncodeError;
  static String ScoreName;

/******************************** GLOBAL DATA ********************************/

  int min_highscore;
  String save_path;
  String login_name;
  byte buffer[];
  int bufsize;

/**************************** FUNCTION DECLARATIONS  *************************/

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : Score
 * DESCRIPTION	  :
 *****************************************************************************/
  Score()
  {

    save_path = new String(JKobo.Context.getAppPath() + "JKobo.hiscores");
    login_name = new String(System.getProperty("user.name"));
    if(login_name.length() > MAX_NAME_LEN)
      login_name = login_name.substring(0, MAX_NAME_LEN - 1);
    min_highscore = Integer.MAX_VALUE;
    bufsize = 4 + 4 + (MAX_NAME_LEN << 1);
    buffer = new byte[bufsize];

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : init
 * DESCRIPTION	  :
 *****************************************************************************/
  void init(int ans[])
  {
    int i, score, stage, n, len;
    byte tmp;
    String name;
    File ifp;
    FileInputStream fis;
    DataInputStream dis;
    Random rand;
    Object objs[];


    n = ans[0] = ans[1] = 0;
    fis = null;

    ifp = new File(save_path);
    if(ifp.exists() == false)
      {
	min_highscore  = 1;
	showHighScores();
	return;
      }

    objs = new Object[2];
    objs[0] = (Object) ScoreName;
    objs[1] = (Object) ifp.getAbsolutePath();

    try
      {
	fis = new FileInputStream(ifp);
	dis = new DataInputStream(fis);
	rand = new Random(ENCRYPT_SEED);
	while(true)
	  {
	    dis.read(buffer);
	    for(i=0; i<bufsize; i++)
	      {
		tmp = (byte) (rand.nextInt() & 0xff);
		buffer[i] ^= tmp;
	      }
	    score = ((((int) buffer[0]) & 0xff) << 24) +
		     ((((int) buffer[1]) & 0xff) << 16) +
		      ((((int) buffer[2]) & 0xff) << 8) +
		       (((int) buffer[3]) & 0xff);
	    min_highscore = Math.min(score, min_highscore);
	    stage = ((((int) buffer[4]) & 0xff) << 24) +
		     ((((int) buffer[5]) & 0xff) << 16) +
		      ((((int) buffer[6]) & 0xff) << 8) +
		       (((int) buffer[7]) & 0xff);
	    for(i=8; i<bufsize; i++)
	      if(buffer[i] == 0)
		break;
	    len = i - 8;
	    name = new String(buffer, 8, len,
			      System.getProperty("file.encoding"));
	    n++;
	    if(name.equalsIgnoreCase(login_name))
	      {
		ans[0] = score;
		ans[1] = stage;
		return;
	      }
	  }
      }

    catch(FileNotFoundException e1)
      {
	 System.err.println(MessageFormat.format(FindError, objs));
      }

    catch(EOFException e3)
      {
      }

    catch(IOException e2)
      {
	 System.err.println(MessageFormat.format(ReadError, objs));
      }

    finally
      {
	if(n < SCORE_SAVE_MAX)
	  min_highscore  = 1;
	if(fis != null)
	  {
	    try
	      {
		fis.close();
	      }
	    catch(IOException e2)
	      {
		System.err.println(MessageFormat.format(CloseError, objs));
	      }
	  }
	showHighScores();
      }

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : record
 * DESCRIPTION	  :
 *****************************************************************************/
  void record(int new_score, int stage)
  {
    int i, n;
    int rec, score, scene;
    long len;
    byte tmp, t[], buf[];
    byte in[], out[];
    File ifp;
    RandomAccessFile raf;
    Random enc_rand, dec_rand;
    Object objs[];


    raf = null;

    if(new_score < min_highscore)
      return;

    buffer[0] = (byte) (new_score >>> 24);
    buffer[1] = (byte) (new_score >>> 16);
    buffer[2] = (byte) (new_score >>> 8);
    buffer[3] = (byte) new_score;
    buffer[4] = (byte) (stage >>> 24);
    buffer[5] = (byte) (stage >>> 16);
    buffer[6] = (byte) (stage >>> 8);
    buffer[7] = (byte) stage;
    objs = new Object[1];
    objs[0] = (Object) login_name;

    try
      {
	t = login_name.getBytes(System.getProperty("file.encoding"));
      }
    catch(UnsupportedEncodingException e)
      {
	System.err.println(MessageFormat.format(EncodeError, objs));
	return;
      }
    for(rec=0; rec<t.length; rec++)
      buffer[rec+8] = t[rec];
    for(rec+=8; rec<bufsize; rec++)
      buffer[rec] = 0;
    buf = new byte[bufsize];

    ifp = new File(save_path);
    if(ifp.exists() == false)
      {
	n = 0;
	len = 0;
      }
    else
      {
	len = ifp.length();
	n = (int) (len / bufsize);
      }
    objs = new Object[2];
    objs[0] = (Object) ScoreName;
    objs[1] = (Object) ifp.getAbsolutePath();

    try
      {
	enc_rand = new Random(ENCRYPT_SEED);
	dec_rand = new Random(ENCRYPT_SEED);
	in = buf;
	out = buffer;
	raf = new RandomAccessFile(ifp, "rw");
	for(rec=0; rec<n; rec++)
	  {
	    raf.read(in);
	    for(i=0; i<bufsize; i++)
	      {
		tmp = (byte) (dec_rand.nextInt() & 0xff);
		in[i] ^= tmp;
	      }
	    score = ((((int) in[0]) & 0xff) << 24) +
		     ((((int) in[1]) & 0xff) << 16) +
		      ((((int) in[2]) & 0xff) << 8) +
		       (((int) in[3]) & 0xff);
	    if(score > new_score)
	      {
		for(i=0; i<bufsize; i++)
		  score = enc_rand.nextInt();
		continue;
	      }
	    else if(score == new_score)
	      {
		scene = ((((int) in[4]) & 0xff) << 24) +
			 ((((int) in[5]) & 0xff) << 16) +
			  ((((int) in[6]) & 0xff) << 8) +
			   (((int) in[7]) & 0xff);
		if(scene > stage)
		  {
		    for(i=0; i<bufsize; i++)
		      score = enc_rand.nextInt();
		    continue;
		  }
	      }
	    raf.seek(rec * bufsize);
	    for(i=0; i<bufsize; i++)
	      {
		tmp = (byte) (enc_rand.nextInt() & 0xff);
		out[i] ^= tmp;
	      }
	    raf.write(out);
	    t = out;
	    out = in;
	    in = t;
	  }

	if(n < SCORE_SAVE_MAX)
	  {
	    for(i=0; i<bufsize; i++)
	      {
		tmp = (byte) (enc_rand.nextInt() & 0xff);
		out[i] ^= tmp;
	      }
	    raf.write(out);
	  }

      }

    catch(EOFException e3)
      {
      }

    catch(IOException e2)
      {
	 System.err.println(MessageFormat.format(ReadError, objs));
      }

    finally
      {
	if(raf != null)
	  {
	    try
	      {
		raf.close();
	      }
	    catch(IOException e2)
	      {
		System.err.println(MessageFormat.format(CloseError, objs));
	      }
	  }
	showHighScores();
      }

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : showHighScores
 * DESCRIPTION	  :
 *****************************************************************************/
  void showHighScores()
  {
    int i, n, rec, l;
    int scores[], stages[];
    byte tmp;
    String names[];
    File ifp;
    FileInputStream fis;
    DataInputStream dis;
    Random rand;
    Object objs[];


    fis = null;

    ifp = new File(save_path);
    if(ifp.exists() == false)
      {
	JKobo.Context.getScoreWin().displayScores(null, null, null);
	return;
      }

    n = (int) (ifp.length() / bufsize);
    scores = new int[n];
    stages = new int[n];
    names = new String[n];
    objs = new Object[2];
    objs[0] = (Object) ScoreName;
    objs[1] = (Object) ifp.getAbsolutePath();

    try
      {
	rand = new Random(ENCRYPT_SEED);
	fis = new FileInputStream(ifp);
	dis = new DataInputStream(fis);
	for(rec=0; rec<n; rec++)
	  {
	    dis.read(buffer);
	    for(i=0; i<bufsize; i++)
	      {
		tmp = (byte) (rand.nextInt() & 0xff);
		buffer[i] ^= tmp;
	      }
	    scores[rec] = ((((int) buffer[0]) & 0xff) << 24) +
			   ((((int) buffer[1]) & 0xff) << 16) +
			    ((((int) buffer[2]) & 0xff) << 8) +
			     (((int) buffer[3]) & 0xff);
	    stages[rec] = ((((int) buffer[4]) & 0xff) << 24) +
			   ((((int) buffer[5]) & 0xff) << 16) +
			    ((((int) buffer[6]) & 0xff) << 8) +
			     (((int) buffer[7]) & 0xff);
	    for(i=8; i<bufsize; i++)
	      if(buffer[i] == 0)
		break;
	    l = i - 8;
	    names[rec] = new String(buffer, 8, l,
				    System.getProperty("file.encoding"));
	  }
      }

    catch(FileNotFoundException e1)
      {
	 System.err.println(MessageFormat.format(FindError, objs));
      }

    catch(EOFException e3)
      {
      }

    catch(IOException e2)
      {
	 System.err.println(MessageFormat.format(ReadError, objs));
      }

    finally
      {
	if(fis != null)
	  {
	    try
	      {
		fis.close();
	      }
	    catch(IOException e2)
	      {
		System.err.println(MessageFormat.format(CloseError, objs));
	      }
	  }
      }

    JKobo.Context.getScoreWin().displayScores(names, scores, stages);

  }

/***************************** MODULE INFORMATION ****************************
 * NAME OF MODULE : static
 * DESCRIPTION	  :
 *****************************************************************************/
  static
  {
    ResourceBundle bundle;


    bundle = JKobo.Context.getResourceBundle();

    try {
      FindError = bundle.getString("FindFile.message");
    }
    catch(MissingResourceException e) {
      FindError = "Unable to find {0} file \"{1}\"";
    }
    try {
      ReadError = bundle.getString("ReadFile.message");
    }
    catch(MissingResourceException e) {
      ReadError = "Error reading {0} file \"{1}\"";
    }
    try {
      EncodeError = bundle.getString("ScoreEncodeError.message");
    }
    catch(MissingResourceException e) {
      EncodeError = "Error encoding \"{0}\"";
    }
    try {
      CloseError = bundle.getString("CloseFile.message");
    }
    catch(MissingResourceException e) {
      CloseError = "Unable to close {0} file \"{1}\"";
    }
    try {
      ScoreName = bundle.getString("ScoreFileName.message");
    }
    catch(MissingResourceException e) {
      ScoreName = "score";
    }

  }

}  /* END OF CLASS : Score */


/* END OF FILE : Score.java */

