/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.nii.icpc2010;

import java.util.ArrayDeque;
import java.util.Deque;
import jp.ac.nii.icpc2010.AbstractTron;
import jp.ac.nii.icpc2010.manager.IOptionSource;
import jp.ac.nii.icpc2010.manager.OptionsManager;
import jp.ac.nii.icpc2010.playfield.FieldDirection;
import jp.ac.nii.icpc2010.playfield.PlayField;

public class Tron
extends AbstractTron {
    private int _lastx;
    private int _lasty;
    private int _nextx;
    private int _nexty;
    private FieldDirection _lastDir;
    private FieldDirection _dir;
    private Deque<Integer> _xTrailDeque;
    private Deque<Integer> _yTrailDeque;
    private IOptionSource _options;
    private TronState _state;

    public Tron(int id, int startx, int starty, FieldDirection startdir, String name, OptionsManager om) {
        this._playerId = id;
        this._lastx = this._nextx = startx;
        this._x = this._nextx;
        this._lasty = this._nexty = starty;
        this._y = this._nexty;
        this._lastDir = startdir;
        this._dir = startdir;
        this._coins = 0;
        this._lifetime = 0;
        this._xTrailDeque = new ArrayDeque<Integer>();
        this._yTrailDeque = new ArrayDeque<Integer>();
        this._xTrailDeque.addFirst(this._x);
        this._yTrailDeque.addFirst(this._y);
        this._options = om;
        this._state = TronState.ALIVE;
        if (!om.isTournamentMode()) {
            System.out.println("tron " + this._playerId + " created.");
        }
    }

    public int getLastX() {
        return this._lastx;
    }

    public int getLastY() {
        return this._lasty;
    }

    public int getNextX() {
        return this._nextx;
    }

    public int getNextY() {
        return this._nexty;
    }

    public FieldDirection getDir() {
        return this._dir;
    }

    public FieldDirection getLastDir() {
        return this._lastDir;
    }

    public void setCoins(int coins) {
        this._coins = coins;
    }

    public void setDirection(FieldDirection dir) {
        if (dir != null) {
            this._lastDir = this._dir;
            this._dir = dir;
        }
    }

    public int getTrailLength() {
        return this._xTrailDeque.size();
    }

    public int getTailX() {
        return this._xTrailDeque.getLast();
    }

    public int getTailY() {
        return this._yTrailDeque.getLast();
    }

    public int removeTailX() {
        return this._xTrailDeque.removeLast();
    }

    public int removeTailY() {
        return this._yTrailDeque.removeLast();
    }

    public void nextStep(PlayField field) {
        int[] newCoords = field.stepOne(this._x, this._y, this._dir);
        this._nextx = newCoords[0];
        this._nexty = newCoords[1];
    }

    public void step() {
        ++this._lifetime;
        this._lastx = this._x;
        this._lasty = this._y;
        this._x = this._nextx;
        this._y = this._nexty;
        this._xTrailDeque.addFirst(this._x);
        this._yTrailDeque.addFirst(this._y);
        if (this._options.isLoggingOn()) {
            System.out.println("id: " + this.getPlayerId() + " is now at " + this.getX() + " , " + this.getY());
        }
    }

    public void die() {
        this._state = TronState.DEAD;
        this._lastx = this._nextx = this._x;
        this._lasty = this._nexty = this._y;
    }

    public boolean isAlive() {
        return this._state == TronState.ALIVE;
    }

    private static enum TronState {
        ALIVE,
        DEAD;

    }
}

