/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.nii.icpc2010.manager;

import java.awt.Color;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import jp.ac.nii.icpc2010.manager.IOptionSource;
import jp.ac.nii.icpc2010.manager.TimeoutAction;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class OptionsManager
implements IOptionSource {
    private boolean _loggingOn = false;
    private boolean tournamentMode;
    private int numOfPlayers;
    int maxSteps;
    private boolean lastmanStanding;
    private String openingName;
    private String levelName;
    private Vector<String> playerClasses;
    private String scoreClass;
    private String recordFile;
    private String playbackFile;
    private boolean trailLimit;
    private boolean backbufferEnabled;
    private boolean drawOnlyChanges;
    private int trailLimitAmount;
    private String graphicSet;
    private String[] backgroundImages;
    private String wallImage;
    private String[] tronImages;
    private Color[] tronColors;
    private String coinImage;
    private Color boardBgColor;
    private Color counterColor;
    private Color scoreColor;
    private Color commentColor;
    private boolean tronHeadImage;
    private String[] tronHeadImages;
    private String[] tronTrailCornerImages;
    private boolean displayQuote;
    private int gameRounds;
    private int openingTime;
    private TimeoutAction timeoutAction;
    private long displayInterval;
    private int cellWidth;
    private int cellHeight;
    private double itemInitProb;
    private double itemRegenProb;
    private int commentLine;
    private long initTimeout;
    private long runTimeout;
    private long turnTimeslot;
    Document doc;
    XPathFactory xfactory;
    XPath xpath;

    public boolean isTournamentMode() {
        return this.tournamentMode;
    }

    public static void main(String ... args) {
        OptionsManager om = new OptionsManager();
        System.out.println(om.getLevelName());
        for (String s : om.playerClasses) {
            System.out.println(s);
        }
    }

    public OptionsManager() {
        this(null);
    }

    public OptionsManager(String[] commandLineArgs) {
        this.loadOptions();
        if (commandLineArgs != null) {
            this.overrideWithCommandLine(commandLineArgs);
        }
    }

    private void loadOptions() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.doc = builder.parse("config.xml");
            this.xfactory = XPathFactory.newInstance();
            this.xpath = this.xfactory.newXPath();
            this.tournamentMode = false;
            this.numOfPlayers = this.overWrite(2, "//Player/@num");
            this.openingName = this.overWrite("opening", "//Opening/@name");
            this.playerClasses = this.xpathQuery("//Player/@className");
            this.scoreClass = this.overWrite("SurvivalScore", "//Score/@className");
            this.graphicSet = this.overWrite("Flat", "//UseSet/@set");
            this.backgroundImages = this.overWrite(new String[]{"flat/black.png"}, this.graphicProperty("Background/@imageName"), true);
            this.wallImage = this.overWrite("flat/grey.png", this.graphicProperty("Wall/@imageName"));
            this.tronImages = this.overWrite(new String[]{"flat/red.png", "flat/blue.png", "flat/green.png", "flat/magenta.png"}, this.graphicProperty("Tron/@imageName"), false);
            this.tronColors = this.parseColors(this.overWrite(new String[]{"RED", "BLUE", "GREEN", "MAGENTA"}, this.graphicProperty("Tron/@color"), false));
            this.coinImage = this.overWrite("flat/yellow.png", this.graphicProperty("Coin/@imageName"));
            this.boardBgColor = this.parseColor(this.overWrite("BLACK", this.graphicProperty("Board/@bgColor")).toLowerCase());
            this.counterColor = this.parseColor(this.overWrite("GREEN", this.graphicProperty("Board/@counterColor")).toLowerCase());
            this.scoreColor = this.parseColor(this.overWrite("WHITE", this.graphicProperty("Board/@scoreColor")).toLowerCase());
            this.commentColor = this.parseColor(this.overWrite("ORANGE", this.graphicProperty("Board/@commentColor")).toLowerCase());
            this.tronHeadImage = "on".compareTo(this.overWrite("off", "//Display/@tronHeadImage")) == 0;
            this.tronTrailCornerImages = this.overWrite(new String[]{"flat/red.png", "flat/blue.png", "flat/green.png", "flat/magenta.png"}, this.graphicProperty("TronTrailCorner/@imageName"), false);
            if (this.tronHeadImage) {
                this.tronHeadImages = this.overWrite(new String[]{"flat/red.png", "flat/blue.png", "flat/green.png", "flat/magenta.png"}, this.graphicProperty("TronHead/@imageName"), false);
            }
            this.runTimeout = this.overWrite(100L, "//Timeout/@run");
            this.initTimeout = this.overWrite(1000L, "//Timeout/@init");
            this.turnTimeslot = this.overWrite(250L, "//Turn/@timeslot");
            this.cellWidth = this.overWrite(16, "//Display/@width");
            this.cellHeight = this.overWrite(16, "//Display/@height");
            this.itemInitProb = this.overWrite(1.0, "//Item/@initProb");
            this.itemRegenProb = this.overWrite(0.01, "//Item/@regenProb");
            this.trailLimit = Boolean.parseBoolean(this.overWrite("true", "//Trail/@limit"));
            this.trailLimitAmount = this.overWrite(25, "//Trail/@amount");
            this.maxSteps = this.overWrite(0, "//Game/@maxSteps");
            this.lastmanStanding = Boolean.parseBoolean(this.overWrite("true", "//Game/@lastmanStanding"));
            this.gameRounds = this.overWrite(2, "//Game/@rounds");
            if (this.levelName == null) {
                this.levelName = this.overWrite("level01.txt", "//UseLevel/@level");
            }
            this.runTimeout = this.overWrite(this.runTimeout, this.levelProperty("Timeout/@run"));
            this.initTimeout = this.overWrite(this.initTimeout, this.levelProperty("Timeout/@init"));
            this.turnTimeslot = this.overWrite(this.turnTimeslot, this.levelProperty("Turn/@timeslot"));
            this.cellWidth = this.overWrite(this.cellWidth, this.levelProperty("Display/@width"));
            this.cellHeight = this.overWrite(this.cellHeight, this.levelProperty("Display/@height"));
            this.itemInitProb = this.overWrite(this.itemInitProb, this.levelProperty("Item/@initProb"));
            this.itemRegenProb = this.overWrite(this.itemRegenProb, this.levelProperty("Item/@regenProb"));
            this.trailLimit = Boolean.parseBoolean(this.overWrite(String.valueOf(this.trailLimit), this.levelProperty("Trail/@limit")));
            this.trailLimitAmount = this.overWrite(this.trailLimitAmount, this.levelProperty("Trail/@amount"));
            this.maxSteps = this.overWrite(this.maxSteps, this.levelProperty("Game/@maxSteps"));
            this.lastmanStanding = Boolean.parseBoolean(this.overWrite(String.valueOf(this.lastmanStanding), this.levelProperty("Game/@lastmanStanding")));
            this.gameRounds = this.overWrite(this.gameRounds, this.levelProperty("Game/@rounds"));
            this.displayQuote = Boolean.parseBoolean(this.overWrite("false", "//Display/@displayQuote"));
            this.openingTime = this.overWrite(1000, "//Display/@openingTime");
            this.timeoutAction = TimeoutAction.valueOf(this.overWrite("Last", "//Timeout/@action"));
            this.displayInterval = this.overWrite(100L, "//Display/@interval");
            this.commentLine = this.overWrite(20, "//Display/@commentLine");
            this.backbufferEnabled = Boolean.parseBoolean(this.overWrite("true", "//Display/@backbufferEnabled"));
            this.drawOnlyChanges = Boolean.parseBoolean(this.overWrite("false", "//Display/@drawOnlyChanges"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String graphicProperty(String name) {
        return "//GraphicSet[@name='" + this.graphicSet + "']/" + name;
    }

    private String levelProperty(String name) {
        return "//Level[@name='" + this.levelName + "']/" + name;
    }

    private Vector<String> xpathQuery(String query) throws Exception {
        Vector<String> result = new Vector<String>();
        XPathExpression expr = this.xpath.compile(query);
        Object xresult = expr.evaluate(this.doc, XPathConstants.NODESET);
        NodeList nodes = (NodeList)xresult;
        int i = 0;
        while (i < nodes.getLength()) {
            result.add(nodes.item(i).getNodeValue());
            ++i;
        }
        return result;
    }

    private String[] overWrite(String[] oldStrings, String expr, boolean shrink) throws Exception {
        Vector<String> newStrings = this.xpathQuery(expr);
        if (newStrings.size() == 0) {
            return oldStrings;
        }
        if (shrink || newStrings.size() > oldStrings.length) {
            return newStrings.toArray(new String[newStrings.size()]);
        }
        int i = 0;
        while (i < newStrings.size()) {
            oldStrings[i] = newStrings.get(i);
            ++i;
        }
        return oldStrings;
    }

    private String overWrite(String oldString, String expr) throws Exception {
        Vector<String> newStrings = this.xpathQuery(expr);
        if (newStrings.size() == 0) {
            return oldString;
        }
        return newStrings.get(0);
    }

    private int overWrite(int oldInt, String expr) throws Exception {
        return Integer.parseInt(this.overWrite(String.valueOf(oldInt), expr));
    }

    private double overWrite(double oldDouble, String expr) throws Exception {
        return Double.parseDouble(this.overWrite(String.valueOf(oldDouble), expr));
    }

    private long overWrite(long oldLong, String expr) throws Exception {
        return Long.parseLong(this.overWrite(String.valueOf(oldLong), expr));
    }

    private Color parseColor(String str) throws Exception {
        if (str.charAt(0) == '#') {
            return Color.decode(str);
        }
        Object o = null;
        o = Class.forName("java.awt.Color").getDeclaredField(str).get(null);
        if (o instanceof Color) {
            return (Color)o;
        }
        return Color.BLACK;
    }

    private Color[] parseColors(String[] strs) throws Exception {
        Color[] colors = new Color[strs.length];
        int i = 0;
        while (i < strs.length) {
            colors[i] = this.parseColor(strs[i]);
            ++i;
        }
        return colors;
    }

    public void overrideWithCommandLine(String[] args) {
        boolean gotPlayerClasses = false;
        Vector<String> myPlayerClasses = new Vector<String>();
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-level")) {
                assert (args.length >= i + 2);
                this.levelName = args[i + 1];
                ++i;
            } else if (args[i].equals("-playerClass")) {
                assert (args.length >= i + 2);
                gotPlayerClasses = true;
                myPlayerClasses.add(args[i + 1]);
                ++i;
            } else if (args[i].equals("-record")) {
                assert (args.length >= i + 2);
                this.recordFile = args[i + 1];
                ++i;
            } else if (args[i].equals("-playback")) {
                assert (args.length >= i + 2);
                this.playbackFile = args[i + 1];
                ++i;
            } else if (args[i].equals("-cmdMode")) {
                this.tournamentMode = true;
            }
            ++i;
        }
        if (gotPlayerClasses) {
            this.playerClasses = myPlayerClasses;
        }
    }

    public String getOpeningName() {
        return this.openingName;
    }

    @Override
    public String getLevelName() {
        return this.levelName;
    }

    @Override
    public String getRecordFile() {
        return this.recordFile;
    }

    @Override
    public String getPlaybackFile() {
        return this.playbackFile;
    }

    @Override
    public Vector<String> getPlayerClasses() {
        return this.playerClasses;
    }

    @Override
    public boolean isLoggingOn() {
        return this._loggingOn;
    }

    @Override
    public String[] getBackgroundImageName() {
        return this.backgroundImages;
    }

    @Override
    public String getWallImageName() {
        return this.wallImage;
    }

    public String getTronImageName(int playerId) {
        return this.tronImages[playerId % this.tronImages.length];
    }

    public String getTronHeadImageName(int playerId) {
        if (this.tronHeadImage) {
            return this.tronHeadImages[playerId % this.tronHeadImages.length];
        }
        return "";
    }

    public String getTronTrailCornerImageName(int playerId) {
        return this.tronTrailCornerImages[playerId % this.tronTrailCornerImages.length];
    }

    @Override
    public String getCoinImageName() {
        return this.coinImage;
    }

    public Color getBoardBgColor() {
        return this.boardBgColor;
    }

    public Color getCounterColor() {
        return this.counterColor;
    }

    public Color getScoreColor() {
        return this.scoreColor;
    }

    public Color getCommentColor() {
        return this.commentColor;
    }

    public boolean isTronHeadImage() {
        return this.tronHeadImage;
    }

    public boolean isDisplayQuote() {
        return this.displayQuote;
    }

    public Color getTronColor(int playerId) {
        return this.tronColors[playerId % this.tronColors.length];
    }

    @Override
    public int getGameRounds() {
        return this.gameRounds;
    }

    @Override
    public TimeoutAction getTimeoutAction() {
        return this.timeoutAction;
    }

    public long getInitTimeout() {
        return this.initTimeout;
    }

    @Override
    public long getRunTimeout() {
        return this.runTimeout;
    }

    @Override
    public long getTurnTimeslot() {
        return this.turnTimeslot;
    }

    public void setTurnTimeslot(long timeslot) {
        this.turnTimeslot = timeslot;
    }

    public long getDisplayInterval() {
        return this.displayInterval;
    }

    public int getCellWidth() {
        return this.cellWidth;
    }

    public int getCellHeight() {
        return this.cellHeight;
    }

    @Override
    public int getTrailLimitAmount() {
        return this.trailLimitAmount;
    }

    @Override
    public boolean hasTrailLimit() {
        return this.trailLimit;
    }

    public int getOpeningTime() {
        return this.openingTime;
    }

    public String getScoreClass() {
        return this.scoreClass;
    }

    public int getNumOfPlayers() {
        return this.numOfPlayers;
    }

    @Override
    public int getMaxTurns() {
        return this.maxSteps;
    }

    public boolean isLastmanStanding() {
        return this.lastmanStanding;
    }

    public double getItemInitProb() {
        return this.itemInitProb;
    }

    public double getItemRegenProb() {
        return this.itemRegenProb;
    }

    public int getCommentLines() {
        return this.commentLine;
    }

    public boolean getBackbufferEnabled() {
        return this.backbufferEnabled;
    }

    public boolean getDrawOnlyChanges() {
        return this.drawOnlyChanges;
    }
}

