/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.nii.icpc2010.playfield;

import java.util.Vector;
import jp.ac.nii.icpc2010.AbstractTron;
import jp.ac.nii.icpc2010.ITron;
import jp.ac.nii.icpc2010.RefTron;
import jp.ac.nii.icpc2010.playfield.AbstractPlayField;

public class RefPlayField
extends AbstractPlayField {
    private Vector<ITron> _trons;
    private int[][] _field;

    public RefPlayField(int width, int height, int nIds) {
        this._width = width;
        this._height = height;
        this._field = new int[width][height];
    }

    public void copy(AbstractPlayField orig) {
        assert (orig.getWidth() == this._width);
        assert (orig.getHeight() == this._height);
        int i = 0;
        while (i < this._width) {
            int j = 0;
            while (j < this._height) {
                this._field[i][j] = orig.getObjectAt(i, j);
                ++j;
            }
            ++i;
        }
        this.keyPressed = orig.keyPressed;
        this._trons = new Vector();
        for (ITron tron : orig.getTrons()) {
            this._trons.add(RefTron.getCopy((AbstractTron)tron));
        }
        this._turn = orig.getTurn();
        this._round = orig.getRound();
        this._maxturn = orig.getMaxTurns();
        this._gameround = orig.getGameRounds();
    }

    @Override
    public int getObjectAt(int x, int y) {
        return this._field[x][y];
    }

    @Override
    public Vector<ITron> getTrons() {
        return this._trons;
    }

    @Override
    public int getNumOfPlayers() {
        return this._trons.size();
    }

    @Override
    public int getRemainingRounds() {
        return this._gameround - this._round - 1;
    }

    @Override
    public int getRemainingTurns() {
        return this._maxturn - this._turn - 1;
    }
}

