/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.nii.icpc2010.recorder;

import java.util.ArrayList;
import java.util.List;
import jp.ac.nii.icpc2010.TronException;
import jp.ac.nii.icpc2010.manager.OptionsManager;
import jp.ac.nii.icpc2010.recorder.IRecorder;
import jp.ac.nii.icpc2010.recorder.PlayerEvent;

public abstract class AbstractRecorder
implements IRecorder {
    private final int _numPlayers;
    private String[] _playerNames;
    private List<Double> playerScores = new ArrayList<Double>();
    private List<PlayerEvent[]> _events;
    private boolean _closed;
    protected OptionsManager om;

    public AbstractRecorder(String[] playerNames, OptionsManager om) {
        this._numPlayers = playerNames.length;
        this._playerNames = playerNames;
        this._events = new ArrayList<PlayerEvent[]>();
        this.om = om;
    }

    @Override
    public void addEvents(PlayerEvent[] events) throws TronException {
        if (this._closed) {
            throw new TronException("Recorder closed");
        }
        this._events.add(events);
    }

    @Override
    public void addPlayerScore(double score) throws TronException {
        if (this._closed) {
            throw new TronException("Recorder closed");
        }
        this.playerScores.add(score);
    }

    @Override
    public void closeWriting() throws TronException {
        this._closed = true;
    }

    @Override
    public void load() throws TronException {
    }

    @Override
    public List<PlayerEvent[]> getEvents() {
        return this._events;
    }

    @Override
    public String[] getPlayerNames() {
        return this._playerNames;
    }

    void setEvents(List<PlayerEvent[]> events) {
        this._events = events;
        if (!this.om.isTournamentMode()) {
            System.out.println("Loaded " + this._events.size() + " event sets.");
        }
    }

    void setPlayerNames(String[] names) {
        this._playerNames = names;
    }

    @Override
    public List<Double> getPlayerScores() {
        return this.playerScores;
    }

    public void setPlayerScores(List<Double> playerScores) {
        this.playerScores = playerScores;
    }
}

