/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.nii.icpc2010.tournament;

import java.io.File;
import jp.ac.nii.icpc2010.Main;
import jp.ac.nii.icpc2010.manager.OptionsManager;
import jp.ac.nii.icpc2010.tournament.Logger;
import jp.ac.nii.icpc2010.tournament.Match;
import jp.ac.nii.icpc2010.tournament.QueuedMatch;
import jp.ac.nii.icpc2010.tournament.TournamentMaster;

public class TournamentSlave
extends Thread {
    private TournamentMaster master;

    public TournamentSlave(TournamentMaster master) {
        this.master = master;
        this.start();
    }

    @Override
    public void run() {
        while (this.master.isAlive()) {
            QueuedMatch qm = this.master.pollQueuedMatch();
            if (qm != null) {
                File recordFile = new File("level_" + qm.getRound().getNumber() + "_rec_" + qm.getPlayerOne() + "_VS_" + qm.getPlayerTwo() + ".dat");
                String[] args = new String[]{"-playerClass", qm.getPlayerOne().getPlayerClass(), "-playerClass", qm.getPlayerTwo().getPlayerClass(), "-cmdMode", "-record", recordFile.getAbsolutePath()};
                Main.main(args);
                Match m = new Match(qm.getPlayerOne(), qm.getPlayerTwo(), recordFile, new OptionsManager(args));
                qm.setMatch(m);
                qm.getGroup().addMatch(m);
                Logger.log("round " + qm.getRound().getNumber() + ": " + qm.getPlayerOne() + " vs " + qm.getPlayerTwo() + " = " + m.getResult(qm.getPlayerOne()));
                this.master.reportFinishedMatch();
                continue;
            }
            try {
                TournamentSlave.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

