package jp.ac.nii.icpc2010.players;

import java.awt.Point;

import jp.ac.nii.icpc2010.playfield.IPlayField;

public class BaseRouteSelecter extends RouteSelecter {

    private Point[][] routes;

    public BaseRouteSelecter(int id, IPlayField playField) {
        super(id, playField);

        this.routes = new Point[12][];

        int width = playField.getWidth();
        int height = playField.getHeight();

        // right, left
        int len = width - 1;
        this.routes[0] = new Point[len];
        this.routes[1] = new Point[len];
        for(int i = 0; i < len; i++){
            this.routes[0][i] = new Point(  i + 1 , 0);
            this.routes[1][i] = new Point(-(i + 1), 0);
        }

        // up, down
        len = height - 1;
        this.routes[2] = new Point[len];
        this.routes[3] = new Point[len];
        for(int i = 0; i < len; i++){
            this.routes[2][i] = new Point(0,   i + 1);
            this.routes[3][i] = new Point(0, -(i + 1));
        }

        // upright, etc.
        int n = Math.min(width, height);
        len = n + n - 1;
        this.routes[ 4] = new Point[len];
        this.routes[ 5] = new Point[len];
        this.routes[ 6] = new Point[len];
        this.routes[ 7] = new Point[len];
        this.routes[ 8] = new Point[len];
        this.routes[ 9] = new Point[len];
        this.routes[10] = new Point[len];
        this.routes[11] = new Point[len];
        for(int i = 0; i < len; i++){
            this.routes[ 4][i] = new Point( (i + 2) / 2,  (i + 1) / 2);
            this.routes[ 5][i] = new Point( (i + 2) / 2, -(i + 1) / 2);
            this.routes[ 6][i] = new Point(-(i + 2) / 2,  (i + 1) / 2);
            this.routes[ 7][i] = new Point(-(i + 2) / 2, -(i + 1) / 2);
            this.routes[ 8][i] = new Point( (i + 1) / 2,  (i + 2) / 2);
            this.routes[ 9][i] = new Point(-(i + 1) / 2,  (i + 2) / 2);
            this.routes[10][i] = new Point( (i + 1) / 2, -(i + 2) / 2);
            this.routes[11][i] = new Point( (i + 1) / 2, -(i + 2) / 2);
        }
    }

    @Override
    protected int getNumOfRoutes() {
        return this.routes.length;
    }

    @Override
    protected Point[] getRoute(int routeId) {
        return this.routes[routeId];
    }
}
