package jp.ac.nii.icpc2010.manager;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

import jp.ac.nii.icpc2010.players.AbstractPlayer;
import jp.ac.nii.icpc2010.playfield.RefPlayField;


public class PlayerInitProcess implements Runnable {
	AbstractPlayer[] player;
	private Constructor<? extends AbstractPlayer> constructor;
	private int id;
	private RefPlayField playField;
	private OptionsManager om;

	public PlayerInitProcess(AbstractPlayer[] player, Constructor<? extends AbstractPlayer> constructor, int id, RefPlayField playField, OptionsManager om){
		this.player = player;
		this.constructor = constructor;
		this.id = id;
		this.playField = playField;
		this.om = om;
		return;
	}

	public void run(){
		try {
			this.player[0] = this.constructor.newInstance(id, playField);
		} catch (IllegalArgumentException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (InstantiationException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (InvocationTargetException e) {
			if(e.getCause() instanceof ThreadDeath){
			}else{
				e.printStackTrace();
			}
		}
	}
}
