package jp.ac.nii.icpc2010.players;

import java.util.ArrayList;
import java.util.List;

import jp.ac.nii.icpc2010.playfield.FieldDirection;
import jp.ac.nii.icpc2010.playfield.IPlayField;

/**
 * Choose the destination square with the most open neighbors
 * 
 * based on "Robert Xiao's Tron Strategy Guide"
 * (see http://csclub.uwaterloo.ca/contest/xiao_strategy.php)
 * 
 * @author yukino
 *
 */
public class MostOpenDestSelectionPlayer extends BasePlayer
{
	public MostOpenDestSelectionPlayer(int id, IPlayField playField) {
		super(id, playField);
		// TODO Auto-generated constructor stub
	}

	FieldDirection prev_dir;

	public FieldDirection getInput()
    {
		int curx = getX();
		int cury = getY();
		
		List<FieldDirection> safeDirs = getSafeDirs(curx, cury);
		
		if (safeDirs.isEmpty())
		{
			//give up
			return prev_dir;
		}
		
		FieldDirection decision = safeDirs.get(0);

		int bestcount = -1;

		for (FieldDirection dir: safeDirs)
		{
			int[] pred = getPlayField().stepOne(curx, cury, dir);
			int count = 0;
    	  
			for (int[] adj: getAdjacentPos(pred[0], pred[1]))
			{
				if (isSafe(adj[0], adj[1]))
				{
					count++;
				}
			}
    	  
			if (count > bestcount)
			{
				bestcount = count;
				decision = dir;
			}
		}
    	  
		prev_dir = decision;
		return decision;
    	}
}