package jp.ac.nii.icpc2010.playfield;
import java.util.Vector;

import jp.ac.nii.icpc2010.AbstractTron;
import jp.ac.nii.icpc2010.ITron;
import jp.ac.nii.icpc2010.RefTron;

public class RefPlayField extends AbstractPlayField
{
	private Vector<ITron> _trons;

	private int[][] _field;
	
	public RefPlayField(int width, int height, int nIds)
	{
		_width = width;
		_height = height;
		_field = new int[width][height];
	}

	public void copy(AbstractPlayField orig)
	{
		assert(orig.getWidth() == _width);
		assert(orig.getHeight() == _height);

		for(int i = 0; i < _width; i++)
		{
			for(int j = 0; j < _height; j++)
			{
				_field[i][j] = orig.getObjectAt(i, j);
			}
		}

		this.keyPressed = orig.keyPressed;

		_trons = new Vector<ITron>();
		for(ITron tron: orig.getTrons()){
			_trons.add(RefTron.getCopy((AbstractTron) tron));
		}
		_turn = orig.getTurn();
		_round = orig.getRound();
		_maxturn = orig.getMaxTurns();
		_gameround = orig.getGameRounds();
	}

	public int getObjectAt(int x, int y)
	{
		return _field[x][y];
	}

	public Vector<ITron> getTrons(){
		return _trons;
	}

	//public Point[] getEnemyPositions(int enemyId)
	//{
	//	Vector<Point> positions = new Vector<Position>();
	//	for (int i = 0; i < _width; i++) {
	//		for (int j = 0; j < _height; j++) {
	//			if(getObjectAt(i,j) == playerTrail(enemyId))
	//				positions.add(new Position(i,j));
	//
	//		}
	//	}
	//	return positions.toArray(new Point[positions.size()]);
	//}

	//TODO
	//public Position getEnemyHead(int enemyId) {
	//	return new Position(1,1);
	//}

	public int getNumOfPlayers(){
		return _trons.size();
	}

	@Override
	public int getRemainingRounds() {
		return _gameround - _round - 1;
	}

	@Override
	public int getRemainingTurns() {
		return _maxturn - _turn - 1;
	}
}
