package jp.ac.nii.icpc2010.tournament;

import java.io.File;
import java.util.List;

import jp.ac.nii.icpc2010.TronException;
import jp.ac.nii.icpc2010.manager.OptionsManager;
import jp.ac.nii.icpc2010.recorder.FileRecorder;

public class Match {
	private Player playerOne, playerTwo;
	private double result;
	private File recording;
	
	public Match(Player one, Player two, File recording, OptionsManager om) {
		super();
		this.playerOne = one;
		this.playerTwo = two;
		this.recording = recording;
		
		// read out the score of the match from the recording
		FileRecorder fr = new FileRecorder(new String[]{one.toString(), two.toString()}, recording.getAbsolutePath(), om);
		try {
			fr.load();
		} catch (TronException e) {
			e.printStackTrace();
			System.exit(1);
		}
		List<Double> scores = fr.getPlayerScores();
		result = scores.get(0)-scores.get(1);
	}

	public Player getPlayerOne() {
		return playerOne;
	}

	public Player getPlayerTwo() {
		return playerTwo;
	}

	public double getResult(Player p) {
		return p == playerOne ? result : -result;
	}

	public File getRecording() {
		return recording;
	}
}
