/*-
 * Javoids -- Javoids is an asteroids based game (that look nothing like the original).
 * 
 * Copyright (C) 1999-2006 Patrick Mallette
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * I can be reached at parickmallette@rogers.com
 */
/*-
 * Title       : Javoids!
 * Description : Java Asteroids Game
 * Copyright   : Copyright (c) 1999-2006
 * 
 * Things to work on :
 *   -Nothing yet.
 * Things Done :
 *   -Nothing yet.
 * Things on Hold:
 *   -Add the image name, sound name to a sprite's information and load from xml file.
 *   -Replace enums of sound and images for sprites with information loaded from the XML file (so they can be changed without the extra coding) 
 *   -Replace hardcoded values with data loaded from an xml file for shapes and colors
 *   -Replace ProgressFrame with the new splash screen when JDK 1.6 is released.
 *   -Modify the icon when iconified when JDK 1.6 is released.
 *   -get JEditorPane to handle the xhtml 1.1 files (it cannot, it only supports HTML 3.2 -- considder removing those features...)
 *   -Line ships (not filled in)
 *   -Make animations using drawing sprites
 *   -Add animation for thrust
 * Things not to bother with (bad support from Sun):
 *   -Full Screen (menu not displaying -- being wiped out; loss of frame; lockups [known race conditions?])
 *     -Must draw own menus apparently
 */
package javoids;

import static javoids.BasicSprite.Collision.NO_COLLISION;
import static javoids.BasicSprite.Gravity.SINK;
import static javoids.BasicSprite.Gravity.SOURCE;
import static javoids.Health.DurationType.AGELESS;
import static javoids.Health.DurationType.IMMORTAL;
import static javoids.Health.DurationType.NORMAL;
import static javoids.ImageMap.Name.GALAXY1;
import static javoids.ImageMap.Name.MISC_CROSSHAIR;
import static javoids.ImageMap.Name.MISC_INFINITE;
import static javoids.ImageMap.Name.MISC_KEYBOARD;
import static javoids.ImageMap.Name.MISC_SOUND;
import static javoids.ImageMap.Name.PACMAN_EATABLE_GHOST;
import static javoids.ImageMap.Name.PACMAN_GHOST;
import static javoids.ImageMap.Name.SHIP1;
import static javoids.KeyMap.Action.ACTION_AFTERBURNER;
import static javoids.KeyMap.Action.ACTION_FIRE;
import static javoids.KeyMap.Action.ACTION_THRUST;
import static javoids.SoundMap.Sound.PACMAN_GAMESTART;
import static javoids.SoundMap.Sound.PACMAN_LEVELUP;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.InputEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.VolatileImage;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ConcurrentModificationException;
import java.util.HashMap;

import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ScrollPaneConstants;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.border.LineBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.MouseInputListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

/**
 * The Javoids Game. This class handles the overall functioning of the game. An asteroids like game.
 * @author Patrick Mallette
 * @version 1.045
 */
public class Javoids extends JApplet implements Runnable,ActionListener,MouseInputListener,KeyListener,MenuKeyListener,ItemListener,ComponentListener,WindowListener,HyperlinkListener
{
  // constants
  /** This is the version used for serializing/deserializing (storing/retrieving) this object */
  private final static long                 serialVersionUID            = 1L;
  /** the parameters for the game */
  private final static transient String[][] JAVOIDSPARMS                = { {Messages.getString("Javoids.Height"),Messages.getString("Javoids.HeightMinimum"),Messages.getString("Javoids.HeightApplet")}, {Messages.getString("Javoids.Width"),Messages.getString("Javoids.WidthMinimum"),Messages.getString("Javoids.WidthApplet")}, {Messages.getString("Javoids.Lives").toUpperCase(),"1-9",Messages.getString("Javoids.NumberOfLives")}}; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$ //$NON-NLS-9$
  /** the minimum screen width */
  private final static int                  MIN_WIDTH                   = 600;
  /** the minimum screen height */
  private final static int                  MIN_HEIGHT                  = 500;
  /** the minimum difficulty level */
  private final static int                  MIN_DIFFICULTY              = 1;
  /** the minimum delay */
  private final static int                  MIN_DELAY                   = 0;
  /** the minimum lives */
  private final static int                  MIN_LIVES                   = 1;
  /** the maximum difficulty */
  private final static int                  MAX_DIFFICULTY              = 10;
  /** the maximum delay */
  private final static int                  MAX_DELAY                   = 1000;
  /** the maximum lives */
  private final static int                  MAX_LIVES                   = 9;
  /** the default difficulty */
  private final static int                  DEFAULT_DIFFICULTY          = 1;
  /** the default delay */
  private final static int                  DEFAULT_DELAY               = 80;
  /** the chance for a singularity (white hole) to create a javoid */
  private final static double               JAVOID_CREATION_CHANCE      = 0.5;                                                                                                                                                                                                                                                                                                                                                                // 100% chance = 1.0 (white hole create Javoid)
  /** one second */
  private final static int                  SECOND                      = 1000;
  /** a list of the number of lives to use */
  private final static transient String[]   livesValues                 = {"1","2","3","4","5","6","7","8","9"};                                                                                                                                                                                                                                                                                                                              //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$ //$NON-NLS-9$
  /** a list of the delays to use */
  private final static transient String[]   delayValues                 = {"1000","900","800","700","600","500","400","300","200","100","90","80","70","60","50","40","30","20","10","9","8","7","6","5","4","3","2","1"};                                                                                                                                                                                                                    //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$ //$NON-NLS-9$ //$NON-NLS-10$ //$NON-NLS-11$ //$NON-NLS-12$ //$NON-NLS-13$ //$NON-NLS-14$ //$NON-NLS-15$ //$NON-NLS-16$ //$NON-NLS-17$ //$NON-NLS-18$ //$NON-NLS-19$ //$NON-NLS-20$ //$NON-NLS-21$ //$NON-NLS-22$ //$NON-NLS-23$ //$NON-NLS-24$ //$NON-NLS-25$ //$NON-NLS-26$ //$NON-NLS-27$ //$NON-NLS-28$
  /** a list of the volume levels to use */
  private final static transient String[]   volumeValues                = {"100","90","80","70","60","50","40","30","20","10","0"};                                                                                                                                                                                                                                                                                                           //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$ //$NON-NLS-9$ //$NON-NLS-10$ //$NON-NLS-11$
  /** a list of the difficulty levels to use */
  private final static transient String[]   difficultyValues            = {"1","2","3","4","5","6","7","8","9","10"};                                                                                                                                                                                                                                                                                                                         //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$ //$NON-NLS-9$ //$NON-NLS-10$
  /** ddelay before beginning play */
  private final static int                  DELAY_PLAYTIMER             = 1000;
  /** delay for reducing the bonus */
  private final static int                  DELAY_BONUS                 = 1000;
  /** delay before showing high score table when the game is over */
  private final static int                  DELAY_HIGHSCORE             = 1000;
  /** bonus to award when a level is complete (starting value) */
  private final static int                  BONUS                       = 10000;
  /** bonus to award when a level is complete (increment value added to starting value * the level) */
  private final static int                  BONUS_INCREMENT             = 1000;
  /** initial delay before a powerup appears */
  private static int                        INITIAL_DELAY_POWERUP       = 2 * Javoids.SECOND;
  /** initial delay before a ship appears */
  private static int                        INITIAL_DELAY_SHIP          = 60 * Javoids.SECOND;
  /** initial delay before a mine appears */
  private static int                        INITIAL_DELAY_MINE          = 120 * Javoids.SECOND;
  /** initial delay before a singularity appears */
  private static int                        INITIAL_DELAY_SINGULARITY   = 180 * Javoids.SECOND;
  /** initial delay before a javoid appears */
  private static int                        INITIAL_DELAY_JAVOID        = 10 * Javoids.SECOND;
  /** initial delay before ghosts are no longer eatable appears */
  private static int                        INITIAL_DELAY_EATABLE_GHOST = 200 * Javoids.SECOND;
  /** default delay before a powerup appears */
  private static int                        DEFAULT_DELAY_POWERUP       = 30 * Javoids.SECOND;
  /** default delay before a ship appears */
  private static int                        DEFAULT_DELAY_SHIP          = 60 * Javoids.SECOND;
  /** default delay before a mine appears */
  private static int                        DEFAULT_DELAY_MINE          = 120 * Javoids.SECOND;
  /** default delay before a singularity appears */
  private static int                        DEFAULT_DELAY_SINGULARITY   = 180 * Javoids.SECOND;
  /** the delay to use before redrawing the screen (in ms) */
  private static int                        delay                       = Javoids.DEFAULT_DELAY;
  /** the mapping of key codes to actions */
  private static KeyMap                     keyMap                      = new KeyMap();
  /** the game display width (not counting menu or status bar areas) */
  private static int                        width                       = Javoids.MIN_WIDTH;
  /** the game display height (not counting menu or status bar areas) */
  private static int                        height                      = Javoids.MIN_HEIGHT;
  /** is the game an applet? */
  private static boolean                    isApplet                    = true;
  /** the frame holding the game */
  private static JFrame                     frame                       = null;
  /** the applet (this) */
  private static Javoids                    applet                      = null;
  /** the user's home directory */
  private static String                     userHome                    = null;
  /** the difficulty level */
  private static int                        difficulty                  = 1;
  /** a list of all javoids */
  private SpriteVector<Javoid>              javoids;
  /** a list of all mines */
  private SpriteVector<Mine>                mines;
  /** a list of all explosions */
  private SpriteVector<Explosion>           explosions;
  /** a list of all powerups */
  private SpriteVector<PowerUp>             powerUps;
  /** a list of all singularities */
  private SpriteVector<Singularity>         singularitys;
  /** a list of all bullets */
  private SpriteVector<Bullet>              bullets;
  /** a list of all ships */
  private SpriteVector<Ship>                ships;
  /** a list of all gravitry points */
  private SpriteVector<GravityPoint>        gravityPlane;
  /** a timer for powerup scheduling */
  private Timer                             powerUpTimer;
  /** a timer for mine scheduling */
  private Timer                             mineTimer;
  /** a timer for singularity scheduling */
  private Timer                             singularityTimer;
  /** a timer for javoid scheduling */
  private Timer                             javoidTimer;
  /** a timer for ship scheduling */
  private Timer                             shipTimer;
  /** a timer for determining when to switch ghosts back so they can't be eaten */
  private Timer                             eatableGhostTimer;
  /** a timer for determining when to decrement the bonus */
  private Timer                             bonusTimer;
  /** a timer for determining when to display the high score table after the game is over */
  private Timer                             highScoreTimer;
  /** a timer for determining how long play was */
  private Timer                             playTimer;
  /** the old game width */
  private int                               oldWidth;
  /** the old game height */
  private int                               oldHeight;
  /** courier new font */
  private Font                              fontCourierNew;
  /** an editor pane to display files */
  private JEditorPane                       editorPane;
  /** a scroll pane to allow scrolling */
  private JScrollPane                       scrollPane;
  /** a panel to display help information */
  private JPanel                            helpPanel;
  /** a dialog to modify the key code to action settings */
  private KeyDialog                         keyDialog;
  /** a popup menu */
  private JPopupMenu                        menuPopup;
  /** the menu bar */
  private JMenuBar                          menuBar;
  /** the file menu */
  private JMenu                             fileMenu;
  /** the file | new menu item */
  private JMenuItem                         fileNew;
  /** the file | high score menu item */
  private JMenuItem                         fileScores;
  /** the file | exit menu item */
  private JMenuItem                         fileExit;
  /** the option menu */
  private JMenu                             optionMenu;
  /** the option | difficulty menu item */
  private JMenuItem                         optionDifficulty;
  /** the option | delay menu item */
  private JMenuItem                         optionDelay;
  /** the option | lives menu item */
  private JMenuItem                         optionLives;
  /** the option | key bindings menu item */
  private JMenuItem                         optionKeyBinding;
  /** the option | user key map menu item */
  private JCheckBoxMenuItem                 optionUserKeyMap;
  /** the option | mouse move menu item */
  private JCheckBoxMenuItem                 optionMouseMove;
  /** the option | sound menu item */
  private JCheckBoxMenuItem                 optionSound;
  /** the option | volume menu item */
  private JMenuItem                         optionVolume;
  /** the option | area checking menu item */
  private JCheckBoxMenuItem                 optionAreaChecking;
  /** the help menu */
  private JMenu                             helpMenu;
  /** the help | readme menu item */
  private JMenuItem                         helpReadMe;
  /** the help | version menu item */
  private JMenuItem                         helpVersion;
  /** the help | license menu item */
  private JMenuItem                         helpLicense;
  /** the help | about menu item */
  private JMenuItem                         helpAbout;
  /** an action to create a new game */
  private AbstractAction                    actionNew;
  /** an action to start a new game */
  private AbstractAction                    actionScores;
  /** an action to exit the game */
  private AbstractAction                    actionExit;
  /** an action to adjust the difficulty */
  private AbstractAction                    actionDifficulty;
  /** an action to ajdust the delay */
  private AbstractAction                    actionDelay;
  /** an action to change the beginning number of lives */
  private AbstractAction                    actionLives;
  /** an action to toggle between the default and user key maps */
  private AbstractAction                    actionUserKeyMap;
  /** an action to toggle between using the keyboard only or keyboard and mouse to move */
  private AbstractAction                    actionMouseMove;
  /** an action to toggle the sound on/off */
  private AbstractAction                    actionSound;
  /** an action to adjust the volume */
  private AbstractAction                    actionVolume;
  /** an action to toggle between area checking and circular bounds collision detection */
  private AbstractAction                    actionAreaChecking;
  /** an action to adjust the key code to action bindings */
  private AbstractAction                    actionKeyBinding;
  /** an action to view the readme file */
  private AbstractAction                    actionReadMe;
  /** an action to view the version file */
  private AbstractAction                    actionVersion;
  /** an action to view the license file */
  private AbstractAction                    actionLicense;
  /** an action to view the about information */
  private AbstractAction                    actionAbout;
  /** the start button */
  private JButton                           startButton;
  /** a lable to display game information */
  private JLabel                            infoLabel;
  /** a panel to display each weapon's ammunition */
  private JPanel                            panelAmmo;
  /** a panel to display game information */
  private JPanel                            infoPanel;
  /** the high score panel */
  private HighScorePanel                    highScorePanel;
  /** an icon for the infinity symbol */
  private ImageIcon                         infiniteIcon;
  /** a line border for decoration of frames */
  private LineBorder                        selectedBorder;
  /** the game canvas where drawing is performed */
  private Canvas                            gameCanvas;
  /** the default cursor */
  private Cursor                            cursorDefault;
  /** the crosshair cursor (for mouse move) */
  private Cursor                            cursorCrosshair;
  /** the graphics context for drawing */
  private transient Graphics2D              graphicsBuffer;
  /** an image to use in double buffering */
  private transient VolatileImage           imageBuffer;
  /** the screen bounds */
  private Rectangle                         screen;
  /** a panel to display the weapon information */
  private HashMap<Item.Type,ToolPanel>      panelWeapon;
  /** a bar to display the health level */
  private JProgressBar                      progressBarHealth;
  /** a bar to display the shield's health level */
  private JProgressBar                      progressBarShield;
  /** a bar to display the amount of a bonus remaining */
  private JProgressBar                      progressBarBonus;
  /** a thread for handling game play */
  private transient volatile Thread         thread;
  /** is this the first game? */
  private boolean                           isFirstGame;
  /** is the game started? */
  private boolean                           isGameStarted;
  /** is the game running? */
  private boolean                           isRunning;
  /** is the game over? */
  private boolean                           isGameOver;
  /** is it a pacman game? */
  private boolean                           isPacmanGame;
  /** are the ghosts edible? */
  private boolean                           isEatableGhost;
  /** is the mouse allowed to move the player */
  private boolean                           isMouseMove;
  /** is the user using his own keymap? */
  private boolean                           isUserKeyMap;
  /** is the sound on? */
  private boolean                           isSound;
  /** is area checking being used? */
  private boolean                           isAreaChecking;
  /** is the screen initialized? */
  private boolean                           isScreenInitialized;
  /** the number of lives a player should have */
  private int                               lives;
  /** the bonus amount of points to award at the end of a level */
  private int                               bonus;
  /** the player's ship */
  private Ship                              shipPlayer;
  /** the mouse's location */
  private Move                              mouseMove;
  /** the game level */
  private int                               level;
  /** the play duration */
  private int                               playTime;
  /** the formatted play duration */
  private String                            duration;

  // Constructor Methods--------------------------------------------------------
  /**
   * Constructor (default)
   */
  public Javoids()
  {
    this(true);
  }

  /**
   * Constructor (default)
   * @param _isApplet is this an applet?
   */
  public Javoids(boolean _isApplet) // used by application
  {
    Image image;
    Dimension dimensions;
    Point location;
    ProgressFrame progressFrame;
    System.out.printf((_isApplet ? Messages.getString("Javoids.ConstructorNameDefault") : Messages.getString("Javoids.ConstructorNameApplet"))); //$NON-NLS-1$ //$NON-NLS-2$
    Javoids.isApplet = _isApplet;
    // initialize the weird stuff Sun makes you call
    JPopupMenu.setDefaultLightWeightPopupEnabled(false);
    ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
    // initialize the shared static resources
    image = Toolkit.getDefaultToolkit().getImage(this.getClass().getResource(Messages.getString("Javoids.SnapShot"))).getScaledInstance(400,400,Image.SCALE_DEFAULT); //$NON-NLS-1$
    dimensions = new Dimension(400,400);
    location = new Point((int)(Toolkit.getDefaultToolkit().getScreenSize().getWidth() - dimensions.getWidth()) / 2,(int)(Toolkit.getDefaultToolkit().getScreenSize().getHeight() - dimensions.getHeight()) / 2);
    progressFrame = new ProgressFrame(Messages.getString("Javoids.IsLoading"),image,location,dimensions); //$NON-NLS-1$
    progressFrame.setVisible(true);
    progressFrame.setString(Messages.getString("Javoids.LoadKeyboard")); //$NON-NLS-1$
    progressFrame.setValue(90);
    progressFrame.setString(Messages.getString("Javoids.BuildUI")); //$NON-NLS-1$
    // initialize classes with static data
    BasicSprite.setAreaChecking(this.isAreaChecking);
    progressFrame.setValue(100);
    progressFrame.setString(Messages.getString("Javoids.StartingApplication")); //$NON-NLS-1$
    progressFrame.dispose();
    progressFrame = null;
  }

  /**
   * The main program when started as an application (never called when run as an applet)
   * @param args a list of arguments passed to the program
   */
  public static void main(String[] args)
  {
    System.out.printf(Messages.getString("Javoids.Main")); //$NON-NLS-1$
    Javoids.applet = new Javoids(false);
    Javoids.applet.init();
    Javoids.frame = new JFrame(String.format(Messages.getString("Javoids.TitleVersion"),Messages.getString("Javoids.Javoids!"),Messages.getString("Javoids.VersionNumber"))); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
    // set initial location for the current frame size
    Javoids.frame.setLocation((int)(Toolkit.getDefaultToolkit().getScreenSize().getWidth() - Javoids.MIN_WIDTH) / 2,(int)(Toolkit.getDefaultToolkit().getScreenSize().getHeight() - Javoids.MIN_HEIGHT) / 2);
    Javoids.frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    Javoids.frame.addWindowListener(Javoids.applet);
    Javoids.frame.addKeyListener(Javoids.applet);
    Javoids.frame.addMouseListener(Javoids.applet);
    Javoids.frame.addComponentListener(Javoids.applet);
    Javoids.frame.add(Javoids.applet);
    Javoids.frame.setIconImage(Media.getImage(SHIP1));
    Javoids.frame.pack();
    Javoids.frame.setVisible(true);
    // set initial location for the current frame size (the full size after all components added)
    Javoids.frame.setLocation((int)(Toolkit.getDefaultToolkit().getScreenSize().getWidth() - Javoids.frame.getWidth()) / 2,(int)(Toolkit.getDefaultToolkit().getScreenSize().getHeight() - Javoids.frame.getHeight()) / 2);
    Javoids.applet.start();
    Javoids.applet.getRootPane().setDefaultButton(Javoids.applet.startButton);
    Javoids.applet.startButton.requestFocus();
  }

  /**
   * Initialize the applet/application.
   */
  /*
   * (non-Javadoc)
   * @see java.applet.Applet#init()
   */
  @Override
  public void init()
  {
    super.init();
    System.out.printf(Messages.getString("Javoids.Init")); //$NON-NLS-1$
    // initialize the GUI
    this.panelWeapon = new HashMap<Item.Type,ToolPanel>(Item.Type.values().length);
    this.fontCourierNew = new Font(Messages.getString("Javoids.FontCourierNew"),Font.PLAIN,12); //$NON-NLS-1$
    this.editorPane = new JEditorPane();
    this.scrollPane = new JScrollPane(ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS,ScrollPaneConstants.HORIZONTAL_SCROLLBAR_ALWAYS);
    this.helpPanel = new JPanel();
    this.cursorDefault = new Cursor(Cursor.DEFAULT_CURSOR);
    this.cursorCrosshair = new Cursor(Cursor.CROSSHAIR_CURSOR);
    this.screen = new Rectangle(0,0,Javoids.MIN_WIDTH,Javoids.MIN_HEIGHT);
    this.isFirstGame = true; // start a new game
    this.isGameStarted = false; // switch to get screen size if a new game has started
    this.isRunning = false; // Is the game running or paused (yes/no)
    this.isGameOver = false; // game over (yes/no)
    this.isPacmanGame = false; // playing pacman (yes/no)
    this.isEatableGhost = false; // ate powerpill so ok to eat ghosts in pacman game (yes/no)
    this.isMouseMove = false; // does the player's ship respond to mouse movement
    this.isUserKeyMap = true; // is the user keymap supposed to be used?
    this.isSound = true; // is the sound active?
    this.isAreaChecking = false; // should collisions be detected by areas? if false detect by circles
    this.lives = Health.DEFAULT_DEATHS;
    this.level = 1;
    // set up the sprite containers
    this.javoids = new SpriteVector<Javoid>(Javoid.MAX_NUMBER);
    this.mines = new SpriteVector<Mine>(Mine.MAX_NUMBER);
    this.explosions = new SpriteVector<Explosion>(Explosion.MAX_NUMBER);
    this.powerUps = new SpriteVector<PowerUp>(PowerUp.MAX_NUMBER);
    this.singularitys = new SpriteVector<Singularity>(Singularity.MAX_NUMBER);
    this.bullets = new SpriteVector<Bullet>(Bullet.MAX_NUMBER);
    this.ships = new SpriteVector<Ship>(Ship.MAX_NUMBER);
    this.gravityPlane = new SpriteVector<GravityPoint>(GravityPoint.MAX_NUMBER);
    this.mouseMove = new Move(new Rectangle(0,0,Javoids.MIN_WIDTH,Javoids.MIN_HEIGHT),0,0,0,0); // dummy move for use tracking mouse only x,y used
    // setup timers
    this.powerUpTimer = new Timer(Javoids.INITIAL_DELAY_POWERUP,this);
    this.mineTimer = new Timer(Javoids.INITIAL_DELAY_MINE,this);
    this.singularityTimer = new Timer(Javoids.INITIAL_DELAY_SINGULARITY,this);
    this.javoidTimer = new Timer(Javoids.INITIAL_DELAY_JAVOID,this);
    this.shipTimer = new Timer(Javoids.INITIAL_DELAY_SHIP,this);
    this.bonusTimer = new Timer(Javoids.DELAY_BONUS,this);
    this.playTimer = new Timer(Javoids.DELAY_PLAYTIMER,this);
    // create miscelaneous components for help
    this.editorPane.setBorder(this.selectedBorder);
    this.editorPane.setFont(this.fontCourierNew);
    this.editorPane.setEditable(false);
    this.editorPane.setContentType(Messages.getString("Javoids.TextPlain")); //$NON-NLS-1$
    this.editorPane.setPreferredSize(new Dimension(750,600));
    this.editorPane.setSize(this.editorPane.getPreferredSize());
    this.editorPane.addHyperlinkListener(this);
    this.scrollPane.setViewportView(this.editorPane);
    this.scrollPane.setPreferredSize(this.editorPane.getSize());
    this.scrollPane.setSize(this.scrollPane.getPreferredSize());
    this.helpPanel.setBorder(this.selectedBorder);
    this.helpPanel.add(this.scrollPane);
    // create actions
    this.actionNew = new AbstractAction(Messages.getString("Javoids.NewGame")) //$NON-NLS-1$
    {
      private final static long serialVersionUID = 1L;

      @SuppressWarnings("unused")
      public void actionPerformed(ActionEvent actionEvent)
      {
        Javoids.this.actionPerformedNew();
      }
    };
    this.actionNew.putValue(Action.ACCELERATOR_KEY,KeyStroke.getKeyStroke(KeyEvent.VK_N,InputEvent.ALT_MASK));
    this.actionNew.putValue(Action.MNEMONIC_KEY,Integer.valueOf(KeyStroke.getKeyStroke(KeyEvent.VK_N,InputEvent.ALT_MASK).getKeyCode()));
    this.actionScores = new AbstractAction(Messages.getString("Javoids.HighScores")) //$NON-NLS-1$
    {
      private final static long serialVersionUID = 1L;

      public void actionPerformed(@SuppressWarnings("unused")
      ActionEvent actionEvent)
      {
        Javoids.this.actionPerformedScores();
      }
    };
    this.actionScores.putValue(Action.ACCELERATOR_KEY,KeyStroke.getKeyStroke(KeyEvent.VK_G,InputEvent.ALT_MASK));
    this.actionScores.putValue(Action.MNEMONIC_KEY,Integer.valueOf(KeyStroke.getKeyStroke(KeyEvent.VK_G,InputEvent.ALT_MASK).getKeyCode()));
    this.actionExit = new AbstractAction(Messages.getString("Javoids.ExitGame")) //$NON-NLS-1$
    {
      private final static long serialVersionUID = 1L;

      public void actionPerformed(@SuppressWarnings("unused")
      ActionEvent actionEvent)
      {
        Javoids.this.actionPerformedExit();
      }
    };
    this.actionExit.putValue(Action.ACCELERATOR_KEY,KeyStroke.getKeyStroke(KeyEvent.VK_X,InputEvent.ALT_MASK));
    this.actionExit.putValue(Action.MNEMONIC_KEY,Integer.valueOf(KeyStroke.getKeyStroke(KeyEvent.VK_X,InputEvent.ALT_MASK).getKeyCode()));
    this.actionDifficulty = new AbstractAction(Messages.getString("Javoids.Difficulty")) //$NON-NLS-1$
    {
      private final static long serialVersionUID = 1L;

      public void actionPerformed(@SuppressWarnings("unused")
      ActionEvent actionEvent)
      {
        Javoids.this.actionPerformedDifficulty();
      }
    };
    this.actionDifficulty.putValue(Action.ACCELERATOR_KEY,KeyStroke.getKeyStroke(KeyEvent.VK_I,InputEvent.ALT_MASK));
    this.actionDifficulty.putValue(Action.MNEMONIC_KEY,Integer.valueOf(KeyStroke.getKeyStroke(KeyEvent.VK_I,InputEvent.ALT_MASK).getKeyCode()));
    this.actionDelay = new AbstractAction(Messages.getString("Javoids.Delay")) //$NON-NLS-1$
    {
      private final static long serialVersionUID = 1L;

      public void actionPerformed(@SuppressWarnings("unused")
      ActionEvent actionEvent)
      {
        Javoids.this.actionPerformedDelay();
      }
    };
    this.actionDelay.putValue(Action.ACCELERATOR_KEY,KeyStroke.getKeyStroke(KeyEvent.VK_D,InputEvent.ALT_MASK));
    this.actionDelay.putValue(Action.MNEMONIC_KEY,Integer.valueOf(KeyStroke.getKeyStroke(KeyEvent.VK_D,InputEvent.ALT_MASK).getKeyCode()));
    this.actionLives = new AbstractAction(Messages.getString("Javoids.Lives")) //$NON-NLS-1$
    {
      private final static long serialVersionUID = 1L;

      public void actionPerformed(@SuppressWarnings("unused")
      ActionEvent actionEvent)
      {
        Javoids.this.actionPerformedLives();
      }
    };
    this.actionLives.putValue(Action.ACCELERATOR_KEY,KeyStroke.getKeyStroke(KeyEvent.VK_L,InputEvent.ALT_MASK));
    this.actionLives.putValue(Action.MNEMONIC_KEY,Integer.valueOf(KeyStroke.getKeyStroke(KeyEvent.VK_L,InputEvent.ALT_MASK).getKeyCode()));
    this.actionKeyBinding = new AbstractAction(Messages.getString("Javoids.EditKeyboard")) //$NON-NLS-1$
    {
      private final static long serialVersionUID = 1L;

      public void actionPerformed(@SuppressWarnings("unused")
      ActionEvent actionEvent)
      {
        Javoids.this.actionPerformedKeyBinding();
      }
    };
    this.actionKeyBinding.putValue(Action.ACCELERATOR_KEY,KeyStroke.getKeyStroke(KeyEvent.VK_K,InputEvent.ALT_MASK));
    this.actionKeyBinding.putValue(Action.MNEMONIC_KEY,Integer.valueOf(KeyStroke.getKeyStroke(KeyEvent.VK_K,InputEvent.ALT_MASK).getKeyCode()));
    this.actionUserKeyMap = new AbstractAction(Messages.getString("Javoids.UserKeyMap")) //$NON-NLS-1$
    {
      private final static long serialVersionUID = 1L;

      public void actionPerformed(@SuppressWarnings("unused")
      ActionEvent actionEvent)
      {
        Javoids.this.actionPerformedKeyMap();
      }
    };
    this.actionUserKeyMap.putValue(Action.ACCELERATOR_KEY,KeyStroke.getKeyStroke(KeyEvent.VK_U,InputEvent.ALT_MASK));
    this.actionUserKeyMap.putValue(Action.MNEMONIC_KEY,Integer.valueOf(KeyStroke.getKeyStroke(KeyEvent.VK_U,InputEvent.ALT_MASK).getKeyCode()));
    this.actionMouseMove = new AbstractAction(Messages.getString("Javoids.MouseOver")) //$NON-NLS-1$
    {
      private final static long serialVersionUID = 1L;

      public void actionPerformed(@SuppressWarnings("unused")
      ActionEvent actionEvent)
      {
        Javoids.this.actionPerformedMouseMove();
      }
    };
    this.actionMouseMove.putValue(Action.ACCELERATOR_KEY,KeyStroke.getKeyStroke(KeyEvent.VK_M,InputEvent.ALT_MASK));
    this.actionMouseMove.putValue(Action.MNEMONIC_KEY,Integer.valueOf(KeyStroke.getKeyStroke(KeyEvent.VK_M,InputEvent.ALT_MASK).getKeyCode()));
    this.actionSound = new AbstractAction(Messages.getString("Javoids.Sound")) //$NON-NLS-1$
    {
      private final static long serialVersionUID = 1L;

      public void actionPerformed(@SuppressWarnings("unused")
      ActionEvent actionEvent)
      {
        Javoids.this.actionPerformedSound();
      }
    };
    this.actionSound.putValue(Action.ACCELERATOR_KEY,KeyStroke.getKeyStroke(KeyEvent.VK_S,InputEvent.ALT_MASK));
    this.actionSound.putValue(Action.MNEMONIC_KEY,Integer.valueOf(KeyStroke.getKeyStroke(KeyEvent.VK_S,InputEvent.ALT_MASK).getKeyCode()));
    this.actionVolume = new AbstractAction(Messages.getString("Javoids.Volume")) //$NON-NLS-1$
    {
      private final static long serialVersionUID = 1L;

      public void actionPerformed(@SuppressWarnings("unused")
      ActionEvent actionEvent)
      {
        Javoids.this.actionPerformedVolume();
      }
    };
    this.actionVolume.putValue(Action.ACCELERATOR_KEY,KeyStroke.getKeyStroke(KeyEvent.VK_S,InputEvent.ALT_MASK));
    this.actionVolume.putValue(Action.MNEMONIC_KEY,Integer.valueOf(KeyStroke.getKeyStroke(KeyEvent.VK_S,InputEvent.ALT_MASK).getKeyCode()));
    this.actionAreaChecking = new AbstractAction(Messages.getString("Javoids.AreaCollisionChecking")) //$NON-NLS-1$
    {
      private final static long serialVersionUID = 1L;

      public void actionPerformed(@SuppressWarnings("unused")
      ActionEvent actionEvent)
      {
        Javoids.this.actionPerformedAreaChecking();
      }
    };
    this.actionAreaChecking.putValue(Action.ACCELERATOR_KEY,KeyStroke.getKeyStroke(KeyEvent.VK_R,InputEvent.ALT_MASK));
    this.actionAreaChecking.putValue(Action.MNEMONIC_KEY,Integer.valueOf(KeyStroke.getKeyStroke(KeyEvent.VK_R,InputEvent.ALT_MASK).getKeyCode()));
    this.actionReadMe = new AbstractAction(Messages.getString("Javoids.ReadMe")) //$NON-NLS-1$
    {
      private final static long serialVersionUID = 1L;

      public void actionPerformed(@SuppressWarnings("unused")
      ActionEvent actionEvent)
      {
        Javoids.this.actionPerformedReadMe();
      }
    };
    this.actionVersion = new AbstractAction(Messages.getString("Javoids.Version")) //$NON-NLS-1$
    {
      private final static long serialVersionUID = 1L;

      public void actionPerformed(@SuppressWarnings("unused")
      ActionEvent actionEvent)
      {
        Javoids.this.actionPerformedVersion();
      }
    };
    this.actionLicense = new AbstractAction(Messages.getString("Javoids.License")) //$NON-NLS-1$
    {
      private final static long serialVersionUID = 1L;

      public void actionPerformed(@SuppressWarnings("unused")
      ActionEvent actionEvent)
      {
        Javoids.this.actionPerformedLicense();
      }
    };
    this.actionAbout = new AbstractAction(Messages.getString("Javoids.HelpAbout")) //$NON-NLS-1$
    {
      private final static long serialVersionUID = 1L;

      public void actionPerformed(@SuppressWarnings("unused")
      ActionEvent actionEvent)
      {
        Javoids.this.actionPerformedAbout();
      }
    };
    // create menu bar, menus, menu items
    this.menuPopup = new JPopupMenu();
    this.menuBar = new JMenuBar();
    this.fileMenu = new JMenu(Messages.getString("Javoids.File")); //$NON-NLS-1$
    this.fileMenu.setMnemonic(KeyEvent.VK_F);
    this.optionMenu = new JMenu(Messages.getString("Javoids.Options")); //$NON-NLS-1$
    this.optionMenu.setMnemonic(KeyEvent.VK_O);
    this.helpMenu = new JMenu(Messages.getString("Javoids.Help")); //$NON-NLS-1$
    this.helpMenu.setMnemonic(KeyEvent.VK_H);
    // create menus and set actions to menu items
    this.fileNew = new JMenuItem(this.actionNew);
    this.fileScores = new JMenuItem(this.actionScores);
    this.fileExit = new JMenuItem(this.actionExit);
    this.optionDifficulty = new JMenuItem(this.actionDifficulty);
    this.optionDelay = new JMenuItem(this.actionDelay);
    this.optionLives = new JMenuItem(this.actionLives);
    this.optionKeyBinding = new JMenuItem(this.actionKeyBinding);
    this.optionUserKeyMap = new JCheckBoxMenuItem(this.actionUserKeyMap);
    this.optionUserKeyMap.setState(this.isUserKeyMap);
    this.optionMouseMove = new JCheckBoxMenuItem(this.actionMouseMove);
    this.optionMouseMove.setState(this.isMouseMove);
    this.optionSound = new JCheckBoxMenuItem(this.actionSound);
    this.optionSound.setState(this.isSound);
    this.optionVolume = new JMenuItem(this.actionVolume);
    this.optionAreaChecking = new JCheckBoxMenuItem(this.actionAreaChecking);
    this.optionAreaChecking.setState(BasicSprite.setAreaChecking(this.isAreaChecking));
    this.helpReadMe = new JMenuItem(this.actionReadMe);
    this.helpVersion = new JMenuItem(this.actionVersion);
    this.helpLicense = new JMenuItem(this.actionLicense);
    this.helpAbout = new JMenuItem(this.actionAbout);
    // add all menu items to their respective menus
    this.fileMenu.add(this.fileNew);
    this.fileMenu.add(this.fileScores);
    this.fileMenu.addSeparator();
    this.fileMenu.add(this.fileExit);
    this.optionMenu.add(this.optionVolume);
    this.optionMenu.add(this.optionDifficulty);
    this.optionMenu.add(this.optionDelay);
    this.optionMenu.add(this.optionLives);
    this.optionMenu.add(this.optionKeyBinding);
    this.optionMenu.addSeparator();
    this.optionMenu.add(this.optionUserKeyMap);
    this.optionMenu.add(this.optionMouseMove);
    this.optionMenu.add(this.optionSound);
    this.optionMenu.add(this.optionAreaChecking);
    this.helpMenu.add(this.helpReadMe);
    this.helpMenu.add(this.helpVersion);
    this.helpMenu.add(this.helpLicense);
    this.helpMenu.addSeparator();
    this.helpMenu.add(this.helpAbout);
    // add the menu items to the popup menu
    this.menuPopup.add(this.actionNew);
    this.menuPopup.add(this.actionScores);
    this.menuPopup.add(this.actionExit);
    this.menuPopup.addSeparator();
    this.menuPopup.add(this.actionVolume);
    this.menuPopup.add(this.actionKeyBinding);
    this.menuPopup.addSeparator();
    this.menuPopup.add(this.actionUserKeyMap);
    this.menuPopup.add(this.actionMouseMove);
    this.menuPopup.add(this.actionSound);
    this.menuPopup.add(this.actionAreaChecking);
    this.menuPopup.addSeparator();
    this.menuPopup.add(this.actionAbout);
    // add the this.menus to the this.menu bar
    this.menuBar.add(this.fileMenu);
    this.menuBar.add(this.optionMenu);
    this.menuBar.add(this.helpMenu);
    // set the menu listeners and preferred sizes (must be done after menus added to menubar
    this.menuBar.setSize(this.menuBar.getPreferredSize());
    Component[] components = this.menuBar.getComponents();
    for (Component element : components)
    {
      if (element instanceof JMenu)
      {
        ((JMenu)element).setSize(((JMenu)element).getPreferredSize());
        ((JMenu)element).addMenuKeyListener(this);
        ((JMenu)element).addItemListener(this);
      }
      Component[] subComponents = ((JMenu)element).getMenuComponents();
      for (Component element0 : subComponents)
        if (element0 instanceof JMenuItem)
          ((JMenuItem)element0).setSize(((JMenuItem)element0).getPreferredSize());
    }
    // set action and menu icons
    this.optionMouseMove.setIcon(new ImageIcon(Media.getScaledImage(MISC_CROSSHAIR,this.optionMouseMove.getHeight(),this.optionMouseMove.getHeight(),Image.SCALE_DEFAULT)));
    this.optionUserKeyMap.setIcon(new ImageIcon(Media.getScaledImage(MISC_KEYBOARD,this.optionUserKeyMap.getHeight(),this.optionUserKeyMap.getHeight(),Image.SCALE_DEFAULT)));
    this.optionSound.setIcon(new ImageIcon(Media.getScaledImage(MISC_SOUND,this.optionSound.getHeight(),this.optionSound.getHeight(),Image.SCALE_DEFAULT)));
    this.optionVolume.setIcon(new ImageIcon(Media.getScaledImage(MISC_SOUND,this.optionVolume.getHeight(),this.optionVolume.getHeight(),Image.SCALE_DEFAULT)));
    this.actionUserKeyMap.putValue(Action.SMALL_ICON,new ImageIcon(Media.getScaledImage(MISC_KEYBOARD,this.optionMouseMove.getHeight(),this.optionMouseMove.getHeight(),Image.SCALE_DEFAULT)));
    this.actionMouseMove.putValue(Action.SMALL_ICON,new ImageIcon(Media.getScaledImage(MISC_CROSSHAIR,this.optionUserKeyMap.getHeight(),this.optionUserKeyMap.getHeight(),Image.SCALE_DEFAULT)));
    this.actionSound.putValue(Action.SMALL_ICON,new ImageIcon(Media.getScaledImage(MISC_SOUND,this.optionSound.getHeight(),this.optionSound.getHeight(),Image.SCALE_DEFAULT)));
    this.actionVolume.putValue(Action.SMALL_ICON,new ImageIcon(Media.getScaledImage(MISC_SOUND,this.optionVolume.getHeight(),this.optionVolume.getHeight(),Image.SCALE_DEFAULT)));
    this.startButton = new JButton(Messages.getString("Javoids.StartGame")); //$NON-NLS-1$
    this.startButton.setSize(this.startButton.getPreferredSize());
    this.startButton.setDefaultCapable(true);
    this.startButton.addActionListener(this);
    this.startButton.addKeyListener(this);
    this.startButton.setAction(this.actionNew);
    this.startButton.setVisible(true);
    this.infoLabel = new JLabel(Messages.getString("Javoids.Javoids!")); //$NON-NLS-1$
    this.infoLabel.setSize(this.infoLabel.getPreferredSize());
    this.infoLabel.setVisible(true);
    this.infoLabel.addKeyListener(this);
    this.progressBarBonus = new JProgressBar(0,0);
    this.progressBarBonus.setPreferredSize(new Dimension(50,this.infoLabel.getHeight()));
    this.progressBarBonus.setSize(this.progressBarBonus.getPreferredSize());
    this.progressBarBonus.setIndeterminate(false);
    this.progressBarBonus.setString(Messages.getString("Javoids.Bonus")); //$NON-NLS-1$
    this.progressBarBonus.setStringPainted(true);
    this.progressBarHealth = new JProgressBar(0,0);
    this.progressBarHealth.setPreferredSize(new Dimension(50,this.infoLabel.getHeight()));
    this.progressBarHealth.setSize(this.progressBarHealth.getPreferredSize());
    this.progressBarHealth.setIndeterminate(false);
    this.progressBarHealth.setString(Messages.getString("Javoids.Health")); //$NON-NLS-1$
    this.progressBarHealth.setStringPainted(true);
    this.progressBarShield = new JProgressBar(0,0);
    this.progressBarShield.setPreferredSize(new Dimension(50,this.infoLabel.getHeight()));
    this.progressBarShield.setSize(this.progressBarShield.getPreferredSize());
    this.progressBarShield.setIndeterminate(false);
    this.progressBarShield.setString(Messages.getString("Javoids.Shield")); //$NON-NLS-1$
    this.progressBarShield.setStringPainted(true);
    this.panelAmmo = new JPanel(new FlowLayout(FlowLayout.LEFT,0,0));
    this.panelAmmo.setSize(this.panelAmmo.getPreferredSize());
    this.panelAmmo.setVisible(true);
    this.panelAmmo.addKeyListener(this);
    this.infiniteIcon = new ImageIcon(Media.getScaledImage(MISC_INFINITE,15,15,Image.SCALE_DEFAULT));
    this.selectedBorder = (LineBorder)BorderFactory.createLineBorder(Color.black);
    this.panelAmmo.setMinimumSize(this.panelAmmo.getMinimumSize());
    this.panelAmmo.setPreferredSize(this.panelAmmo.getMinimumSize());
    this.panelAmmo.setSize(this.panelAmmo.getMinimumSize());
    this.panelAmmo.validate();
    this.infoPanel = new JPanel(new GridBagLayout());
    this.infoPanel.add(this.infoLabel,new GridBagConstraints(0,0,1,1,1.0,0.0,GridBagConstraints.NORTHWEST,GridBagConstraints.HORIZONTAL,new Insets(0,0,0,0),0,0));
    this.infoPanel.add(this.progressBarBonus,new GridBagConstraints(1,0,1,1,1.0,0.0,GridBagConstraints.NORTHWEST,GridBagConstraints.HORIZONTAL,new Insets(0,0,0,0),0,0));
    this.infoPanel.add(this.progressBarHealth,new GridBagConstraints(2,0,1,1,1.0,0.0,GridBagConstraints.NORTHWEST,GridBagConstraints.HORIZONTAL,new Insets(0,0,0,0),0,0));
    this.infoPanel.add(this.progressBarShield,new GridBagConstraints(3,0,1,1,1.0,0.0,GridBagConstraints.NORTHWEST,GridBagConstraints.HORIZONTAL,new Insets(0,0,0,0),0,0));
    this.infoPanel.add(this.panelAmmo,new GridBagConstraints(0,1,4,1,0.0,0.0,GridBagConstraints.NORTHWEST,GridBagConstraints.HORIZONTAL,new Insets(0,0,0,0),0,0));
    this.infoPanel.setMinimumSize(new Dimension((int)this.infoPanel.getMinimumSize().getWidth(),(int)(this.infoPanel.getMinimumSize().getHeight() + this.panelAmmo.getMinimumSize().getHeight())));
    this.infoPanel.setPreferredSize(this.infoPanel.getMinimumSize());
    this.infoPanel.setSize(this.infoPanel.getMinimumSize());
    this.infoPanel.validate();
    this.infoPanel.setVisible(true);
    this.infoPanel.addKeyListener(this);
    this.gameCanvas = new Canvas();
    this.gameCanvas.setSize(Javoids.MIN_WIDTH,Javoids.MIN_HEIGHT);
    this.gameCanvas.setVisible(true);
    this.gameCanvas.addMouseListener(this); // allow click on game play area to regain key control
    this.gameCanvas.addMouseMotionListener(this); // allows detecting where the mouse is
    this.gameCanvas.addKeyListener(this);
    // set menus
    this.setJMenuBar(this.menuBar);
    this.setLayout(new GridBagLayout());
    this.add(this.infoPanel,new GridBagConstraints(0,0,1,1,1.0,0.0,GridBagConstraints.NORTH,GridBagConstraints.HORIZONTAL,new Insets(0,0,0,0),0,0));
    this.add(this.gameCanvas,new GridBagConstraints(0,1,1,1,1.0,1.0,GridBagConstraints.CENTER,GridBagConstraints.BOTH,new Insets(0,0,0,0),0,0));
    this.add(this.startButton,new GridBagConstraints(0,2,1,1,1.0,0.0,GridBagConstraints.SOUTH,GridBagConstraints.HORIZONTAL,new Insets(0,0,0,0),0,0));
    this.menuPopup.setInvoker(this);
    // always display mnemonic on Windows 2000, XP
    this.getRootPane().getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW).put(KeyStroke.getKeyStroke(KeyEvent.VK_ALT,Event.ALT_MASK,false),Messages.getString("Javoids.Repaint")); //$NON-NLS-1$
    // only allow an exit when run as an application
    if (Javoids.isApplet)
      this.fileExit.setEnabled(false);
    this.setVisible(true);
    this.keyDialog = new KeyDialog(Javoids.frame,Messages.getString("Javoids.KeyboardLayoutEditor"),true); //$NON-NLS-1$
    if (this.isMouseMove)
      this.setCursor(this.isMouseMove ? this.cursorDefault : this.cursorCrosshair);
    Media.setIsSound(this.optionSound.getState());
    Media.setVolume(50);
    this.addComponentListener(this);
    if (Javoids.isApplet)
    {
      try
      {
        String parameterString;
        parameterString = this.getParameter(Messages.getString("Javoids.Width")); //$NON-NLS-1$
        Javoids.width = parameterString == null ? Javoids.width : Integer.parseInt(parameterString);
        Javoids.width = Javoids.width > Javoids.MIN_WIDTH ? Javoids.width : Javoids.MIN_WIDTH;
        parameterString = this.getParameter(Messages.getString("Javoids.Height")); //$NON-NLS-1$
        Javoids.height = parameterString == null ? Javoids.height : Integer.parseInt(parameterString);
        Javoids.height = Javoids.height > Javoids.MIN_HEIGHT ? Javoids.height : Javoids.MIN_HEIGHT;
        this.setSize(new Dimension(Javoids.width,Javoids.height));
        parameterString = this.getParameter(Messages.getString("Javoids.Difficulty").toUpperCase()); //$NON-NLS-1$
        Javoids.difficulty = parameterString == null ? Javoids.difficulty : Integer.parseInt(parameterString);
        Javoids.difficulty = Javoids.difficulty > Javoids.MIN_DIFFICULTY && Javoids.difficulty < Javoids.MAX_DIFFICULTY ? Javoids.difficulty : Javoids.DEFAULT_DIFFICULTY;
        this.setDifficulty(Javoids.difficulty);
        parameterString = this.getParameter(Messages.getString("Javoids.DelayText")); //$NON-NLS-1$
        Javoids.delay = parameterString == null ? Javoids.delay : Integer.parseInt(parameterString);
        Javoids.delay = Javoids.delay > Javoids.MIN_DELAY && Javoids.delay < Javoids.MAX_DELAY ? Javoids.delay : Javoids.DEFAULT_DELAY;
        parameterString = this.getParameter(Messages.getString("Javoids.Lives").toUpperCase()); //$NON-NLS-1$
        this.lives = parameterString == null ? this.lives : Integer.parseInt(parameterString);
        this.lives = this.lives > Javoids.MIN_LIVES && this.lives < Javoids.MAX_LIVES ? this.lives : Health.DEFAULT_DEATHS;
        parameterString = this.getParameter(Messages.getString("Javoids.Pacman")); //$NON-NLS-1$
        this.isPacmanGame = Boolean.valueOf(parameterString).booleanValue();
      }
      catch (NullPointerException nullPointerException)
      {
        System.out.printf(Messages.getString("Javoids.ErrorProblemParameters"),nullPointerException.getMessage()); //$NON-NLS-1$
        // if the parameters failed to be set in the HTML, then set them to the defaults
        Javoids.width = Javoids.MIN_WIDTH;
        Javoids.height = Javoids.MIN_HEIGHT;
        this.setSize(new Dimension(Javoids.width,Javoids.height));
        Javoids.difficulty = Javoids.DEFAULT_DIFFICULTY;
        this.setDifficulty(Javoids.difficulty);
        Javoids.delay = Javoids.DEFAULT_DELAY;
        this.lives = Health.DEFAULT_DEATHS;
        this.isPacmanGame = false;
      }
    }
    this.addMouseListener(this); // don't activate listeners until game made
    this.addKeyListener(this); // don't activate listeners until game made
    this.gameCanvas.requestFocus(); // this is required here
    this.setVisible(true);
  }

  /**
   * Start the applet/application.
   */
  /*
   * (non-Javadoc)
   * @see java.applet.Applet#start()
   */
  @Override
  public void start()
  {
    System.out.printf(Messages.getString("Javoids.Start")); //$NON-NLS-1$
    this.startButton.setEnabled(true);
    if (this.isFirstGame)
    {
      this.screen = new Rectangle(0,0,this.getGameWidth(),this.screen.height);
      this.mouseMove.setScreen(this.screen);
      if (this.isUserKeyMap && this.checkSecurityUserHome() && this.checkSecurityKeyboard())
      {
        URL url;
        try
        {
          url = new URL(String.format(Messages.getString("Javoids.FileFormat"),System.getProperty(Messages.getString("Javoids.UserHome")),File.separator,Messages.getString("Javoids.KeyboardProperties"))); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
          if (!Javoids.keyMap.load(url))
            Javoids.keyMap.reset();
        }
        catch (MalformedURLException malformedURLException)
        {
          System.out.printf(Messages.getString("Javoids.MalformedURL"),malformedURLException.getMessage()); //$NON-NLS-1$
        }
      }
      else
        Javoids.keyMap.reset();
      this.keyDialog.setKeyMap(Javoids.keyMap);
    }
    if (this.thread == null)
    {
      this.thread = new Thread(this); // only make one thread and reuse it (don't set it to null until done)
      this.thread.start();
    }
  }

  /**
   * Stop the applet/application.
   */
  /*
   * (non-Javadoc)
   * @see java.applet.Applet#stop()
   */
  @Override
  public void stop()
  {
    if (Debug.debug)
      System.out.printf(Messages.getString("Javoids.Stop")); //$NON-NLS-1$
    this.stopTimers();
    this.thread = null;
  }

  /**
   * Run the applet/application (handle game play, displays etc).
   */
  /*
   * (non-Javadoc)
   * @see java.lang.Runnable#run()
   */
  public void run()
  {
    Thread thisThread = Thread.currentThread();
    if (Debug.debug)
      System.out.printf(Messages.getString("Javoids.Run")); //$NON-NLS-1$
    while (this.thread.equals(thisThread))
    {
      if (!this.isFirstGame)
        this.handleGamePlay();
      this.repaint();
      try
      {
        Thread.sleep(Javoids.delay);
      }
      catch (InterruptedException interruptedException)
      {
        System.out.printf(Messages.getString("Javoids.ErrorGameInterrupted"),interruptedException.getMessage()); //$NON-NLS-1$
      }
    }
  }

  /**
   * @return the game canvas' width
   */
  private int getGameWidth()
  {
    return this.getWidth();
  }

  /**
   * @return the game canvas' height
   */
  private int getGameHeight()
  {
    return this.getHeight() - this.menuBar.getHeight() - (this.isFirstGame ? 0 : this.infoPanel.getHeight()) - this.startButton.getHeight();
  }

  /**
   * @return the minimum size for the frame
   */
  /*
   * (non-Javadoc)
   * @see java.awt.Container#getMinimumSize()
   */
  @Override
  public Dimension getMinimumSize()
  {
    return new Dimension(Javoids.MIN_WIDTH,this.menuBar.getHeight() + this.infoPanel.getHeight() + Javoids.MIN_HEIGHT + this.startButton.getHeight());
  }

  /**
   * @return the preferred size for the frame
   */
  /*
   * (non-Javadoc)
   * @see java.awt.Container#getPreferredSize()
   */
  @Override
  public Dimension getPreferredSize()
  {
    return new Dimension(Javoids.MIN_WIDTH,this.menuBar.getHeight() + this.infoPanel.getHeight() + Javoids.MIN_HEIGHT + this.startButton.getHeight());
  }

  /**
   * @return the minimum allowable size of the game's frame
   */
  public Dimension getFrameMinimumSize()
  {
    return new Dimension(Javoids.MIN_WIDTH + Javoids.frame.getInsets().left + Javoids.frame.getInsets().right,this.menuBar.getHeight() + this.infoPanel.getHeight() + Javoids.MIN_HEIGHT + this.startButton.getHeight() + Javoids.frame.getInsets().top + Javoids.frame.getInsets().bottom);
  }

  /**
   * @return the preferred size of the game's frame
   */
  public Dimension getFramePreferredSize()
  {
    return new Dimension(Javoids.MIN_WIDTH + Javoids.frame.getInsets().left + Javoids.frame.getInsets().right,this.menuBar.getHeight() + this.infoPanel.getHeight() + Javoids.MIN_HEIGHT + this.startButton.getHeight() + Javoids.frame.getInsets().top + Javoids.frame.getInsets().bottom);
  }

  /**
   * @param componentEvent the component's event
   */
  /*
   * (non-Javadoc)
   * @see java.awt.event.ComponentListener#componentMoved(java.awt.event.ComponentEvent)
   */
  public void componentMoved(@SuppressWarnings("unused")
  ComponentEvent componentEvent)
  {
    /* Do Nothing */
  }

  /**
   * @param componentEvent the component's event
   */
  /*
   * (non-Javadoc)
   * @see java.awt.event.ComponentListener#componentShown(java.awt.event.ComponentEvent)
   */
  public void componentShown(@SuppressWarnings("unused")
  ComponentEvent componentEvent)
  {
    /* Do Nothing */
  }

  /**
   * @param componentEvent the component's event
   */
  /*
   * (non-Javadoc)
   * @see java.awt.event.ComponentListener#componentHidden(java.awt.event.ComponentEvent)
   */
  public void componentHidden(@SuppressWarnings("unused")
  ComponentEvent componentEvent)
  {
    /* Do Nothing */
  }

  /**
   * The component was resized, adjust the game canvas etc.
   * @param componentEvent the component's event
   */
  /*
   * (non-Javadoc)
   * @see java.awt.event.ComponentListener#componentResized(java.awt.event.ComponentEvent)
   */
  public void componentResized(@SuppressWarnings("unused")
  ComponentEvent componentEvent)
  {
    // set the applet size no matter what
    if (!Javoids.isApplet && Javoids.frame != null)
    {
      if (Javoids.frame.getWidth() < this.getFrameMinimumSize().width || Javoids.frame.getHeight() < this.getFrameMinimumSize().height)
      {
        Javoids.frame.setSize(this.getFramePreferredSize());
        this.setSize(this.getPreferredSize());
      }
    }
    if (this.getWidth() < this.getMinimumSize().width || this.getHeight() < this.getMinimumSize().height)
      this.setSize(this.getPreferredSize());
  }

  /**
   * @param itemEvent the item event to handle
   */
  /*
   * (non-Javadoc)
   * @see java.awt.event.ItemListener#itemStateChanged(java.awt.event.ItemEvent)
   */
  public void itemStateChanged(ItemEvent itemEvent)
  {
    if (itemEvent.getSource() instanceof JMenu)
      if (itemEvent.getStateChange() == ItemEvent.SELECTED && this.isRunning)
        this.pause();
  }

  /**
   * @param windowEvent the window event to handle
   */
  /*
   * (non-Javadoc)
   * @see java.awt.event.WindowListener#windowOpened(java.awt.event.WindowEvent)
   */
  public void windowOpened(@SuppressWarnings("unused")
  WindowEvent windowEvent)
  {
    /* Do Nothing */
  }

  /**
   * @param windowEvent the window event to handle
   */
  /*
   * (non-Javadoc)
   * @see java.awt.event.WindowListener#windowClosing(java.awt.event.WindowEvent)
   */
  public void windowClosing(@SuppressWarnings("unused")
  WindowEvent windowEvent)
  {
    /* Do Nothing */
  }

  /**
   * @param windowEvent the window event to handle
   */
  /*
   * (non-Javadoc)
   * @see java.awt.event.WindowListener#windowClosed(java.awt.event.WindowEvent)
   */
  public void windowClosed(@SuppressWarnings("unused")
  WindowEvent windowEvent)
  {
    /* Do Nothing */
  }

  /**
   * Set the focus to the game canvas so it can accept key events.
   * @param windowEvent the window event to handle
   */
  /*
   * (non-Javadoc)
   * @see java.awt.event.WindowListener#windowActivated(java.awt.event.WindowEvent)
   */
  public void windowActivated(@SuppressWarnings("unused")
  WindowEvent windowEvent)
  {
    this.gameCanvas.requestFocus();
  }

  /**
   * @param windowEvent the window event to handle
   */
  /*
   * (non-Javadoc)
   * @see java.awt.event.WindowListener#windowDeactivated(java.awt.event.WindowEvent)
   */
  public void windowDeactivated(@SuppressWarnings("unused")
  WindowEvent windowEvent)
  {
    /* Do Nothing */
  }

  /**
   * Stop game play and running threads to minimize CPU use.
   * @param windowEvent the window event to handle
   */
  /*
   * (non-Javadoc)
   * @see java.awt.event.WindowListener#windowIconified(java.awt.event.WindowEvent)
   */
  public void windowIconified(@SuppressWarnings("unused")
  WindowEvent windowEvent)
  {
    this.stop();
  }

  /**
   * Start game play and restart threads to handle game play.
   * @param windowEvent the window event to handle
   */
  /*
   * (non-Javadoc)
   * @see java.awt.event.WindowListener#windowDeiconified(java.awt.event.WindowEvent)
   */
  public void windowDeiconified(@SuppressWarnings("unused")
  WindowEvent windowEvent)
  {
    this.start();
  }

  /**
   * @param mouseEvent the mouse event to handle
   */
  /*
   * (non-Javadoc)
   * @see java.awt.event.MouseListener#mouseEntered(java.awt.event.MouseEvent)
   */
  public void mouseEntered(@SuppressWarnings("unused")
  MouseEvent mouseEvent)
  {
    /* Do Nothing */
  }

  /**
   * @param mouseEvent the mouse event to handle
   */
  /*
   * (non-Javadoc)
   * @see java.awt.event.MouseListener#mouseExited(java.awt.event.MouseEvent)
   */
  public void mouseExited(@SuppressWarnings("unused")
  MouseEvent mouseEvent)
  {
    /* Do Nothing */
  }

  /**
   * Unpause the game (if the popup menu is not displayed) and give focus to the game canvas to accept key events.
   * @param mouseEvent the mouse event to handle
   */
  /*
   * (non-Javadoc)
   * @see java.awt.event.MouseListener#mouseClicked(java.awt.event.MouseEvent)
   */
  public void mouseClicked(@SuppressWarnings("unused")
  MouseEvent mouseEvent)
  {
    if (!this.menuPopup.isVisible())
      this.menuItemUnPause();
    this.gameCanvas.requestFocus();
  }

  /**
   * Handle moving the mouse and deal with things in the tool panel being pressed.
   * @param mouseEvent the mouse event to handle
   */
  /*
   * (non-Javadoc)
   * @see java.awt.event.MouseListener#mousePressed(java.awt.event.MouseEvent)
   */
  public void mousePressed(MouseEvent mouseEvent)
  {
    Item.Type itemName = Item.Type.NO_TOOL;

    this.menuItemUnPause();
    this.gameCanvas.requestFocus();
    if (!this.isFirstGame && !this.isGameOver && this.shipPlayer.isAlive())
    {
      if (mouseEvent.getSource() instanceof ToolPanel)
        itemName = ((ToolPanel)mouseEvent.getSource()).getItemNumber();
      else if (mouseEvent.getSource() instanceof JLabel)
        itemName = ((ToolPanel)((JLabel)mouseEvent.getSource()).getParent()).getItemNumber();
      synchronized (Javoids.keyMap)
      {
        switch (itemName)
        {
          case GUN1 :
            Javoids.keyMap.pressMouse(KeyMap.Action.ACTION_SELECT_WEAPON_01);
            break;
          case GUN2 :
            Javoids.keyMap.pressMouse(KeyMap.Action.ACTION_SELECT_WEAPON_02);
            break;
          case GUN3 :
            Javoids.keyMap.pressMouse(KeyMap.Action.ACTION_SELECT_WEAPON_03);
            break;
          case MACHINEGUN1 :
            Javoids.keyMap.pressMouse(KeyMap.Action.ACTION_SELECT_WEAPON_04);
            break;
          case MACHINEGUN2 :
            Javoids.keyMap.pressMouse(KeyMap.Action.ACTION_SELECT_WEAPON_05);
            break;
          case MACHINEGUN3 :
            Javoids.keyMap.pressMouse(KeyMap.Action.ACTION_SELECT_WEAPON_06);
            break;
          case MULTIGUN1 :
            Javoids.keyMap.pressMouse(KeyMap.Action.ACTION_SELECT_WEAPON_07);
            break;
          case MULTIGUN2 :
            Javoids.keyMap.pressMouse(KeyMap.Action.ACTION_SELECT_WEAPON_08);
            break;
          case MULTIGUN3 :
            Javoids.keyMap.pressMouse(KeyMap.Action.ACTION_SELECT_WEAPON_09);
            break;
          case MULTIGUN4 :
            Javoids.keyMap.pressMouse(KeyMap.Action.ACTION_SELECT_WEAPON_10);
            break;
          case MULTIGUN5 :
            Javoids.keyMap.pressMouse(KeyMap.Action.ACTION_SELECT_WEAPON_11);
            break;
          case MULTIGUN6 :
            Javoids.keyMap.pressMouse(KeyMap.Action.ACTION_SELECT_WEAPON_12);
            break;
          case ROCKET1 :
            Javoids.keyMap.pressMouse(KeyMap.Action.ACTION_SELECT_WEAPON_13);
            break;
          case ROCKET2 :
            Javoids.keyMap.pressMouse(KeyMap.Action.ACTION_SELECT_WEAPON_14);
            break;
          case SHIELD :
            Javoids.keyMap.pressMouse(KeyMap.Action.ACTION_SHIELD);
            break;
          case AFTERBURNER :
            Javoids.keyMap.pressMouse(KeyMap.Action.ACTION_AFTERBURNER);
            break;
          case JUMP :
            Javoids.keyMap.pressMouse(KeyMap.Action.ACTION_JUMP);
            break;
          case BOMB1 :
            Javoids.keyMap.pressMouse(KeyMap.Action.ACTION_BOMB1);
            break;
          case BOMB2 :
            Javoids.keyMap.pressMouse(KeyMap.Action.ACTION_BOMB2);
            break;
          default :
            if (!Item.Type.NO_TOOL.equals(itemName))
              System.out.printf(Messages.getString("Javoids.ErrorMissingTool"),itemName); //$NON-NLS-1$
            break;
        }
      }
    }
    if (!this.isMouseMove && SwingUtilities.isRightMouseButton(mouseEvent))
    {
      this.menuItemPause();
      this.menuPopup.show(mouseEvent.getComponent(),mouseEvent.getX(),mouseEvent.getY());
    }
    if (mouseEvent.getSource() instanceof Canvas)
      if (this.isMouseMove)
        this.mouseAction(mouseEvent);
  }

  /**
   * Unpause the game (if the popup menu is not displayed) and give focus to the game canvas to accept key events. When the middle mouse button is pressed use the afterburner (if the game is being played). Select a tool if it is clicked and it is one of the guns or rockets.
   * @param mouseEvent the mouse event to handle
   */
  /*
   * (non-Javadoc)
   * @see java.awt.event.MouseListener#mouseReleased(java.awt.event.MouseEvent)
   */
  public void mouseReleased(MouseEvent mouseEvent)
  {
    if (!this.menuPopup.isVisible())
      this.menuItemUnPause();
    this.gameCanvas.requestFocus();
    if (!this.isFirstGame && this.isMouseMove)
    {
      if (SwingUtilities.isMiddleMouseButton(mouseEvent))
        this.shipPlayer.setSoundAfterburner(false);
    }
    Item.Type toolNumber = Item.Type.NO_TOOL;
    if (!this.isFirstGame && !this.isGameOver && this.shipPlayer.isAlive())
    {
      if (mouseEvent.getSource() instanceof ToolPanel)
        toolNumber = ((ToolPanel)mouseEvent.getSource()).getItemNumber();
      else if (mouseEvent.getSource() instanceof JLabel)
        toolNumber = ((ToolPanel)((JLabel)mouseEvent.getSource()).getParent()).getItemNumber();
      if (Item.Type.AFTERBURNER.equals(toolNumber))
        this.shipPlayer.setSoundAfterburner(false);
    }
  }

  /**
   * Move the ship toward the mouse's current position.
   * @param mouseEvent the mouse event to handle
   */
  /*
   * (non-Javadoc)
   * @see java.awt.event.MouseMotionListener#mouseDragged(java.awt.event.MouseEvent)
   */
  public void mouseDragged(MouseEvent mouseEvent)
  {
    this.mouseMoved(mouseEvent);
  }

  /**
   * Move the ship in response to mouse movement.
   * @param mouseEvent the mouse event to handle
   */
  /*
   * (non-Javadoc)
   * @see java.awt.event.MouseMotionListener#mouseMoved(java.awt.event.MouseEvent)
   */
  public void mouseMoved(MouseEvent mouseEvent)
  {
    if (this.isMouseMove)
    {
      if (!this.isFirstGame && !this.isGameOver && this.shipPlayer.isAlive())
      {
        this.mouseMove.setX(mouseEvent.getX());
        this.mouseMove.setY(mouseEvent.getY());
        Common.target(this.shipPlayer.getMove(),this.mouseMove);
        this.shipPlayer.getShield().setMove(new Move(this.shipPlayer.getMove())); // keep shield in sync with ship
        this.mouseAction(mouseEvent);
      }
    }
  }

  /**
   * A key was pressed, perform the associated action (if any). Add the key to the list of keys pressed.
   * @param keyEvent the key event to handle
   */
  /*
   * (non-Javadoc)
   * @see java.awt.event.KeyListener#keyPressed(java.awt.event.KeyEvent)
   */
  public void keyPressed(KeyEvent keyEvent)
  {
    synchronized (Javoids.keyMap)
    {
      Javoids.keyMap.pressKey(Integer.valueOf(keyEvent.getKeyCode()));
    }
    if (keyEvent.isAltDown())
    {
      if (keyEvent.getKeyCode() != KeyEvent.VK_ALT)
      {
        if (this.isRunning)
          this.pause();
      }
      else
        keyEvent.consume();
    }
  }

  /**
   * A key was released. Remove the key from the list of keys pressed.
   * @param keyEvent the key event to handle
   */
  /*
   * (non-Javadoc)
   * @see java.awt.event.KeyListener#keyReleased(java.awt.event.KeyEvent)
   */
  synchronized public void keyReleased(KeyEvent keyEvent)
  {
    if (!this.isFirstGame && this.shipPlayer.isPlayer() && this.shipPlayer.isAlive())
    {
      if (ACTION_AFTERBURNER.equals(Javoids.keyMap.getAction(Integer.valueOf(keyEvent.getKeyCode()))))
        this.shipPlayer.setSoundAfterburner(false);
    }
    Javoids.keyMap.depressKey(Integer.valueOf(keyEvent.getKeyCode()));
  }

  /**
   * @param keyEvent the key event to handle
   */
  /*
   * (non-Javadoc)
   * @see java.awt.event.KeyListener#keyTyped(java.awt.event.KeyEvent)
   */
  public void keyTyped(@SuppressWarnings("unused")
  KeyEvent keyEvent)
  {
    /* Do Nothing */
  }

  /**
   * If the escpae key was pressed unpause the game and request focus to the game canvas to accept key events again.
   * @param menuKeyEvent the menu key event to handle
   */
  /*
   * (non-Javadoc)
   * @see javax.swing.event.MenuKeyListener#menuKeyPressed(javax.swing.event.MenuKeyEvent)
   */
  public void menuKeyPressed(MenuKeyEvent menuKeyEvent)
  {
    if (menuKeyEvent.getKeyCode() == KeyEvent.VK_ESCAPE)
    {
      this.menuItemUnPause();
      this.gameCanvas.requestFocus();
    }
  }

  /**
   * @param menuKeyEvent the menu key event to handle
   */
  /*
   * (non-Javadoc)
   * @see javax.swing.event.MenuKeyListener#menuKeyReleased(javax.swing.event.MenuKeyEvent)
   */
  public void menuKeyReleased(@SuppressWarnings("unused")
  MenuKeyEvent menuKeyEvent)
  {
    /* Do Nothing */
  }

  /**
   * @param menuKeyEvent the menu key event to handle
   */
  /*
   * (non-Javadoc)
   * @see javax.swing.event.MenuKeyListener#menuKeyTyped(javax.swing.event.MenuKeyEvent)
   */
  public void menuKeyTyped(@SuppressWarnings("unused")
  MenuKeyEvent menuKeyEvent)
  {
    /* Do Nothing */
  }

  /**
   * Start a new game.
   */
  public void actionPerformedNew()
  {
    this.menuItemPause();
    this.FileNewGame();
    this.menuItemUnPause();
  }

  /**
   * Display the high score table.
   */
  public void actionPerformedScores()
  {
    this.menuItemPause();
    if (this.initializeHighScores())
      JOptionPane.showMessageDialog(this,this.highScorePanel,Messages.getString("Javoids.HighScores"),JOptionPane.INFORMATION_MESSAGE); //$NON-NLS-1$
    this.menuItemUnPause();
  }

  /**
   * Exit the game.
   */
  public void actionPerformedExit()
  {
    if (!Javoids.isApplet)
    {
      this.menuItemPause();
      this.stop();
      this.menuItemUnPause();
      Javoids.frame.dispose();
      Javoids.frame = null;
    }
  }

  /**
   * Display a dialog to allow the suer to select a value from a list of values.
   * @param message the message to display in the dialog
   * @param title the title of the dialog
   * @param values the values to use in the dropdown list
   * @param selectedValue the default selected value
   * @param targetValue the currently selected value
   * @return the selected value
   */
  private String selectValue(String message,String title,Object[] values,Object selectedValue,int targetValue)
  {
    Object valueSelected = selectedValue;
    for (Object value : values)
    {
      String valueString = (String)value;
      int valueInt = Integer.parseInt(valueString);
      if (valueInt == targetValue)
      {
        valueSelected = value;
        break;
      }
    }
    String returnValue = (String)JOptionPane.showInputDialog(this,message,title,JOptionPane.INFORMATION_MESSAGE,null,values,valueSelected);
    return returnValue;
  }

  /**
   * Prompt the user to set the difficulty of the game.
   */
  public void actionPerformedDifficulty()
  {
    this.menuItemPause();
    String difficultyObject = this.selectValue(Messages.getString("Javoids.SelectDifficulty"),Messages.getString("Javoids.InputDifficulty"),Javoids.difficultyValues,Javoids.difficultyValues[0],Javoids.difficulty); //$NON-NLS-1$ //$NON-NLS-2$
    if (difficultyObject != null)
      this.setDifficulty(Integer.parseInt(difficultyObject));
    this.menuItemUnPause();
  }

  /**
   * Prompt the user to set the time delay of the game.
   */
  public void actionPerformedDelay()
  {
    this.menuItemPause();
    String delayObject = this.selectValue(Messages.getString("Javoids.SelectDelay"),Messages.getString("Javoids.InputDelay"),Javoids.delayValues,Javoids.delayValues[Javoids.delayValues.length - 1],Javoids.delay); //$NON-NLS-1$ //$NON-NLS-2$
    if (delayObject != null)
      Javoids.delay = Integer.parseInt(delayObject);
    this.menuItemUnPause();
  }

  /**
   * Prompt the user to set the number of lives a player starts with.
   */
  public void actionPerformedLives()
  {
    this.menuItemPause();
    String livesObject = this.selectValue(Messages.getString("Javoids.SelectLives"),Messages.getString("Javoids.InputLives"),Javoids.livesValues,Javoids.livesValues[0],this.lives); //$NON-NLS-1$ //$NON-NLS-2$
    if (livesObject != null)
      this.lives = Integer.parseInt(livesObject);
    this.menuItemUnPause();
  }

  /**
   * Prompt the user to configure his keyboard set-up.
   */
  public void actionPerformedKeyBinding()
  {
    this.menuItemPause();
    this.keyDialog.setKeyMap(Javoids.keyMap); // set the dialog to use the current keymap (not the stored copy)
    this.keyDialog.setVisible(true);
    if (this.keyDialog.getSuccessStatus())
      Javoids.keyMap = new KeyMap(this.keyDialog.getKeyMap());
    this.menuItemUnPause();
  }

  /**
   * Toggle from the user's keymap to the default keymap.
   */
  public void actionPerformedKeyMap()
  {
    URL url = null;
    this.menuItemPause();
    try
    {
      this.isUserKeyMap = !this.isUserKeyMap;
      this.optionUserKeyMap.setState(this.isUserKeyMap);
      if (this.isUserKeyMap)
      {
        if (!Javoids.keyMap.load(new URL(String.format(Messages.getString("Javoids.FileFormat"),System.getProperty(Messages.getString("Javoids.UserHome")),File.separator,Messages.getString("Javoids.KeyboardProperties"))))) //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
          Javoids.keyMap.load(this.getClass().getResource(Messages.getString("Javoids.KeyboardProperties"))); //$NON-NLS-1$
      }
      else
        Javoids.keyMap.reset();
    }
    catch (MalformedURLException malformedURLException)
    {
      System.out.printf(Messages.getString("Javoids.ErrorURL"),url,malformedURLException.getMessage()); //$NON-NLS-1$
    }
    this.menuItemUnPause();
  }

  /**
   * Allow the player to play by using the mouse.
   */
  public void actionPerformedMouseMove()
  {
    this.menuItemPause();
    this.isMouseMove = !this.isMouseMove;
    this.optionMouseMove.setState(this.isMouseMove);
    this.setCursor(this.isMouseMove ? this.cursorCrosshair : this.cursorDefault);
    this.menuItemUnPause();
  }

  /**
   * Toggle the use of sound in the game between on/off.
   */
  public void actionPerformedSound()
  {
    this.menuItemPause();
    this.isSound = !this.isSound;
    this.optionSound.setState(this.isSound);
    Media.setIsSound(this.isSound);
    this.menuItemUnPause();
  }

  /**
   * Prompt the user to set the volume level.
   */
  public void actionPerformedVolume()
  {
    this.menuItemPause();
    String volumeObject = this.selectValue(Messages.getString("Javoids.SelectVolume"),Messages.getString("Javoids.InputVolume"),Javoids.volumeValues,Javoids.volumeValues[0],Media.getVolume()); //$NON-NLS-1$ //$NON-NLS-2$
    if (volumeObject != null)
      Media.setVolume(Integer.parseInt(volumeObject));
    this.menuItemUnPause();
  }

  /**
   * Toggle between checking for collisions using a bounding circle and using the actual area the sprites take up.
   */
  public void actionPerformedAreaChecking()
  {
    this.menuItemPause();
    this.isAreaChecking = !this.isAreaChecking;
    this.optionAreaChecking.setState(BasicSprite.setAreaChecking(this.isAreaChecking));
    this.menuItemUnPause();
  }

  /**
   * Display the readme file.
   */
  public void actionPerformedReadMe()
  {
    this.menuItemPause();
    this.editorPane.setContentType(Messages.getString("Javoids.TextHtml")); //$NON-NLS-1$
    if (!this.editorPane.getText().equals(Media.getReadme()))
      this.editorPane.setText(Media.getReadme());
    this.editorPane.setCaretPosition(0);
    this.scrollPane.getVerticalScrollBar().setValue(0);
    JOptionPane.showMessageDialog(this,this.helpPanel,Messages.getString("Javoids.ReadMeFile"),JOptionPane.INFORMATION_MESSAGE); //$NON-NLS-1$
    this.menuItemUnPause();
  }

  /**
   * Display the version file.
   */
  public void actionPerformedVersion()
  {
    this.menuItemPause();
    this.editorPane.setContentType(Messages.getString("Javoids.TextHtml")); //$NON-NLS-1$
    if (!this.editorPane.getText().equals(Media.getVersion()))
      this.editorPane.setText(Media.getVersion());
    this.editorPane.setCaretPosition(0);
    this.scrollPane.getVerticalScrollBar().setValue(0);
    JOptionPane.showMessageDialog(this,this.helpPanel,Messages.getString("Javoids.VersionFile"),JOptionPane.INFORMATION_MESSAGE); //$NON-NLS-1$
    this.menuItemUnPause();
  }

  /**
   * Display the license file.
   */
  public void actionPerformedLicense()
  {
    this.menuItemPause();
    this.editorPane.setContentType(Messages.getString("Javoids.TextHtml")); //$NON-NLS-1$
    if (!this.editorPane.getText().equals(Media.getLicense()))
      this.editorPane.setText(Media.getLicense());
    this.editorPane.setCaretPosition(0);
    this.scrollPane.getVerticalScrollBar().setValue(0);
    JOptionPane.showMessageDialog(this,this.helpPanel,Messages.getString("Javoids.LicenseFile"),JOptionPane.INFORMATION_MESSAGE); //$NON-NLS-1$
    this.menuItemUnPause();
  }

  /**
   * Display information about the game.
   */
  public void actionPerformedAbout()
  {
    this.menuItemPause();
    JOptionPane.showMessageDialog(this,String.format(Messages.getString("Javoids.Javoids"),Messages.getString("Javoids.VersionNumber")),Messages.getString("Javoids.AboutJavoids"),JOptionPane.INFORMATION_MESSAGE); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
    this.menuItemUnPause();
  }

  /**
   * Handle all of the actions in the game.
   * @param actionEvent the action event to handle
   */
  /*
   * (non-Javadoc)
   * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
   */
  public void actionPerformed(ActionEvent actionEvent)
  {
    URL url = null;
    Object source = actionEvent.getSource();

    if (source instanceof Timer && this.isRunning && !this.isGameOver) // timers active when game finishes
    {
      if (source.equals(this.playTimer))
      {
        this.playTime++;
      }
      else if (source.equals(this.powerUpTimer) && Debug.CreatePowerUp)
      {
        if (this.powerUps.size() <= PowerUp.MAX_NUMBER)
        {
          this.powerUps.add(new PowerUp(null,new Health(1,Health.DEFAULT_DAMAGE_CAPACITY * 3,Health.DEFAULT_DURATION * 2,1,NORMAL),new Move(this.screen,Math.random() * this.screen.width + 1,Math.random() * this.screen.width + 1,Math.random() * 360,Math.random() * Move.MAX_VELOCITY),PowerUp.DEFAULT_SIZE));
          this.powerUpTimer.setDelay((int)(Javoids.DEFAULT_DELAY_POWERUP * Math.random()));
        }
      }
      else if (source.equals(this.mineTimer) && Debug.CreateMine)
      {
        if (this.mines.size() <= Mine.MAX_NUMBER)
        {
          this.mines.add(new Mine(null,new Health(1,Health.DEFAULT_DAMAGE_CAPACITY * 2,Health.DEFAULT_DURATION * 2,-1,NORMAL),new Move(this.screen,Math.random() * this.screen.width + 1,Math.random() * this.screen.width + 1,Math.random() * 360,Move.MAX_VELOCITY / 4),Mine.DEFAULT_SIZE));
          this.mineTimer.setDelay((int)(Javoids.DEFAULT_DELAY_MINE * Math.random()));
        }
      }
      else if (source.equals(this.eatableGhostTimer))
      {
        if (this.isPacmanGame)
        {
          this.eatableGhostTimer.stop();
          this.eatableGhostTimer = null;
          this.isEatableGhost = false;
          for (BasicSprite basicSprite : this.javoids)
          {
            Javoid javoid = (Javoid)basicSprite;
            if (javoid.isAlive())
              javoid.setImage(PACMAN_GHOST);
          }
        }
      }
      else if (source.equals(this.singularityTimer) && Debug.CreateSingularity)
      {
        if (this.singularitys.size() <= Singularity.MAX_NUMBER)
        {
          Singularity singularity = new Singularity(null,new Health(GravityPoint.MAX_DEATHS,GravityPoint.MAXIMUM_DAMAGE_CAPACITY,GravityPoint.DEFAULT_DURATION,GravityPoint.DEFAULT_AGING_RATE,IMMORTAL),new Move(this.screen,Math.random() * this.screen.width + 1,Math.random() * this.screen.height + 1,Math.random() * 360,Math.random() * Move.MAX_VELOCITY / 5.0),Singularity.DEFAULT_SIZE * 2);
          singularity.setGravity(Math.random() < 0.5 ? SINK : SOURCE);
          this.singularitys.add(singularity);
          this.singularityTimer.setDelay((int)(Javoids.DEFAULT_DELAY_SINGULARITY * Math.random()));
          if (singularity.isGravitySource())
          {
            if (Math.random() <= Javoids.JAVOID_CREATION_CHANCE)
            {
              singularity.grow(-1);
              this.javoidTimer.setDelay(this.singularityTimer.getDelay() / 2);
              this.javoidTimer.start();
            }
          }
        }
      }
      else if (source.equals(this.javoidTimer) && Debug.CreateSingularityJavoid)
      {
        if (this.javoids.size() <= Javoid.MAX_NUMBER)
        {
          for (BasicSprite basicSprite : this.singularitys)
          {
            Singularity singularity = (Singularity)basicSprite;
            if (singularity.isGravitySource())
            {
              if (Math.random() <= Javoids.JAVOID_CREATION_CHANCE)
              {
                Javoid javoid = new Javoid(null,new Health(1,singularity.getSize(),Health.DEFAULT_DURATION,0,AGELESS),new Move(this.screen,singularity.getX(),singularity.getY(),Math.random() * 360,Math.random() * Move.MAX_VELOCITY),Javoid.DEFAULT_SIZE);
                BasicSprite.setPacmanGame(this.isPacmanGame);
                this.javoids.addAll(javoid.breakApart());
                singularity.grow(-1);
                this.javoidTimer.setDelay(this.singularityTimer.getDelay() / 2);
                this.javoidTimer.start();
              }
              else
                this.javoidTimer.stop();
              break;
            }
          }
        }
      }
      else if (source.equals(this.shipTimer) && Debug.CreateShip)
      {
        if (this.ships.size() <= Ship.MAX_NUMBER)
        {
          int size = (int)(Math.random() * Ship.MAX_SIZE);
          Move move;
          Health health;
          if (Debug.debugShip)
          {
            move = new Move(this.screen,this.screen.x + this.screen.width * 1 / 5,this.screen.y + this.screen.height * 4 / 5,0,Ship.DEFAULT_VELOCITY);
            health = new Health(Health.MIN_DEATHS,Health.DEFAULT_DAMAGE_CAPACITY,Health.DEFAULT_DAMAGE_CAPACITY,Health.DEFAULT_AGING_RATE,NORMAL);
          }
          else
          {
            move = new Move(this.screen,this.screen.x + Math.random() * this.screen.width,this.screen.y + Math.random() * this.screen.height,0,Ship.DEFAULT_VELOCITY);
            health = new Health(Health.MIN_DEATHS,Health.DEFAULT_DAMAGE_CAPACITY,5000,Health.DEFAULT_AGING_RATE,NORMAL);
          }
          this.ships.add(new Ship(null,health,move,size));
          this.shipTimer.setDelay((int)(Javoids.DEFAULT_DELAY_SHIP * Math.random()));
        }
      }
      else if (source.equals(this.bonusTimer))
      {
        if (this.bonus > 0)
        {
          this.bonus = this.bonus - 100;
          this.shipTimer.setDelay(Javoids.DELAY_BONUS);
        }
      }
    }
    else if (source instanceof Timer && this.isRunning && this.isGameOver)
    {
      if (source.equals(this.highScoreTimer))
      {
        this.highScoreTimer.stop();
        this.highScoreTimer = null;
        if (this.highScorePanel.insertScore(this,this.shipPlayer.getPoints(),this.duration,this.level))
        {
          String location = String.format(Messages.getString("Javoids.FileFormat"),System.getProperty(Messages.getString("Javoids.UserHome")),File.separator,Messages.getString("Javoids.HighScoreProperties")); //$NON-NLS-1$//$NON-NLS-2$ //$NON-NLS-3$

          if (this.highScorePanel == null)
            this.highScorePanel = new HighScorePanel();
          try
          {
            url = new URL(location);
            this.highScorePanel.save(url);
          }
          catch (MalformedURLException malformedURLException)
          {
            System.out.printf(Messages.getString("Javoids.ErrorLoadingHighScore"),location,malformedURLException.getMessage()); //$NON-NLS-1$
          }
          catch (NullPointerException nullPointerException)
          {
            System.out.printf(Messages.getString("Javoids.ErrorLoadingHighScore"),location,nullPointerException.getMessage()); //$NON-NLS-1$
          }
        }
      }
    }
  }

  /**
   * Follow a clicked link in one of the help screens.
   * @param hyperlinkEvent the hyperlink event to handle
   */
  /*
   * (non-Javadoc)
   * @see javax.swing.event.HyperlinkListener#hyperlinkUpdate(javax.swing.event.HyperlinkEvent)
   */
  public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent)
  {
    if (HyperlinkEvent.EventType.ACTIVATED.equals(hyperlinkEvent.getEventType()))
    {
      JEditorPane pane = (JEditorPane)hyperlinkEvent.getSource();
      if (hyperlinkEvent instanceof HTMLFrameHyperlinkEvent)
      {
        HTMLDocument document = (HTMLDocument)pane.getDocument();
        document.processHTMLFrameHyperlinkEvent((HTMLFrameHyperlinkEvent)hyperlinkEvent);
      }
      else
      {
        try
        {
          pane.setPage(hyperlinkEvent.getURL());
        }
        catch (IOException iOException)
        {
          System.out.printf(Messages.getString("Javoids.ErrorOpeningURL"),hyperlinkEvent.getURL().toString(),iOException.getMessage()); //$NON-NLS-1$
        }
      }
    }
  }

  /**
   * Do all of the game drawing here (or pass it off to helper functions).
   * @param graphics the graphics context to use for drawing in the game.
   */
  /*
   * (non-Javadoc)
   * @see java.awt.Container#paint(java.awt.Graphics)
   */
  @Override
  public void paint(Graphics graphics)
  {
    Rectangle2D rectangle;
    FontMetrics fontMetrics;

    if (this.isGameStarted || this.getWidth() != this.oldWidth || this.getHeight() != this.oldHeight)
    {
      if (this.isGameStarted)
        this.isGameStarted = false; // turn this off if the game has just started running a new game
      this.oldWidth = this.getWidth();
      this.oldHeight = this.getHeight();
      this.screen.setBounds(0,0,this.getGameWidth(),this.getGameHeight());
      this.mouseMove.setScreen(this.screen);
      Media.setImage(GALAXY1,Media.getImage(GALAXY1).getScaledInstance(this.screen.width,this.screen.height,Image.SCALE_FAST));
      this.imageBuffer = this.createVolatileImage(this.screen.width,this.screen.height);
      this.graphicsBuffer = (Graphics2D)this.imageBuffer.getGraphics();
      // fix the off center bug
      if (!this.isScreenInitialized && this.shipPlayer != null)
      {
        this.shipPlayer.setScreen(this.screen);
        Move move = new Move(this.screen,this.screen.x + this.screen.width / 2,this.screen.y + this.screen.height / 2,0,Ship.DEFAULT_VELOCITY);
        this.shipPlayer.setMove(move);
        this.isScreenInitialized = true;
      }
    }
    if (this.shipPlayer != null)
      this.setInformation(this.shipPlayer,this.level);
    // paint components
    this.drawSprites((Graphics2D)graphics,this.graphicsBuffer);
    this.menuBar.repaint();
    this.infoPanel.repaint();
    if (!this.isRunning && !this.isFirstGame && !this.isGameOver) // if paused
    {
      this.graphicsBuffer.setColor(Color.red);
      this.graphicsBuffer.setFont(new Font(Messages.getString("Javoids.FontSerif"),Font.BOLD,72)); //$NON-NLS-1$
      fontMetrics = this.graphicsBuffer.getFontMetrics();
      rectangle = fontMetrics.getStringBounds(Messages.getString("Javoids.Paused"),this.graphicsBuffer); //$NON-NLS-1$
      this.graphicsBuffer.drawString(Messages.getString("Javoids.Paused"),(int)((this.getWidth() - rectangle.getWidth()) / 2),this.getHeight() / 2 - 2 * fontMetrics.getDescent()); //$NON-NLS-1$
    }
    else if (this.isGameOver) // if not paused display the game over message when all players dead
    {
      this.graphicsBuffer.setColor(Color.red);
      this.graphicsBuffer.setFont(new Font(Messages.getString("Javoids.FontSerif"),Font.BOLD,72)); //$NON-NLS-1$
      fontMetrics = this.graphicsBuffer.getFontMetrics();
      rectangle = fontMetrics.getStringBounds(Messages.getString("Javoids.GameOver"),this.graphicsBuffer); //$NON-NLS-1$
      this.graphicsBuffer.drawString(Messages.getString("Javoids.GameOver"),(int)((this.getWidth() - rectangle.getWidth()) / 2),this.getHeight() / 2 - 2 * fontMetrics.getDescent()); //$NON-NLS-1$
    }
    else if (this.isFirstGame)
    {
      this.graphicsBuffer.setColor(Color.red);
      this.graphicsBuffer.setFont(new Font(Messages.getString("Javoids.FontSerif"),Font.BOLD,72)); //$NON-NLS-1$
      fontMetrics = this.graphicsBuffer.getFontMetrics();
      rectangle = fontMetrics.getStringBounds(Messages.getString("Javoids.Javoids!") + Messages.getString("Javoids.VersionNumber"),this.graphicsBuffer); //$NON-NLS-1$ //$NON-NLS-2$
      this.graphicsBuffer.drawString(Messages.getString("Javoids.Javoids!") + Messages.getString("Javoids.VersionNumber"),(int)((this.getWidth() - rectangle.getWidth()) / 2),this.getHeight() / 5 - fontMetrics.getDescent()); //$NON-NLS-1$ //$NON-NLS-2$
      rectangle = fontMetrics.getStringBounds(Messages.getString("Javoids.PressStart"),this.graphicsBuffer); //$NON-NLS-1$
      this.graphicsBuffer.drawString(Messages.getString("Javoids.PressStart"),(int)((this.getWidth() - rectangle.getWidth()) / 2),this.getHeight() * 2 / 5 - fontMetrics.getDescent()); //$NON-NLS-1$
      rectangle = fontMetrics.getStringBounds("to",this.graphicsBuffer); //$NON-NLS-1$
      this.graphicsBuffer.drawString("to",(int)((this.getWidth() - rectangle.getWidth()) / 2),this.getHeight() * 3 / 5 - fontMetrics.getDescent()); //$NON-NLS-1$
      rectangle = fontMetrics.getStringBounds(Messages.getString("Javoids.Play"),this.graphicsBuffer); //$NON-NLS-1$
      this.graphicsBuffer.drawString(Messages.getString("Javoids.Play"),(int)((this.getWidth() - rectangle.getWidth()) / 2),this.getHeight() * 4 / 5 - fontMetrics.getDescent()); //$NON-NLS-1$
    }
    this.gameCanvas.getGraphics().drawImage(this.imageBuffer,0,0,this);
    this.startButton.repaint();
  }

  /**
   * Dummy method that calls paint(graphics) for compatibility with early Swing components.
   * @param graphics the graphics context to use for drawing in the game.
   */
  /*
   * (non-Javadoc)
   * @see javax.swing.JApplet#update(java.awt.Graphics)
   */
  @Override
  public void update(Graphics graphics)
  {
    this.paint(graphics);
  }

  /**
   * @return the information about the applet
   */
  /*
   * (non-Javadoc)
   * @see java.applet.Applet#getAppletInfo()
   */
  @Override
  public String getAppletInfo()
  {
    return String.format(Messages.getString("Javoids.Info"),Messages.getString("Javoids.VersionNumber")); //$NON-NLS-1$ //$NON-NLS-2$
  }

  /**
   * @return the information about the applet's parameters.
   */
  /*
   * (non-Javadoc)
   * @see java.applet.Applet#getParameterInfo()
   */
  @Override
  public String[][] getParameterInfo()
  {
    return Javoids.JAVOIDSPARMS;
  }

  /**
   * Perform the basic work of starting a new game.
   */
  public void FileNewGame()
  {
    this.isFirstGame = false;
    this.isGameStarted = true;
    this.start();
    this.stopGame();
    this.newGame();
    this.startTimers();
  }

  /**
   * Reset game specific information (to start a new game).
   */
  public void newGame()
  {
    Move move;
    System.out.printf(Messages.getString("Javoids.NewGameMethod")); //$NON-NLS-1$
    this.isGameOver = false;
    // do an immediate repaint to get the correct screen dimensions (needed or ship is off center)
    this.paint(this.getGraphics());
    this.gravityPlane.clear();
    this.level = 1;
    this.switchPacmanGame(true);
    this.bonus = Javoids.BONUS + Javoids.BONUS_INCREMENT * (this.level - 1);
    // must create player first!
    if (Debug.debugShip)
      move = new Move(this.screen,this.screen.x + this.screen.width * 1 / 2,this.screen.y + this.screen.height * 4 / 5,0,Ship.DEFAULT_VELOCITY);
    else
      move = new Move(this.screen,this.screen.x + this.screen.width / 2,this.screen.y + this.screen.height / 2,0,Ship.DEFAULT_VELOCITY);
    Ship.restoreCount(); // must be done to reset #of ships to initialize player
    this.ships.clear();
    this.ships.add(new Ship(null,new Health(this.lives,Ship.MAXIMUM_DAMAGE_CAPACITY,Health.DEFAULT_DURATION,0,AGELESS),move,Ship.DEFAULT_SIZE));
    this.shipPlayer = this.ships.get(0);
    this.progressBarBonus.setMaximum(this.bonus);
    this.progressBarBonus.setValue(this.bonus);
    this.progressBarHealth.setMaximum(this.shipPlayer.getMaxDamage());
    this.progressBarHealth.setValue(this.shipPlayer.getDamage());
    this.progressBarShield.setMaximum(this.shipPlayer.getShield().getMaxDamage());
    this.progressBarShield.setValue(this.shipPlayer.getShield().getDamage());
    this.panelAmmo.removeAll();
    this.panelWeapon.clear();
    this.javoids.addAll(this.createLevelJavoids());
    // setup display
    this.addPanelItem(this.shipPlayer.getItems().get(Item.Type.GUN1));
    this.addPanelItem(this.shipPlayer.getItems().get(Item.Type.GUN2));
    this.addPanelItem(this.shipPlayer.getItems().get(Item.Type.GUN3));
    this.addPanelItem(this.shipPlayer.getItems().get(Item.Type.MACHINEGUN1));
    this.addPanelItem(this.shipPlayer.getItems().get(Item.Type.MACHINEGUN2));
    this.addPanelItem(this.shipPlayer.getItems().get(Item.Type.MACHINEGUN3));
    this.addPanelItem(this.shipPlayer.getItems().get(Item.Type.MULTIGUN1));
    this.addPanelItem(this.shipPlayer.getItems().get(Item.Type.MULTIGUN2));
    this.addPanelItem(this.shipPlayer.getItems().get(Item.Type.MULTIGUN3));
    this.addPanelItem(this.shipPlayer.getItems().get(Item.Type.MULTIGUN4));
    this.addPanelItem(this.shipPlayer.getItems().get(Item.Type.MULTIGUN5));
    this.addPanelItem(this.shipPlayer.getItems().get(Item.Type.MULTIGUN6));
    this.addPanelItem(this.shipPlayer.getItems().get(Item.Type.ROCKET1));
    this.addPanelItem(this.shipPlayer.getItems().get(Item.Type.ROCKET2));
    this.addPanelItem(this.shipPlayer.getItems().get(Item.Type.SHIELD));
    this.addPanelItem(this.shipPlayer.getItems().get(Item.Type.AFTERBURNER));
    this.addPanelItem(this.shipPlayer.getItems().get(Item.Type.JUMP));
    this.addPanelItem(this.shipPlayer.getItems().get(Item.Type.BOMB1));
    this.addPanelItem(this.shipPlayer.getItems().get(Item.Type.BOMB2));
    this.panelWeapon.get(Item.Type.GUN1).setBorder(this.selectedBorder); // add the border so it's sized correctly
    // resize the ammunition panel to draw correctly
    this.panelAmmo.setMinimumSize(this.panelAmmo.getComponent(0).getMinimumSize());
    this.panelAmmo.setPreferredSize(this.panelAmmo.getMinimumSize());
    this.panelAmmo.setSize(this.panelAmmo.getMinimumSize());
    this.panelAmmo.validate();
    // resize the information panel to draw correctly
    this.infoPanel.setMinimumSize(new Dimension((int)this.infoPanel.getMinimumSize().getWidth(),(int)(this.infoLabel.getMinimumSize().getHeight() + this.panelAmmo.getMinimumSize().getHeight())));
    this.infoPanel.setPreferredSize(this.infoPanel.getMinimumSize());
    this.infoPanel.setSize(this.infoPanel.getMinimumSize());
    this.infoPanel.validate();
    // reset oldHeight to force screen size recalculation, then repaint
    this.oldHeight = -1;
    this.repaint();
    // reset Timers then start them
    this.powerUpTimer.setDelay(Javoids.INITIAL_DELAY_POWERUP);
    this.mineTimer.setDelay(Javoids.INITIAL_DELAY_MINE);
    this.singularityTimer.setDelay(Javoids.INITIAL_DELAY_SINGULARITY);
    this.javoidTimer.setDelay(Javoids.INITIAL_DELAY_JAVOID);
    this.shipTimer.setDelay(Javoids.INITIAL_DELAY_SHIP);
    this.bonusTimer.setDelay(Javoids.DELAY_BONUS);
    this.playTimer.setDelay(Javoids.DELAY_PLAYTIMER);
    this.playTime = 0;
    this.startTimers();
    this.gameCanvas.requestFocus();
    // do another immediate repaint to get the correct screen dimensions (to prevent canvas of wrong size)
    this.paint(this.getGraphics());
    this.isRunning = true;
  }

  /**
   * @return true if the user's home was set and the game has access, otherwise return false
   */
  private boolean checkSecurityUserHome()
  {
    SecurityManager securityManager = null;
    boolean returnValue = true;
    if (Debug.debugUserHome)
      System.out.printf(Messages.getString("Javoids.CheckSecurity")); //$NON-NLS-1$
    securityManager = System.getSecurityManager();
    if (securityManager != null)
    {
      // check to see if javoids has read access to their system properties so we can build where the high score file should be
      try
      {
        securityManager.checkPropertyAccess(Messages.getString("Javoids.UserHome")); //$NON-NLS-1$
        Javoids.userHome = System.getProperty(Messages.getString("Javoids.UserHome")); //$NON-NLS-1$
      }
      catch (SecurityException securityException)
      {
        JOptionPane.showMessageDialog(this,Messages.getString("Javoids.ErrorUnableToAccessSystemProperties") + securityException.getMessage(),Messages.getString("Javoids.ErrorJavaSecurity"),JOptionPane.ERROR_MESSAGE); //$NON-NLS-1$ //$NON-NLS-2$
        if (Debug.debugUserHome)
          System.out.printf(String.format(Messages.getString("Javoids.ErrorSecurity"),Integer.valueOf(1))); //$NON-NLS-1$
        if (Debug.debugUserHome)
          System.out.printf(Messages.getString("Javoids.ErrorUserHome"),securityException.getMessage()); //$NON-NLS-1$
        returnValue = false;
      }
    }
    if (Debug.debugUserHome)
      System.out.printf(Messages.getString("Javoids.ReturnValue"),Boolean.valueOf(returnValue)); //$NON-NLS-1$
    return returnValue;
  }

  /**
   * @return true if the high score can be read and the game has access, otherwise return false
   */
  private boolean checkSecurityHighScores()
  {
    SecurityManager securityManager = null;
    Object context = null;
    boolean returnValue = true;
    if (Debug.debugHighScores)
      System.out.printf(Messages.getString("Javoids.CheckSecurity")); //$NON-NLS-1$
    securityManager = System.getSecurityManager();
    if (securityManager != null)
    {
      context = securityManager.getSecurityContext();
      // check to see if javoids has read access to the player's high score file
      try
      {
        if (Javoids.userHome != null)
          securityManager.checkRead(Javoids.userHome + File.separator + Messages.getString("Javoids.HighScoreProperties"),context); //$NON-NLS-1$
      }
      catch (SecurityException securityException)
      {
        JOptionPane.showMessageDialog(this,Messages.getString("Javoids.ErrorUnableToAccessHighScores") + securityException.getMessage(),Messages.getString("Javoids.ErrorJavaSecurity"),JOptionPane.ERROR_MESSAGE); //$NON-NLS-1$ //$NON-NLS-2$
        if (Debug.debugHighScores)
          System.out.printf(String.format(Messages.getString("Javoids.ErrorSecurity"),Integer.valueOf(4))); //$NON-NLS-1$
        if (Debug.debugHighScores)
          System.out.printf(Messages.getString("Javoids.ErrorUserHome"),securityException.getMessage()); //$NON-NLS-1$
        returnValue = false;
      }
    }
    if (Debug.debugHighScores)
      System.out.printf(Messages.getString("Javoids.ReturnValue"),Boolean.valueOf(returnValue)); //$NON-NLS-1$
    return returnValue;
  }

  /**
   * @return true if the keyboard file can be read and the game has access, otherwise return false
   */
  private boolean checkSecurityKeyboard()
  {
    SecurityManager securityManager = null;
    Object context = null;
    boolean returnValue = true;
    if (Debug.debugKeyMap)
      System.out.printf(Messages.getString("Javoids.CheckSecurity")); //$NON-NLS-1$
    securityManager = System.getSecurityManager();
    if (securityManager != null)
    {
      context = securityManager.getSecurityContext();
      // check to see if javoids has read access to the player's Keyboard file
      try
      {
        if (Javoids.userHome != null)
          securityManager.checkRead(Javoids.userHome + File.separator + Messages.getString("Javoids.KeyboardProperties"),context); //$NON-NLS-1$
      }
      catch (SecurityException securityException)
      {
        JOptionPane.showMessageDialog(this,Messages.getString("Javoids.ErrorUnableToAccessKeyboard") + securityException.getMessage(),Messages.getString("Javoids.ErrorJavaSecurity"),JOptionPane.ERROR_MESSAGE); //$NON-NLS-1$ //$NON-NLS-2$
        if (Debug.debugKeyMap)
          System.out.printf(String.format(Messages.getString("Javoids.ErrorSecurity"),Integer.valueOf(4))); //$NON-NLS-1$
        if (Debug.debugKeyMap)
          System.out.printf(Messages.getString("Javoids.ErrorUserHome"),securityException.getMessage()); //$NON-NLS-1$
        returnValue = false;
      }
    }
    if (Debug.debugKeyMap)
      System.out.printf(Messages.getString("Javoids.ReturnValue"),Boolean.valueOf(returnValue)); //$NON-NLS-1$
    return returnValue;
  }

  /**
   * @return true if the high score file was read successfully otherwise return false
   */
  private boolean initializeHighScores()
  {
    URL url = null;
    boolean returnValue = true;
    if (this.highScorePanel == null)
    {
      String location = String.format(Messages.getString("Javoids.FileFormat"),System.getProperty(Messages.getString("Javoids.UserHome")),File.separator,Messages.getString("Javoids.HighScoreProperties")); //$NON-NLS-1$//$NON-NLS-2$ //$NON-NLS-3$

      this.highScorePanel = new HighScorePanel();
      try
      {
        returnValue = this.checkSecurityUserHome() && this.checkSecurityHighScores();
        if (returnValue)
        {
          url = new URL(location);
          if (!this.highScorePanel.load(url))
            this.highScorePanel.load(this.getClass().getResource('/' + Messages.getString("Javoids.HighScoreProperties"))); //$NON-NLS-1$
        }
      }
      catch (MalformedURLException malformedURLException)
      {
        System.out.printf(Messages.getString("Javoids.ErrorAcessing"),location,malformedURLException.getMessage()); //$NON-NLS-1$
        returnValue = false;
      }
      catch (NullPointerException nullPointerException)
      {
        System.out.printf(Messages.getString("Javoids.ErrorAcessing"),location,nullPointerException.getMessage()); //$NON-NLS-1$
        returnValue = false;
      }
    }
    return returnValue;
  }

  /**
   * Start or re-start the timers.
   */
  public void startTimers()
  {
    this.powerUpTimer.start();
    this.mineTimer.start();
    this.singularityTimer.start();
    if (this.javoidTimer.getDelay() != Javoids.INITIAL_DELAY_JAVOID)
      this.javoidTimer.start();
    this.shipTimer.start();
    if (this.eatableGhostTimer != null)
      this.eatableGhostTimer.start();
    this.bonusTimer.start();
    if (this.highScoreTimer != null)
      this.highScoreTimer.start();
    this.playTimer.start();
  }

  /**
   * Stop the timers, clean up all lists and say the game isn't running.
   */
  public void stopGame()
  {
    System.out.printf(Messages.getString("Javoids.StopGame")); //$NON-NLS-1$
    this.isRunning = false;
    this.stopTimers();
    Javoids.keyMap.pressedKeys().clear();
    Javoids.keyMap.pressedButtons().clear();
    this.javoids.clear();
    this.mines.clear();
    this.explosions.clear();
    this.powerUps.clear();
    this.singularitys.clear();
    this.bullets.clear();
    this.ships.clear();
  }

  /**
   * Stop the timers.
   */
  public void stopTimers()
  {
    this.powerUpTimer.stop();
    this.mineTimer.stop();
    this.singularityTimer.stop();
    this.javoidTimer.stop();
    this.shipTimer.stop();
    if (this.eatableGhostTimer != null)
      this.eatableGhostTimer.stop();
    this.bonusTimer.stop();
    if (this.highScoreTimer != null)
      this.highScoreTimer.stop();
    this.playTimer.stop();
    Media.stopAll(); // added here for simplicity since if timers stop, sound should too
  }

  /**
   * Process mouse commands (fire, afterburners and thrust).
   * @param mouseEvent the mouse event to handle
   */
  private void mouseAction(MouseEvent mouseEvent)
  {
    synchronized (Javoids.keyMap)
    {
      if (SwingUtilities.isLeftMouseButton(mouseEvent))
        Javoids.keyMap.pressMouse(ACTION_FIRE);
      if (SwingUtilities.isMiddleMouseButton(mouseEvent))
        Javoids.keyMap.pressMouse(ACTION_AFTERBURNER);
      if (SwingUtilities.isRightMouseButton(mouseEvent))
        Javoids.keyMap.pressMouse(ACTION_THRUST);
    }
  }

  /**
   * Pause the game when a menu item is clicked.
   */
  private void menuItemPause()
  {
    if (this.isRunning)
      this.pause();
  }

  /**
   * Unpause the game after processing a menu item request.
   */
  private void menuItemUnPause()
  {
    if (!this.isFirstGame)
    {
      Javoids.keyMap.pressedKeys().clear();
      if (!this.isRunning)
        this.pause();
    }
  }

  /**
   * Toggle the game between being paused/unpaused.
   */
  private void pause()
  {
    if (this.isRunning)
    {
      this.stopTimers();
      this.isRunning = false;
    }
    else
    {
      if (!this.isFirstGame && !this.isGameOver) // only start the timers if the game is running and the game is not over
        this.startTimers();
      this.isRunning = true;
    }
  }

  /**
   * Process any key presses in the key map's list of pressed keys.
   */
  private void handleGamePlay()
  {
    this.handleAction();
    if (this.isRunning)
    {
      this.moveSprites();
      this.detectCollisions();
      if (this.isGameOver)
        this.startButton.requestFocus();
    }
  }

  /**
   * Handle actions from key or mouse presses.
   */
  synchronized public void handleAction()
  {
    try
    {
      // non-ship related actions
      for (Integer keyPressed : Javoids.keyMap.pressedKeys())
      {
        switch (Javoids.keyMap.getAction(keyPressed))
        {
          case ACTION_PACMAN :
            this.switchPacmanGame(false);
            break;
          case ACTION_ESCAPE :
            this.menuItemUnPause();
            this.gameCanvas.requestFocus();
            break;
          case ACTION_MENU :
            if (this.isRunning)
            {
              this.pause();
              Javoids.keyMap.depressKey(keyPressed);
            }
            break;
          case ACTION_NEWGAME :
            this.start();
            this.stopGame();
            this.newGame();
            break;
          case ACTION_PAUSE :
            this.pause();
            Javoids.keyMap.depressKey(keyPressed);
            break;
          default :
            break;
        }
      }
    }
    catch (ConcurrentModificationException concurrentModificationException)
    {
      /* do nothing */
    }

    // ship commands
    if (this.isRunning && this.ships.size() > 0)
    {
      try
      {
        if (!this.isGameOver && this.shipPlayer.isAlive())
        {
          // check pressed keys first
          for (Integer keyPressed : Javoids.keyMap.pressedKeys())
            this.shipPlayer.performAction(Javoids.keyMap.getAction(keyPressed),this.ships,this.bullets,this.mines,this.javoids,this.explosions);
        }
      }
      catch (ConcurrentModificationException concurrentModificationException)
      {
        /* do nothing */
      }

      try
      {
        // check pressed buttons
        for (KeyMap.Action buttonPressed : Javoids.keyMap.pressedButtons())
        {
          this.shipPlayer.performAction(buttonPressed,this.ships,this.bullets,this.mines,this.javoids,this.explosions);
          Javoids.keyMap.depressMouse(buttonPressed);
        }
      }
      catch (ConcurrentModificationException concurrentModificationException)
      {
        /* do nothing */
      }
    }
  }

  /**
   * Detect collisions between sprites.
   */
  public void detectCollisions()
  {
    SpriteVector<Javoid> tempJavoids;

    try
    {
      tempJavoids = new SpriteVector<Javoid>(Javoid.MAX_NUMBER);
      // javoid vs...
      for (Javoid javoid : this.javoids)
      {
        if (javoid.isAlive())
        {
          // bullets first
          for (Bullet bullet : this.bullets)
            if (bullet.isAlive())
            {
              bullet.modifyPoints(javoid.collide(bullet,javoid.collisionDetected(bullet)));
              tempJavoids.addAll(javoid.breakApart());
            }
          // ships next
          for (Ship ship : this.ships)
          {
            if (this.isPacmanGame && this.isEatableGhost)
            {
              ship.modifyPoints(javoid.getDamage());
              javoid.modifyDamage(-javoid.getDamage());
            }
            else
            {
              ship.modifyPoints(javoid.collide(ship,javoid.collisionDetected(ship)));
              tempJavoids.addAll(javoid.breakApart());
            }
          }
        }
      }
      // mine vs...
      for (Mine mine : this.mines)
      {
        for (Bullet bullet : this.bullets)
          if (bullet.isAlive())
            bullet.modifyPoints(mine.collide(bullet,mine.collisionDetected(bullet)));
        for (Ship ship : this.ships)
          if (this.isPacmanGame)
          {
            ship.modifyPoints(mine.getDamage());
            mine.modifyDamage(-mine.getDamage());
          }
          else
            ship.modifyPoints(mine.collide(ship,mine.collisionDetected(ship)));
      }
      // powerups vs...
      for (PowerUp powerUp : this.powerUps)
      {
        // bullets first
        for (Bullet bullet : this.bullets)
          if (bullet.isAlive())
            bullet.modifyPoints(powerUp.collide(bullet,powerUp.collisionDetected(bullet)));
        // ships next
        for (Ship ship : this.ships)
        {
          if (!NO_COLLISION.equals(ship.collisionDetected(powerUp)))
          {
            ship.apply(powerUp);
            if (this.isPacmanGame)
            {
              this.isEatableGhost = true;
              for (BasicSprite tempJavoid : this.javoids)
              {
                Javoid javoid = (Javoid)tempJavoid;
                javoid.setImage(PACMAN_EATABLE_GHOST);
              }
              this.eatableGhostTimer = new Timer(Javoids.INITIAL_DELAY_EATABLE_GHOST,this);
              this.eatableGhostTimer.start();
            }
          }
        }
      }
      // ships vs...
      for (Ship ship : this.ships)
      {
        for (Bullet bullet : this.bullets)
          if (bullet.isAlive() && (bullet.getParent() == null || !bullet.getParent().equals(ship)))
            bullet.modifyPoints(bullet.collide(ship,bullet.collisionDetected(ship)));
        for (Ship ship2 : this.ships)
          if (!ship.equals(ship2)) // don't shoot or collide with yourself
            if (!this.isPacmanGame)
              ship.modifyPoints(ship.collide(ship2,ship.collisionDetected(ship2)));
      }
      // Singularities vs...
      for (Singularity singularity : this.singularitys)
      {
        if (singularity.isAlive())
        {
          for (Singularity singularity2 : this.singularitys)
            singularity.collide(singularity2,singularity.collisionDetected(singularity2));
          for (Bullet bullet : this.bullets)
            singularity.collide(bullet,singularity.collisionDetected(bullet));
          for (Javoid javoid : this.javoids)
          {
            singularity.collide(javoid,singularity.collisionDetected(javoid));
            tempJavoids.addAll(javoid.breakApart());
          }
          for (PowerUp powerUp : this.powerUps)
            singularity.collide(powerUp,singularity.collisionDetected(powerUp));
          for (Mine mine : this.mines)
            singularity.collide(mine,singularity.collisionDetected(mine));
          for (Explosion explosion : this.explosions)
            singularity.collide(explosion,singularity.collisionDetected(explosion));
          for (Ship ship : this.ships)
            singularity.collide(ship,singularity.collisionDetected(ship));
        }
      }
      this.explosions.addAll(this.createExplosions(this.javoids));
      this.explosions.addAll(this.createExplosions(this.mines));
      this.explosions.addAll(this.createExplosions(this.powerUps));
      this.explosions.addAll(this.createExplosions(this.ships));
      this.restoreShips(); // bring any dead ships back to life if they have extra lives
      this.removeDead();
      this.javoids.addAll(tempJavoids); // add the new javoids to the roid list if there are no more javoids at all, make new javoids
      if (this.javoids.size() == 0)
      {
        if (this.ships.size() > 0)
        {
          if (this.shipPlayer.isPlayer() && this.shipPlayer.isAlive())
          {
            this.shipPlayer.getShield().modifyDamage(Shield.MAXIMUM_DAMAGE_CAPACITY);
            this.shipPlayer.getShield().modifyDuration(Shield.DEFAULT_DURATION / 2);
            this.shipPlayer.getShield().setMove(this.shipPlayer.getMove());
            this.shipPlayer.modifyPoints(this.bonus);
          }
        }
        this.singularitys.clear();
        this.gravityPlane.clear();
        this.level++;
        this.bonus = Javoids.BONUS + Javoids.BONUS_INCREMENT * (this.level - 1);
        this.progressBarBonus.setMaximum(this.bonus);
        this.progressBarBonus.setValue(this.bonus);
        this.javoids.addAll(this.createLevelJavoids());
        if (Math.random() < 0.03)
          this.createGravityPlane();
        if (this.isPacmanGame)
          Media.play(PACMAN_LEVELUP);
      }
      // only make it game over when the player dies
      if (!this.isGameOver)
      {
        this.isGameOver = this.ships.size() > 0 ? !this.shipPlayer.isAlive() : true;
        if (this.isGameOver)
        {
          if (this.initializeHighScores())
          {
            this.highScoreTimer = new Timer(Javoids.DELAY_HIGHSCORE,this);
            this.highScoreTimer.start();
            this.playTimer.stop();
            Thread.sleep(1); // sleep long enough for other thread to take over (prevents high score timer from running away and never being ended)
          }
        }
      }
      // this must only happen once per new game
      if (this.isGameOver)
        this.shipPlayer.setPlayer(false);
    }
    catch (InterruptedException interruptedException)
    {
      System.out.printf(Messages.getString("Javoids.ErrorGameInterrupted"),interruptedException.getMessage()); //$NON-NLS-1$
    }
  }

  /**
   * Rstore all ships to their default values (alive if possible for a player, and dead otherwise).
   */
  private void restoreShips()
  {
    for (BasicSprite basicSprite : this.ships)
    {
      Ship ship = (Ship)basicSprite;
      if (!ship.isAlive() && ship.isRestorable())
      {
        if (ship.equals(this.shipPlayer))
          ship.restore(this.screen.width / 2,this.screen.height / 2,Ship.DEFAULT_VELOCITY,0);
        else
          ship.restore(Math.random() * this.screen.width,Math.random() * this.screen.height,Ship.DEFAULT_VELOCITY,0);
      }
    }
  }

  /**
   * Move the sprites and age them as necessary.
   */
  public void moveSprites()
  {
    // gravity wells
    this.gravityPlane.moveSpritesGravity(this.singularitys);
    this.gravityPlane.moveSpritesGravity(this.javoids);
    this.gravityPlane.moveSpritesGravity(this.mines);
    this.gravityPlane.moveSpritesGravity(this.powerUps);
    this.gravityPlane.moveSpritesGravity(this.explosions);
    this.gravityPlane.moveSpritesGravity(this.bullets);
    this.gravityPlane.moveSpritesGravity(this.ships);
    this.singularitys.moveSpritesGravity(this.singularitys);
    this.singularitys.moveSpritesGravity(this.javoids);
    this.singularitys.moveSpritesGravity(this.mines);
    this.singularitys.moveSpritesGravity(this.powerUps);
    this.singularitys.moveSpritesGravity(this.explosions);
    this.singularitys.moveSpritesGravity(this.bullets);
    this.singularitys.moveSpritesGravity(this.ships);
    this.mines.moveSpritesGravity(this.javoids);
    this.mines.moveSpritesGravity(this.powerUps);
    this.mines.moveSpritesGravity(this.bullets);
    this.mines.moveSpritesGravity(this.ships);
    this.javoids.moveSpritesGravity(this.singularitys);
    this.javoids.moveSpritesGravity(this.javoids);
    this.javoids.moveSpritesGravity(this.bullets);
    this.javoids.moveSpritesGravity(this.ships);
    this.ships.moveSpritesGravity(this.singularitys);
    this.ships.moveSpritesGravity(this.javoids);
    this.ships.moveSpritesGravity(this.mines);
    this.ships.moveSpritesGravity(this.explosions);
    this.ships.moveSpritesGravity(this.bullets);
    this.ships.moveSpritesGravity(this.ships);
    // homing
    if (this.mines.size() > 0)
      this.bullets.moveSpritesHoming(this.mines);
    else if (this.ships.size() > 1)
      this.bullets.moveSpritesHoming(this.ships);
    else
      this.bullets.moveSpritesHoming(this.javoids);
    this.mines.moveSpritesHoming(this.ships);
    this.javoids.moveSpritesHoming(this.ships);
    // perform automatic actions like firing for non-player ships
    this.automaticActionSprites();
    // regular movement
    this.explosions.moveSprites();
    this.gravityPlane.moveSprites();
    this.singularitys.moveSprites();
    this.javoids.moveSprites();
    this.mines.moveSprites();
    this.powerUps.moveSprites();
    this.bullets.moveSprites();
    this.ships.moveSprites();
  }

  /**
   * Handle the actionjs of autonomous sprites (automatic move sprites).
   */
  synchronized private void automaticActionSprites()
  {
    for (BasicSprite basicSprite : this.ships)
    {
      Ship ship = (Ship)basicSprite;
      if (ship.isAutomaticMove())
        synchronized (this.bullets)
        {
          this.bullets.addAll(ship.useAutomaticGun());
        }
    }
  }

  /**
   * Remove sprites that are dead or expired their duration.
   */
  public void removeDead()
  {
    this.javoids.removeDead();
    this.mines.removeDead();
    this.ships.removeDead();
    this.explosions.removeDead();
    this.powerUps.removeDead();
    this.gravityPlane.removeDead();
    this.singularitys.removeDead();
    this.modifyShotCount(); // must bedone before dead Bullet objects are removed
    synchronized (this.bullets)
    {
      this.bullets.removeDead();
    }
  }

  /**
   * Modify a weapon's shot count.
   */
  private void modifyShotCount()
  {
    for (BasicSprite basicSprite : this.bullets)
    {
      Bullet bullet = (Bullet)basicSprite;
      if (!bullet.isAlive())
      {
        Weapon weapon = (Weapon)((Ship)bullet.getParent()).getItems().get(bullet.getWeapon());
        weapon.modifyFired(-1);
      }
    }
  }

  /**
   * Draw all of the sprites.
   * @param g2d the graphics context to use in drawing.
   * @param foregroundImage the image to draw on (used for double buffering)
   */
  public void drawSprites(Graphics2D g2d,Graphics2D foregroundImage)
  {
    foregroundImage.drawImage(Media.getImage(GALAXY1),0,0,null);
    this.gravityPlane.drawSprites(g2d,foregroundImage);
    this.bullets.drawSprites(g2d,foregroundImage);
    this.explosions.drawSprites(g2d,foregroundImage);
    this.javoids.drawSprites(g2d,foregroundImage);
    this.mines.drawSprites(g2d,foregroundImage);
    this.powerUps.drawSprites(g2d,foregroundImage);
    this.ships.drawSprites(g2d,foregroundImage);
    this.singularitys.drawSprites(g2d,foregroundImage);
    g2d.setTransform(g2d.getDeviceConfiguration().getDefaultTransform());
  }

  /**
   * @param sprites the sprites to create explosions for.
   * @param <E> the type of sprite creating explosions
   * @return a list of explosions
   */
  private <E extends BasicSprite> SpriteVector<Explosion> createExplosions(SpriteVector<E> sprites)
  {
    SpriteVector<Explosion> explosionVector = new SpriteVector<Explosion>(Explosion.MAX_NUMBER);
    for (E basicSprite : sprites)
      if (!basicSprite.isAlive())
        explosionVector.add(new Explosion(null,new Move(basicSprite.getMove()),basicSprite.getSize()));
    return explosionVector;
  }

  /**
   * Create a collection of sprites that act as a plane or other shape (that attract the Javoids and ships to it).
   */
  public void createGravityPlane()
  {
    double x0 = 0.0;
    double y0 = 0.0;
    double m = 0.0;
    this.gravityPlane.clear();
    switch ((int)(Math.random() * 6))
    {
      case 0 : // line crossing screen at any angle
        double x1 = Math.random() * this.screen.width;
        double y1 = Math.random() * this.screen.height;
        double x2 = Math.random() * this.screen.width;
        double y2 = Math.random() * this.screen.height;
        double b = Math.random() * this.screen.height;
        x0 = Math.random() * this.screen.width;
        m = x2 - x1 != 0.0 ? (y2 - y1) / (x2 - x1) : 1.0;
        for (int i = 0;i < GravityPoint.MAX_NUMBER;i++)
        {
          double increment;
          if (Math.abs(m) >= 40)
            increment = i / 24.0;
          else if (Math.abs(m) >= 20)
            increment = i / 12.0;
          else if (Math.abs(m) >= 10)
            increment = i / 6.0;
          else if (Math.abs(m) >= 5)
            increment = i / 2.0;
          else
          {
            increment = Math.abs(m) >= 1 ? i : i * 1.5;
          }
          double x = x0 + 300 * increment / GravityPoint.MAX_NUMBER;
          double y = m * x + b;
          this.gravityPlane.add(new GravityPoint(null,new Health(GravityPoint.MAX_DEATHS,GravityPoint.MAXIMUM_DAMAGE_CAPACITY,GravityPoint.DEFAULT_DURATION,GravityPoint.DEFAULT_AGING_RATE,IMMORTAL),new Move(this.screen,x,y,0,0),GravityPoint.DEFAULT_SIZE));
        }
        break;
      case 1 : // circle
        x0 = Math.random() * (this.screen.width - 200);
        y0 = Math.random() * (this.screen.height - 200);
        double radius = 50.0 + Math.random() * 250.0;
        double multiplier = Common.PI2 / GravityPoint.MAX_NUMBER;
        for (int i = 0;i < GravityPoint.MAX_NUMBER;i++)
        {
          double x = x0 + 100 + radius * Math.sin(multiplier * i);
          double y = y0 + 100 + radius * Math.cos(multiplier * i);
          this.gravityPlane.add(new GravityPoint(null,new Health(GravityPoint.MAX_DEATHS,GravityPoint.MAXIMUM_DAMAGE_CAPACITY,GravityPoint.DEFAULT_DURATION,GravityPoint.DEFAULT_AGING_RATE,IMMORTAL),new Move(this.screen,x,y,0,0),GravityPoint.DEFAULT_SIZE));
        }
        break;
      case 2 : // line on x axis
        for (int i = 0;i < GravityPoint.MAX_NUMBER;i++)
          this.gravityPlane.add(new GravityPoint(null,new Health(GravityPoint.MAX_DEATHS,GravityPoint.MAXIMUM_DAMAGE_CAPACITY,GravityPoint.DEFAULT_DURATION,GravityPoint.DEFAULT_AGING_RATE,IMMORTAL),new Move(this.screen,this.screen.width * i / GravityPoint.MAX_NUMBER,0,0,0),GravityPoint.DEFAULT_SIZE));
        break;
      case 3 : // line on y axis
        for (int i = 0;i < GravityPoint.MAX_NUMBER;i++)
          this.gravityPlane.add(new GravityPoint(null,new Health(GravityPoint.MAX_DEATHS,GravityPoint.MAXIMUM_DAMAGE_CAPACITY,GravityPoint.DEFAULT_DURATION,GravityPoint.DEFAULT_AGING_RATE,IMMORTAL),new Move(this.screen,0,this.screen.height * i / GravityPoint.MAX_NUMBER,0,0),GravityPoint.DEFAULT_SIZE));
        break;
      default : // random gravity points
        for (int i = 0;i < Math.random() * GravityPoint.MAX_NUMBER + 1;i++)
          this.gravityPlane.add(new GravityPoint(null,new Health(GravityPoint.MAX_DEATHS,GravityPoint.MAXIMUM_DAMAGE_CAPACITY,GravityPoint.DEFAULT_DURATION,GravityPoint.DEFAULT_AGING_RATE,IMMORTAL),new Move(this.screen,Math.random() * this.screen.width + 1,Math.random() * this.screen.height + 1,0,0),GravityPoint.DEFAULT_SIZE));
        break;
    }
  }

  /**
   * Create all of the javoids for the new level.
   * @return a list of new javoids
   */
  public SpriteVector<Javoid> createLevelJavoids()
  {
    SpriteVector<Javoid> newJavoids;
    Javoid javoid;
    double maxVelocity;
    int side;
    int initialx;
    int initialy;
    int nJavoids = this.level + Javoids.difficulty - 1;

    this.isEatableGhost = false;
    newJavoids = new SpriteVector<Javoid>(Javoid.MAX_NUMBER);
    nJavoids = nJavoids > Javoid.MAX_NUMBER - this.javoids.size() ? Javoid.MAX_NUMBER - this.javoids.size() : nJavoids;
    nJavoids = nJavoids < 0 ? 0 : nJavoids;
    for (int i = 0;i < nJavoids;i++)
    {
      maxVelocity = Math.random() * Move.MAX_VELOCITY;
      // make the javoids come in from the sides!
      side = (int)(Math.random() * 4); // top=0,right=1,bottom=2,left=3
      initialx = side == 0 || side == 2 ? (int)(Math.random() * this.screen.width) : 0;
      initialy = side == 0 || side == 2 ? 0 : (int)(Math.random() * this.screen.width);
      initialx = side == 1 || side == 3 ? 0 : (int)(Math.random() * this.screen.height);
      initialy = side == 1 || side == 3 ? (int)(Math.random() * this.screen.height) : 0;
      if (Debug.debugJavoid)
        javoid = new Javoid(null,new Health(1,Javoid.MAX_SIZE,Health.DEFAULT_DURATION,0,AGELESS),new Move(this.screen,this.screen.width * 0.75,this.screen.height * 0.5,0,0),Javoid.DEFAULT_SIZE * 2);
      else
        javoid = new Javoid(null,new Health(1,Javoid.MAX_SIZE,Health.DEFAULT_DURATION,0,AGELESS),new Move(this.screen,initialx,initialy,Math.random() * 360,maxVelocity),Javoid.DEFAULT_SIZE);
      newJavoids.add(javoid);
    }
    return newJavoids;
  }

  /**
   * Set the game information up for display.
   * @param ship the player's ship
   * @param _level the game level
   */
  private void setInformation(Ship ship,int _level)
  {
    String s = null;
    if (ship != null)
    {
      if (ship.isRestorable())
      {
        s = String.format(Messages.getString("Javoids.Stats"),Integer.valueOf(_level),Integer.valueOf(ship.getMaxDeaths() - ship.getDeaths()),Integer.valueOf(ship.getPoints())); //$NON-NLS-1$
      }
      else
      {
        s = String.format(Messages.getString("Javoids.FinalScore"),Integer.valueOf(ship.getPoints()),Integer.valueOf(_level)); //$NON-NLS-1$
        this.bonus = 0;
      }
      if (this.bonus > 0)
      {
        this.progressBarBonus.setValue(this.bonus);
        if ((float)this.bonus / (Javoids.BONUS + Javoids.BONUS_INCREMENT) > 0.6) // > 60%
          this.progressBarBonus.setForeground(Color.green);
        else if ((float)this.bonus / (Javoids.BONUS + Javoids.BONUS_INCREMENT) > 0.2) // > 20%
          this.progressBarBonus.setForeground(Color.yellow);
        else
          this.progressBarBonus.setForeground(Color.red);
        this.progressBarBonus.setVisible(true);
      }
      else
        this.progressBarBonus.setVisible(false);
      if (ship.isAlive())
      {
        this.progressBarHealth.setValue(ship.getMaxDamage() - ship.getDamage());
        this.progressBarHealth.setForeground(ship.getColor());
        this.progressBarHealth.setVisible(true);
      }
      else
        this.progressBarHealth.setVisible(false);
      if (ship.getShield().isAlive())
      {
        this.progressBarShield.setValue(ship.getShield().getMaxDamage() - ship.getShield().getDamage());
        this.progressBarShield.setForeground(ship.getShield().getColor());
        this.progressBarShield.setVisible(true);
      }
      else
        this.progressBarShield.setVisible(false);
      this.duration = this.formatTime(this.playTime); // duration is used for high score table
      s += Messages.getString("Javoids.ForDuration") + this.duration; //$NON-NLS-1$
      this.infoLabel.setText(s);
      this.setAmmoInformation(ship.getCurrentItem(),ship.getItems());
    }
    else
      this.setAmmoInformation(Item.Type.GUN1,Media.getItems());
  }

  /**
   * @param time the time to format
   * @return the formatted time value.
   */
  private String formatTime(int time)
  {
    final int SECONDS_PER_DAY = 86400;
    final int SECONDS_PER_HOUR = 3600;
    final int SECONDS_PER_MINUTE = 60;
    int days = time / SECONDS_PER_DAY;
    int hours = (time - days * SECONDS_PER_DAY) / SECONDS_PER_HOUR;
    int minutes = (time - hours * SECONDS_PER_HOUR) / SECONDS_PER_MINUTE;
    int seconds = time - minutes * SECONDS_PER_MINUTE;
    return String.format(Messages.getString("Javoids.TimeFormat"),Integer.valueOf(days),Integer.valueOf(hours),Integer.valueOf(minutes),Integer.valueOf(seconds)); //$NON-NLS-1$
  }

  /**
   * Display the ammo information for each item.
   * @param currentItem the currently selected item
   * @param items the list of item mappings
   */
  private void setAmmoInformation(Item.Type currentItem,HashMap<Item.Type,? extends Item> items)
  {
    String ammo;
    String toolName;
    int count;
    String homingIndicator;
    String shieldIndicator;
    Item item = null;
    for (Item.Type name : Item.Type.values())
    {
      if (!Item.Type.NO_TOOL.equals(name))
      {
        item = items.get(name);
        ammo = ""; //$NON-NLS-1$
        count = item.getCount();
        toolName = item.getName();
        if (item.isWeapon())
        {
          homingIndicator = ((Weapon)item).getHomings() > 0 ? Messages.getString("Javoids.Homing") : ""; //$NON-NLS-1$ //$NON-NLS-2$
          shieldIndicator = ((Weapon)item).getShields() > 0 ? Messages.getString("Javoids.Sheilded") : ""; //$NON-NLS-1$ //$NON-NLS-2$
          toolName = shieldIndicator + homingIndicator + toolName;
        }
        this.infoPanel.setVisible(!this.isFirstGame);
        if (!this.isFirstGame)
        {
          this.panelWeapon.get(name).setVisible(count > 0);
          this.panelWeapon.get(name).getAmount().setIcon(item.isLimitless() ? this.infiniteIcon : null);
          this.panelWeapon.get(name).setBorder(name.equals(currentItem) ? this.selectedBorder : null);
          this.panelWeapon.get(name).setToolTipText(toolName);
          this.panelWeapon.get(name).getItem().setIcon(Media.getImageIcon(item.getImage()));
          ammo += !item.isLimitless() && count > 0 ? Integer.toString(count) : ""; //$NON-NLS-1$
          this.panelWeapon.get(name).getAmount().setText(ammo);
        }
      }
    }
  }

  /**
   * Set the delays for timers based on the game difficulty.
   */
  private void setDelays()
  {
    Javoids.INITIAL_DELAY_POWERUP = 2000 * Javoids.difficulty; // 2 seconds
    Javoids.INITIAL_DELAY_SHIP = 60000 / Javoids.difficulty; // 60 seconds
    Javoids.INITIAL_DELAY_MINE = 120000 / Javoids.difficulty; // 120 seconds
    Javoids.INITIAL_DELAY_SINGULARITY = 180000 / Javoids.difficulty; // 180 seconds
    Javoids.INITIAL_DELAY_JAVOID = 10000 / Javoids.difficulty; // 10 seconds
    Javoids.INITIAL_DELAY_EATABLE_GHOST = 200000 / Javoids.difficulty; // 0 seconds
    Javoids.DEFAULT_DELAY_POWERUP = 30000 * Javoids.difficulty; // 30 seconds
    Javoids.DEFAULT_DELAY_SHIP = 60000 / Javoids.difficulty; // 60 seconds
    Javoids.DEFAULT_DELAY_MINE = 120000 / Javoids.difficulty; // 120 seconds
    Javoids.DEFAULT_DELAY_SINGULARITY = 180000 / Javoids.difficulty; // 180 seconds
  }

  /**
   * Set the game difficulty.
   * @param _difficulty the desired difficulty
   */
  private void setDifficulty(int _difficulty)
  {
    Javoids.difficulty = _difficulty < Javoids.MIN_DIFFICULTY || _difficulty > Javoids.MAX_DIFFICULTY ? Javoids.MIN_DIFFICULTY : _difficulty;
    this.setDelays();
  }

  /**
   * @return the difficulty setting for the game
   */
  public static int getDifficulty()
  {
    return Javoids.difficulty;
  }

  /**
   * toggle to/from a pacman game
   * @param reset true (use a pacman game)/false (don't use a pacman game)
   */
  private void switchPacmanGame(boolean reset)
  {
    this.isPacmanGame = !reset && !this.isPacmanGame;
    BasicSprite.setPacmanGame(this.isPacmanGame);
    this.isEatableGhost = false;
    if (!reset && this.isPacmanGame)
      Media.play(PACMAN_GAMESTART);
  }

  /**
   * @param item the item to add to the tool panel
   */
  private void addPanelItem(Item item)
  {
    this.panelWeapon.put(item.getType(),new ToolPanel(this,new FlowLayout(FlowLayout.LEFT),item.getName(),item.getType(),new ImageIcon(Media.getScaledImage(item.getImage(),item.getSize(),item.getSize(),Image.SCALE_DEFAULT)),this.infiniteIcon));
    this.panelAmmo.add(this.panelWeapon.get(item.getType()));
  }

  /**
   * Provide a String representation of this object.
   * @return String A representation of the object for debugging.
   */
  @Override
  public String toString()
  {
    return super.toString();
  }
}

/**
 * A class for handling actions.
 * @author mallette
 */
class ActionHandler extends AbstractAction
{
  /** This is the version used for serializing/deserializing (storing/retrieving) this object */
  private final static long serialVersionUID = 1L;
  /** the javoids game */
  private Javoids           javoids;

  /**
   * @param _javoids the list of all javoids
   * @param name the name of the action to be performed
   * @param keyStroke the keystroke that goes with the action
   */
  public ActionHandler(Javoids _javoids,String name,KeyStroke keyStroke)
  {
    super(name);
    this.javoids = _javoids;
    this.putValue(Action.ACCELERATOR_KEY,keyStroke);
    this.putValue(Action.MNEMONIC_KEY,Integer.valueOf(keyStroke.getKeyCode()));
  }

  /**
   * Create a new game.
   * @param actionEvent the action event to handle
   */
  /*
   * (non-Javadoc)
   * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
   */
  public void actionPerformed(@SuppressWarnings( {"unused"})
  ActionEvent actionEvent)
  {
    this.javoids.actionPerformedNew();
  }
}
