/*
 * Decompiled with CFR 0.152.
 */
package Objects;

import Animations.FallingDeadSprites;
import Objects.BasicEnemy;
import SandBox.Mario;
import com.golden.gamedev.object.AnimatedSprite;
import com.golden.gamedev.object.Timer;
import com.golden.gamedev.object.sprite.VolatileSingleImage;
import com.golden.gamedev.util.ImageUtil;
import java.awt.image.BufferedImage;

public class EnemyMashroom
extends AnimatedSprite
implements BasicEnemy {
    boolean PositiveX = true;
    Mario game;
    public int Gravity = 5;

    public EnemyMashroom(int x, int y, BufferedImage[] Enemy_Image, Mario g) {
        this.setLocation(x, y);
        this.setImages(Enemy_Image);
        this.setAnimationTimer(new Timer(300));
        this.setAnimate(true);
        this.setLoopAnim(true);
        this.setAnimationFrame(0, 1);
        this.game = g;
        this.setID(100);
    }

    public void update(long l) {
        this.moveY(this.Gravity);
        if (this.PositiveX) {
            this.moveX(-1.0);
        } else {
            this.moveX(1.0);
        }
        super.update(l);
    }

    public void MarioJumpedOnEnemy() {
        if (this.game.player.HasStar()) {
            this.KilledByFireBall();
        } else {
            this.game.player.Jump(-8);
            VolatileSingleImage DeadMushroom = new VolatileSingleImage(ImageUtil.resize(this.getImage(), 32, 16), this.getX(), this.getY() + 16.0, 100);
            this.game.VolitileGroup.add(DeadMushroom);
            this.setActive(false);
        }
    }

    public void KilledByFireBall() {
        this.game.AnimationGroup.add(new FallingDeadSprites(this.getX(), this.getY(), this.getImage(), this.MariotoRight()));
        this.setActive(false);
        this.game.parent.amitsAudioPlayer.smb_kick.play();
    }

    public void bounce() {
    }

    public void setYloc(double d) {
        this.setY(d);
    }

    public void CollidedWithShell() {
    }

    public int getType() {
        return this.getID();
    }

    public void CollidedWithMovingShell() {
        this.KilledByFireBall();
    }

    public void CollidedWithBrick_GoToLeft() {
        this.PositiveX = true;
        this.setAnimationFrame(0, 1);
    }

    public void CollidedWithBrick_GoToRight() {
        this.PositiveX = false;
        this.setAnimationFrame(0, 1);
    }

    public void OtherEnemyTouchedFromRight() {
        this.PositiveX = true;
        this.setAnimationFrame(0, 1);
    }

    public void OtherEnemyTouchedFromLeft() {
        this.PositiveX = false;
        this.setAnimationFrame(0, 1);
    }

    public void CollidedWithMarioFromTOLeft() {
        if (this.game.player.HasStar()) {
            this.KilledByFireBall();
        } else {
            this.game.player.Decerease();
        }
    }

    public void CollidedWithMarioTORight() {
        if (this.game.player.HasStar()) {
            this.KilledByFireBall();
        } else {
            this.game.player.Decerease();
        }
    }

    public void EnemyJumperOnMario() {
        if (this.game.player.HasStar()) {
            this.KilledByFireBall();
        } else {
            this.game.player.Decerease();
        }
    }

    public int Life() {
        return 0;
    }

    public void CollidedWithJumping_Brick() {
        this.KilledByFireBall();
    }

    public boolean MariotoRight() {
        boolean positive = !(this.game.player.getX() < this.getX());
        return positive;
    }
}

