/*
 * Decompiled with CFR 0.152.
 */
package Objects;

import Animations.FallingDeadSprites;
import Objects.BasicEnemy;
import Objects.EnemyTurtle;
import SandBox.Mario;
import com.golden.gamedev.object.AnimatedSprite;
import com.golden.gamedev.object.Timer;
import com.golden.gamedev.util.ImageUtil;
import java.awt.image.BufferedImage;

public class FlyingTurtle
extends AnimatedSprite
implements BasicEnemy {
    boolean PositiveX = true;
    Mario game;
    public double Gravity = -6.0;
    String Color;

    public FlyingTurtle(String color, int x, int y, Mario g) {
        super(x, y);
        this.Color = color;
        this.game = g;
        if (this.Color.equals("normal")) {
            this.setImages(this.game.bsLoader.getStoredImages("FlyingTurtle"));
        } else {
            this.setImages(this.game.bsLoader.getStoredImages("FlyingTurtledark"));
        }
        this.setAnimationTimer(new Timer(300));
        this.setAnimate(true);
        this.setLoopAnim(true);
        this.setAnimationFrame(0, 1);
        this.setID(101);
    }

    public void update(long l) {
        if (this.Gravity < 5.0) {
            this.Gravity += 0.25;
        }
        super.update(l);
        this.moveY(this.Gravity);
        if (this.PositiveX) {
            this.moveX(-1.0);
        } else {
            this.moveX(1.0);
        }
        super.update(l);
    }

    public void bounce() {
        this.Gravity = -8.0;
    }

    public void MarioJumpedOnEnemy() {
        this.game.player.Jump(-8);
        if (this.Color.equals("normal")) {
            this.game.EnemyGroup.add(new EnemyTurtle((int)this.getX(), (int)this.getY(), this.game, true));
        } else {
            this.game.EnemyGroup.add(new EnemyTurtle((int)this.getX(), (int)this.getY(), this.game, true, this.Color));
        }
        this.setActive(false);
    }

    public void CollidedWithMovingShell() {
        BufferedImage HorizontalFilpShell = this.Color.equals("normal") ? this.game.bsLoader.getStoredImage("TurtelShell") : this.game.bsLoader.getStoredImage("TurtelShelldark");
        HorizontalFilpShell = ImageUtil.flipHorizontal(HorizontalFilpShell);
        this.game.AnimationGroup.add(new FallingDeadSprites(this.getX(), this.getY(), HorizontalFilpShell, this.MariotoRight()));
        this.setActive(false);
        this.game.parent.amitsAudioPlayer.smb_kick.play();
    }

    public void CollidedWithBrick_GoToLeft() {
        this.PositiveX = true;
        this.setAnimationFrame(0, 1);
    }

    public void CollidedWithBrick_GoToRight() {
        this.PositiveX = false;
        this.setAnimationFrame(2, 3);
    }

    public int getType() {
        return this.getID();
    }

    public void KilledByFireBall() {
        this.CollidedWithMovingShell();
    }

    public void setYloc(double d) {
        this.setY(d);
        this.bounce();
    }

    public void CollidedWithShell() {
    }

    public void OtherEnemyTouchedFromRight() {
        this.PositiveX = false;
        this.setAnimationFrame(2, 3);
    }

    public void OtherEnemyTouchedFromLeft() {
        this.PositiveX = true;
        this.setAnimationFrame(0, 1);
    }

    public void CollidedWithMarioFromTOLeft() {
        if (this.game.player.HasStar()) {
            this.CollidedWithMovingShell();
            this.setActive(false);
        } else {
            this.game.player.Decerease();
        }
    }

    public void CollidedWithMarioTORight() {
        if (this.game.player.HasStar()) {
            this.CollidedWithMovingShell();
            this.setActive(false);
        } else {
            this.game.player.Decerease();
        }
    }

    public void Kill() {
    }

    public void EnemyJumperOnMario() {
        if (this.game.player.HasStar()) {
            this.CollidedWithMovingShell();
            this.setActive(false);
        } else {
            this.game.player.Decerease();
        }
    }

    public int Life() {
        return 0;
    }

    public void CollidedWithJumping_Brick() {
    }

    public boolean MariotoRight() {
        boolean positive = !(this.game.player.getX() < this.getX());
        return positive;
    }
}

