/*
 * Decompiled with CFR 0.152.
 */
package com.golden.gamedev.engine.timer;

import com.golden.gamedev.engine.BaseTimer;
import com.golden.gamedev.engine.timer.FPSCounter;

public class SystemTimer
implements BaseTimer {
    private int fps = 50;
    private long msDelay;
    private long start;
    private long end;
    private long timeDiff;
    private long sleepTime;
    private long overSleepTime;
    private boolean running;
    private FPSCounter fpsCounter = new FPSCounter();

    public void startTimer() {
        if (this.running) {
            this.stopTimer();
        }
        this.running = true;
        this.msDelay = 1000 / this.fps;
        this.refresh();
        this.fpsCounter.refresh();
    }

    public void stopTimer() {
        this.running = false;
    }

    public long sleep() {
        this.end = System.currentTimeMillis();
        this.timeDiff = this.end - this.start;
        this.sleepTime = this.msDelay - this.timeDiff - this.overSleepTime;
        if (this.sleepTime > 0L) {
            try {
                Thread.sleep(this.sleepTime);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            this.overSleepTime = System.currentTimeMillis() - this.end - this.sleepTime;
        } else {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            this.overSleepTime = 0L;
        }
        this.fpsCounter.calculateFPS();
        long end = System.currentTimeMillis();
        long elapsedTime = end - this.start;
        this.start = end;
        return elapsedTime;
    }

    public boolean isRunning() {
        return this.running;
    }

    public int getCurrentFPS() {
        return this.fpsCounter.getCurrentFPS();
    }

    public int getFPS() {
        return this.fps;
    }

    public void setFPS(int fps) {
        if (this.fps == fps) {
            return;
        }
        this.fps = fps;
        if (this.running) {
            this.startTimer();
        }
    }

    public long getTime() {
        return System.currentTimeMillis();
    }

    public void refresh() {
        this.start = System.currentTimeMillis();
        this.overSleepTime = 0L;
    }
}

